/*
 * Decompiled with CFR 0.152.
 */
package bt747.j2se_view;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.convert.Conv;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;
import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.sf.bt747.j2se.system.J2SEJavaTranslations;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GPXLogConvert
extends GPSLogConvertInterface {
    private GPSRecord activeFields = GPSRecord.getLogFormatRecord(0);
    private boolean passToFindFieldsActivatedInLog;
    private final GPSRecord activeFileFields = GPSRecord.getLogFormatRecord(0);
    private Node gpx;
    private int error;

    @Override
    public int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        object = ((Node)object).getChildNodes();
        int n = 0;
        for (int i = 0; i < object.getLength(); ++i) {
            Object object2 = object.item(i);
            if (!object2.getNodeName().equalsIgnoreCase("trk")) continue;
            object2 = object2.getChildNodes();
            for (int j = 0; j < object2.getLength(); ++j) {
                Object object3 = object2.item(j);
                if (!object3.getNodeName().equalsIgnoreCase("trkseg")) continue;
                object3 = object3.getChildNodes();
                for (int k = 0; k < object3.getLength(); ++k) {
                    Object object4 = object3.item(k);
                    if (!object4.getNodeName().equalsIgnoreCase("trkpt")) continue;
                    object4 = this.convertNodeToGPSRecord((Node)object4);
                    v0.recCount = ++n;
                    if (!((GPSRecord)object4).equalsFormat(this.activeFields)) {
                        this.activeFields = ((GPSRecord)object4).cloneRecord();
                        if (!this.passToFindFieldsActivatedInLog) {
                            gPSFileConverterInterface.writeLogFmtHeader(this.activeFields);
                        }
                    }
                    if (!this.passToFindFieldsActivatedInLog) {
                        CommonIn.adjustHeight((GPSRecord)object4, this.factorConversionWGS84ToMSL);
                        gPSFileConverterInterface.addLogRecord((GPSRecord)object4);
                    }
                    if (!this.stop) continue;
                    this.errorInfo = "Conversion aborted";
                    return -3;
                }
            }
        }
        return 0;
    }

    @Override
    protected Object getFileObject(BT747Path bT747Path) {
        if (this.gpx == null && bt747.sys.File.isAvailable()) {
            try {
                Object object = new File(bT747Path.getPath());
                object = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((File)object);
                XPath xPath = XPathFactory.newInstance().newXPath();
                try {
                    this.gpx = (Node)xPath.evaluate("//gpx", object, XPathConstants.NODE);
                }
                catch (Exception exception) {
                    Generic.debug("Did not find 'gpx' path", exception);
                    this.errorInfo = "Did not find 'gpx' path in gpx file";
                    return -3;
                }
            }
            catch (Exception exception) {
                Generic.debug("Initialising GPX reading " + bT747Path, exception);
                this.errorInfo = bT747Path + "\n" + exception.getMessage();
                this.error = -1;
                return this.error;
            }
        }
        return this.gpx;
    }

    @Override
    protected void closeFileObject(Object object) {
        this.gpx = null;
    }

    @Override
    public int toGPSFile(BT747Path object, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        if ((object = this.getFileObject((BT747Path)object)) == null) {
            return this.error;
        }
        this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
        if (this.passToFindFieldsActivatedInLog) {
            this.error = this.parseFile(object, gPSFileConverterInterface);
            gPSFileConverterInterface.setActiveFileFields(this.activeFileFields);
        }
        this.passToFindFieldsActivatedInLog = false;
        do {
            this.error = this.parseFile(object, gPSFileConverterInterface);
        } while (this.error == 0 && gPSFileConverterInterface.nextPass());
        this.closeFileObject(object);
        gPSFileConverterInterface.finaliseFile();
        if (gPSFileConverterInterface.getNbrFilesCreated() == 0) {
            this.error = -2;
        }
        Generic.debug("Conversion done", null);
        return this.error;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GPSRecord convertNodeToGPSRecord(Node object) {
        int n;
        NodeList nodeList = object.getChildNodes();
        GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
        object = object.getAttributes();
        for (n = 0; n < object.getLength(); ++n) {
            Node node;
            try {
                node = object.getNamedItem("lat");
                if (node != null) {
                    this.activeFileFields.latitude = 0.0;
                    gPSRecord.latitude = Double.valueOf(node.getNodeValue());
                }
            }
            catch (Exception exception) {}
            try {
                node = object.getNamedItem("lon");
                if (node == null) continue;
                this.activeFileFields.longitude = 0.0;
                gPSRecord.longitude = Double.valueOf(node.getNodeValue());
                continue;
            }
            catch (Exception exception) {}
        }
        n = 0;
        while (n < nodeList.getLength()) {
            Object object2 = nodeList.item(n);
            object = object2.getNodeName().toUpperCase();
            if (!((String)object).startsWith("#") && (object2 = object2.getFirstChild()) != null && object2.getNodeType() == 3) {
                String string = object2.getNodeValue();
                try {
                    switch (infoType.valueOf((String)object)) {
                        case SPEED: {
                            gPSRecord.speed = Float.valueOf(string).floatValue() * 3.6f;
                            this.activeFileFields.speed = 0.0f;
                            break;
                        }
                        case COURSE: {
                            gPSRecord.heading = Float.valueOf(string).floatValue();
                            this.activeFileFields.heading = 0.0f;
                            break;
                        }
                        case ELE: {
                            gPSRecord.height = Float.valueOf(string).floatValue();
                            this.activeFileFields.height = 0.0f;
                            break;
                        }
                        case TIME: {
                            if (string.length() < 20) break;
                            int n2 = Integer.valueOf(string.substring(0, 4));
                            int n3 = Integer.valueOf(string.substring(5, 7));
                            int n4 = Integer.valueOf(string.substring(8, 10));
                            int n5 = Integer.valueOf(string.substring(11, 13));
                            int n6 = Integer.valueOf(string.substring(14, 16));
                            int n7 = Integer.valueOf(string.substring(17, 19));
                            gPSRecord.utc = n2 = JavaLibBridge.getDateInstance(n4, n3, n2).dateToUTCepoch1970() + (n5 * 3600 + n6 * 60 + n7);
                            this.activeFileFields.utc = 50000;
                            if (string.length() >= 24) {
                                gPSRecord.milisecond = Integer.valueOf(string.substring(20, string.length() - 1));
                                this.activeFileFields.milisecond = 100;
                            }
                            break;
                        }
                        case HDOP: {
                            gPSRecord.hdop = Math.round(Float.valueOf(string).floatValue() * 100.0f);
                            this.activeFileFields.hdop = 100;
                            break;
                        }
                        case VDOP: {
                            gPSRecord.vdop = Math.round(Float.valueOf(string).floatValue() * 100.0f);
                            this.activeFileFields.vdop = 100;
                            break;
                        }
                        case PDOP: {
                            gPSRecord.pdop = Math.round(Float.valueOf(string).floatValue() * 100.0f);
                            this.activeFileFields.pdop = 100;
                            break;
                        }
                        case FIX: {
                            object2 = string.toLowerCase();
                            if (((String)object2).equals("none")) {
                                gPSRecord.valid = 1;
                            } else if (((String)object2).equals("3d")) {
                                gPSRecord.valid = 2;
                            } else if (((String)object2).equals("dgps")) {
                                gPSRecord.valid = 4;
                            } else if (((String)object2).equals("pps")) {
                                gPSRecord.valid = 8;
                            }
                            this.activeFileFields.valid = 10;
                            break;
                        }
                        case TYPE: {
                            gPSRecord.rcr = 0;
                            this.activeFileFields.rcr = 1;
                            if (string.charAt(0) != 'X') {
                                if (string.indexOf(66, 0) != -1) {
                                    gPSRecord.rcr |= 8;
                                }
                                if (string.indexOf(84, 0) != -1) {
                                    gPSRecord.rcr |= 1;
                                }
                                if (string.indexOf(83, 0) != -1) {
                                    gPSRecord.rcr |= 2;
                                }
                                if (string.indexOf(68, 0) != -1) {
                                    gPSRecord.rcr |= 4;
                                }
                                if (string.indexOf(86, 0) != -1) {
                                    gPSRecord.rcr = 768;
                                }
                                if (string.indexOf(67, 0) == -1) break;
                                gPSRecord.rcr = 1280;
                            } else {
                                if (string.length() != 5) break;
                                gPSRecord.rcr = Conv.hex2Int(string.substring(1));
                            }
                            break;
                        }
                        case SYM: {
                            break;
                        }
                        case CMT: {
                            break;
                        }
                        case SAT: {
                            gPSRecord.nsat = Integer.valueOf(string) << 8;
                            this.activeFileFields.nsat = 10;
                            break;
                        }
                        case NAME: {
                            break;
                        }
                        case AGEOFDGPSDATA: {
                            gPSRecord.dage = Integer.valueOf(string);
                            break;
                        }
                        case DGPSID: {
                            gPSRecord.dsta = Integer.valueOf(string);
                            break;
                        }
                        case LINK: {
                            gPSRecord.voxStr = object2.getAttributes().getNamedItem("href").getTextContent();
                        }
                    }
                }
                catch (Exception exception) {
                    Generic.debug("Problem in trackpoint info:" + (String)object, exception);
                }
            }
            ++n;
        }
        return gPSRecord;
    }

    public static void main(String[] stringArray) {
        JavaLibBridge.setJavaLibImplementation(J2SEJavaTranslations.getInstance());
        new GPXLogConvert().toGPSFile(new BT747Path("c:/BT747/20080915_2010.gpx"), null);
    }

    @Override
    public int getType() {
        return 3;
    }

    static enum infoType {
        ELE,
        TIME,
        SPEED,
        HDOP,
        VDOP,
        PDOP,
        FIX,
        TYPE,
        SYM,
        COURSE,
        CMT,
        SAT,
        NAME,
        DGPSID,
        AGEOFDGPSDATA,
        LINK,
        EXTENSIONS;

    }
}

