## v161213

- **Bug Fix:** Prevent browser autocomplete in Comment Mail options. See [Issue #319](https://github.com/websharks/comment-mail/issues/319).
- **Bug Fix:** Searching by email address alone should always narrow to the search to that specific email address and not result in any fuzzy or fulltext matching. See [Issue #226](https://github.com/websharks/comment-mail/issues/226).
- **Bug Fix:** The conflict check for 'Subscribe to Comments Reloaded' was not working in the previous release; i.e., if you attempt to activate both Comment Mail and the 'Subscribe to Comments Reloaded' plugin at the same, this should result in a Dashboard warning. Fixed in this release. See [Issue #315](https://github.com/websharks/comment-mail/issues/315).
- **Bug Fix:** Notify 'Subscribe to Comments Reloaded' users about the comment form template being disabled under certain scenarios. See [Issue #314](https://github.com/websharks/comment-mail/issues/314).
- **Bug Fix:** Do not attempt to import 'Subscribe to Comments Reloaded' (StCR) settings if StCR is no longer installed, even if old StCR options exist in the database. See [Issue #294](https://github.com/websharks/comment-mail/issues/294).
- **Bug Fix** (Pro): Do not show SparkPost partner image when Mandrill is selected as the RVE handler. See [Issue #318](https://github.com/websharks/comment-mail/issues/318).
- **Bug Fix** (Pro): Conflict checks between lite and pro corrected. This was not working properly in the previous release; i.e., installing Comment Mail Pro when Comment Mail Lite is already running should result in Comment Mail Lite being deactivated automatically. See [Issue #270](https://github.com/websharks/comment-mail/issues/270).
- **New Feature:** It is now possible to manually process the outgoing mail queue. See: **WP Dashboard → Comment Mail → Mail Queue**. See also [Issue #282](https://github.com/websharks/comment-mail/issues/282).
- **New Feature** (Pro): In Comment Mail Pro it is now possible to enable/disable comment content clipping entirely; e.g., if you prefer that email notifications include the full original comment content in raw HTML instead of being clipped and displayed in the email as plain text. See: **WP Dashboard → Comment Mail → Config. Options → Email Notification Clips**. See also: [Issue #281](https://github.com/websharks/comment-mail/issues/281).
- **Accessibility:** This release improves screen reader accessibility by adding `aria-hidden="true"` to all FontAwesome icons. See [Issue #304](https://github.com/websharks/comment-mail/issues/304).
- **Accessibility:** This release improves screen reader accessibility by offering a new setting that allows a site owner to enable or disable select menu option enhancement via jQuery. Disabling select menu option enhancement has the benefit of improving accessibility for screen readers whenever accessibility is of more concern than presentation. See: **Dashboard → Comment Mail → Config Options → Misc. UI-Related Settings**. See also [Issue #304](https://github.com/websharks/comment-mail/issues/304).

## v161129

- **Bug Fix:** This release corrects a nasty bug that was first introduced in the previous release, resulting in the loss of template modifications when/if any Comment Mail options were edited after having upgraded to the previous release. See [Issue #322](https://github.com/websharks/comment-mail/issues/322).

  In short, please avoid v161118 (the previous release).

  _**Note:** If you already upgraded to v161118, but you have not edited your Comment Mail options yet (or had no template modifications anyway), there is no cause for alarm._

  _However, if you upgraded to v161118 and **did** edit your Comment Mail options after updating, and if you also modified Comment Mail templates, you may have experienced a loss of template data; i.e., the changes you made to the default templates may have been lost as a result of this bug. We are very sorry about this. Please see [Issue #322](https://github.com/websharks/comment-mail/issues/322) for additional details._

## v161118

- **Bug Fix:** Exclude unapproved comments from the dropdown menu on the 'Subscribe Without Commenting' form. See [Issue #299](https://github.com/websharks/comment-mail/issues/299).
- **Enhancement:** When parsing templates, this release uses `include()` instead of `eval()` whenever possible. This improves compatibility with shared hosting providers and makes it easier to debug template parsing issues should they occur. See [Issue #192](https://github.com/websharks/comment-mail/issues/192).
- **PHP v7 Compatibility:** After further testing, it was found that while Comment Mail is compatible with PHP v7.0, you must be running PHP v7.0.9+. Starting with this release of Comment Mail if you're running PHP v7 < 7.0.9 a warning is displayed in the WordPress Dashboard asking the site owner to upgrade to PHP v7.0.9 or higher. Note: While PHP v7.0.9 is adequate, PHP v7.0.10 is strongly recommended. See [Issue #272](https://github.com/websharks/comment-mail/issues/272).
- **New SparkPost Integration** (Pro):  It is now possible to use SparkPost for Replies-via-Email (RVE) instead of Mandrill. Note that SparkPost is now the suggested RVE Handler for Comment Mail because Mandrill changed its pricing structure a while back. In short, Mandrill requires a fee, whereas SparkPost (recommended) offers Relay Webhooks as a part of their free plan. See [Issue #265](https://github.com/websharks/comment-mail/issues/265).
- **New Feature** (Pro): Adding support for MailChimp integration. It is now possible to give users the option of subscribing to your site-wide mailing list whenever they leave a comment or reply; i.e., in addition to subscribing to comment reply notifications they can also join your MailChimp mailing list. See [Issue #114](https://github.com/websharks/comment-mail/issues/114).

## v160824

- **Bug Fix**: Fixed a bug that was generating a fatal error when replying to comments. This bug only affected the Lite version of Comment Mail and was introduced by the previous release (v160818) where [work](https://github.com/websharks/comment-mail/issues/285) was done to strip out unused Pro-only code from the Lite codebase. A few references to Pro-only functions were missed and that resulted in fatal errors for the Lite version in some scenarios. See [Issue #297](https://github.com/websharks/comment-mail/issues/297).

## v160818

- **Bug Fix**: Fixed a bug where the "My Comment Subscriptions" link would appear on the Add New Subscription page (when Subscribing without Commenting) and would lead to a page that displayed an error message stating that there were no subscriptions to list. That link is now hidden when there are no subscriptions to list. Props @Reedyseth @kristineds. See [Issue #229](https://github.com/websharks/comment-mail/issues/229).
- **Bug Fix** (Pro): Removed an erroneous anchor tag in the Advanced Template for Comment Notification Message Body. Props @kristineds. See [Issue #287](https://github.com/websharks/comment-mail/issues/287).
- **UI Enhancement:** Improved the nav bar at the top of the options pages to reduce unnecessary whitespace. Also moved the Restore button to the nav bar so that it's not so prominent. Props @renzms. See [Issue #284](https://github.com/websharks/comment-mail/issues/284).
- **UI Enhancement:** Added links to the Comment Mail [Twitter](http://twitter.com/CommentMail) and [Facebook](https://www.facebook.com/Comment-Mail-565683256946855/) pages to the nav bar on the options page. Props @renzms. See [Issue #286](https://github.com/websharks/comment-mail/issues/286).
- **UX Enhancement:** Removed IP address information from email notification templates to better comply with data protection laws in certain countries. Props @kristineds. See [Issue #288](https://github.com/websharks/comment-mail/issues/288).
- **SEO Improvement:** Added `rel="nofollow"` to the "Subscribe without Commenting" link and "Manage Subscriptions" link on the comment subscription form to avoid indexing or transferring PageRank. Props @IvanRF. See [Issue #80](https://github.com/websharks/comment-mail-pro/pull/80).
- Removed several development-only files from the distributable that were inadvertently included during the build process. See [Issue #285](https://github.com/websharks/comment-mail/issues/285).
- Added Renz Sevilla (`renzms`) to the contributors list.

## v160618

- **Restructured Codebase**: The codebase has been completely restructured to improve performance, enhance flexibility, and make it easier to build in new features! Props @jaswsinc. See [Issue #150](https://github.com/websharks/comment-mail/issues/150).
- **Comment Mail Pro Upgrade Notice: Incompatible Advanced Templates.** This version of Comment Mail includes a rewritten and improved codebase. This rewrite, however, came with the unfortunate side effect of breaking backwards compatibility with Advanced Templates that were customized in a previous version of Comment Mail Pro.

     If you are currently using Comment Mail Pro and you've customized your Advanced Templates, all of your customized Advanced Templates will be backed up and the templates will then be reset to their new defaults. You will find the backup of your old customized template appended to the bottom of the new template, separated with a  <code>Legacy Template Backup</code> PHP comment. See [example screenshots](https://github.com/websharks/comment-mail/issues/238#issuecomment-225029042).

     Note: This change has no effect on Simple templates—only Advanced Templates are affected. Advanced Templates are a Pro-only feature, so this notice only applies to Comment Mail Pro. See [Issue #238](https://github.com/websharks/comment-mail/issues/238).
- **Bug Fix**: Fixed a bug where `esc_html()` was being used where `esc_sql()` should've been used. Props @jaswsinc @kristineds. See [Issue #268](https://github.com/websharks/comment-mail/issues/268).
- **Bug Fix**: Fixed a bug that in some scenarios resulted in a "DB table creation failure" error when activating the plugin. Props @thienhaxanh2405, @PanNovak, @kristineds, and @jaswsinc. See [Issue #260](https://github.com/websharks/comment-mail/issues/260).
- **Bug Fix**: Fixed a bug where "New reply" notification emails were not being parsed properly by some Hotmail accounts and were showing up as blank. Props @kristineds. See [Issue #259](https://github.com/websharks/comment-mail/issues/259).
- **Bug Fix**: Fixed a bug that allowed spam comments to create subscriptions in Comment Mail when using Akismet. Props @IvanRF. See [Issue #250](https://github.com/websharks/comment-mail/issues/250).
- **Bug Fix** (Pro): When Chrome or Firefox Autofill Username/Password was enabled, the Comment Mail Pro Updater fields would incorrectly be autofilled by the browser with invalid credentials. This has been fixed. Props @renzms. [Issue #274](https://github.com/websharks/comment-mail/issues/274).
- **Bug Fix**: Fixed a bug where the cron job for the Queue Processor could get deleted and never recreated, which would result in notifications getting stuck in the Mail Queue and not being sent out. If you ever installed Comment Mail and then deleted it (without first disabling Data Safeguards), and then installed Comment Mail again, you were probably affected by this issue. This release fixes the issue and makes the cron setup more robust. Props @kristineds, @renzms, @jaswsinc, and @IvanRF for help testing. See [Issue #194](https://github.com/websharks/comment-mail/issues/194) and [Issue #173](https://github.com/websharks/comment-mail/issues/173).
- **Bug Fix:** Fixed a bug where a subscriber who selected Hourly Digest and who had never been notified before could, in some scenarios, have their subscription treated instead as a Weekly Digest. This bug was found and fixed during the codebase restructuring. Props @jaswsinc. See [Issue #150](https://github.com/websharks/comment-mail/issues/150) and additional discussion in [Issue #173](https://github.com/websharks/comment-mail/issues/173#issuecomment-225215333).
- **Bug Fix:** Fixed a bug where in some scenarios Mail Queue entries for Digest Notifications that should have been held for sending later were not being held and were also not being sent. They also would not have shown up in the Mail Queue Event Log. This bug was found and fixed during the codebase restructuring. Props @jaswsinc. See [Issue #150](https://github.com/websharks/comment-mail/issues/150) and additional discussion in [Issue #173](https://github.com/websharks/comment-mail/issues/173#issuecomment-225215333).
- **Enhancement**: Minor improvements to the Options Page menu links and positioning of the Pro Preview link. Props @renzms. See [Issue #227](https://github.com/websharks/comment-mail/issues/227).
- **Enhancement**: It's now possible to use the following shortcodes in the Email Footer Tag for Email Footer Templates: `[home_url]`, `[blog_name_clip]`, and `[current_host_path]`. Props @kristineds and @IvanRF. See [Issue #246](https://github.com/websharks/comment-mail/issues/246).
- **Enhancement**: Improved the Subscriptions meta box that appears on the Post Edit screen. For each subscription, the meta box now lists the full name and email address, the date the subscription was created, and a view link that allows you to view/edit the subscription. Props @kristineds. See [Issue #231](https://github.com/websharks/comment-mail/issues/231).
- **UX Enhancement (Pro)**: Improved the Dashboard notice that appears when you try to enable the Pro version of Comment Mail when the Lite version is currently enabled. Props @kristineds @jaswsinc. See [Issue #230](https://github.com/websharks/comment-mail/issues/230).
- **UX Enhancement**: When Subscribing Without Commenting, the Add New Subscription form now pre-populates the Name and Email address fields whenever possible. Props @kristineds. See [Issue #204](https://github.com/websharks/comment-mail/issues/204).
- **UI Enhancement**: Dashboard notices generated by Comment Mail now use the WordPress-style dismiss button to keep things consistent. Props @kristineds. See [Issue #193](https://github.com/websharks/comment-mail/issues/193).

## v160213

- **Minor Fix**: Fixed a spelling mistake in one of the default email templates. Props @kristineds  @RealDavidoff. See [Issue #208](https://github.com/websharks/comment-mail/issues/208).
- **Enhancement**: Moved the default location for the Subscriptions Meta Box on the Post Edit screen so that it shows up underneath the post editing area instead of above the Publish box. See [Issue #57](https://github.com/websharks/comment-mail/issues/57#issuecomment-174482908).
- **Enhancement**: Removed an irrelevant and confusing note from the Add New Subscription page. Props @kristineds @RealDavidoff. See [Issue #207](https://github.com/websharks/comment-mail/issues/207).
- **Enhancement**: Improved the front-end Edit Subscription form and removed the "x" in on the Status and Deliver fields that allowed clearing those fields, which did not make sense since both of those fields are required. Props @kristineds. See [Issue #195](https://github.com/websharks/comment-mail/issues/195).
- **Enhancement**: Improved the way some links work by opening on-site links in current tab, and external links in new tab. Props @RealDavidoff @kristineds @renzms. See [Issue #202](https://github.com/websharks/comment-mail/issues/202).
- **Enhancement**: Improved front-end pages by using `<em>` (emphasis) tags instead of quotation marks in various areas. Props @RealDavidoff @renzms. See [Issue #201](https://github.com/websharks/comment-mail/issues/201).
- **Enhancement**: Improved email templates by simplifying the subject lines by using `[` and `]` brackets around the meta information in the subject. See [Issue #232](https://github.com/websharks/comment-mail/issues/232).
- **Enhancement**: When Subscribing Without Commenting, the Add New Subscription form now pre-populates the Name and Email address fields whenever possible. Props @kristineds. See [Issue #204](https://github.com/websharks/comment-mail/issues/204).
- **Enhancement**: Improved the consistency of how we refer to the "instant" delivery option by replacing any occurrences of "asap" with "instantly". These names were previously being mixed. We now use "instantly". Props @RealDavidoff @renzms @kristineds. See [Issue #206](https://github.com/websharks/comment-mail/issues/206).
- **Enhancement**: Added the installed version number to the plugin options pages. Props @kristineds. See [Issue #187](https://github.com/websharks/comment-mail/issues/187).
- **Enhancement**: Improved the organization of navigation links on the plugin options pages. Props @kristineds. See [Issue #187](https://github.com/websharks/comment-mail/issues/187).

## v151224

- **Bug Fix** (Multisite): Fixed a Multisite uninstallation bug that was preventing Comment Mail from taking Child Blogs into consideration when uninstalling, which was resulting in an incomplete uninstallation. See [Issue #136](https://github.com/websharks/comment-mail/issues/136).
- **Bug Fix** (StCR Import): This release corrects an StCR importation bug. The bug was causing an existing StCR subscription with a `Y` status (i.e., one for all comments/replies) to be imported into Comment Mail on a per-comment basis. Therefore, a symptom of this bug was to find that you had multiple subscriptions imported for users who wanted _all_ comments, instead of them just having one subscription imported which would automatically cover the entire post. See also [Issue #162](https://github.com/websharks/comment-mail/issues/162).
- **Bug Fix** (StCR Import): Fixed a bug with the StCR Import routine that was preventing subscriptions for comments awaiting approval from being imported. See [Issue #182](https://github.com/websharks/comment-mail/issues/182).
- **Bug Fix** (StCR Import): Fixed a bug in how the Subscribe to Comments Reloaded Import routine counts imported subscriptions. Comment Mail was previously reporting the number of subscriptions that it created during the import as the total number imported, however due to a difference in how Comment Mail and StCR store subscriptions, the total number of StCR subscriptions imported is almost always going to be different from the number of subscriptions that Comment Mail creates. This difference resulted in confusion about why the total StCR subscriptions did not match the total reported by Comment Mail as "imported". This has been fixed by adjusting what is reported as 'total imported' and including two new pieces of information: 'total skipped' and 'total created'. When you add the 'total imported' and 'total skipped' numbers together, that number should equal the number of subscriptions reported in StCR. Props @Reedyseth @jaswsinc. See [Issue #166](https://github.com/websharks/comment-mail/issues/166).
- **Bug Fix**: Removed a UTF-8 "Branch Icon" in the default email templates that was not showing up properly in some email clients. Props @renzms @kristineds. See [Issue #116](https://github.com/websharks/comment-mail/issues/116).
- **Bug Fix**: Fixed an email template bug that was forcing an ellipsis to show even when the length of the comment content was shorter than the max length. See [this commit](https://github.com/websharks/comment-mail/commit/80aab562fb1fe3cdcdb4f10eda7e74c8ea21aa61) for details.
- **Bug Fix**: Fixed an email template bug that was not linking the "add reply" link directly to the comment form for replying to the comment (it was just linking to the comment itself). See [this commit](https://github.com/websharks/comment-mail/commit/686b2737e708dc4a70ede129b7f4a9151c150907#commitcomment-14925636) for details.
- **Bug Fix**: Fixed a bug with "Restore Default Options" that was introducing a browser quirk that was preventing the default options from being restored. Props @renzms. See [Issue #181](https://github.com/websharks/comment-mail/issues/181).
- **Bug Fix**: Fixed a bug where certain icons would not appear, or the wrong icon would appear, when Comment Mail was installed alongside the ZenCache plugin. Both plugins use the same Sharkicons library, but were using different versions, which introduced a conflict. Comment Mail has been updated to use the latest version of the Sharkicons library. Props @Reedyseth. See [Issue #87](https://github.com/websharks/comment-mail/issues/87#issuecomment-166458711).
- **Bug Fix**: Fixed a UI bug where some of the Dashboard notices generated by Comment Mail were either misaligned or were clashing with the Subscribe to Comments Reloaded options menu. Props @renzms. See [Issue #186](https://github.com/websharks/comment-mail/issues/186).
- **Enhancement (Pro)**: Added a "Pro" label to the plugin name to clearly indicate when the Pro version of Comment Mail is installed. Props @kristineds. See [Issue #131](https://github.com/websharks/comment-mail/issues/131).
- **Enhancement (Pro)**: Added a note to the default email templates when RVE (Replies via Email) is enabled, warning email readers that "Your reply will be posted publicly and immediately." Props @Reedyseth. See [Issue #123](https://github.com/websharks/comment-mail/issues/123).
- **Enhancement (Pro):** If you have Comment Mail's SSO integration enabled and have users who are registering an account via Facebook, Twitter, LinkedIn, or Google+, the SSO service that a particular user (or commenter) signed up with is now shown in the list of Users. Props @kristineds See [Issue #73](https://github.com/websharks/comment-mail/issues/73).
- **Enhancement (Pro):** Theme Syntax Highlighting: This release makes it possible for the color-scheme used in template file syntax highlighting to be changed to any one of 30+ options. See: _Dashboard → Comment Mail → Config. Options → Template-Related Settings_. Props @kristineds. See [Issue #147](https://github.com/websharks/comment-mail/issues/147).
- **Enhancement** (StCR Import): Moved the Import Status box (for importing Subscribe to Comments Reloaded subscriptions) up underneath the "Begin StCR Auto-Importation" button to improve visibility when importing subscriptions. See [Issue #172](https://github.com/websharks/comment-mail/issues/172).
- **Enhancement** (StCR Import): The "Upgrading from Subscribe to Comments Reloaded" notice, which appears when installing Comment Mail on a site running the StCR plugin, is now automatically hidden once you run the StCR import process. See [Issue #169](https://github.com/websharks/comment-mail/issues/169).
- **Enhancement** (StCR Import): During the import process, Comment Mail now keeps track of and reports total number of StCR subscriptions skipped and total number of Comment Mail subscriptions created. Skipped subscriptions are the number of StCR subscriptions that were not imported for one of several possible reasons. See [Issue #166](https://github.com/websharks/comment-mail/issues/166).
- **Enhancement** (StCR Import): The StCR importer now generates a log file in `comment-mail-pro/stcr-import-failures.log` that includes reports of any failures or skipped subscriptions, along with information about why they failed or why they were skipped. Note that this file is only created if there were failures or skipped subscriptions during import. See [Issue #166](https://github.com/websharks/comment-mail/issues/166).
- **Enhancement**: Removed references to "CAN-SPAM Act", which is a United States law that may not be understood or applicable to Comment Mail users outside of the United States. Props @Li-An and @kristineds. See [Issue #122](https://github.com/websharks/comment-mail/issues/122).
- **Enhancement**: Added the default translation file. Translators can now build translations using the default translation file located in `includes/translations/`. Props @kristineds. See [Issue #118](https://github.com/websharks/comment-mail/issues/118).
- **Enhancement**: Improved the on-hover color when hovering the mouse over Option Panels in the Comment Mail Options by changing it from green to dark blue. Props @kristineds. See [Issue #117](https://github.com/websharks/comment-mail/issues/117).
- **Enhancement**: Improved the Subscriptions table and the Event Log UI by using proper case for Status and Event values. Props @kristineds. See [Issue #72](https://github.com/websharks/comment-mail/issues/72).
- **Enhancement**: Comment Mail is now only enabled for the standard `post` Post Type by default and there's a new "Enable for Post Types" option inside _Comment Mail → Config. Options → Enable/Disable_ that allows you to specify a comma-delimited list of Post Types that Comment Mail should be enabled for. It's also possible to enable Comment Mail on all Post Types that support comments by leaving the field empty (this was the previous behavior). Props to @bonest. See [Issue #149](https://github.com/websharks/comment-mail/issues/149).
- **Enhancement**: Improved Dashboard notices. The "Upgrading from Subscribe to Comments Reloaded" message has been improved and a new Dashboard notice lets you know when Comment Mail is disabled. Props @kristineds. See [Issue #163](https://github.com/websharks/comment-mail/issues/163).
- **Enhancement**: Many improvements the default email templates. The templates are now fully responsive and look much better on mobile devices. The wording in several places was also cleaned up for clarity and consistency and any references to an ID# (which is generally useless for readers) have been removed. The default templates also use a single font style now instead of mixing font styles and the email templates no longer use tables (this improves responsiveness). If you've modified the default Comment Mail email templates on your site, your changes will not be overwritten by updating, however if you've modified the templates and you want to get these changes, you'll need to reset to the default email templates and make your changes again (you can do this by emptying the email template fields completely and saving your options). See [Issue #77](https://github.com/websharks/comment-mail/issues/77).
- **Enhancement**: Ellipses (`...`) in email templates are now surrounded by square brackets (i.e., `[...]`) to avoid confusion about whether or not the ellipsis was part of the comment content. See [Issue #77](https://github.com/websharks/comment-mail/issues/77).
- **Enhancement**: In the email templates, the "Add Reply" links have been changed to "Reply" and when the reply is in response to someone and we have the authors name, the link includes the authors name (e.g., "Reply to <author-name>"). See [Issue #77](https://github.com/websharks/comment-mail/issues/77).
- **Enhancement**: Updated email templates to use `\WP_Comment` instead of `\stdClass` where appropriate. See [Issue #77](https://github.com/websharks/comment-mail/issues/77).
- **Enhancement**: The manual "Add New Subscription" functionality has been hidden from the front-end of the site (i.e., hidden from the "My Comment Subscriptions" page that subscribers use to manage their subscriptions, and from email templates). Note that this change has no effect on the subscription options that appear on the comment form itself. See discussion in [Issue #108](https://github.com/websharks/comment-mail/issues/108#issuecomment-161462209).
- **WordPress v4.4 Compatibility:** Fixed a compatibility bug with WordPress v4.4. Props @jaswsinc. See [Issue #170](https://github.com/websharks/comment-mail/issues/170).
- **Jetpack Compatibility:** This release fixes a bug in the automatic Jetpack conflict detection; i.e., if you enable Jetpack Subscriptions w/ Follow Comments enabled together with Comment Mail at the same, a warning is displayed to notify you of a possible conflict in your configuration. See [Issue #113](https://github.com/websharks/comment-mail/issues/113).

## v150709 

- Initial release.
