/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.LoadingState;
import com.intellij.util.containers.ObjectLongHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StartUpMeasurer {
    static final AtomicReference<LoadingState> currentState = new AtomicReference<LoadingState>(LoadingState.BOOTSTRAP);
    public static final long MEASURE_THRESHOLD = TimeUnit.MILLISECONDS.toNanos(10L);
    public static boolean measuringPluginStartupCosts = true;
    private static long startTime = System.nanoTime();
    private static final ConcurrentLinkedQueue<ActivityImpl> items = new ConcurrentLinkedQueue();
    private static boolean isEnabled = true;
    @ApiStatus.Internal
    public static final Map<String, ObjectLongHashMap<String>> pluginCostMap = new HashMap<String, ObjectLongHashMap<String>>();

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static long getCurrentTime() {
        return System.nanoTime();
    }

    @NotNull
    public static Activity startActivity(@NotNull String name) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(1);
        }
        return StartUpMeasurer.startActivity(name, ActivityCategory.APP_INIT);
    }

    @NotNull
    public static Activity startActivity(@NotNull String name, @NotNull ActivityCategory category) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(2);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(3);
        }
        return StartUpMeasurer.startActivity(name, category, null);
    }

    @NotNull
    public static Activity startActivity(@NotNull String name, @NotNull ActivityCategory category, @Nullable String pluginId) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(4);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(5);
        }
        ActivityImpl activity = new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, pluginId);
        activity.setCategory(category);
        ActivityImpl activityImpl = activity;
        if (activityImpl == null) {
            StartUpMeasurer.$$$reportNull$$$0(6);
        }
        return activityImpl;
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NotNull Class<?> clazz, @NotNull ActivityCategory category, @Nullable String pluginId, long l) {
        void threshold;
        if (clazz == null) {
            StartUpMeasurer.$$$reportNull$$$0(10);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(11);
        }
        if (!isEnabled) {
            return -1L;
        }
        long end = StartUpMeasurer.getCurrentTime();
        long duration = end - start;
        if (duration <= threshold) {
            return duration;
        }
        StartUpMeasurer.addCompletedActivity(start, end, clazz.getName(), category, pluginId);
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    public static void addCompletedActivity(long start, long end, @NotNull String name, @NotNull ActivityCategory activityCategory, String string2) {
        void category;
        void pluginId;
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(14);
        }
        if (activityCategory == null) {
            StartUpMeasurer.$$$reportNull$$$0(15);
        }
        if (!isEnabled) {
            return;
        }
        ActivityImpl item = new ActivityImpl(name, start, null, (String)pluginId);
        item.setCategory((ActivityCategory)category);
        item.setEnd(end);
        StartUpMeasurer.addActivity(item);
    }

    @ApiStatus.Internal
    public static long getStartTime() {
        return startTime;
    }

    static void addActivity(@NotNull ActivityImpl activity) {
        if (activity == null) {
            StartUpMeasurer.$$$reportNull$$$0(21);
        }
        items.add(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void addPluginCost(@NotNull String pluginId, @NotNull String phase, long time) {
        if (pluginId == null) {
            StartUpMeasurer.$$$reportNull$$$0(24);
        }
        if (phase == null) {
            StartUpMeasurer.$$$reportNull$$$0(25);
        }
        if (!StartUpMeasurer.isMeasuringPluginStartupCosts()) {
            return;
        }
        Map<String, ObjectLongHashMap<String>> map2 = pluginCostMap;
        synchronized (map2) {
            StartUpMeasurer.doAddPluginCost(pluginId, phase, time, pluginCostMap);
        }
    }

    public static boolean isMeasuringPluginStartupCosts() {
        return measuringPluginStartupCosts;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static void doAddPluginCost(@NotNull String pluginId, @NotNull String phase, long time, @NotNull Map<String, ObjectLongHashMap<String>> map2) {
        long oldCost;
        void pluginCostMap;
        ObjectLongHashMap<String> costPerPhaseMap;
        if (pluginId == null) {
            StartUpMeasurer.$$$reportNull$$$0(26);
        }
        if (phase == null) {
            StartUpMeasurer.$$$reportNull$$$0(27);
        }
        if (map2 == null) {
            StartUpMeasurer.$$$reportNull$$$0(28);
        }
        if ((costPerPhaseMap = (ObjectLongHashMap<String>)((Object)pluginCostMap.get(pluginId))) == null) {
            costPerPhaseMap = new ObjectLongHashMap<String>();
            pluginCostMap.put(pluginId, costPerPhaseMap);
        }
        if ((oldCost = costPerPhaseMap.get(phase)) == -1L) {
            oldCost = 0L;
        }
        costPerPhaseMap.put(phase, oldCost + time);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/StartUpMeasurer";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedState";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timings";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginCostMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/StartUpMeasurer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startActivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addInstantEvent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startActivity";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startMainActivity";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addCompletedActivity";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentState";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetCurrentState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "stateSet";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processAndClear";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addActivity";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addTimings";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addPluginCost";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doAddPluginCost";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

