import { Bridge } from "../bridge";
export interface ThinRequest {
    getId(): string;
}
interface QueueUserItem {
    type: "join" | "leave";
    kickUser?: string;
    reason?: string;
    attempts: number;
    roomId: string;
    userId: string;
    retry: boolean;
    req: ThinRequest;
}
export interface MembershipQueueOpts {
    concurrentRoomLimit: number;
    maxAttempts: number;
    joinDelayMs: number;
    maxJoinDelayMs: number;
}
/**
 * This class sends membership changes for rooms in a linearized queue.
 */
export declare class MembershipQueue {
    private bridge;
    private opts;
    private queues;
    constructor(bridge: Bridge, opts: MembershipQueueOpts);
    /**
     * Join a user to a room
     * @param roomId The roomId to join
     * @param userId Leave empty to act as the bot user.
     * @param req The request entry for logging context
     * @param retry Should the request retry if it fails
     */
    join(roomId: string, userId: string | undefined, req: ThinRequest, retry?: boolean): Promise<void>;
    /**
     * Leave OR kick a user from a room
     * @param roomId The roomId to leave
     * @param userId Leave empty to act as the bot user.
     * @param req The request entry for logging context
     * @param retry Should the request retry if it fails
     * @param reason Reason for leaving/kicking
     * @param kickUser The user to be kicked. If left blank, this will be a leave.
     */
    leave(roomId: string, userId: string, req: ThinRequest, retry?: boolean, reason?: string, kickUser?: string): Promise<void>;
    queueMembership(item: QueueUserItem): Promise<void>;
    private hashRoomId;
    private serviceQueue;
    private shouldRetry;
}
export {};
