/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.primitives.Else;
import com.dickimawbooks.texparserlib.primitives.Fi;
import com.dickimawbooks.texparserlib.primitives.If;
import com.dickimawbooks.texparserlib.primitives.Or;
import java.io.IOException;

public class IfCase
extends If {
    public IfCase() {
        this("ifcase");
    }

    public IfCase(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new IfCase(this.getName());
    }

    @Override
    public boolean istrue(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        return numerical.number(teXParser) == 0;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        int n = numerical.number(teXParser);
        if (n == 0) {
            this.doCase(teXParser, teXObjectList, teXObjectList2);
        } else {
            this.skipToCase(n, teXParser, teXObjectList, teXObjectList2);
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    protected void doCase(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        TeXObjectList teXObjectList3;
        TeXObject teXObject = teXObjectList.popToken();
        if (teXObject instanceof Expandable && (teXObjectList3 = teXParser == teXObjectList ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObjectList.addAll(0, teXObjectList3);
            teXObject = teXObjectList.popToken();
        }
        if (teXObject instanceof Else || teXObject instanceof Or) {
            this.skipToFi(teXParser, teXObjectList);
        } else if (!(teXObject instanceof Fi)) {
            if (teXObjectList2 == null) {
                if (teXParser == teXObjectList) {
                    teXObject.process(teXParser);
                } else {
                    teXObject.process(teXParser, teXObjectList);
                }
            } else {
                teXObjectList2.add(teXObject);
            }
            this.doCase(teXParser, teXObjectList, teXObjectList2);
        }
    }

    protected void skipToCase(int n, TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        int n2 = 0;
        while (n2 > -1 && n2 < n) {
            n2 = this.skipToCase(n2, n, teXParser, teXObjectList, teXObjectList2);
        }
        if (n2 > -1) {
            this.doCase(teXParser, teXObjectList, teXObjectList2);
        }
    }

    protected int skipToCase(int n, int n2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        TeXObject teXObject = teXObjectList.popToken();
        if (teXObject instanceof TeXCsRef) {
            teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
        }
        if (teXObject == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.expected", "\\fi");
        }
        if (teXObject instanceof Or) {
            return n + 1;
        }
        if (teXObject instanceof Else) {
            return n2;
        }
        if (teXObject instanceof Fi) {
            return -1;
        }
        return this.skipToCase(n, n2, teXParser, teXObjectList, teXObjectList2);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXObjectList.add(0, this.expandonce(teXParser, teXObjectList));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.add(0, this.expandonce(teXParser));
    }
}

