/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.backend.common.lower.inline.InlineFunctionResolver;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/inline/DefaultInlineFunctionResolver;", "Lorg/jetbrains/kotlin/backend/common/lower/inline/InlineFunctionResolver;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getFunctionDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "ir.backend.common"})
public class DefaultInlineFunctionResolver
implements InlineFunctionResolver {
    @NotNull
    private final CommonBackendContext context;

    @Override
    @NotNull
    public IrFunction getFunctionDeclaration(@NotNull IrFunctionSymbol symbol2) {
        Object object;
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        FunctionDescriptor functionDescriptor = symbol2.getDescriptor().getOriginal();
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "symbol.descriptor.original");
        FunctionDescriptor descriptor2 = functionDescriptor;
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this.getContext().getConfiguration());
        if (CommonCoroutineCodegenUtilKt.isBuiltInIntercepted(descriptor2, languageVersionSettings)) {
            String string2 = "Continuation.intercepted is not available with release coroutines";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (CommonCoroutineCodegenUtilKt.isBuiltInSuspendCoroutineUninterceptedOrReturn(descriptor2, languageVersionSettings)) {
            object = this.getContext().getIr().getSymbols().getSuspendCoroutineUninterceptedOrReturn().getOwner();
        } else if (Intrinsics.areEqual(symbol2, this.getContext().getIr().getSymbols().getCoroutineContextGetter())) {
            object = this.getContext().getIr().getSymbols().getCoroutineGetContext().getOwner();
        } else {
            IrSimpleFunction irSimpleFunction;
            IrFunction irFunction = symbol2.getOwner();
            if (!(irFunction instanceof IrSimpleFunction)) {
                irFunction = null;
            }
            object = (irSimpleFunction = (IrSimpleFunction)irFunction) != null && (irSimpleFunction = IrFakeOverrideUtilsKt.resolveFakeOverride$default(irSimpleFunction, false, null, 3, null)) != null ? (IrFunction)irSimpleFunction : symbol2.getOwner();
        }
        return object;
    }

    @NotNull
    public CommonBackendContext getContext() {
        return this.context;
    }

    public DefaultInlineFunctionResolver(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }
}

