/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.download;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.osmand.Collator;
import net.osmand.OsmAndCollator;
import net.osmand.map.OsmandRegions;
import net.osmand.map.WorldRegion;
import net.osmand.plus.download.DownloadActivityType;
import net.osmand.plus.download.DownloadResources;
import net.osmand.plus.download.IndexItem;
import net.sourceforge.offroad.OsmWindow;

public class DownloadResourceGroup {
    private final DownloadResourceGroupType type;
    private final DownloadResourceGroup parentGroup;
    private final List<IndexItem> individualResources;
    private final List<DownloadResourceGroup> groups;
    protected final String id;
    protected WorldRegion region;

    public DownloadResourceGroup(DownloadResourceGroup parentGroup, DownloadResourceGroupType type) {
        this(parentGroup, type, type.getDefaultId());
    }

    public DownloadResourceGroup(DownloadResourceGroup parentGroup, DownloadResourceGroupType type, String id2) {
        boolean flat = type.containsIndexItem();
        if (flat) {
            this.individualResources = new ArrayList<IndexItem>();
            this.groups = null;
        } else {
            this.individualResources = null;
            this.groups = new ArrayList<DownloadResourceGroup>();
        }
        this.id = id2;
        this.type = type;
        this.parentGroup = parentGroup;
    }

    public static WorldRegion getRegion(DownloadResourceGroup group) {
        if (group != null) {
            if (group.getRegion() != null) {
                return group.getRegion();
            }
            if (group.getParentGroup() != null) {
                return DownloadResourceGroup.getRegion(group.getParentGroup());
            }
            return null;
        }
        return null;
    }

    public DownloadResourceGroup getRegionGroup(WorldRegion region) {
        DownloadResourceGroup res = null;
        if (this.region == region) {
            res = this;
        } else if (this.groups != null) {
            for (DownloadResourceGroup group : this.groups) {
                if (group.region == region) {
                    res = group;
                    break;
                }
                res = group.getRegionGroup(region);
                if (res == null) continue;
                break;
            }
        }
        return res;
    }

    public void trimEmptyGroups() {
        if (this.groups != null) {
            for (DownloadResourceGroup gr : this.groups) {
                gr.trimEmptyGroups();
            }
            Iterator<DownloadResourceGroup> gr = this.groups.iterator();
            while (gr.hasNext()) {
                DownloadResourceGroup group = gr.next();
                if (!group.isEmpty()) continue;
                gr.remove();
            }
        }
    }

    public void createHillshadeSRTMGroups() {
        if (this.getType().isScreen()) {
            DownloadResourceGroup subregs;
            DownloadResourceGroup regionMaps = this.getSubGroupById(DownloadResourceGroupType.REGION_MAPS.getDefaultId());
            if (regionMaps != null && regionMaps.size() == 1 && this.parentGroup != null && this.parentGroup.getParentGroup() != null && this.isEmpty(this.getSubGroupById(DownloadResourceGroupType.SUBREGIONS.getDefaultId()))) {
                DownloadResourceGroup hillshades;
                IndexItem item = regionMaps.individualResources.get(0);
                DownloadResourceGroup screenParent = this.parentGroup.getParentGroup();
                if (item.getType() == DownloadActivityType.HILLSHADE_FILE) {
                    hillshades = screenParent.getSubGroupById(DownloadResourceGroupType.HILLSHADE_HEADER.getDefaultId());
                    if (hillshades == null) {
                        hillshades = new DownloadResourceGroup(screenParent, DownloadResourceGroupType.HILLSHADE_HEADER);
                        screenParent.addGroup(hillshades);
                    }
                    hillshades.addItem(item);
                    regionMaps.individualResources.remove(0);
                } else if (item.getType() == DownloadActivityType.SRTM_COUNTRY_FILE) {
                    hillshades = screenParent.getSubGroupById(DownloadResourceGroupType.SRTM_HEADER.getDefaultId());
                    if (hillshades == null) {
                        hillshades = new DownloadResourceGroup(screenParent, DownloadResourceGroupType.SRTM_HEADER);
                        screenParent.addGroup(hillshades);
                    }
                    hillshades.addItem(item);
                    regionMaps.individualResources.remove(0);
                }
            }
            if ((subregs = this.getSubGroupById(DownloadResourceGroupType.SUBREGIONS.getDefaultId())) != null) {
                for (DownloadResourceGroup g : subregs.getGroups()) {
                    g.createHillshadeSRTMGroups();
                }
            }
        }
    }

    private boolean isEmpty(DownloadResourceGroup subGroupById) {
        return subGroupById == null || subGroupById.isEmpty();
    }

    public void addGroup(DownloadResourceGroup g) {
        if (this.type.isScreen() && !g.type.isHeader()) {
            throw new UnsupportedOperationException("Trying to add " + g.getUniqueId() + " to " + this.getUniqueId());
        }
        if (this.type.isHeader() && !g.type.isScreen()) {
            throw new UnsupportedOperationException("Trying to add " + g.getUniqueId() + " to " + this.getUniqueId());
        }
        this.groups.add(g);
        if (g.individualResources != null) {
            final Collator collator = OsmAndCollator.primaryCollator();
            final OsmandRegions osmandRegions = OsmWindow.getInstance().getRegions();
            Collections.sort(g.individualResources, new Comparator<IndexItem>(){

                @Override
                public int compare(IndexItem lhs, IndexItem rhs) {
                    int rri;
                    int lli = lhs.getType().getOrderIndex();
                    if (lli < (rri = rhs.getType().getOrderIndex())) {
                        return -1;
                    }
                    if (lli > rri) {
                        return 1;
                    }
                    return collator.compare(lhs.getVisibleName(OsmWindow.getInstance(), osmandRegions), rhs.getVisibleName(OsmWindow.getInstance(), osmandRegions));
                }
            });
        }
    }

    public void addItem(IndexItem i) {
        i.setRelatedGroup(this);
        this.individualResources.add(i);
    }

    public boolean isEmpty() {
        return this.isEmpty(this.individualResources) && this.isEmpty(this.groups);
    }

    private boolean isEmpty(List<?> l) {
        return l == null || l.isEmpty();
    }

    public DownloadResourceGroup getParentGroup() {
        return this.parentGroup;
    }

    public List<DownloadResourceGroup> getGroups() {
        return this.groups;
    }

    public int size() {
        return this.groups != null ? this.groups.size() : this.individualResources.size();
    }

    public DownloadResourceGroup getGroupByIndex(int ind) {
        if (this.groups != null && ind < this.groups.size()) {
            return this.groups.get(ind);
        }
        return null;
    }

    public IndexItem getItemByIndex(int ind) {
        if (this.individualResources != null && ind < this.individualResources.size()) {
            return this.individualResources.get(ind);
        }
        return null;
    }

    public DownloadResources getRoot() {
        if (this instanceof DownloadResources) {
            return (DownloadResources)this;
        }
        if (this.parentGroup != null) {
            return this.parentGroup.getRoot();
        }
        return null;
    }

    public DownloadResourceGroupType getType() {
        return this.type;
    }

    public DownloadResourceGroup getGroupById(String uid) {
        String[] lst = uid.split("\\#");
        return this.getGroupById(lst, 0);
    }

    public DownloadResourceGroup getSubGroupById(String uid) {
        String[] lst = uid.split("\\#");
        return this.getSubGroupById(lst, 0);
    }

    public List<IndexItem> getIndividualResources() {
        return this.individualResources;
    }

    public WorldRegion getRegion() {
        return this.region;
    }

    private DownloadResourceGroup getGroupById(String[] lst, int subInd) {
        if (lst.length > subInd && lst[subInd].equals(this.id)) {
            if (lst.length == subInd + 1) {
                return this;
            }
            if (this.groups != null) {
                return this.getSubGroupById(lst, subInd + 1);
            }
        }
        return null;
    }

    private DownloadResourceGroup getSubGroupById(String[] lst, int subInd) {
        for (DownloadResourceGroup rg : this.groups) {
            DownloadResourceGroup r = rg.getGroupById(lst, subInd);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public String getName(OsmWindow ctx) {
        if (this.region != null) {
            return this.region.getLocaleName();
        }
        if (this.type != null && this.type.resId != -1) {
            return ctx.getString(this.type.resId);
        }
        return this.id;
    }

    public String getUniqueId() {
        if (this.parentGroup == null) {
            return this.id;
        }
        return this.parentGroup.getUniqueId() + "#" + this.id;
    }

    public String getId() {
        return this.id;
    }

    public static enum DownloadResourceGroupType {
        WORLD_MAPS(57),
        REGION_MAPS(56),
        SRTM_HEADER(1060),
        HILLSHADE_HEADER(128),
        OTHER_MAPS_HEADER(1059),
        VOICE_HEADER_TTS(316),
        VOICE_HEADER_REC(315),
        OTHER_MAPS_GROUP(1059),
        VOICE_GROUP(615),
        SUBREGIONS(55),
        VOICE_TTS(316),
        VOICE_REC(315),
        OTHER_MAPS(1059),
        WORLD(-1),
        REGION(-1);

        final int resId;

        private DownloadResourceGroupType(int resId) {
            this.resId = resId;
        }

        public boolean isScreen() {
            return this == WORLD || this == REGION || this == VOICE_TTS || this == VOICE_REC || this == OTHER_MAPS;
        }

        public String getDefaultId() {
            return this.name().toLowerCase();
        }

        public int getResourceId() {
            return this.resId;
        }

        public boolean containsIndexItem() {
            return this.isHeader() && this != SUBREGIONS && this != VOICE_GROUP && this != OTHER_MAPS_GROUP;
        }

        public boolean isHeader() {
            return this == VOICE_HEADER_REC || this == VOICE_HEADER_TTS || this == SUBREGIONS || this == WORLD_MAPS || this == REGION_MAPS || this == VOICE_GROUP || this == HILLSHADE_HEADER || this == SRTM_HEADER || this == OTHER_MAPS_HEADER || this == OTHER_MAPS_GROUP;
        }

        public static String getVoiceTTSId() {
            return "#" + VOICE_GROUP.name().toLowerCase() + "#" + VOICE_TTS.name().toLowerCase();
        }
    }
}

