/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public abstract class TimeHeader {
    protected static final int Y_POS_ROW16 = 16;
    protected static final int Y_POS_ROW28 = 28;
    private final TimeScale timeScale;
    protected final Day min;
    protected final Day max;

    public TimeHeader(Day min, Day max, TimeScale timeScale) {
        this.timeScale = timeScale;
        this.min = min;
        this.max = max;
    }

    public abstract void drawTimeHeader(UGraphic var1, double var2);

    public abstract double getFullHeaderHeight();

    protected final void drawHline(UGraphic ug, double y) {
        double xmin = this.getTimeScale().getStartingPosition(this.min);
        double xmax = this.getTimeScale().getEndingPosition(this.max);
        ULine hline = ULine.hline(xmax - xmin);
        ug.apply(HColorUtils.LIGHT_GRAY).apply(UTranslate.dy(y)).draw(hline);
    }

    protected final FontConfiguration getFontConfiguration(int size, boolean bold, HColor color) {
        UFont font = UFont.serif(size);
        if (bold) {
            font = font.bold();
        }
        return new FontConfiguration(font, color, color, false);
    }

    public final TimeScale getTimeScale() {
        return this.timeScale;
    }

    protected final TextBlock getTextBlock(String text, int size, boolean bold, HColor color) {
        return Display.getWithNewlines(text).create(this.getFontConfiguration(size, bold, color), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    protected final void printCentered(UGraphic ug, TextBlock text, double start, double end) {
        double width = text.calculateDimension(ug.getStringBounder()).getWidth();
        double available = end - start;
        double diff = Math.max(0.0, available - width);
        text.drawU(ug.apply(UTranslate.dx(start + diff / 2.0)));
    }

    protected final void printCentered(UGraphic ug, double start, double end, TextBlock ... texts) {
        double available = end - start;
        for (int i = texts.length - 1; i >= 0; --i) {
            TextBlock text = texts[i];
            double width = text.calculateDimension(ug.getStringBounder()).getWidth();
            if (i != 0 && !(width <= available)) continue;
            double diff = Math.max(0.0, available - width);
            text.drawU(ug.apply(UTranslate.dx(start + diff / 2.0)));
            return;
        }
    }
}

