/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.server;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import net.sf.sdedit.ui.G2DGraphicsDevice;
import net.sf.sdedit.util.Utilities;
import org.freehep.graphics2d.AbstractVectorGraphics;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.gif.GIFGraphics2D;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;

public class Exporter
extends G2DGraphicsDevice {
    private OutputStream stream;
    private String type;
    private VectorGraphics vg;
    private String orientation;
    private String format;
    private Dimension dim;

    public Exporter(String orientation, String format) {
        this.orientation = orientation;
        this.format = format;
    }

    public static Exporter getExporter(String type, String orientation, String format, OutputStream stream) {
        Exporter exporter = new Exporter(orientation, format);
        exporter.setType(type);
        exporter.setOutputStream(stream);
        return exporter;
    }

    private VectorGraphics getGraphics() {
        AbstractVectorGraphics vectorGraphics;
        if (this.orientation == null) {
            String string = this.orientation = this.dim.getWidth() <= this.dim.getHeight() ? "Portrait" : "Landscape";
        }
        if (this.type.equals("gif")) {
            vectorGraphics = new GIFGraphics2D(this.stream, this.dim);
        } else if (this.type.equals("png")) {
            vectorGraphics = new ImageGraphics2D(this.stream, this.dim, "png");
        } else if (this.type.equals("bmp")) {
            vectorGraphics = new ImageGraphics2D(this.stream, this.dim, "bmp");
        } else if (this.type.equals("jpg")) {
            vectorGraphics = new ImageGraphics2D(this.stream, this.dim, "jpg");
        } else if (this.type.equals("pdf")) {
            PDFGraphics2D pdf = new PDFGraphics2D(this.stream, this.dim);
            Properties properties = new Properties();
            properties.setProperty(PDFGraphics2D.ORIENTATION, this.orientation);
            properties.setProperty(PDFGraphics2D.PAGE_SIZE, this.format);
            pdf.setProperties(properties);
            vectorGraphics = pdf;
        } else if (Utilities.in(this.type, "ps", "eps")) {
            PSGraphics2D ps = new PSGraphics2D(this.stream, this.dim);
            Properties properties = new Properties();
            properties.setProperty(PSGraphics2D.ORIENTATION, this.orientation);
            properties.setProperty(PSGraphics2D.PAGE_SIZE, this.format);
            ps.setProperties(properties);
            ps.setMultiPage("ps".equals(this.type));
            vectorGraphics = ps;
        } else if (this.type.equals("emf")) {
            vectorGraphics = new EMFGraphics2D(this.stream, this.dim);
        } else if (this.type.equals("svg")) {
            vectorGraphics = new SVGGraphics2D(this.stream, this.dim);
        } else {
            throw new IllegalArgumentException("Unknown type: " + this.type);
        }
        return vectorGraphics;
    }

    @Override
    protected Graphics2D createDummyGraphics() {
        this.dim = new Dimension(1, 1);
        VectorGraphics dummy = this.getGraphics();
        Font font = this.getFont();
        dummy.setFont(font);
        return dummy;
    }

    @Override
    protected Graphics2D createGraphics() {
        this.dim = new Dimension(this.getWidth(), this.getHeight());
        this.vg = this.getGraphics();
        if (this.vg instanceof ImageGraphics2D) {
            this.vg.setColor(Color.WHITE);
            this.vg.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        return this.vg;
    }

    protected void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    protected void setType(String type) {
        this.type = type.toLowerCase();
    }

    public void export() {
        this.vg.startExport();
        if (this.vg instanceof PSGraphics2D && "ps".equals(this.type)) {
            try {
                ((PSGraphics2D)this.vg).openPage(this.dim, "");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.drawAll();
        if (this.vg instanceof PSGraphics2D && "ps".equals(this.type)) {
            ((PSGraphics2D)this.vg).closePage();
        }
        this.vg.endExport();
    }
}

