# -*- coding: utf-8 -*-
#
# This module contains the configuration of the individual eric6 installation
#

_pkg_config = {
    'ericDir': r'/usr/lib/python3.8/site-packages/eric6',
    'ericPixDir': r'/usr/lib/python3.8/site-packages/eric6/pixmaps',
    'ericIconDir': r'/usr/lib/python3.8/site-packages/eric6/icons',
    'ericDTDDir': r'/usr/lib/python3.8/site-packages/eric6/DTDs',
    'ericCSSDir': r'/usr/lib/python3.8/site-packages/eric6/CSSs',
    'ericStylesDir': r'/usr/lib/python3.8/site-packages/eric6/Styles',
    'ericDocDir': r'/usr/lib/python3.8/site-packages/eric6/Documentation',
    'ericExamplesDir': r'/usr/lib/python3.8/site-packages/eric6/Examples',
    'ericTranslationsDir': r'/usr/lib/python3.8/site-packages/eric6/i18n',
    'ericTemplatesDir': r'/usr/lib/python3.8/site-packages/eric6/DesignerTemplates',
    'ericCodeTemplatesDir': r'/usr/lib/python3.8/site-packages/eric6/CodeTemplates',
    'ericOthersDir': r'/usr/lib/python3.8/site-packages/eric6',
    'bindir': r'/usr/bin',
    'mdir': r'/usr/lib/python3.8/site-packages',
    'apidir': r'/usr/share/qt/qsci/api',
    'apis': ['Ruby-1.8.7.api', 'Ruby-1.9.1.api', 'calliope.api', 'circuitpython.api', 'eric6.api', 'microbit.api', 'micropython.api', 'micropython.api', 'qss.api', 'zope-2.10.7.api', 'zope-2.11.2.api', 'zope-3.3.1.api'],
    'macAppBundlePath': r'/Applications',
    'macAppBundleName': r'eric6.app',
}

def getConfig(name):
    '''
    Module function to get a configuration value.

    @param name name of the configuration value    @type str
    @exception AttributeError raised to indicate an invalid config entry
    '''
    try:
        return _pkg_config[name]
    except KeyError:
        pass

    raise AttributeError(
        '"{0}" is not a valid configuration value'.format(name))
