/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.Range;

public class LongRange
extends AbstractNumericRange<Long> {
    protected long _min;
    protected long _max;

    public LongRange() {
        this(0L, 1L);
    }

    public LongRange(long l, long l2) {
        this._min = Math.min(l, l2);
        this._max = Math.max(l, l2);
    }

    public LongRange(LongRange longRange) {
        this((long)longRange.minimum(), (long)longRange.maximum());
    }

    @Override
    public Range<Long> copy() {
        return new LongRange(this);
    }

    @Override
    public double minimum() {
        return this._min;
    }

    @Override
    public double maximum() {
        return this._max;
    }

    public long getMin() {
        return this._min;
    }

    public void setMin(long l) {
        long l2 = this._min;
        if (l2 == l) {
            return;
        }
        assert (l <= this._max) : "minimum " + l + " not <= " + this._max;
        this._min = l;
        this.firePropertyChange("min", l2, l);
    }

    public long getMax() {
        return this._max;
    }

    public void setMax(long l) {
        long l2 = this._max;
        if (l2 == l) {
            return;
        }
        assert (l >= this._min) : "maximum " + l + " not >= " + this._min;
        this._max = l;
        this.firePropertyChange("max", l2, l);
    }

    @Override
    public void adjust(Long l, Long l2) {
        double d = this.size();
        if (l != null) {
            this.setMin(l);
        } else if (l2 != null) {
            this.setMin(l2 - (long)d);
        }
        if (l2 != null) {
            this.setMax(l2);
        } else if (l != null) {
            this.setMin(l + (long)d);
        }
    }

    @Override
    public double size() {
        return this._max - this._min;
    }

    @Override
    public Long lower() {
        return (long)this.minimum();
    }

    @Override
    public Long upper() {
        return (long)this.maximum();
    }

    @Override
    public boolean contains(Long l) {
        return l >= this._min && l <= this._max;
    }

    @Override
    public Range<Long> createIntermediate(Range<Long> range, double d) {
        double d2 = this.minimum();
        double d3 = this.maximum();
        double d4 = range.minimum();
        double d5 = range.maximum();
        double d6 = d2 + d * (d4 - d2);
        double d7 = d3 + d * (d5 - d3);
        return new LongRange((int)Math.round(d6), (int)Math.round(d7));
    }

    public boolean equals(Object object) {
        if (object instanceof LongRange) {
            LongRange longRange = (LongRange)object;
            return this._min == longRange._min && this._max == longRange._max;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this._max * 29L + this._min);
    }

    public String toString() {
        return String.format("#<LongRange min=%d max=%d>", this._min, this._max);
    }
}

