/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.Tile;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.QuadCurveTo;

public class InfoRegion
extends Region {
    private static final double PREFERRED_WIDTH = 52.0;
    private static final double PREFERRED_HEIGHT = 52.0;
    private static final double MINIMUM_WIDTH = 1.0;
    private static final double MINIMUM_HEIGHT = 1.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double width;
    private double height;
    private Path path;
    private Path icon;
    private Color backgroundColor = Tile.DARK_BLUE;
    private Color foregroundColor = Tile.FOREGROUND;
    private boolean roundedCorner = true;
    private Tooltip tooltip;

    public InfoRegion() {
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(52.0, 52.0);
            }
        }
        this.path = new Path();
        this.path.setStroke(Color.TRANSPARENT);
        this.icon = new Path();
        this.icon.setStroke(Color.TRANSPARENT);
        this.icon.setMouseTransparent(true);
        this.tooltip = new Tooltip("");
        this.getChildren().setAll((Node[])new Node[]{this.path, this.icon});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    @Override
    public void layoutChildren() {
        super.layoutChildren();
    }

    @Override
    protected double computeMinWidth(double HEIGHT) {
        return 1.0;
    }

    @Override
    protected double computeMinHeight(double WIDTH) {
        return 1.0;
    }

    @Override
    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    @Override
    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    @Override
    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    @Override
    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color COLOR) {
        this.backgroundColor = COLOR;
        this.redraw();
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color COLOR) {
        this.foregroundColor = COLOR;
        this.redraw();
    }

    public boolean isRoundedCorner() {
        return this.roundedCorner;
    }

    public void setRoundedCorner(boolean ROUNDED) {
        this.roundedCorner = ROUNDED;
        this.redraw();
    }

    public String getToolTipText() {
        return this.tooltip.getText();
    }

    public void setTooltipText(String TEXT) {
        if (null == TEXT || TEXT.isEmpty()) {
            Tooltip.uninstall(this.path, this.tooltip);
        } else {
            this.tooltip.setText(TEXT);
            Tooltip.install(this.path, this.tooltip);
        }
    }

    @Override
    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.path.getElements().clear();
            if (this.isRoundedCorner()) {
                this.path.getElements().add(new MoveTo(this.size * 0.23809524, 0.0));
                this.path.getElements().add(new LineTo(this.size, 0.0));
                this.path.getElements().add(new LineTo(0.0, this.size));
                this.path.getElements().add(new LineTo(0.0, this.size * 0.23809524));
                this.path.getElements().add(new QuadCurveTo(0.0, 0.0, this.size * 0.23809524, 0.0));
                this.path.getElements().add(new ClosePath());
            } else {
                this.path.getElements().add(new MoveTo(0.0, 0.0));
                this.path.getElements().add(new LineTo(this.size, 0.0));
                this.path.getElements().add(new LineTo(0.0, this.size));
                this.path.getElements().add(new ClosePath());
            }
            this.icon.getElements().clear();
            this.icon.getElements().add(new MoveTo(this.size * 0.185714285714286, this.size * 0.119047619047619));
            this.icon.getElements().add(new LineTo(this.size * 0.254761904761905, this.size * 0.185714285714286));
            this.icon.getElements().add(new LineTo(this.size * 0.185714285714286, this.size * 0.254761904761905));
            this.icon.getElements().add(new LineTo(this.size * 0.119047619047619, this.size * 0.185714285714286));
            this.icon.getElements().add(new ClosePath());
            this.icon.getElements().add(new MoveTo(this.size * 0.304761904761905, this.size * 0.238095238095238));
            this.icon.getElements().add(new LineTo(this.size * 0.466666666666667, this.size * 0.4));
            this.icon.getElements().add(new LineTo(this.size * 0.4, this.size * 0.466666666666667));
            this.icon.getElements().add(new LineTo(this.size * 0.238095238095238, this.size * 0.304761904761905));
            this.icon.getElements().add(new ClosePath());
            this.redraw();
        }
    }

    private void redraw() {
        this.path.setFill(this.getBackgroundColor());
        this.icon.setFill(this.getForegroundColor());
    }
}

