/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Version {
    private static final Logger logger = LogManager.getLogger();
    private int major;
    private int minor;
    private int patch;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public Version(String versionsstring) {
        String[] versions = versionsstring.replaceAll("-SNAPSHOT", "").split("\\.");
        if (versions.length == 3) {
            try {
                this.major = Integer.parseInt(versions[0]);
                this.minor = Integer.parseInt(versions[1]);
                this.patch = Integer.parseInt(versions[2]);
            }
            catch (NumberFormatException ex) {
                logger.error("Fehler beim Parsen der Version: {}", (Object)versionsstring, (Object)ex);
                this.major = 0;
                this.minor = 0;
                this.patch = 0;
            }
        }
    }

    public Version() {
        this.major = 0;
        this.minor = 0;
        this.patch = 0;
    }

    public int toNumber() {
        return this.major * 100 + this.minor * 10 + this.patch;
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    public int compare(Version versionzwei) {
        return Integer.compare(versionzwei.toNumber(), this.toNumber());
    }
}

