/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.plantuml.EmbeddedDiagram;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class BodyEnhanced
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private TextBlock area;
    private final FontConfiguration titleConfig;
    private final List<CharSequence> rawBody;
    private final FontParam fontParam;
    private final ISkinParam skinParam;
    private final boolean lineFirst;
    private final HorizontalAlignment align;
    private final boolean manageHorizontalLine;
    private final boolean manageModifier;
    private final List<Url> urls = new ArrayList<Url>();
    private final Stereotype stereotype;
    private final ILeaf entity;
    private final boolean inEllipse;
    private final double minClassWidth;
    private final SName diagramType;

    public BodyEnhanced(List<String> rawBody, FontParam fontParam, ISkinParam skinParam, boolean manageModifier, Stereotype stereotype, ILeaf entity, SName diagramType) {
        this.diagramType = diagramType;
        this.rawBody = new ArrayList<String>(rawBody);
        this.stereotype = stereotype;
        this.fontParam = fontParam;
        this.skinParam = skinParam;
        this.titleConfig = new FontConfiguration(skinParam, fontParam, stereotype);
        this.lineFirst = true;
        this.align = skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT);
        this.manageHorizontalLine = true;
        this.manageModifier = manageModifier;
        this.entity = entity;
        this.inEllipse = false;
        this.minClassWidth = 0.0;
    }

    public BodyEnhanced(Display display, FontParam fontParam, ISkinParam skinParam, HorizontalAlignment align, Stereotype stereotype, boolean manageHorizontalLine, boolean manageModifier, ILeaf entity, SName diagramType) {
        this(display, fontParam, skinParam, align, stereotype, manageHorizontalLine, manageHorizontalLine, entity, 0.0, diagramType);
    }

    public BodyEnhanced(Display display, FontParam fontParam, ISkinParam skinParam, HorizontalAlignment align, Stereotype stereotype, boolean manageHorizontalLine, boolean manageModifier, ILeaf entity, double minClassWidth, SName diagramType) {
        this.diagramType = diagramType;
        this.minClassWidth = minClassWidth;
        this.entity = entity;
        this.stereotype = stereotype;
        this.rawBody = new ArrayList<CharSequence>();
        this.fontParam = fontParam;
        this.skinParam = skinParam;
        this.titleConfig = new FontConfiguration(skinParam, fontParam, stereotype);
        this.lineFirst = false;
        this.align = skinParam.getDefaultTextAlignment(align);
        this.manageHorizontalLine = manageHorizontalLine;
        this.manageModifier = manageModifier;
        boolean bl = this.inEllipse = fontParam == FontParam.USECASE;
        if (manageHorizontalLine && this.inEllipse && display.size() > 0 && BodyEnhanced.isBlockSeparator(display.get(0).toString())) {
            this.rawBody.add("");
        }
        for (CharSequence s : display) {
            this.rawBody.add(s);
        }
    }

    private TextBlock decorate(StringBounder stringBounder, TextBlock b, char separator, TextBlock title) {
        if (separator == '\u0000') {
            return b;
        }
        if (title == null) {
            return new TextBlockLineBefore(TextBlockUtils.withMargin(b, 6.0, 4.0), separator);
        }
        Dimension2D dimTitle = title.calculateDimension(stringBounder);
        TextBlockLineBefore raw = new TextBlockLineBefore(TextBlockUtils.withMargin(b, 6.0, 6.0, dimTitle.getHeight() / 2.0, 4.0), separator, title);
        return TextBlockUtils.withMargin(raw, 0.0, 0.0, dimTitle.getHeight() / 2.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getArea(stringBounder).calculateDimension(stringBounder);
    }

    private TextBlock getArea(StringBounder stringBounder) {
        if (this.area != null) {
            return this.area;
        }
        this.urls.clear();
        ArrayList<TextBlock> blocks = new ArrayList<TextBlock>();
        char separator = this.lineFirst ? (char)'_' : '\u0000';
        TextBlock title = null;
        ArrayList<Member> members = new ArrayList<Member>();
        ListIterator<CharSequence> it = this.rawBody.listIterator();
        while (it.hasNext()) {
            CharSequence s2 = it.next();
            if (s2 instanceof EmbeddedDiagram) {
                if (members.size() > 0 || separator != '\u0000') {
                    blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(members, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity, this.diagramType), separator, title));
                    separator = '\u0000';
                    title = null;
                    members = new ArrayList();
                }
                blocks.add(((EmbeddedDiagram)s2).asDraw(this.skinParam));
                continue;
            }
            String s = s2.toString();
            if (this.manageHorizontalLine && BodyEnhanced.isBlockSeparator(s)) {
                blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(members, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity, this.diagramType), separator, title));
                separator = s.charAt(0);
                title = this.getTitle(s, this.skinParam);
                members = new ArrayList();
                continue;
            }
            if (Parser.isTreeStart(s)) {
                if (members.size() > 0) {
                    blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(members, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity, this.diagramType), separator, title));
                }
                separator = '\u0000';
                title = null;
                members = new ArrayList();
                List<CharSequence> allTree = BodyEnhanced.buildAllTree(s, it);
                TextBlock bloc = Display.create(allTree).create7(this.fontParam.getFontConfiguration(this.skinParam), this.align, this.skinParam, CreoleMode.FULL);
                blocks.add(bloc);
                continue;
            }
            Member m = new Member(s, Member.isMethod(s), this.manageModifier);
            members.add(m);
            if (m.getUrl() == null) continue;
            this.urls.add(m.getUrl());
        }
        if (this.inEllipse && members.size() == 0) {
            members.add(new Member("", false, false));
        }
        blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(members, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity, this.diagramType), separator, title));
        this.area = blocks.size() == 1 ? (TextBlock)blocks.get(0) : new TextBlockVertical2(blocks, this.align);
        if (this.minClassWidth > 0.0) {
            this.area = TextBlockUtils.withMinWidth(this.area, this.minClassWidth, this.skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT));
        }
        return this.area;
    }

    private static List<CharSequence> buildAllTree(String init, ListIterator<CharSequence> it) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        result.add(init);
        while (it.hasNext()) {
            CharSequence s = it.next();
            if (Parser.isTreeStart(StringUtils.trinNoTrace(s))) {
                result.add(s);
                continue;
            }
            it.previous();
            return result;
        }
        return result;
    }

    public static boolean isBlockSeparator(String s) {
        if (s.startsWith("--") && s.endsWith("--")) {
            return true;
        }
        if (s.startsWith("==") && s.endsWith("==")) {
            return true;
        }
        if (s.startsWith("..") && s.endsWith("..") && !s.equals("...")) {
            return true;
        }
        return s.startsWith("__") && s.endsWith("__");
    }

    private TextBlock getTitle(String s, ISkinSimple spriteContainer) {
        if (s.length() <= 4) {
            return null;
        }
        s = StringUtils.trin(s.substring(2, s.length() - 2));
        return Display.getWithNewlines(s).create(this.titleConfig, HorizontalAlignment.LEFT, spriteContainer);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        TextBlock area = this.getArea(stringBounder);
        if (area instanceof WithPorts) {
            return ((WithPorts)((Object)area)).getPorts(stringBounder);
        }
        return new Ports();
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getArea(ug.getStringBounder()).drawU(ug);
    }

    public List<Url> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return this.getArea(stringBounder).getInnerPosition(member, stringBounder, strategy);
    }
}

