/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core3;

import net.sourceforge.plantuml.project.core3.Histogram;
import net.sourceforge.plantuml.project.core3.HistogramSimple;
import net.sourceforge.plantuml.project.core3.TaskLoad;
import net.sourceforge.plantuml.project.core3.TaskLoadImpl;

public class Solver10 {
    private final Histogram workLoad;

    public Solver10(Histogram workLoad) {
        this.workLoad = workLoad;
    }

    public TaskLoad solver(long totalLoad) {
        HistogramSimple resultLoad = new HistogramSimple();
        TaskLoadImpl result = new TaskLoadImpl(resultLoad);
        long start = this.workLoad.getNext(0L);
        result.setStart(start);
        long currentTime = start;
        while (totalLoad > 0L) {
            long tmpWorkLoad = this.workLoad.getValueAt(currentTime);
            long nextChange = this.workLoad.getNext(currentTime);
            long duration = nextChange - currentTime;
            long partialLoad = duration * tmpWorkLoad;
            resultLoad.put(currentTime, tmpWorkLoad);
            if (partialLoad >= totalLoad) {
                long end = currentTime + totalLoad / tmpWorkLoad;
                result.setEnd(end);
                resultLoad.put(end, 0L);
                return result;
            }
            totalLoad -= partialLoad;
            currentTime = nextChange;
        }
        throw new UnsupportedOperationException();
    }
}

