/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.lang.SentenceDisplayOnSameRowAs;
import net.sourceforge.plantuml.project.lang.SentenceEnds;
import net.sourceforge.plantuml.project.lang.SentenceHappens;
import net.sourceforge.plantuml.project.lang.SentenceHappensDate;
import net.sourceforge.plantuml.project.lang.SentenceIsColored;
import net.sourceforge.plantuml.project.lang.SentenceIsDeleted;
import net.sourceforge.plantuml.project.lang.SentenceIsForTask;
import net.sourceforge.plantuml.project.lang.SentenceLasts;
import net.sourceforge.plantuml.project.lang.SentenceLinksTo;
import net.sourceforge.plantuml.project.lang.SentenceOccurs;
import net.sourceforge.plantuml.project.lang.SentencePausesDate;
import net.sourceforge.plantuml.project.lang.SentencePausesDates;
import net.sourceforge.plantuml.project.lang.SentencePausesDayOfWeek;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.SentenceTaskEndsAbsolute;
import net.sourceforge.plantuml.project.lang.SentenceTaskStarts;
import net.sourceforge.plantuml.project.lang.SentenceTaskStartsAbsolute;
import net.sourceforge.plantuml.project.lang.SentenceTaskStartsWithColor;
import net.sourceforge.plantuml.project.lang.Subject;

public class SubjectTask
implements Subject {
    public Failable<Task> getMe(GanttDiagram project, RegexResult arg) {
        String s = arg.get("SUBJECT", 0);
        String shortName = arg.get("SUBJECT", 1);
        String then = arg.get("THEN", 0);
        String resource = arg.get("RESOURCE", 0);
        Task result = project.getOrCreateTask(s, shortName, then != null);
        if (result == null) {
            throw new IllegalStateException();
        }
        if (resource != null) {
            StringTokenizer st = new StringTokenizer(resource, "{}");
            while (st.hasMoreTokens()) {
                String part = st.nextToken().trim();
                if (part.length() <= 0) continue;
                project.affectResource(result, part);
            }
        }
        return Failable.ok(result);
    }

    @Override
    public Collection<? extends SentenceSimple> getSentences() {
        return Arrays.asList(new SentenceLasts(), new SentenceTaskStarts(), new SentenceTaskStartsWithColor(), new SentenceTaskStartsAbsolute(), new SentenceHappens(), new SentenceHappensDate(), new SentenceEnds(), new SentenceTaskEndsAbsolute(), new SentenceIsColored(), new SentenceIsDeleted(), new SentenceIsForTask(), new SentenceLinksTo(), new SentenceOccurs(), new SentenceDisplayOnSameRowAs(), new SentencePausesDate(), new SentencePausesDates(), new SentencePausesDayOfWeek());
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(new RegexLeaf("THEN", "(then[%s]+)?"), new RegexLeaf("SUBJECT", "\\[([^\\[\\]]+?)\\](?:[%s]+as[%s]+\\[([^\\[\\]]+?)\\])?"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("on"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("RESOURCE", "((?:\\{[^{}]+\\}[%s]*)+)"))));
    }
}

