/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.time;

import java.util.Calendar;
import java.util.TimeZone;
import net.sourceforge.plantuml.project.Value;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.project.time.Month;
import net.sourceforge.plantuml.project.time.MonthYear;

public class Day
implements Comparable<Day>,
Value {
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    private static final Calendar gmt = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private final int dayOfMonth;
    private final MonthYear monthYear;
    private final long ms1;

    public static Day create(int year, String month, int dayOfMonth) {
        return new Day(year, Month.fromString(month), dayOfMonth);
    }

    public static Day create(int year, int month, int dayOfMonth) {
        return new Day(year, Month.values()[month - 1], dayOfMonth);
    }

    public static Day create(long ms) {
        return new Day(ms);
    }

    public static Day today() {
        return Day.create(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Day(int year, Month month, int dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        this.monthYear = MonthYear.create(year, month);
        Calendar calendar = gmt;
        synchronized (calendar) {
            gmt.clear();
            gmt.set(year, month.ordinal(), dayOfMonth);
            this.ms1 = gmt.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Day(long ms) {
        this.ms1 = ms;
        Calendar calendar = gmt;
        synchronized (calendar) {
            int dayOfMonth;
            gmt.clear();
            gmt.setTimeInMillis(ms);
            int year = gmt.get(1);
            int month = gmt.get(2);
            this.dayOfMonth = dayOfMonth = gmt.get(5);
            this.monthYear = MonthYear.create(year, Month.values()[month]);
        }
    }

    public Day increment() {
        return this.addDays(1);
    }

    public Day decrement() {
        return this.addDays(-1);
    }

    public Day addDays(int nday) {
        return Day.create(86400000L * (long)(this.getAbsoluteDayNum() + nday));
    }

    public final int getAbsoluteDayNum() {
        return (int)(this.ms1 / 86400000L);
    }

    public final long getMillis() {
        return this.ms1;
    }

    public int year() {
        return this.monthYear.year();
    }

    private int internalNumber() {
        return this.year() * 100 * 100 + this.month().ordinal() * 100 + this.dayOfMonth;
    }

    public String toString() {
        return this.monthYear.toString() + "/" + this.dayOfMonth;
    }

    public int hashCode() {
        return this.monthYear.hashCode() + this.dayOfMonth * 17;
    }

    public boolean equals(Object obj) {
        Day other = (Day)obj;
        return other.internalNumber() == this.internalNumber();
    }

    public final int getDayOfMonth() {
        return this.dayOfMonth;
    }

    private int daysPerMonth() {
        return this.month().getDaysPerMonth(this.year());
    }

    public Month month() {
        return this.monthYear.month();
    }

    public MonthYear monthYear() {
        return this.monthYear;
    }

    public DayOfWeek getDayOfWeek() {
        int q = this.dayOfMonth;
        int m = this.month().m();
        int y = m >= 13 ? this.year() - 1 : this.year();
        int k = y % 100;
        int j = y / 100;
        int h = (q + 13 * (m + 1) / 5 + k + k / 4 + j / 4 + 5 * j) % 7;
        return DayOfWeek.fromH(h);
    }

    @Override
    public int compareTo(Day other) {
        return this.internalNumber() - other.internalNumber();
    }

    public static Day min(Day wink1, Day wink2) {
        if (wink2.internalNumber() < wink1.internalNumber()) {
            return wink2;
        }
        return wink1;
    }

    public static Day max(Day wink1, Day wink2) {
        if (wink2.internalNumber() > wink1.internalNumber()) {
            return wink2;
        }
        return wink1;
    }
}

