/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class StateDiagram
extends AbstractEntityDiagram {
    private static final String CONCURRENT_PREFIX = "CONC";
    private boolean hideEmptyDescription = false;

    public StateDiagram(ISkinSimple skinParam) {
        super(skinParam);
    }

    public boolean checkConcurrentStateOk(Ident ident, Code code) {
        if (this.V1972()) {
            return this.checkConcurrentStateOkInternal1972(ident);
        }
        boolean result = this.checkConcurrentStateOkInternal(code);
        return result;
    }

    private boolean checkConcurrentStateOkInternal(Code code) {
        if (!this.leafExist(code)) {
            return true;
        }
        ILeaf existing = this.getLeaf(code);
        if (this.getCurrentGroup().getGroupType() == GroupType.CONCURRENT_STATE && this.getCurrentGroup() != existing.getParentContainer()) {
            return false;
        }
        return existing.getParentContainer().getGroupType() != GroupType.CONCURRENT_STATE || this.getCurrentGroup() == existing.getParentContainer();
    }

    private boolean checkConcurrentStateOkInternal1972(Ident ident) {
        if (!this.leafExistSmart(ident)) {
            return true;
        }
        ILeaf existing = this.getLeafSmart(ident);
        if (this.getCurrentGroup().getGroupType() == GroupType.CONCURRENT_STATE && this.getCurrentGroup() != existing.getParentContainer()) {
            return false;
        }
        return existing.getParentContainer().getGroupType() != GroupType.CONCURRENT_STATE || this.getCurrentGroup() == existing.getParentContainer();
    }

    @Override
    public IEntity getOrCreateLeaf(Ident ident, Code code, LeafType type, USymbol symbol) {
        this.checkNotNull(ident);
        if (!this.checkConcurrentStateOk(ident, code)) {
            throw new IllegalStateException("Concurrent State " + code);
        }
        if (!this.V1972() && type == null) {
            if (code.getName().startsWith("[*]")) {
                throw new IllegalArgumentException();
            }
            if (this.isGroup(code)) {
                return this.getGroup(code);
            }
            return this.getOrCreateLeafDefault(ident, code, LeafType.STATE, null);
        }
        if (this.V1972() && type == null) {
            ILeaf result;
            if (ident.getName().startsWith("[*]")) {
                throw new IllegalArgumentException();
            }
            if (this.isGroupVerySmart(ident)) {
                return this.getGroupVerySmart(ident);
            }
            if (this.getNamespaceSeparator() == null && (result = this.getLeafVerySmart(ident)) != null) {
                return result;
            }
            return this.getOrCreateLeafDefault(ident, code, LeafType.STATE, null);
        }
        return this.getOrCreateLeafDefault(ident, code, type, symbol);
    }

    public IEntity getStart() {
        IGroup g = this.getCurrentGroup();
        if (EntityUtils.groupRoot(g)) {
            Ident ident = this.buildLeafIdent("*start");
            Ident code = this.V1972() ? ident : this.buildCode("*start");
            return this.getOrCreateLeaf(ident, code, LeafType.CIRCLE_START, null);
        }
        String idShort = "*start*" + g.getCodeGetName();
        Ident ident = this.buildLeafIdent(idShort);
        Ident code = this.V1972() ? ident : this.buildCode(idShort);
        return this.getOrCreateLeaf(ident, code, LeafType.CIRCLE_START, null);
    }

    public IEntity getEnd() {
        IGroup p = this.getCurrentGroup();
        if (EntityUtils.groupRoot(p)) {
            Ident ident = this.buildLeafIdent("*end");
            Ident code = this.V1972() ? ident : this.buildCode("*end");
            return this.getOrCreateLeaf(ident, code, LeafType.CIRCLE_END, null);
        }
        String idShort = "*end*" + p.getCodeGetName();
        Ident ident = this.buildLeafIdent(idShort);
        Ident code = this.V1972() ? ident : this.buildCode(idShort);
        return this.getOrCreateLeaf(ident, code, LeafType.CIRCLE_END, null);
    }

    public IEntity getHistorical() {
        IGroup g = this.getCurrentGroup();
        if (EntityUtils.groupRoot(g)) {
            Ident ident = this.buildLeafIdent("*historical");
            Code code = this.buildCode("*historical");
            return this.getOrCreateLeaf(ident, code, LeafType.PSEUDO_STATE, null);
        }
        String idShort = "*historical*" + g.getCodeGetName();
        Ident ident = this.buildLeafIdent(idShort);
        Ident code = this.V1972() ? ident : this.buildCode(idShort);
        return this.getOrCreateLeaf(ident, code, LeafType.PSEUDO_STATE, null);
    }

    public IEntity getHistorical(String idShort) {
        Ident idNewLong = this.buildLeafIdent(idShort);
        Ident codeGroup = this.V1972() ? idNewLong : this.buildCode(idShort);
        this.gotoGroup(idNewLong, codeGroup, Display.getWithNewlines(codeGroup), GroupType.STATE, this.getRootGroup(), NamespaceStrategy.SINGLE);
        IGroup g = this.getCurrentGroup();
        String tmp = "*historical*" + g.getCodeGetName();
        Ident ident = this.buildLeafIdent(tmp);
        Ident code = this.V1972() ? ident : this.buildCode(tmp);
        IEntity result = this.getOrCreateLeaf(ident, code, LeafType.PSEUDO_STATE, null);
        this.endGroup();
        return result;
    }

    public IEntity getDeepHistory() {
        IGroup g = this.getCurrentGroup();
        if (EntityUtils.groupRoot(g)) {
            Ident ident = this.buildLeafIdent("*deephistory");
            Code code = this.buildCode("*deephistory");
            return this.getOrCreateLeaf(ident, code, LeafType.DEEP_HISTORY, null);
        }
        String idShort = "*deephistory*" + g.getCodeGetName();
        Ident ident = this.buildLeafIdent(idShort);
        Ident code = this.V1972() ? ident : this.buildCode(idShort);
        return this.getOrCreateLeaf(ident, code, LeafType.DEEP_HISTORY, null);
    }

    public IEntity getDeepHistory(String idShort) {
        Ident idNewLong = this.buildLeafIdent(idShort);
        Ident codeGroup = this.V1972() ? idNewLong : this.buildCode(idShort);
        this.gotoGroup(idNewLong, codeGroup, Display.getWithNewlines(codeGroup), GroupType.STATE, this.getRootGroup(), NamespaceStrategy.SINGLE);
        IGroup g = this.getCurrentGroup();
        String tmp = "*deephistory*" + g.getCodeGetName();
        Ident ident = this.buildLeafIdent(tmp);
        Ident code = this.V1972() ? ident : this.buildCode(tmp);
        IEntity result = this.getOrCreateLeaf(ident, code, LeafType.DEEP_HISTORY, null);
        this.endGroup();
        return result;
    }

    public boolean concurrentState(char direction) {
        IGroup cur = this.getCurrentGroup();
        if (!EntityUtils.groupRoot(cur) && cur.getGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        this.getCurrentGroup().setConcurrentSeparator(direction);
        String tmp1 = UniqueSequence.getString(CONCURRENT_PREFIX);
        Ident ident1 = this.buildLeafIdent(tmp1);
        Ident code1 = this.V1972() ? ident1 : this.buildCode(tmp1);
        this.gotoGroup(ident1, code1, Display.create(""), GroupType.CONCURRENT_STATE, this.getCurrentGroup(), NamespaceStrategy.SINGLE);
        IGroup conc1 = this.getCurrentGroup();
        if (!EntityUtils.groupRoot(cur) && cur.getGroupType() == GroupType.STATE) {
            cur.moveEntitiesTo(conc1);
            super.endGroup();
            String tmp2 = UniqueSequence.getString(CONCURRENT_PREFIX);
            Ident ident2 = this.buildLeafIdent(tmp2);
            Ident code2 = this.V1972() ? ident2 : this.buildCode(tmp2);
            this.gotoGroup(ident2, code2, Display.create(""), GroupType.CONCURRENT_STATE, this.getCurrentGroup(), NamespaceStrategy.SINGLE);
        }
        return true;
    }

    @Override
    public void endGroup() {
        IGroup cur = this.getCurrentGroup();
        if (!EntityUtils.groupRoot(cur) && cur.getGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        super.endGroup();
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.STATE;
    }

    @Override
    public final void setHideEmptyDescription(boolean hideEmptyDescription) {
        this.hideEmptyDescription = hideEmptyDescription;
    }

    @Override
    public final boolean isHideEmptyDescriptionForState() {
        return this.hideEmptyDescription;
    }

    @Override
    public String checkFinalError() {
        for (Link link : this.getLinks()) {
            IGroup parent2;
            IGroup parent1 = StateDiagram.getGroupParentIfItIsConcurrentState(link.getEntity1());
            if (StateDiagram.isCompatible(parent1, parent2 = StateDiagram.getGroupParentIfItIsConcurrentState(link.getEntity2()))) continue;
            return "State within concurrent state cannot be linked out of this concurrent state (between " + link.getEntity1().getCodeGetName() + " and " + link.getEntity2().getCodeGetName() + ")";
        }
        return super.checkFinalError();
    }

    private static boolean isCompatible(IGroup parent1, IGroup parent2) {
        if (parent1 == null && parent2 == null) {
            return true;
        }
        if (parent1 != null ^ parent2 != null) {
            return false;
        }
        assert (parent1 != null && parent2 != null);
        return parent1 == parent2;
    }

    private static IGroup getGroupParentIfItIsConcurrentState(IEntity ent) {
        for (IGroup parent = ent.getParentContainer(); parent != null; parent = parent.getParentContainer()) {
            if (parent.getGroupType() != GroupType.CONCURRENT_STATE) continue;
            return parent;
        }
        return null;
    }
}

