/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageStateEmptyDescription
extends AbstractEntityImage {
    private final TextBlock desc;
    private final Url url;
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 40;

    public EntityImageStateEmptyDescription(IEntity entity, ISkinParam skinParam) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        this.desc = entity.getDisplay().create8(new FontConfiguration(this.getSkinParam(), FontParam.STATE, stereotype), HorizontalAlignment.CENTER, skinParam, CreoleMode.FULL, skinParam.wrapWidth());
        Display list = Display.empty();
        for (Member att : entity.getBodier().getFieldsToDisplay()) {
            list = list.addAll(Display.getWithNewlines(att.getDisplay(true)));
        }
        this.url = entity.getUrl99();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.desc.calculateDimension(stringBounder);
        Dimension2D result = Dimension2DDouble.delta(dim, 10.0);
        return Dimension2DDouble.atLeast(result, 50.0, 40.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal).rounded(25.0);
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            rect.setDeltaShadow(4.0);
        }
        ug = ug.apply(new UStroke(1.5)).apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBorder));
        HColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBackground);
        }
        ug = ug.apply(backcolor.bg());
        ug.draw(rect);
        double xDesc = (widthTotal - dimDesc.getWidth()) / 2.0;
        double yDesc = (heightTotal - dimDesc.getHeight()) / 2.0;
        this.desc.drawU(ug.apply(new UTranslate(xDesc, yDesc)));
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }
}

