/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Deque;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre8Compat;
import org.apache.tomcat.util.res.StringManager;

class Jre9Compat
extends Jre8Compat {
    private static final Log log = LogFactory.getLog(Jre9Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre9Compat.class);
    private static final Class<?> inaccessibleObjectExceptionClazz;
    private static final Method setDefaultUseCachesMethod;
    private static final Method bootMethod;
    private static final Method configurationMethod;
    private static final Method modulesMethod;
    private static final Method referenceMethod;
    private static final Method locationMethod;
    private static final Method isPresentMethod;
    private static final Method getMethod;
    private static final Constructor<JarFile> jarFileConstructor;
    private static final Method isMultiReleaseMethod;
    private static final Object RUNTIME_VERSION;
    private static final int RUNTIME_MAJOR_VERSION;
    private static final Method canAccessMethod;
    private static final Method getModuleMethod;
    private static final Method isExportedMethod;

    Jre9Compat() {
    }

    static boolean isSupported() {
        return inaccessibleObjectExceptionClazz != null;
    }

    @Override
    public boolean isInstanceOfInaccessibleObjectException(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        return inaccessibleObjectExceptionClazz.isAssignableFrom(throwable.getClass());
    }

    @Override
    public void disableCachingForJarUrlConnections() throws IOException {
        try {
            setDefaultUseCachesMethod.invoke(null, "JAR", Boolean.FALSE);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException(invocationTargetException);
        }
    }

    @Override
    public void addBootModulePath(Deque<URL> deque) {
        try {
            Object object = bootMethod.invoke(null, new Object[0]);
            Object object2 = configurationMethod.invoke(object, new Object[0]);
            Set set = (Set)modulesMethod.invoke(object2, new Object[0]);
            for (Object e : set) {
                Object object3 = referenceMethod.invoke(e, new Object[0]);
                Object object4 = locationMethod.invoke(object3, new Object[0]);
                Boolean bl = (Boolean)isPresentMethod.invoke(object4, new Object[0]);
                if (!bl.booleanValue()) continue;
                URI uRI = (URI)getMethod.invoke(object4, new Object[0]);
                try {
                    URL uRL = uRI.toURL();
                    deque.add(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    log.warn((Object)sm.getString("jre9Compat.invalidModuleUri", uRI), (Throwable)malformedURLException);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException(invocationTargetException);
        }
    }

    @Override
    public JarFile jarFileNewInstance(File file) throws IOException {
        try {
            return jarFileConstructor.newInstance(file, Boolean.TRUE, 1, RUNTIME_VERSION);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException(invocationTargetException);
        }
    }

    @Override
    public boolean jarFileIsMultiRelease(JarFile jarFile) {
        try {
            return (Boolean)isMultiReleaseMethod.invoke((Object)jarFile, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    @Override
    public int jarFileRuntimeMajorVersion() {
        return RUNTIME_MAJOR_VERSION;
    }

    @Override
    public boolean canAcccess(Object object, AccessibleObject accessibleObject) {
        try {
            return (Boolean)canAccessMethod.invoke((Object)accessibleObject, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    @Override
    public boolean isExported(Class<?> clazz) {
        try {
            String string = clazz.getPackage().getName();
            Object object = getModuleMethod.invoke(clazz, new Object[0]);
            return (Boolean)isExportedMethod.invoke(object, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    static {
        Class<?> clazz = null;
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        Method method4 = null;
        Method method5 = null;
        Method method6 = null;
        Method method7 = null;
        Method method8 = null;
        Constructor constructor = null;
        Method method9 = null;
        Object object = null;
        Object object2 = null;
        Method method10 = null;
        Method method11 = null;
        Method method12 = null;
        try {
            clazz = Class.forName("java.lang.reflect.InaccessibleObjectException");
            Class<?> clazz2 = Class.forName("java.lang.ModuleLayer");
            Class<?> clazz3 = Class.forName("java.lang.module.Configuration");
            Class<?> clazz4 = Class.forName("java.lang.module.ResolvedModule");
            Class<?> clazz5 = Class.forName("java.lang.module.ModuleReference");
            Class<?> clazz6 = Class.forName("java.util.Optional");
            Class<?> clazz7 = Class.forName("java.lang.Runtime$Version");
            Method method13 = JarFile.class.getMethod("runtimeVersion", new Class[0]);
            Method method14 = clazz7.getMethod("major", new Class[0]);
            method = URLConnection.class.getMethod("setDefaultUseCaches", String.class, Boolean.TYPE);
            method2 = clazz2.getMethod("boot", new Class[0]);
            method3 = clazz2.getMethod("configuration", new Class[0]);
            method4 = clazz3.getMethod("modules", new Class[0]);
            method5 = clazz4.getMethod("reference", new Class[0]);
            method6 = clazz5.getMethod("location", new Class[0]);
            method7 = clazz6.getMethod("isPresent", new Class[0]);
            method8 = clazz6.getMethod("get", new Class[0]);
            constructor = JarFile.class.getConstructor(File.class, Boolean.TYPE, Integer.TYPE, clazz7);
            method9 = JarFile.class.getMethod("isMultiRelease", new Class[0]);
            object = method13.invoke(null, new Object[0]);
            object2 = method14.invoke(object, new Object[0]);
            method10 = AccessibleObject.class.getMethod("canAccess", Object.class);
            method11 = Class.class.getMethod("getModule", new Class[0]);
            Class<?> clazz8 = Class.forName("java.lang.Module");
            method12 = clazz8.getMethod("isExported", String.class);
        }
        catch (SecurityException securityException) {
            log.error((Object)sm.getString("jre9Compat.unexpected"), (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.error((Object)sm.getString("jre9Compat.unexpected"), (Throwable)noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (clazz == null) {
                log.debug((Object)sm.getString("jre9Compat.javaPre9"), (Throwable)classNotFoundException);
            } else {
                log.error((Object)sm.getString("jre9Compat.unexpected"), (Throwable)classNotFoundException);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error((Object)sm.getString("jre9Compat.unexpected"), (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.error((Object)sm.getString("jre9Compat.unexpected"), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.error((Object)sm.getString("jre9Compat.unexpected"), (Throwable)invocationTargetException);
        }
        inaccessibleObjectExceptionClazz = clazz;
        setDefaultUseCachesMethod = method;
        bootMethod = method2;
        configurationMethod = method3;
        modulesMethod = method4;
        referenceMethod = method5;
        locationMethod = method6;
        isPresentMethod = method7;
        getMethod = method8;
        jarFileConstructor = constructor;
        isMultiReleaseMethod = method9;
        RUNTIME_VERSION = object;
        RUNTIME_MAJOR_VERSION = object2 != null ? (Integer)object2 : 8;
        canAccessMethod = method10;
        getModuleMethod = method11;
        isExportedMethod = method12;
    }
}

