/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.tomcat.InstrumentableClassLoader;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.PermissionCheck;

public abstract class WebappClassLoaderBase
extends URLClassLoader
implements Lifecycle,
InstrumentableClassLoader,
PermissionCheck {
    private static final Log log = LogFactory.getLog(WebappClassLoaderBase.class);
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final List<String> JVM_THREAD_GROUP_NAMES = new ArrayList<String>();
    private static final String JVM_THREAD_GROUP_SYSTEM = "system";
    private static final String SERVICES_PREFIX = "/META-INF/services/";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final Manifest MANIFEST_UNKNOWN = new Manifest();
    private static final Method GET_CLASSLOADING_LOCK_METHOD;
    protected static final StringManager sm;
    protected static final String[] triggers;
    protected static final String[] packageTriggers;
    boolean antiJARLocking = false;
    protected DirContext resources = null;
    protected Map<String, ResourceEntry> resourceEntries = new ConcurrentHashMap<String, ResourceEntry>();
    protected HashMap<String, String> notFoundResources = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> entry) {
            return this.size() > 1000;
        }
    };
    protected boolean delegate = false;
    protected long lastJarAccessed = 0L;
    protected int jarOpenInterval = 90000;
    protected String[] repositories = new String[0];
    protected URL[] repositoryURLs = null;
    protected File[] files = new File[0];
    protected JarFile[] jarFiles = new JarFile[0];
    protected File[] jarRealFiles = new File[0];
    protected String jarPath = null;
    protected String[] jarNames = new String[0];
    protected long[] lastModifiedDates = new long[0];
    protected String[] paths = new String[0];
    protected ArrayList<Permission> permissionList = new ArrayList();
    protected File loaderDir = null;
    protected String canonicalLoaderDir = null;
    protected HashMap<String, PermissionCollection> loaderPC = new HashMap();
    protected SecurityManager securityManager = null;
    protected ClassLoader parent = null;
    @Deprecated
    protected ClassLoader system = null;
    protected ClassLoader j2seClassLoader;
    protected boolean started = false;
    protected boolean hasExternalRepositories = false;
    protected boolean searchExternalFirst = false;
    protected boolean needConvert = false;
    protected Permission allPermission = new AllPermission();
    private boolean clearReferencesRmiTargets = true;
    @Deprecated
    private boolean clearReferencesStatic = false;
    private boolean clearReferencesStopThreads = false;
    private boolean clearReferencesStopTimerThreads = false;
    private boolean clearReferencesLogFactoryRelease = true;
    private boolean clearReferencesHttpClientKeepAliveThread = true;
    private String contextName = "unknown";
    private boolean clearReferencesObjectStreamClassCaches = true;
    private boolean clearReferencesThreadLocals = true;
    private final List<ClassFileTransformer> transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private URL webInfClassesCodeBase = null;

    public WebappClassLoaderBase() {
        super(new URL[0]);
        ClassLoader classLoader = this.getParent();
        if (classLoader == null) {
            classLoader = WebappClassLoaderBase.getSystemClassLoader();
        }
        this.parent = classLoader;
        ClassLoader classLoader2 = String.class.getClassLoader();
        if (classLoader2 == null) {
            classLoader2 = WebappClassLoaderBase.getSystemClassLoader();
            while (classLoader2.getParent() != null) {
                classLoader2 = classLoader2.getParent();
            }
        }
        this.j2seClassLoader = classLoader2;
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public WebappClassLoaderBase(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        ClassLoader classLoader2 = this.getParent();
        if (classLoader2 == null) {
            classLoader2 = WebappClassLoaderBase.getSystemClassLoader();
        }
        this.parent = classLoader2;
        ClassLoader classLoader3 = String.class.getClassLoader();
        if (classLoader3 == null) {
            classLoader3 = WebappClassLoaderBase.getSystemClassLoader();
            while (classLoader3.getParent() != null) {
                classLoader3 = classLoader3.getParent();
            }
        }
        this.j2seClassLoader = classLoader3;
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public DirContext getResources() {
        return this.resources;
    }

    public void setResources(DirContext dirContext) {
        this.resources = dirContext;
        if (dirContext instanceof ProxyDirContext) {
            this.contextName = ((ProxyDirContext)dirContext).getContextName();
        }
    }

    public String getContextName() {
        return this.contextName;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean bl) {
        this.delegate = bl;
    }

    public void setJarOpenInterval(int n) {
        this.jarOpenInterval = n;
    }

    public int getJarOpenInterval() {
        return this.jarOpenInterval;
    }

    public boolean getAntiJARLocking() {
        return this.antiJARLocking;
    }

    public void setAntiJARLocking(boolean bl) {
        this.antiJARLocking = bl;
    }

    public boolean getSearchExternalFirst() {
        return this.searchExternalFirst;
    }

    public boolean getClearReferencesRmiTargets() {
        return this.clearReferencesRmiTargets;
    }

    public void setClearReferencesRmiTargets(boolean bl) {
        this.clearReferencesRmiTargets = bl;
    }

    public void setSearchExternalFirst(boolean bl) {
        this.searchExternalFirst = bl;
    }

    public void addPermission(String string) {
        if (string == null) {
            return;
        }
        String string2 = string;
        if (this.securityManager != null) {
            Permission permission = null;
            if (string2.startsWith("jndi:") || string2.startsWith("jar:jndi:")) {
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                permission = new JndiPermission(string2 + "*");
                this.addPermission(permission);
            } else {
                if (!string2.endsWith(File.separator)) {
                    permission = new FilePermission(string2, "read");
                    this.addPermission(permission);
                    string2 = string2 + File.separator;
                }
                permission = new FilePermission(string2 + "-", "read");
                this.addPermission(permission);
            }
        }
    }

    public void addPermission(URL uRL) {
        if (uRL != null) {
            this.addPermission(uRL.toString());
        }
    }

    public void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.permissionList.add(permission);
        }
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(String string) {
        this.jarPath = string;
    }

    public void setWorkDir(File file) {
        this.loaderDir = new File(file, "loader");
        try {
            this.canonicalLoaderDir = this.loaderDir.getCanonicalPath();
            if (!this.canonicalLoaderDir.endsWith(File.separator)) {
                this.canonicalLoaderDir = this.canonicalLoaderDir + File.separator;
            }
        }
        catch (IOException iOException) {
            this.canonicalLoaderDir = null;
        }
    }

    @Deprecated
    protected void setParentClassLoader(ClassLoader classLoader) {
        this.parent = classLoader;
    }

    @Deprecated
    public boolean getClearReferencesStatic() {
        return this.clearReferencesStatic;
    }

    @Deprecated
    public void setClearReferencesStatic(boolean bl) {
        this.clearReferencesStatic = bl;
    }

    public boolean getClearReferencesStopThreads() {
        return this.clearReferencesStopThreads;
    }

    public void setClearReferencesStopThreads(boolean bl) {
        this.clearReferencesStopThreads = bl;
    }

    public boolean getClearReferencesStopTimerThreads() {
        return this.clearReferencesStopTimerThreads;
    }

    public void setClearReferencesStopTimerThreads(boolean bl) {
        this.clearReferencesStopTimerThreads = bl;
    }

    public boolean getClearReferencesLogFactoryRelease() {
        return this.clearReferencesLogFactoryRelease;
    }

    public void setClearReferencesLogFactoryRelease(boolean bl) {
        this.clearReferencesLogFactoryRelease = bl;
    }

    public boolean getClearReferencesHttpClientKeepAliveThread() {
        return this.clearReferencesHttpClientKeepAliveThread;
    }

    public void setClearReferencesHttpClientKeepAliveThread(boolean bl) {
        this.clearReferencesHttpClientKeepAliveThread = bl;
    }

    public boolean getClearReferencesObjectStreamClassCaches() {
        return this.clearReferencesObjectStreamClassCaches;
    }

    public void setClearReferencesObjectStreamClassCaches(boolean bl) {
        this.clearReferencesObjectStreamClassCaches = bl;
    }

    public boolean getClearReferencesThreadLocals() {
        return this.clearReferencesThreadLocals;
    }

    public void setClearReferencesThreadLocals(boolean bl) {
        this.clearReferencesThreadLocals = bl;
    }

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        if (classFileTransformer == null) {
            throw new IllegalArgumentException(sm.getString("webappClassLoader.addTransformer.illegalArgument", new Object[]{this.getContextName()}));
        }
        if (this.transformers.contains(classFileTransformer)) {
            log.warn((Object)sm.getString("webappClassLoader.addTransformer.duplicate", new Object[]{classFileTransformer, this.getContextName()}));
            return;
        }
        this.transformers.add(classFileTransformer);
        log.info((Object)sm.getString("webappClassLoader.addTransformer", new Object[]{classFileTransformer, this.getContextName()}));
    }

    public void removeTransformer(ClassFileTransformer classFileTransformer) {
        if (classFileTransformer == null) {
            return;
        }
        if (this.transformers.remove(classFileTransformer)) {
            log.info((Object)sm.getString("webappClassLoader.removeTransformer", new Object[]{classFileTransformer, this.getContextName()}));
            return;
        }
    }

    protected void copyStateWithoutTransformers(WebappClassLoaderBase webappClassLoaderBase) {
        webappClassLoaderBase.antiJARLocking = this.antiJARLocking;
        webappClassLoaderBase.resources = this.resources;
        webappClassLoaderBase.files = this.files;
        webappClassLoaderBase.delegate = this.delegate;
        webappClassLoaderBase.lastJarAccessed = this.lastJarAccessed;
        webappClassLoaderBase.repositories = this.repositories;
        webappClassLoaderBase.jarPath = this.jarPath;
        webappClassLoaderBase.loaderDir = this.loaderDir;
        webappClassLoaderBase.canonicalLoaderDir = this.canonicalLoaderDir;
        webappClassLoaderBase.clearReferencesStatic = this.clearReferencesStatic;
        webappClassLoaderBase.clearReferencesStopThreads = this.clearReferencesStopThreads;
        webappClassLoaderBase.clearReferencesStopTimerThreads = this.clearReferencesStopTimerThreads;
        webappClassLoaderBase.clearReferencesLogFactoryRelease = this.clearReferencesLogFactoryRelease;
        webappClassLoaderBase.clearReferencesHttpClientKeepAliveThread = this.clearReferencesHttpClientKeepAliveThread;
        webappClassLoaderBase.repositoryURLs = (URL[])this.repositoryURLs.clone();
        webappClassLoaderBase.jarFiles = (JarFile[])this.jarFiles.clone();
        webappClassLoaderBase.jarRealFiles = (File[])this.jarRealFiles.clone();
        webappClassLoaderBase.jarNames = (String[])this.jarNames.clone();
        webappClassLoaderBase.lastModifiedDates = (long[])this.lastModifiedDates.clone();
        webappClassLoaderBase.paths = (String[])this.paths.clone();
        webappClassLoaderBase.notFoundResources.putAll(this.notFoundResources);
        webappClassLoaderBase.permissionList.addAll(this.permissionList);
        webappClassLoaderBase.loaderPC.putAll(this.loaderPC);
        webappClassLoaderBase.contextName = this.contextName;
        webappClassLoaderBase.hasExternalRepositories = this.hasExternalRepositories;
        webappClassLoaderBase.searchExternalFirst = this.searchExternalFirst;
        webappClassLoaderBase.jarOpenInterval = this.jarOpenInterval;
    }

    public void addRepository(String string) {
        if (string.startsWith("/WEB-INF/lib") || string.startsWith("/WEB-INF/classes")) {
            return;
        }
        try {
            URL uRL = new URL(string);
            super.addURL(uRL);
            this.hasExternalRepositories = true;
            this.repositoryURLs = null;
        }
        catch (MalformedURLException malformedURLException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid repository: " + string);
            illegalArgumentException.initCause(malformedURLException);
            throw illegalArgumentException;
        }
    }

    synchronized void addRepository(String string, File file) {
        int n;
        if (string == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addRepository(" + string + ")"));
        }
        String[] stringArray = new String[this.repositories.length + 1];
        for (n = 0; n < this.repositories.length; ++n) {
            stringArray[n] = this.repositories[n];
        }
        stringArray[this.repositories.length] = string;
        this.repositories = stringArray;
        File[] fileArray = new File[this.files.length + 1];
        for (n = 0; n < this.files.length; ++n) {
            fileArray[n] = this.files[n];
        }
        fileArray[this.files.length] = file;
        this.files = fileArray;
    }

    synchronized void addJar(String string, JarFile jarFile, File file) throws IOException {
        int n;
        Object[] objectArray;
        if (string == null) {
            return;
        }
        if (jarFile == null) {
            return;
        }
        if (file == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addJar(" + string + ")"));
        }
        if (this.jarPath != null && string.startsWith(this.jarPath)) {
            String string2 = string.substring(this.jarPath.length());
            while (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            objectArray = new String[this.jarNames.length + 1];
            for (n = 0; n < this.jarNames.length; ++n) {
                objectArray[n] = this.jarNames[n];
            }
            objectArray[this.jarNames.length] = string2;
            this.jarNames = objectArray;
        }
        try {
            long l = ((ResourceAttributes)this.resources.getAttributes(string)).getLastModified();
            String[] stringArray = new String[this.paths.length + 1];
            for (n = 0; n < this.paths.length; ++n) {
                stringArray[n] = this.paths[n];
            }
            stringArray[this.paths.length] = string;
            this.paths = stringArray;
            long[] lArray = new long[this.lastModifiedDates.length + 1];
            for (n = 0; n < this.lastModifiedDates.length; ++n) {
                lArray[n] = this.lastModifiedDates[n];
            }
            lArray[this.lastModifiedDates.length] = l;
            this.lastModifiedDates = lArray;
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (!this.validateJarFile(file)) {
            return;
        }
        JarFile[] jarFileArray = new JarFile[this.jarFiles.length + 1];
        for (n = 0; n < this.jarFiles.length; ++n) {
            jarFileArray[n] = this.jarFiles[n];
        }
        jarFileArray[this.jarFiles.length] = jarFile;
        this.jarFiles = jarFileArray;
        objectArray = new File[this.jarRealFiles.length + 1];
        for (n = 0; n < this.jarRealFiles.length; ++n) {
            objectArray[n] = this.jarRealFiles[n];
        }
        objectArray[this.jarRealFiles.length] = file;
        this.jarRealFiles = objectArray;
    }

    public String[] findRepositories() {
        return (String[])this.repositories.clone();
    }

    public boolean modified() {
        int n;
        int n2;
        if (log.isDebugEnabled()) {
            log.debug((Object)"modified()");
        }
        if ((n2 = this.paths.length) > (n = this.lastModifiedDates.length)) {
            n2 = n;
        }
        for (int i = 0; i < n2; ++i) {
            try {
                long l = ((ResourceAttributes)this.resources.getAttributes(this.paths[i])).getLastModified();
                if (l == this.lastModifiedDates[i]) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Resource '" + this.paths[i] + "' was modified; Date is now: " + new Date(l) + " Was: " + new Date(this.lastModifiedDates[i])));
                }
                return true;
            }
            catch (NamingException namingException) {
                log.error((Object)("    Resource '" + this.paths[i] + "' is missing"));
                return true;
            }
        }
        n2 = this.jarNames.length;
        if (this.getJarPath() != null) {
            try {
                String string;
                NameClassPair nameClassPair;
                NamingEnumeration<Binding> namingEnumeration = this.resources.listBindings(this.getJarPath());
                int n3 = 0;
                while (namingEnumeration.hasMoreElements() && n3 < n2) {
                    nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                    string = nameClassPair.getName();
                    if (!string.endsWith(".jar")) continue;
                    if (!string.equals(this.jarNames[n3])) {
                        log.info((Object)("    Additional JARs have been added : '" + string + "'"));
                        return true;
                    }
                    ++n3;
                }
                if (namingEnumeration.hasMoreElements()) {
                    while (namingEnumeration.hasMoreElements()) {
                        nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                        string = nameClassPair.getName();
                        if (!string.endsWith(".jar")) continue;
                        log.info((Object)"    Additional JARs have been added");
                        return true;
                    }
                } else if (n3 < this.jarNames.length) {
                    log.info((Object)"    Additional JARs have been added");
                    return true;
                }
            }
            catch (NamingException namingException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("    Failed tracking modifications of '" + this.getJarPath() + "'"));
                }
            }
            catch (ClassCastException classCastException) {
                log.error((Object)("    Failed tracking modifications of '" + this.getJarPath() + "' : " + classCastException.getMessage()));
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("\r\n  context: ");
        stringBuilder.append(this.contextName);
        stringBuilder.append("\r\n  delegate: ");
        stringBuilder.append(this.delegate);
        stringBuilder.append("\r\n  repositories:\r\n");
        if (this.repositories != null) {
            for (int i = 0; i < this.repositories.length; ++i) {
                stringBuilder.append("    ");
                stringBuilder.append(this.repositories[i]);
                stringBuilder.append("\r\n");
            }
        }
        if (this.parent != null) {
            stringBuilder.append("----------> Parent Classloader:\r\n");
            stringBuilder.append(this.parent.toString());
            stringBuilder.append("\r\n");
        }
        if (this.transformers.size() > 0) {
            stringBuilder.append("----------> Class file transformers:\r\n");
            for (ClassFileTransformer classFileTransformer : this.transformers) {
                stringBuilder.append(classFileTransformer).append("\r\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected void addURL(URL uRL) {
        super.addURL(uRL);
        this.hasExternalRepositories = true;
        this.repositoryURLs = null;
    }

    protected final Class<?> doDefineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) {
        return super.defineClass(string, byArray, n, n2, protectionDomain);
    }

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        int n;
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findClass(" + string + ")"));
        }
        if (!this.started) {
            throw new ClassNotFoundException(string);
        }
        if (this.securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(string.substring(0, n));
            }
            catch (Exception exception) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      -->Exception-->ClassNotFoundException", (Throwable)exception);
                }
                throw new ClassNotFoundException(string, exception);
            }
        }
        Class<?> clazz = null;
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("      findClassInternal(" + string + ")"));
            }
            if (this.hasExternalRepositories && this.searchExternalFirst) {
                try {
                    clazz = super.findClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (AccessControlException accessControlException) {
                    log.warn((Object)("WebappClassLoaderBase.findClassInternal(" + string + ") security exception: " + accessControlException.getMessage()), (Throwable)accessControlException);
                    throw new ClassNotFoundException(string, accessControlException);
                }
                catch (RuntimeException runtimeException) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)runtimeException);
                    }
                    throw runtimeException;
                }
            }
            if (clazz == null) {
                try {
                    clazz = this.findClassInternal(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!this.hasExternalRepositories || this.searchExternalFirst) {
                        throw classNotFoundException;
                    }
                }
                catch (AccessControlException accessControlException) {
                    log.warn((Object)("WebappClassLoaderBase.findClassInternal(" + string + ") security exception: " + accessControlException.getMessage()), (Throwable)accessControlException);
                    throw new ClassNotFoundException(string, accessControlException);
                }
                catch (RuntimeException runtimeException) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)runtimeException);
                    }
                    throw runtimeException;
                }
            }
            if (clazz == null && this.hasExternalRepositories && !this.searchExternalFirst) {
                try {
                    clazz = super.findClass(string);
                }
                catch (AccessControlException accessControlException) {
                    log.warn((Object)("WebappClassLoaderBase.findClassInternal(" + string + ") security exception: " + accessControlException.getMessage()), (Throwable)accessControlException);
                    throw new ClassNotFoundException(string, accessControlException);
                }
                catch (RuntimeException runtimeException) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)runtimeException);
                    }
                    throw runtimeException;
                }
            }
            if (clazz == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"    --> Passing on ClassNotFoundException");
            }
            throw classNotFoundException;
        }
        if (log.isTraceEnabled()) {
            log.debug((Object)("      Returning class " + clazz));
        }
        if (log.isTraceEnabled()) {
            ClassLoader classLoader = Globals.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedGetClassLoader(clazz)) : clazz.getClassLoader();
            log.debug((Object)("      Loaded by " + classLoader.toString()));
        }
        return clazz;
    }

    @Override
    public URL findResource(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findResource(" + string + ")"));
        }
        URL uRL = null;
        String string2 = this.nameToPath(string);
        if (this.hasExternalRepositories && this.searchExternalFirst) {
            uRL = super.findResource(string);
        }
        if (uRL == null) {
            ResourceEntry resourceEntry = this.resourceEntries.get(string2);
            if (resourceEntry == null) {
                if (this.securityManager != null) {
                    PrivilegedFindResourceByName privilegedFindResourceByName = new PrivilegedFindResourceByName(string, string2, false);
                    resourceEntry = AccessController.doPrivileged(privilegedFindResourceByName);
                } else {
                    resourceEntry = this.findResourceInternal(string, string2, false);
                }
            }
            if (resourceEntry != null) {
                uRL = resourceEntry.source;
            }
        }
        if (uRL == null && this.hasExternalRepositories && !this.searchExternalFirst) {
            uRL = super.findResource(string);
        }
        if (log.isDebugEnabled()) {
            if (uRL != null) {
                log.debug((Object)("    --> Returning '" + uRL.toString() + "'"));
            } else {
                log.debug((Object)"    --> Resource not found, returning null");
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        int n;
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findResources(" + string + ")"));
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        int n2 = this.jarFiles.length;
        int n3 = this.repositories.length;
        if (this.hasExternalRepositories && this.searchExternalFirst) {
            object = super.findResources(string);
            while (object.hasMoreElements()) {
                linkedHashSet.add(object.nextElement());
            }
        }
        for (n = 0; n < n3; ++n) {
            try {
                object = this.repositories[n] + string;
                this.resources.lookup((String)object);
                try {
                    linkedHashSet.add(this.getURI(new File(this.files[n], string)));
                }
                catch (MalformedURLException malformedURLException) {}
                continue;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        object = string.startsWith("/") ? string.substring(1) : string;
        Object object2 = this.jarFiles;
        synchronized (this.jarFiles) {
            if (this.openJARs()) {
                for (n = 0; n < n2; ++n) {
                    JarEntry jarEntry = this.jarFiles[n].getJarEntry((String)object);
                    if (jarEntry == null) continue;
                    try {
                        String string2 = this.getURI(this.jarRealFiles[n]).toString();
                        linkedHashSet.add(UriUtil.buildJarUrl((String)string2, (String)object));
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            // ** MonitorExit[var7_9] (shouldn't be in output)
            if (this.hasExternalRepositories && !this.searchExternalFirst) {
                object2 = super.findResources(string);
                while (object2.hasMoreElements()) {
                    linkedHashSet.add(object2.nextElement());
                }
            }
            return Collections.enumeration(linkedHashSet);
        }
    }

    @Override
    public URL getResource(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResource(" + string + ")"));
        }
        URL uRL = null;
        if (this.delegate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader " + this.parent));
            }
            if ((uRL = this.parent.getResource(string)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  --> Returning '" + uRL.toString() + "'"));
                }
                return uRL;
            }
        }
        if ((uRL = this.findResource(string)) != null) {
            if (this.antiJARLocking) {
                String string2 = this.nameToPath(string);
                ResourceEntry resourceEntry = this.resourceEntries.get(string2);
                try {
                    String string3 = resourceEntry.codeBase.toString();
                    if (string3.endsWith(".jar") && !string.endsWith(CLASS_FILE_SUFFIX)) {
                        File file = new File(this.loaderDir, string);
                        uRL = this.getURI(file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  --> Returning '" + uRL.toString() + "'"));
            }
            return uRL;
        }
        if (!this.delegate && (uRL = this.parent.getResource(string)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  --> Returning '" + uRL.toString() + "'"));
            }
            return uRL;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        Enumeration<URL> enumeration = this.getParent().getResources(string);
        Enumeration<URL> enumeration2 = this.findResources(string);
        if (this.delegate) {
            return new CombinedEnumeration(enumeration, enumeration2);
        }
        return new CombinedEnumeration(enumeration2, enumeration);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        URL uRL;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResourceAsStream(" + string + ")"));
        }
        InputStream inputStream = null;
        inputStream = this.findLoadedResource(string);
        if (inputStream != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from cache");
            }
            return inputStream;
        }
        if (this.delegate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader " + this.parent));
            }
            if ((inputStream = this.parent.getResourceAsStream(string)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  --> Returning stream from parent");
                }
                return inputStream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching local repositories");
        }
        if ((uRL = this.findResource(string)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from local");
            }
            inputStream = this.findLoadedResource(string);
            try {
                if (this.hasExternalRepositories && inputStream == null) {
                    inputStream = uRL.openStream();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputStream != null) {
                return inputStream;
            }
        }
        if (!this.delegate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader unconditionally " + this.parent));
            }
            if ((inputStream = this.parent.getResourceAsStream(string)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  --> Returning stream from parent");
                }
                return inputStream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Object object = this.getClassLoadingLockInternal(string);
        synchronized (object) {
            boolean bl2;
            int n;
            if (log.isDebugEnabled()) {
                log.debug((Object)("loadClass(" + string + ", " + bl + ")"));
            }
            Class<?> clazz = null;
            if (!this.started) {
                try {
                    throw new IllegalStateException();
                }
                catch (IllegalStateException illegalStateException) {
                    log.info((Object)sm.getString("webappClassLoader.stopped", new Object[]{string}), (Throwable)illegalStateException);
                }
            }
            if ((clazz = this.findLoadedClass0(string)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Returning class from cache");
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            clazz = this.findLoadedClass(string);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Returning class from cache");
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            try {
                clazz = this.j2seClassLoader.loadClass(string);
                if (clazz != null) {
                    if (bl) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (this.securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
                try {
                    this.securityManager.checkPackageAccess(string.substring(0, n));
                }
                catch (SecurityException securityException) {
                    String string2 = "Security Violation, attempt to use Restricted Class: " + string;
                    if (string.endsWith("BeanInfo")) {
                        log.debug((Object)string2, (Throwable)securityException);
                    } else {
                        log.info((Object)string2, (Throwable)securityException);
                    }
                    throw new ClassNotFoundException(string2, securityException);
                }
            }
            boolean bl3 = bl2 = this.delegate || this.filter(string);
            if (bl2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Delegating to parent classloader1 " + this.parent));
                }
                try {
                    clazz = Class.forName(string, false, this.parent);
                    if (clazz != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"  Loading class from parent");
                        }
                        if (bl) {
                            this.resolveClass(clazz);
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Searching local repositories");
            }
            try {
                clazz = this.findClass(string);
                if (clazz != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Loading class from local repository");
                    }
                    if (bl) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!bl2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Delegating to parent classloader at end: " + this.parent));
                }
                try {
                    clazz = Class.forName(string, false, this.parent);
                    if (clazz != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"  Loading class from parent");
                        }
                        if (bl) {
                            this.resolveClass(clazz);
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        throw new ClassNotFoundException(string);
    }

    private Object getClassLoadingLockInternal(String string) {
        if (JreCompat.isJre7Available() && GET_CLASSLOADING_LOCK_METHOD != null) {
            try {
                return GET_CLASSLOADING_LOCK_METHOD.invoke((Object)this, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String string = codeSource.getLocation().toString();
        PermissionCollection permissionCollection = this.loaderPC.get(string);
        if (permissionCollection == null && (permissionCollection = super.getPermissions(codeSource)) != null) {
            for (Permission permission : this.permissionList) {
                permissionCollection.add(permission);
            }
            this.loaderPC.put(string, permissionCollection);
        }
        return permissionCollection;
    }

    public boolean check(Permission permission) {
        CodeSource codeSource;
        PermissionCollection permissionCollection;
        ResourceEntry resourceEntry;
        if (!Globals.IS_SECURITY_ENABLED) {
            return true;
        }
        Policy policy = Policy.getPolicy();
        return policy != null && (resourceEntry = this.findResourceInternal("/", "/", false)) != null && (permissionCollection = policy.getPermissions(codeSource = new CodeSource(resourceEntry.codeBase, (Certificate[])null))).implies(permission);
    }

    @Override
    public URL[] getURLs() {
        if (this.repositoryURLs != null) {
            return (URL[])this.repositoryURLs.clone();
        }
        URL[] uRLArray = super.getURLs();
        int n = this.files.length;
        int n2 = this.jarRealFiles.length;
        int n3 = uRLArray.length;
        int n4 = 0;
        try {
            int n5;
            URL[] uRLArray2 = new URL[n + n2 + n3];
            if (this.searchExternalFirst) {
                for (n5 = 0; n5 < n3; ++n5) {
                    uRLArray2[n5] = uRLArray[n5];
                }
                n4 = n3;
            }
            for (n5 = 0; n5 < n; ++n5) {
                uRLArray2[n4 + n5] = this.getURI(this.files[n5]);
            }
            n4 += n;
            for (n5 = 0; n5 < n2; ++n5) {
                uRLArray2[n4 + n5] = this.getURI(this.jarRealFiles[n5]);
            }
            n4 += n2;
            if (!this.searchExternalFirst) {
                for (n5 = 0; n5 < n3; ++n5) {
                    uRLArray2[n4 + n5] = uRLArray[n5];
                }
            }
            this.repositoryURLs = uRLArray2;
        }
        catch (MalformedURLException malformedURLException) {
            this.repositoryURLs = new URL[0];
        }
        return (URL[])this.repositoryURLs.clone();
    }

    @Override
    public void addLifecycleListener(LifecycleListener lifecycleListener) {
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    @Override
    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
    }

    @Override
    public LifecycleState getState() {
        return LifecycleState.NEW;
    }

    @Override
    public String getStateName() {
        return this.getState().toString();
    }

    @Override
    public void init() {
    }

    @Override
    public void start() throws LifecycleException {
        this.started = true;
        String string = null;
        try {
            string = System.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            return;
        }
        if (string.indexOf("EBCDIC") != -1) {
            this.needConvert = true;
        }
        for (int i = 0; i < this.repositories.length; ++i) {
            if (!this.repositories[i].equals("/WEB-INF/classes/")) continue;
            try {
                this.webInfClassesCodeBase = this.files[i].toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {}
            break;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void stop() throws LifecycleException {
        int n;
        this.clearReferences();
        this.started = false;
        int n2 = this.files.length;
        for (n = 0; n < n2; ++n) {
            this.files[n] = null;
        }
        n2 = this.jarFiles.length;
        for (n = 0; n < n2; ++n) {
            try {
                if (this.jarFiles[n] != null) {
                    this.jarFiles[n].close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jarFiles[n] = null;
        }
        this.notFoundResources.clear();
        this.resourceEntries.clear();
        this.resources = null;
        this.repositories = null;
        this.repositoryURLs = null;
        this.files = null;
        this.jarFiles = null;
        this.jarRealFiles = null;
        this.jarPath = null;
        this.jarNames = null;
        this.lastModifiedDates = null;
        this.paths = null;
        this.hasExternalRepositories = false;
        this.parent = null;
        this.webInfClassesCodeBase = null;
        this.permissionList.clear();
        this.loaderPC.clear();
        if (this.loaderDir != null) {
            WebappClassLoaderBase.deleteDir(this.loaderDir);
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeJARs(boolean bl) {
        if (this.jarFiles.length <= 0 || !bl && this.jarOpenInterval <= 0) return;
        JarFile[] jarFileArray = this.jarFiles;
        synchronized (this.jarFiles) {
            if (!bl && (this.jarOpenInterval <= 0 || System.currentTimeMillis() <= this.lastJarAccessed + (long)this.jarOpenInterval)) return;
            for (int i = 0; i < this.jarFiles.length; ++i) {
                try {
                    if (this.jarFiles[i] == null) continue;
                    this.jarFiles[i].close();
                    this.jarFiles[i] = null;
                    continue;
                }
                catch (IOException iOException) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Failed to close JAR", (Throwable)iOException);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected ClassLoader getJavaseClassLoader() {
        return this.j2seClassLoader;
    }

    protected void setJavaseClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException(sm.getString("webappClassLoader.javaseClassLoaderNull"));
        }
        this.j2seClassLoader = classLoader;
    }

    protected void clearReferences() {
        this.clearReferencesJdbc();
        this.clearReferencesThreads();
        if (this.clearReferencesObjectStreamClassCaches) {
            this.clearReferencesObjectStreamClassCaches();
        }
        if (this.clearReferencesThreadLocals) {
            this.checkThreadLocalsForLeaks();
        }
        if (this.clearReferencesRmiTargets) {
            this.clearReferencesRmiTargets();
        }
        if (this.clearReferencesStatic) {
            this.clearReferencesStaticFinal();
        }
        IntrospectionUtils.clear();
        if (this.clearReferencesLogFactoryRelease) {
            LogFactory.release((ClassLoader)this);
        }
        Introspector.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void clearReferencesJdbc() {
        Object object;
        void var2_3;
        InputStream inputStream = this.getResourceAsStream("org/apache/catalina/loader/JdbcLeakPrevention.class");
        byte[] byArray = new byte[2048];
        int n = 0;
        int n2 = inputStream.read(byArray, n, byArray.length - n);
        while (n2 > -1) {
            if ((n += n2) == ((void)var2_3).length) {
                object = new byte[((void)var2_3).length * 2];
                System.arraycopy(var2_3, 0, object, 0, ((void)var2_3).length);
                Object object2 = object;
            }
            n2 = inputStream.read((byte[])var2_3, n, ((void)var2_3).length - n);
        }
        object = this.defineClass("org.apache.catalina.loader.JdbcLeakPrevention", (byte[])var2_3, 0, n, this.getClass().getProtectionDomain());
        Object obj = ((Class)object).newInstance();
        List list = (List)obj.getClass().getMethod("clearJdbcDriverRegistrations", new Class[0]).invoke(obj, new Object[0]);
        for (String string : list) {
            log.error((Object)sm.getString("webappClassLoader.clearJdbc", new Object[]{this.contextName, string}));
        }
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveStreamError", new Object[]{this.contextName}), (Throwable)iOException);
        }
        return;
        catch (Exception exception) {
            try {
                Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)exception);
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveFailed", new Object[]{this.contextName}), throwable);
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveStreamError", new Object[]{this.contextName}), (Throwable)iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveStreamError", new Object[]{this.contextName}), (Throwable)iOException);
            }
            return;
        }
    }

    private final void clearReferencesStaticFinal() {
        int n;
        Field[] fieldArray;
        Class<?> clazz;
        ArrayList<ResourceEntry> arrayList = new ArrayList<ResourceEntry>();
        arrayList.addAll(this.resourceEntries.values());
        block6: for (ResourceEntry resourceEntry : arrayList) {
            if (resourceEntry.loadedClass == null) continue;
            clazz = resourceEntry.loadedClass;
            try {
                fieldArray = clazz.getDeclaredFields();
                for (n = 0; n < fieldArray.length; ++n) {
                    if (!Modifier.isStatic(fieldArray[n].getModifiers())) continue;
                    fieldArray[n].get(null);
                    continue block6;
                }
            }
            catch (Throwable throwable) {
            }
        }
        for (ResourceEntry resourceEntry : arrayList) {
            if (resourceEntry.loadedClass == null) continue;
            clazz = resourceEntry.loadedClass;
            try {
                fieldArray = clazz.getDeclaredFields();
                for (n = 0; n < fieldArray.length; ++n) {
                    Field field = fieldArray[n];
                    int n2 = field.getModifiers();
                    if (field.getType().isPrimitive() || field.getName().indexOf(36) != -1 || !Modifier.isStatic(n2)) continue;
                    try {
                        field.setAccessible(true);
                        if (Modifier.isFinal(n2)) {
                            if (field.getType().getName().startsWith("java.") || field.getType().getName().startsWith("javax.")) continue;
                            this.nullInstance(field.get(null));
                            continue;
                        }
                        field.set(null, null);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Set field " + field.getName() + " to null in class " + clazz.getName()));
                        continue;
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Could not set field " + field.getName() + " to null in class " + clazz.getName()), throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not clean fields for class " + clazz.getName()), throwable);
            }
        }
    }

    private void nullInstance(Object object) {
        if (object == null) {
            return;
        }
        Field[] fieldArray = object.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if (field.getType().isPrimitive() || field.getName().indexOf(36) != -1) continue;
            try {
                Object object2;
                field.setAccessible(true);
                if (Modifier.isStatic(n) && Modifier.isFinal(n) || null == (object2 = field.get(object))) continue;
                Class<?> clazz = object2.getClass();
                if (!this.loadedByThisOrChild(clazz)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Not setting field " + field.getName() + " to null in object of class " + object.getClass().getName() + " because the referenced object was of type " + clazz.getName() + " which was not loaded by this web application class loader."));
                    continue;
                }
                field.set(object, null);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Set field " + field.getName() + " to null in class " + object.getClass().getName()));
                continue;
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not set field " + field.getName() + " to null in object instance of class " + object.getClass().getName()), throwable);
            }
        }
    }

    private void clearReferencesThreads() {
        Thread[] threadArray = this.getThreads();
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        for (Thread thread : threadArray) {
            ClassLoader classLoader;
            if (thread == null || (classLoader = thread.getContextClassLoader()) != this || thread == Thread.currentThread()) continue;
            ThreadGroup threadGroup = thread.getThreadGroup();
            if (threadGroup != null && JVM_THREAD_GROUP_NAMES.contains(threadGroup.getName())) {
                if (!this.clearReferencesHttpClientKeepAliveThread || !thread.getName().equals("Keep-Alive-Timer")) continue;
                thread.setContextClassLoader(this.parent);
                log.debug((Object)sm.getString("webappClassLoader.checkThreadsHttpClient"));
                continue;
            }
            if (!thread.isAlive()) continue;
            if (thread.getClass().getName().startsWith("java.util.Timer") && this.clearReferencesStopTimerThreads) {
                this.clearReferencesStopTimerThread(thread);
                continue;
            }
            if (this.isRequestThread(thread)) {
                log.error((Object)sm.getString("webappClassLoader.warnRequestThread", new Object[]{this.contextName, thread.getName()}));
            } else {
                log.error((Object)sm.getString("webappClassLoader.warnThread", new Object[]{this.contextName, thread.getName()}));
            }
            if (!this.clearReferencesStopThreads) continue;
            boolean bl = false;
            try {
                Object object = null;
                for (String string : new String[]{"target", "runnable", "action"}) {
                    try {
                        Field field = thread.getClass().getDeclaredField(string);
                        field.setAccessible(true);
                        object = field.get(thread);
                        break;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                }
                if (object != null && object.getClass().getCanonicalName() != null && object.getClass().getCanonicalName().equals("java.util.concurrent.ThreadPoolExecutor.Worker")) {
                    Field field = object.getClass().getDeclaredField("this$0");
                    field.setAccessible(true);
                    Object object2 = field.get(object);
                    if (object2 instanceof ThreadPoolExecutor) {
                        ((ThreadPoolExecutor)object2).shutdownNow();
                        bl = true;
                    }
                }
            }
            catch (SecurityException securityException) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", new Object[]{thread.getName(), this.contextName}), (Throwable)securityException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", new Object[]{thread.getName(), this.contextName}), (Throwable)noSuchFieldException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", new Object[]{thread.getName(), this.contextName}), (Throwable)illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", new Object[]{thread.getName(), this.contextName}), (Throwable)illegalAccessException);
            }
            if (!bl && !thread.isInterrupted()) {
                thread.interrupt();
            }
            arrayList.add(thread);
        }
        int n = 0;
        for (Thread thread : arrayList) {
            while (thread.isAlive() && n < 100) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                ++n;
            }
            if (!thread.isAlive()) continue;
            thread.stop();
        }
    }

    private boolean isRequestThread(Thread thread) {
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[stackTraceElementArray.length - (i + 1)];
            if (!"org.apache.catalina.connector.CoyoteAdapter".equals(stackTraceElement.getClassName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesStopTimerThread(Thread thread) {
        try {
            try {
                Field field = thread.getClass().getDeclaredField("newTasksMayBeScheduled");
                field.setAccessible(true);
                Field field2 = thread.getClass().getDeclaredField("queue");
                field2.setAccessible(true);
                Object object = field2.get(thread);
                Method method = object.getClass().getDeclaredMethod("clear", new Class[0]);
                method.setAccessible(true);
                Object object2 = object;
                synchronized (object2) {
                    field.setBoolean(thread, false);
                    method.invoke(object, new Object[0]);
                    object.notifyAll();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Method method = thread.getClass().getDeclaredMethod("cancel", new Class[0]);
                Thread thread2 = thread;
                synchronized (thread2) {
                    method.setAccessible(true);
                    method.invoke((Object)thread, new Object[0]);
                }
            }
            log.error((Object)sm.getString("webappClassLoader.warnTimerThread", new Object[]{this.contextName, thread.getName()}));
        }
        catch (Exception exception) {
            Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)exception);
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("webappClassLoader.stopTimerThreadFail", new Object[]{thread.getName(), this.contextName}), throwable);
        }
    }

    private void checkThreadLocalsForLeaks() {
        Thread[] threadArray = this.getThreads();
        try {
            Field field = Thread.class.getDeclaredField("threadLocals");
            field.setAccessible(true);
            Field field2 = Thread.class.getDeclaredField("inheritableThreadLocals");
            field2.setAccessible(true);
            Class<?> clazz = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field field3 = clazz.getDeclaredField("table");
            field3.setAccessible(true);
            Method method = clazz.getDeclaredMethod("expungeStaleEntries", new Class[0]);
            method.setAccessible(true);
            for (Thread thread : threadArray) {
                if (thread == null) continue;
                Object object = field.get(thread);
                if (null != object) {
                    method.invoke(object, new Object[0]);
                    this.checkThreadLocalMapForLeaks(object, field3);
                }
                if (null == (object = field2.get(thread))) continue;
                method.invoke(object, new Object[0]);
                this.checkThreadLocalMapForLeaks(object, field3);
            }
        }
        catch (Throwable throwable) {
            JreCompat jreCompat = JreCompat.getInstance();
            if (jreCompat.isInstanceOfInaccessibleObjectException(throwable)) {
                log.warn((Object)sm.getString("webappClassLoader.addExportsThreadLocal"));
            }
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaksFail", new Object[]{this.getContextName()}), throwable);
        }
    }

    private void checkThreadLocalMapForLeaks(Object object, Field field) throws IllegalAccessException, NoSuchFieldException {
        Object[] objectArray;
        if (object != null && (objectArray = (Object[])field.get(object)) != null) {
            for (Object object2 : objectArray) {
                if (object2 == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                Object t = ((Reference)object2).get();
                if (this.equals(t) || this.loadedByThisOrChild(t)) {
                    bl = true;
                }
                Field field2 = object2.getClass().getDeclaredField("value");
                field2.setAccessible(true);
                Object object3 = field2.get(object2);
                if (this.equals(object3) || this.loadedByThisOrChild(object3)) {
                    bl2 = true;
                }
                if (!bl && !bl2) continue;
                Object[] objectArray2 = new Object[5];
                objectArray2[0] = this.contextName;
                if (t != null) {
                    objectArray2[1] = this.getPrettyClassName(t.getClass());
                    try {
                        objectArray2[2] = t.toString();
                    }
                    catch (Exception exception) {
                        log.error((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badKey", new Object[]{objectArray2[1]}), (Throwable)exception);
                        objectArray2[2] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                    }
                }
                if (object3 != null) {
                    objectArray2[3] = this.getPrettyClassName(object3.getClass());
                    try {
                        objectArray2[4] = object3.toString();
                    }
                    catch (Exception exception) {
                        log.error((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badValue", new Object[]{objectArray2[3]}), (Throwable)exception);
                        objectArray2[4] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                    }
                }
                if (bl2) {
                    log.error((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks", objectArray2));
                    continue;
                }
                if (object3 == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaksNull", objectArray2));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaksNone", objectArray2));
            }
        }
    }

    private String getPrettyClassName(Class<?> clazz) {
        String string = clazz.getCanonicalName();
        if (string == null) {
            string = clazz.getName();
        }
        return string;
    }

    private boolean loadedByThisOrChild(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        for (ClassLoader classLoader = clazz.getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (classLoader != this) continue;
            return true;
        }
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            try {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!this.loadedByThisOrChild(e)) continue;
                    return true;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                log.warn((Object)sm.getString("webappClassLoader", new Object[]{clazz.getName(), this.getContextName()}), (Throwable)concurrentModificationException);
            }
        }
        return false;
    }

    private Thread[] getThreads() {
        Thread[] threadArray;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        try {
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
        }
        catch (SecurityException securityException) {
            threadArray = sm.getString("webappClassLoader.getThreadGroupError", new Object[]{threadGroup.getName()});
            if (log.isDebugEnabled()) {
                log.debug((Object)threadArray, (Throwable)securityException);
            }
            log.warn((Object)threadArray);
        }
        int n = threadGroup.activeCount() + 50;
        threadArray = new Thread[n];
        int n2 = threadGroup.enumerate(threadArray);
        while (n2 == n) {
            threadArray = new Thread[n *= 2];
            n2 = threadGroup.enumerate(threadArray);
        }
        return threadArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesRmiTargets() {
        try {
            Object object;
            Class<?> clazz = Class.forName("sun.rmi.transport.Target");
            Field field = clazz.getDeclaredField("ccl");
            field.setAccessible(true);
            Field field2 = clazz.getDeclaredField("stub");
            field2.setAccessible(true);
            Class<?> clazz2 = Class.forName("sun.rmi.transport.ObjectTable");
            Field field3 = clazz2.getDeclaredField("objTable");
            field3.setAccessible(true);
            Object object2 = field3.get(null);
            if (object2 == null) {
                return;
            }
            Field field4 = clazz2.getDeclaredField("tableLock");
            field4.setAccessible(true);
            Object object3 = object = field4.get(null);
            synchronized (object3) {
                Object object4;
                Iterator iterator;
                Object object5;
                Object object6;
                if (object2 instanceof Map) {
                    object6 = ((Map)object2).values().iterator();
                    while (object6.hasNext()) {
                        object5 = object6.next();
                        iterator = field.get(object5);
                        if (this != iterator) continue;
                        object6.remove();
                        object4 = field2.get(object5);
                        log.error((Object)sm.getString("webappClassLoader.clearRmi", new Object[]{object4.getClass().getName(), object4}));
                    }
                }
                object6 = clazz2.getDeclaredField("implTable");
                ((Field)object6).setAccessible(true);
                object5 = ((Field)object6).get(null);
                if (object5 == null) {
                    return;
                }
                if (object5 instanceof Map) {
                    iterator = ((Map)object5).values().iterator();
                    while (iterator.hasNext()) {
                        object4 = iterator.next();
                        Object object7 = field.get(object4);
                        if (this != object7) continue;
                        iterator.remove();
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.info((Object)sm.getString("webappClassLoader.clearRmiInfo", new Object[]{this.contextName}), (Throwable)classNotFoundException);
        }
        catch (SecurityException securityException) {
            log.warn((Object)sm.getString("webappClassLoader.clearRmiFail", new Object[]{this.contextName}), (Throwable)securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            log.warn((Object)sm.getString("webappClassLoader.clearRmiFail", new Object[]{this.contextName}), (Throwable)noSuchFieldException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn((Object)sm.getString("webappClassLoader.clearRmiFail", new Object[]{this.contextName}), (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn((Object)sm.getString("webappClassLoader.clearRmiFail", new Object[]{this.contextName}), (Throwable)illegalAccessException);
        }
        catch (Exception exception) {
            JreCompat jreCompat = JreCompat.getInstance();
            if (jreCompat.isInstanceOfInaccessibleObjectException((Throwable)exception)) {
                log.warn((Object)sm.getString("webappClassLoader.addExportsRmi"));
            }
            throw new RuntimeException(exception);
        }
    }

    private void clearReferencesObjectStreamClassCaches() {
        try {
            Class<?> clazz = Class.forName("java.io.ObjectStreamClass$Caches");
            this.clearCache(clazz, "localDescs");
            this.clearCache(clazz, "reflectors");
        }
        catch (SecurityException securityException) {
            log.warn((Object)sm.getString("webappClassLoader.clearObjectStreamClassCachesFail", new Object[]{this.getContextName()}), (Throwable)securityException);
        }
        catch (ClassCastException classCastException) {
            log.warn((Object)sm.getString("webappClassLoader.clearObjectStreamClassCachesFail", new Object[]{this.getContextName()}), (Throwable)classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn((Object)sm.getString("webappClassLoader.clearObjectStreamClassCachesFail", new Object[]{this.getContextName()}), (Throwable)illegalArgumentException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            log.warn((Object)sm.getString("webappClassLoader.clearObjectStreamClassCachesFail", new Object[]{this.getContextName()}), (Throwable)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn((Object)sm.getString("webappClassLoader.clearObjectStreamClassCachesFail", new Object[]{this.getContextName()}), (Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.warn((Object)sm.getString("webappClassLoader.clearObjectStreamClassCachesFail", new Object[]{this.getContextName()}), (Throwable)classNotFoundException);
        }
    }

    private void clearCache(Class<?> clazz, String string) throws SecurityException, ClassCastException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        Map map = (Map)field.get(null);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object t;
            Object k = iterator.next();
            if (!(k instanceof Reference) || !this.loadedByThisOrChild(t = ((Reference)k).get())) continue;
            iterator.remove();
        }
    }

    protected boolean openJARs() {
        if (this.started && this.jarFiles.length > 0) {
            this.lastJarAccessed = System.currentTimeMillis();
            if (this.jarFiles[0] == null) {
                for (int i = 0; i < this.jarFiles.length; ++i) {
                    try {
                        this.jarFiles[i] = JreCompat.getInstance().jarFileNewInstance(this.jarRealFiles[i]);
                        continue;
                    }
                    catch (IOException iOException) {
                        log.warn((Object)sm.getString("webappClassLoader.jarOpenFail", new Object[]{this.jarFiles[i]}), (Throwable)iOException);
                        this.closeJARs(true);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected Class<?> findClassInternal(String string) throws ClassNotFoundException {
        Class<?> clazz;
        if (!this.validate(string)) {
            throw new ClassNotFoundException(string);
        }
        ResourceEntry resourceEntry = null;
        String string2 = this.binaryNameToPath(string, true);
        if (this.securityManager != null) {
            clazz = new PrivilegedFindResourceByName(string, string2, true);
            resourceEntry = AccessController.doPrivileged(clazz);
        } else {
            resourceEntry = this.findResourceInternal(string, string2, true);
        }
        if (resourceEntry == null) {
            throw new ClassNotFoundException(string);
        }
        clazz = resourceEntry.loadedClass;
        if (clazz != null) {
            return clazz;
        }
        Object object = this.getClassLoadingLockInternal(string);
        synchronized (object) {
            void var8_13;
            Package package_;
            String string3;
            clazz = resourceEntry.loadedClass;
            if (clazz != null) {
                return clazz;
            }
            if (resourceEntry.binaryContent == null) {
                throw new ClassNotFoundException(string);
            }
            if (this.transformers.size() > 0) {
                string3 = string2.substring(1, string2.length() - CLASS_FILE_SUFFIX.length());
                for (ClassFileTransformer object22 : this.transformers) {
                    try {
                        byte[] unsupportedClassVersionError = object22.transform(this, string3, null, null, resourceEntry.binaryContent);
                        if (unsupportedClassVersionError == null) continue;
                        resourceEntry.binaryContent = unsupportedClassVersionError;
                    }
                    catch (IllegalClassFormatException illegalClassFormatException) {
                        log.error((Object)sm.getString("webappClassLoader.transformError", new Object[]{string}), (Throwable)illegalClassFormatException);
                        return null;
                    }
                }
            }
            string3 = null;
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string3 = string.substring(0, n);
            }
            Object var8_10 = null;
            if (string3 != null && (package_ = this.getPackage(string3)) == null) {
                try {
                    if (resourceEntry.manifest == null) {
                        this.definePackage(string3, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(string3, resourceEntry.manifest, resourceEntry.codeBase);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                Package package_2 = this.getPackage(string3);
            }
            if (this.securityManager != null && var8_13 != null) {
                boolean bl = true;
                if (var8_13.isSealed()) {
                    bl = var8_13.isSealed(resourceEntry.codeBase);
                } else {
                    boolean bl2 = bl = resourceEntry.manifest == null || !this.isPackageSealed(string3, resourceEntry.manifest);
                }
                if (!bl) {
                    throw new SecurityException("Sealing violation loading " + string + " : Package " + string3 + " is sealed.");
                }
            }
            try {
                clazz = this.defineClass(string, resourceEntry.binaryContent, 0, resourceEntry.binaryContent.length, new CodeSource(resourceEntry.codeBase, resourceEntry.certificates));
            }
            catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                throw new UnsupportedClassVersionError(unsupportedClassVersionError.getLocalizedMessage() + " " + sm.getString("webappClassLoader.wrongVersion", new Object[]{string}));
            }
            resourceEntry.loadedClass = clazz;
            resourceEntry.binaryContent = null;
            resourceEntry.codeBase = null;
            resourceEntry.manifest = null;
            resourceEntry.certificates = null;
        }
        return clazz;
    }

    protected ResourceEntry findResourceInternal(File file, String string) {
        ResourceEntry resourceEntry = new ResourceEntry();
        try {
            resourceEntry.source = this.getURI(new File(file, string));
            String string2 = resourceEntry.source.toString();
            resourceEntry.codeBase = string2.startsWith(this.webInfClassesCodeBase.toString()) && string2.endsWith(CLASS_FILE_SUFFIX) ? this.webInfClassesCodeBase : resourceEntry.source;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return resourceEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResourceEntry findResourceInternal(String string, String string2, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        Object object5;
        Object object6;
        int n;
        if (!this.started) {
            log.info((Object)sm.getString("webappClassLoader.stopped", new Object[]{string}));
            return null;
        }
        if (string == null) return null;
        if (string2 == null) {
            return null;
        }
        JarEntry jarEntry = null;
        String string3 = string2.substring(1);
        Object object7 = this.resourceEntries.get(string2);
        if (object7 != null) {
            if (!bl) return object7;
            if (((ResourceEntry)object7).manifest != MANIFEST_UNKNOWN) return object7;
            JarFile[] jarFileArray = this.jarFiles;
            synchronized (this.jarFiles) {
                if (!this.openJARs()) return object7;
                int n2 = 0;
                while (n2 < this.jarFiles.length) {
                    jarEntry = this.jarFiles[n2].getJarEntry(string3);
                    if (jarEntry != null) {
                        try {
                            ((ResourceEntry)object7).manifest = this.jarFiles[n2].getManifest();
                        }
                        catch (IOException iOException) {}
                        return object7;
                    }
                    ++n2;
                }
                return object7;
            }
        }
        int n3 = -1;
        InputStream inputStream = null;
        boolean bl2 = string2.endsWith(CLASS_FILE_SUFFIX);
        boolean bl3 = bl2;
        if (!bl3) {
            bl3 = string2.startsWith(SERVICES_PREFIX);
        }
        int n4 = this.jarFiles.length;
        int n5 = this.repositories.length;
        Resource resource = null;
        boolean bl4 = false;
        for (n = 0; object7 == null && n < n5; ++n) {
            try {
                object6 = this.repositories[n] + string2;
                object5 = this.resources.lookup((String)object6);
                if (object5 instanceof Resource) {
                    resource = (Resource)object5;
                }
                serializable = (ResourceAttributes)this.resources.getAttributes((String)object6);
                n3 = (int)((ResourceAttributes)serializable).getContentLength();
                object4 = ((ResourceAttributes)serializable).getCanonicalPath();
                object7 = object4 != null ? this.findResourceInternal(new File((String)object4), "") : this.findResourceInternal(this.files[n], string2);
                ((ResourceEntry)object7).lastModified = ((ResourceAttributes)serializable).getLastModified();
                if (resource == null) continue;
                try {
                    inputStream = resource.streamContent();
                }
                catch (IOException iOException) {
                    return null;
                }
                if (this.needConvert && string2.endsWith(".properties")) {
                    bl4 = true;
                }
                object3 = this.allPermission;
                synchronized (object3) {
                    int n6;
                    object2 = new long[this.lastModifiedDates.length + 1];
                    for (n6 = 0; n6 < this.lastModifiedDates.length; ++n6) {
                        object2[n6] = this.lastModifiedDates[n6];
                    }
                    object2[this.lastModifiedDates.length] = ((ResourceEntry)object7).lastModified;
                    this.lastModifiedDates = object2;
                    object = new String[this.paths.length + 1];
                    for (n6 = 0; n6 < this.paths.length; ++n6) {
                        object[n6] = this.paths[n6];
                    }
                    object[this.paths.length] = object6;
                    this.paths = object;
                    continue;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (object7 == null && this.notFoundResources.containsKey(string)) {
            return null;
        }
        object6 = this.jarFiles;
        synchronized (this.jarFiles) {
            block93: {
                try {
                    int n7;
                    if (!this.openJARs()) {
                        object5 = null;
                        // ** MonitorExit[var16_19 /* !! */ ] (shouldn't be in output)
                        return object5;
                    }
                    n = 0;
                    while (true) {
                        block95: {
                            block96: {
                                block94: {
                                    if (object7 != null || n >= n4) break block94;
                                    jarEntry = this.jarFiles[n].getJarEntry(string3);
                                    if (jarEntry == null) break block95;
                                    object7 = new ResourceEntry();
                                    try {
                                        ((ResourceEntry)object7).codeBase = this.getURI(this.jarRealFiles[n]);
                                        ((ResourceEntry)object7).source = UriUtil.buildJarUrl((String)((ResourceEntry)object7).codeBase.toString(), (String)string3);
                                        ((ResourceEntry)object7).lastModified = this.jarRealFiles[n].lastModified();
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        serializable = null;
                                        if (inputStream == null) return serializable;
                                        try {
                                            inputStream.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                        return serializable;
                                    }
                                    n3 = (int)jarEntry.getSize();
                                    try {
                                        ((ResourceEntry)object7).manifest = bl ? this.jarFiles[n].getManifest() : MANIFEST_UNKNOWN;
                                        inputStream = this.jarFiles[n].getInputStream(jarEntry);
                                    }
                                    catch (IOException iOException) {
                                        serializable = null;
                                        if (inputStream == null) return serializable;
                                        try {
                                            inputStream.close();
                                        }
                                        catch (IOException iOException2) {
                                            // empty catch block
                                        }
                                        return serializable;
                                    }
                                    if (!this.antiJARLocking || string2.endsWith(CLASS_FILE_SUFFIX)) break block95;
                                    object5 = new byte[1024];
                                    serializable = new File(this.loaderDir, jarEntry.getName());
                                    if (((File)serializable).exists()) break block95;
                                    object4 = this.jarFiles[n].entries();
                                    break block96;
                                }
                                if (object7 == null) {
                                    object5 = this.notFoundResources;
                                    synchronized (object5) {
                                        this.notFoundResources.put(string, string);
                                    }
                                    object5 = null;
                                    // ** MonitorExit[var16_19 /* !! */ ] (shouldn't be in output)
                                    return object5;
                                }
                                if (inputStream == null || !bl3 && !bl4) break block93;
                                object5 = new byte[n3];
                                n7 = 0;
                                try {
                                    int n8;
                                    while ((n8 = inputStream.read((byte[])object5, n7, ((Object)object5).length - n7)) > 0) {
                                        n7 += n8;
                                    }
                                    break;
                                }
                                catch (IOException iOException) {
                                    log.error((Object)sm.getString("webappClassLoader.readError", new Object[]{string}), (Throwable)iOException);
                                    object3 = null;
                                    if (inputStream == null) return object3;
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException iOException3) {
                                        // empty catch block
                                    }
                                    return object3;
                                }
                            }
                            block74: while (object4.hasMoreElements()) {
                                object3 = (JarEntry)object4.nextElement();
                                if (((ZipEntry)object3).isDirectory() || ((ZipEntry)object3).getName().endsWith(CLASS_FILE_SUFFIX)) continue;
                                serializable = new File(this.loaderDir, ((ZipEntry)object3).getName());
                                try {
                                    if (!((File)serializable).getCanonicalPath().startsWith(this.canonicalLoaderDir)) {
                                        throw new IllegalArgumentException(sm.getString("webappClassLoader.illegalJarPath", new Object[]{((ZipEntry)object3).getName()}));
                                    }
                                }
                                catch (IOException iOException) {
                                    throw new IllegalArgumentException(sm.getString("webappClassLoader.validationErrorJarPath", new Object[]{((ZipEntry)object3).getName()}), iOException);
                                }
                                File file = ((File)serializable).getParentFile();
                                if (file.mkdirs() || !file.exists()) {
                                    // empty if block
                                }
                                object2 = null;
                                object = null;
                                try {
                                    object = this.jarFiles[n].getInputStream((ZipEntry)object3);
                                    object2 = new FileOutputStream((File)serializable);
                                    while (true) {
                                        int n9;
                                        if ((n9 = ((InputStream)object).read((byte[])object5)) <= 0) {
                                            ((File)serializable).setLastModified(((ZipEntry)object3).getTime());
                                            continue block74;
                                        }
                                        ((FileOutputStream)object2).write((byte[])object5, 0, n9);
                                    }
                                }
                                catch (IOException iOException) {}
                                continue;
                                finally {
                                    try {
                                        if (object != null) {
                                            ((InputStream)object).close();
                                        }
                                    }
                                    catch (IOException iOException) {}
                                    try {
                                        if (object2 == null) continue;
                                        ((FileOutputStream)object2).close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        ++n;
                    }
                    if (bl4) {
                        String string4 = new String((byte[])object5, 0, n7);
                        try {
                            object5 = string4.getBytes(CHARSET_UTF8);
                        }
                        catch (Exception exception) {
                            ResourceEntry resourceEntry = null;
                            if (inputStream == null) return resourceEntry;
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return resourceEntry;
                        }
                    }
                    ((ResourceEntry)object7).binaryContent = (byte[])object5;
                    if (jarEntry != null) {
                        ((ResourceEntry)object7).certificates = jarEntry.getCertificates();
                    }
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            // ** MonitorExit[var16_19 /* !! */ ] (shouldn't be in output)
            object6 = this.resourceEntries;
            synchronized (object6) {
                object5 = this.resourceEntries.get(string2);
                if (object5 != null) return object5;
                this.resourceEntries.put(string2, (ResourceEntry)object7);
                return object7;
            }
        }
    }

    private String binaryNameToPath(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(7 + string.length());
        if (bl) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string.replace('.', '/'));
        stringBuilder.append(CLASS_FILE_SUFFIX);
        return stringBuilder.toString();
    }

    private String nameToPath(String string) {
        if (string.startsWith("/")) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(1 + string.length());
        stringBuilder.append('/');
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    protected boolean isPackageSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/') + '/';
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    protected InputStream findLoadedResource(String string) {
        String string2 = this.nameToPath(string);
        ResourceEntry resourceEntry = this.resourceEntries.get(string2);
        if (resourceEntry != null) {
            if (resourceEntry.binaryContent != null) {
                return new ByteArrayInputStream(resourceEntry.binaryContent);
            }
            try {
                return resourceEntry.source.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Class<?> findLoadedClass0(String string) {
        String string2 = this.binaryNameToPath(string, true);
        ResourceEntry resourceEntry = this.resourceEntries.get(string2);
        if (resourceEntry != null) {
            return resourceEntry.loadedClass;
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected boolean filter(String string) {
        if (string == null) {
            return false;
        }
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        string2 = string.substring(0, n);
        for (int i = 0; i < packageTriggers.length; ++i) {
            if (!string2.startsWith(packageTriggers[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean validate(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("java.")) {
            return false;
        }
        if (string.startsWith("javax.servlet.jsp.jstl")) {
            return true;
        }
        if (string.startsWith("javax.servlet.")) {
            return false;
        }
        return !string.startsWith("javax.el");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateJarFile(File file) throws IOException {
        if (triggers == null) {
            return true;
        }
        JarFile jarFile = null;
        try {
            int n;
            jarFile = JreCompat.getInstance().jarFileNewInstance(file);
            for (n = 0; n < triggers.length; ++n) {
                JarEntry jarEntry;
                Class<?> clazz = null;
                try {
                    clazz = this.parent != null ? this.parent.loadClass(triggers[n]) : Class.forName(triggers[n]);
                }
                catch (Exception exception) {
                    clazz = null;
                }
                if (clazz == null) continue;
                String string = triggers[n].replace('.', '/') + CLASS_FILE_SUFFIX;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Checking for " + string));
                }
                if ((jarEntry = jarFile.getJarEntry(string)) == null) continue;
                log.info((Object)("validateJarFile(" + file + ") - jar not loaded. See Servlet Spec 3.0, section 10.7.2. Offending class: " + string));
                boolean bl = false;
                return bl;
            }
            n = 1;
            return n != 0;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Deprecated
    protected URL getURL(File file, boolean bl) throws MalformedURLException {
        File file2 = file;
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            return this.getURI(file2);
        }
        return file2.toURI().toURL();
    }

    protected URL getURI(File file) throws MalformedURLException {
        File file2 = file;
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file2.toURI().toURL();
    }

    protected static void deleteDir(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                WebappClassLoaderBase.deleteDir(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    static {
        sm = StringManager.getManager((String)"org.apache.catalina.loader");
        Method method = null;
        try {
            if (JreCompat.isJre7Available()) {
                final Method method2 = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        method2.setAccessible(true);
                        return null;
                    }
                });
                method2.invoke(null, new Object[0]);
                method = ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GET_CLASSLOADING_LOCK_METHOD = method;
        JVM_THREAD_GROUP_NAMES.add(JVM_THREAD_GROUP_SYSTEM);
        JVM_THREAD_GROUP_NAMES.add("RMI Runtime");
        triggers = new String[]{"javax.servlet.Servlet", "javax.el.Expression"};
        packageTriggers = new String[0];
    }

    private static class CombinedEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL>[] sources;
        private int index = 0;

        public CombinedEnumeration(Enumeration<URL> enumeration, Enumeration<URL> enumeration2) {
            Enumeration[] enumerationArray = new Enumeration[]{enumeration, enumeration2};
            this.sources = enumerationArray;
        }

        @Override
        public boolean hasMoreElements() {
            return this.inc();
        }

        @Override
        public URL nextElement() {
            if (this.inc()) {
                return this.sources[this.index].nextElement();
            }
            throw new NoSuchElementException();
        }

        private boolean inc() {
            while (this.index < this.sources.length) {
                if (this.sources[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }
    }

    protected static final class PrivilegedGetClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> clazz;

        public PrivilegedGetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            return this.clazz.getClassLoader();
        }
    }

    protected class PrivilegedFindResourceByName
    implements PrivilegedAction<ResourceEntry> {
        private final String name;
        private final String path;
        private final boolean manifestRequired;

        PrivilegedFindResourceByName(String string, String string2, boolean bl) {
            this.name = string;
            this.path = string2;
            this.manifestRequired = bl;
        }

        @Override
        public ResourceEntry run() {
            return WebappClassLoaderBase.this.findResourceInternal(this.name, this.path, this.manifestRequired);
        }
    }
}

