/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.JrePlatform;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.tomcat.util.http.RequestUtil;

public class FileDirContext
extends BaseDirContext {
    private static final Log log = LogFactory.getLog(FileDirContext.class);
    protected static final int BUFFER_SIZE = 2048;
    protected File base = null;
    protected String absoluteBase = null;
    private String canonicalBase = null;
    protected boolean allowLinking = false;

    public FileDirContext() {
    }

    public FileDirContext(Hashtable<String, Object> hashtable) {
        super(hashtable);
    }

    @Override
    public void setDocBase(String string) {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("resources.null"));
        }
        this.base = new File(string);
        try {
            this.base = this.base.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(this.base.exists() && this.base.isDirectory() && this.base.canRead())) {
            throw new IllegalArgumentException(sm.getString("fileResources.base", string));
        }
        this.absoluteBase = this.normalize(this.base.getAbsolutePath());
        try {
            this.canonicalBase = this.base.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        super.setDocBase(string);
    }

    public void setAllowLinking(boolean bl) {
        this.allowLinking = bl;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    @Override
    public void release() {
        super.release();
    }

    @Override
    protected String doGetRealPath(String string) {
        File file = new File(this.getDocBase(), string);
        return file.getAbsolutePath();
    }

    @Override
    protected Object doLookup(String string) {
        Object object = null;
        File file = this.file(string, true);
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            FileDirContext fileDirContext = new FileDirContext(this.env);
            fileDirContext.setDocBase(file.getPath());
            fileDirContext.setAllowLinking(this.getAllowLinking());
            object = fileDirContext;
        } else {
            object = new FileResource(file);
        }
        return object;
    }

    @Override
    public void unbind(String string) throws NamingException {
        File file = this.file(string, true);
        if (file == null) {
            throw new NameNotFoundException(sm.getString("resources.notFound", string));
        }
        if (!file.delete()) {
            throw new NamingException(sm.getString("resources.unbindFailed", string));
        }
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        File file = this.file(string, true);
        if (file == null) {
            throw new NameNotFoundException(sm.getString("resources.notFound", string));
        }
        File file2 = this.file(string2, false);
        if (file2 == null) {
            throw new NamingException(sm.getString("resources.renameFail", string, string2));
        }
        if (!file.renameTo(file2)) {
            throw new NamingException(sm.getString("resources.renameFail", string, string2));
        }
    }

    @Override
    protected List<NamingEntry> doListBindings(String string) throws NamingException {
        File file = this.file(string, true);
        if (file == null) {
            return null;
        }
        return this.list(file);
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.unbind(string);
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    @Override
    protected Attributes doGetAttributes(String string, String[] stringArray) throws NamingException {
        File file = this.file(string, true);
        if (file == null) {
            return null;
        }
        return new FileResourceAttributes(file);
    }

    @Override
    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        if (string.endsWith("/")) {
            throw new NamingException(sm.getString("resources.bindFailed", string));
        }
        File file = this.file(string, false);
        if (file == null) {
            throw new NamingException(sm.getString("resources.bindFailed", string));
        }
        if (file.exists()) {
            throw new NameAlreadyBoundException(sm.getString("resources.alreadyBound", string));
        }
        this.rebind(string, object, attributes);
    }

    @Override
    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        File file = this.file(string, false);
        if (file == null) {
            throw new NamingException(sm.getString("resources.bindFailed", string));
        }
        InputStream inputStream = null;
        if (object instanceof Resource) {
            try {
                inputStream = ((Resource)object).streamContent();
            }
            catch (IOException iOException) {}
        } else if (object instanceof InputStream) {
            inputStream = (InputStream)object;
        } else if (object instanceof DirContext) {
            if (file.exists() && !file.delete()) {
                throw new NamingException(sm.getString("resources.bindFailed", string));
            }
            if (!file.mkdir()) {
                throw new NamingException(sm.getString("resources.bindFailed", string));
            }
        }
        if (inputStream == null) {
            throw new NamingException(sm.getString("resources.bindFailed", string));
        }
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[2048];
        int n = -1;
        try {
            fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException(sm.getString("resources.bindFailed", iOException));
            namingException.initCause(iOException);
            throw namingException;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        File file = this.file(string, false);
        if (file == null) {
            throw new NamingException(sm.getString("resources.bindFailed", string));
        }
        if (file.exists()) {
            throw new NameAlreadyBoundException(sm.getString("resources.alreadyBound", string));
        }
        if (!file.mkdir()) {
            throw new NamingException(sm.getString("resources.bindFailed", string));
        }
        return (DirContext)this.lookup(string);
    }

    @Override
    public DirContext getSchema(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, SearchControls searchControls) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return null;
    }

    protected String normalize(String string) {
        return RequestUtil.normalize((String)string, (File.separatorChar == '\\' ? 1 : 0) != 0);
    }

    protected File file(String string) {
        return this.file(string, true);
    }

    protected File file(String string, boolean bl) {
        if (string.equals("/")) {
            string = "";
        }
        File file = new File(this.base, string);
        return this.validate(file, string, bl, this.absoluteBase, this.canonicalBase);
    }

    protected File validate(File file, String string, boolean bl, String string2, String string3) {
        if (string.endsWith("/") && file.isFile()) {
            return null;
        }
        if (bl && !file.canRead()) {
            return null;
        }
        if (this.allowLinking) {
            return file;
        }
        if (JrePlatform.IS_WINDOWS && this.isInvalidWindowsFilename(string)) {
            return null;
        }
        String string4 = null;
        try {
            string4 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string4 == null || !string4.startsWith(string3)) {
            return null;
        }
        String string5 = this.normalize(file.getAbsolutePath());
        if (string2.length() > string5.length()) {
            return null;
        }
        string5 = string5.substring(string2.length());
        if ((string4 = string4.substring(string3.length())).length() > 0) {
            string4 = this.normalize(string4);
        }
        if (!string4.equals(string5)) {
            return null;
        }
        return file;
    }

    private boolean isInvalidWindowsFilename(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\"' && c != '<' && c != '>') continue;
            return true;
        }
        return string.charAt(n - 1) == ' ';
    }

    protected List<NamingEntry> list(File file) {
        ArrayList<NamingEntry> arrayList = new ArrayList<NamingEntry>();
        if (!file.isDirectory()) {
            return arrayList;
        }
        Object[] objectArray = file.list();
        if (objectArray == null) {
            log.warn((Object)sm.getString("fileResources.listingNull", file.getAbsolutePath()));
            return arrayList;
        }
        Arrays.sort(objectArray);
        NamingEntry namingEntry = null;
        for (int i = 0; i < objectArray.length; ++i) {
            File file2 = new File(file, (String)objectArray[i]);
            Object object = null;
            if (file2.isDirectory()) {
                FileDirContext fileDirContext = new FileDirContext(this.env);
                fileDirContext.setDocBase(file2.getPath());
                fileDirContext.setAllowLinking(this.getAllowLinking());
                object = fileDirContext;
            } else {
                object = new FileResource(file2);
            }
            namingEntry = new NamingEntry((String)objectArray[i], object, 0);
            arrayList.add(namingEntry);
        }
        return arrayList;
    }

    protected static class FileResourceAttributes
    extends ResourceAttributes {
        private static final long serialVersionUID = 1L;
        protected File file;
        protected boolean accessed = false;
        protected String canonicalPath = null;

        public FileResourceAttributes(File file) {
            this.file = file;
            this.getCreation();
            this.getLastModified();
        }

        @Override
        public boolean isCollection() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.isCollection();
        }

        @Override
        public long getContentLength() {
            if (this.contentLength != -1L) {
                return this.contentLength;
            }
            this.contentLength = this.file.length();
            return this.contentLength;
        }

        @Override
        public long getCreation() {
            if (this.creation != -1L) {
                return this.creation;
            }
            this.creation = this.getLastModified();
            return this.creation;
        }

        @Override
        public Date getCreationDate() {
            if (this.creation == -1L) {
                this.creation = this.getCreation();
            }
            return super.getCreationDate();
        }

        @Override
        public long getLastModified() {
            if (this.lastModified != -1L) {
                return this.lastModified;
            }
            this.lastModified = this.file.lastModified();
            return this.lastModified;
        }

        @Override
        public Date getLastModifiedDate() {
            if (this.lastModified == -1L) {
                this.lastModified = this.getLastModified();
            }
            return super.getLastModifiedDate();
        }

        @Override
        public String getName() {
            if (this.name == null) {
                this.name = this.file.getName();
            }
            return this.name;
        }

        @Override
        public String getResourceType() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.getResourceType();
        }

        @Override
        public String getCanonicalPath() {
            if (this.canonicalPath == null) {
                try {
                    this.canonicalPath = this.file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.canonicalPath;
        }
    }

    protected static class FileResource
    extends Resource {
        protected File file;

        public FileResource(File file) {
            this.file = file;
        }

        @Override
        public InputStream streamContent() throws IOException {
            if (this.binaryContent == null) {
                FileInputStream fileInputStream = new FileInputStream(this.file);
                this.inputStream = fileInputStream;
                return fileInputStream;
            }
            return super.streamContent();
        }
    }
}

