/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.AsyncStateMachine;
import org.apache.coyote.ErrorState;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.parser.Host;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractProcessor<S>
implements ActionHook,
Processor<S> {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote");
    protected char[] hostNameC = new char[0];
    protected Adapter adapter;
    protected AsyncStateMachine<S> asyncStateMachine;
    protected AbstractEndpoint<S> endpoint;
    protected Request request;
    protected Response response;
    protected SocketWrapper<S> socketWrapper = null;
    private int maxCookieCount = 200;
    private ErrorState errorState = ErrorState.NONE;
    protected final UserDataHelper userDataHelper;

    protected AbstractProcessor() {
        this.userDataHelper = null;
    }

    public AbstractProcessor(AbstractEndpoint<S> abstractEndpoint) {
        this.endpoint = abstractEndpoint;
        this.asyncStateMachine = new AsyncStateMachine(this);
        this.request = new Request();
        this.response = new Response();
        this.response.setHook(this);
        this.request.setResponse(this.response);
        this.userDataHelper = new UserDataHelper(this.getLog());
    }

    protected void setErrorState(ErrorState errorState, Throwable throwable) {
        boolean bl = this.response.setError();
        boolean bl2 = this.errorState.isIoAllowed() && !errorState.isIoAllowed();
        this.errorState = this.errorState.getMostSevere(errorState);
        if (this.response.getStatus() < 400 && !(throwable instanceof IOException)) {
            this.response.setStatus(500);
        }
        if (throwable != null) {
            this.request.setAttribute("javax.servlet.error.exception", throwable);
        }
        if (bl2 && this.isAsync() && bl && this.asyncStateMachine.asyncError()) {
            this.getEndpoint().processSocketAsync(this.socketWrapper, SocketStatus.ERROR);
        }
    }

    protected void resetErrorState() {
        this.errorState = ErrorState.NONE;
    }

    protected ErrorState getErrorState() {
        return this.errorState;
    }

    protected AbstractEndpoint<S> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected final void setSocketWrapper(SocketWrapper<S> socketWrapper) {
        this.socketWrapper = socketWrapper;
    }

    protected final SocketWrapper<S> getSocketWrapper() {
        return this.socketWrapper;
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    @Override
    public boolean isAsync() {
        return this.asyncStateMachine != null && this.asyncStateMachine.isAsync();
    }

    @Override
    public AbstractEndpoint.Handler.SocketState asyncPostProcess() {
        return this.asyncStateMachine.asyncPostProcess();
    }

    @Override
    public void errorDispatch() {
        this.getAdapter().errorDispatch(this.request, this.response);
    }

    @Override
    public abstract boolean isComet();

    protected void parseHost(MessageBytes messageBytes) {
        if (messageBytes == null || messageBytes.isNull()) {
            this.populateHost();
            this.populatePort();
            return;
        }
        if (messageBytes.getLength() == 0) {
            this.request.serverName().setString("");
            this.populatePort();
            return;
        }
        ByteChunk byteChunk = messageBytes.getByteChunk();
        byte[] byArray = byteChunk.getBytes();
        int n = byteChunk.getLength();
        int n2 = byteChunk.getStart();
        if (this.hostNameC.length < n) {
            this.hostNameC = new char[n];
        }
        try {
            int n3;
            int n4 = Host.parse(messageBytes);
            if (n4 != -1) {
                n3 = 0;
                for (int i = n4 + 1; i < n; ++i) {
                    char c = (char)byArray[i + n2];
                    if (c < '0' || c > '9') {
                        this.response.setStatus(400);
                        this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                        return;
                    }
                    n3 = n3 * 10 + c - 48;
                }
                this.request.setServerPort(n3);
                n = n4;
            }
            for (n3 = 0; n3 < n; ++n3) {
                this.hostNameC[n3] = (char)byArray[n3 + n2];
            }
            this.request.serverName().setChars(this.hostNameC, 0, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            UserDataHelper.Mode mode = this.userDataHelper.getNextMode();
            if (mode != null) {
                String string = sm.getString("abstractProcessor.hostInvalid", new Object[]{messageBytes.toString()});
                switch (mode) {
                    case INFO_THEN_DEBUG: {
                        string = string + sm.getString("abstractProcessor.fallToDebug");
                    }
                    case INFO: {
                        this.getLog().info((Object)string, (Throwable)illegalArgumentException);
                        break;
                    }
                    case DEBUG: {
                        this.getLog().debug((Object)string, (Throwable)illegalArgumentException);
                    }
                }
            }
            this.response.setStatus(400);
            this.setErrorState(ErrorState.CLOSE_CLEAN, illegalArgumentException);
        }
    }

    protected void populateHost() {
    }

    protected void populatePort() {
    }

    @Override
    public abstract boolean isUpgrade();

    @Override
    public abstract AbstractEndpoint.Handler.SocketState process(SocketWrapper<S> var1) throws IOException;

    @Override
    public abstract AbstractEndpoint.Handler.SocketState event(SocketStatus var1) throws IOException;

    @Override
    public abstract AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus var1);

    @Override
    public abstract AbstractEndpoint.Handler.SocketState upgradeDispatch() throws IOException;

    public int getMaxCookieCount() {
        return this.maxCookieCount;
    }

    public void setMaxCookieCount(int n) {
        this.maxCookieCount = n;
    }

    @Override
    @Deprecated
    public abstract UpgradeInbound getUpgradeInbound();

    protected abstract Log getLog();

    @Override
    public final AsyncStateMachine<S> getAsyncStateMachine() {
        return this.asyncStateMachine;
    }
}

