/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.http.WebConnection;
import org.apache.coyote.Adapter;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.Processor;
import org.apache.coyote.ProtocolException;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractProtocol<S>
implements ProtocolHandler,
MBeanRegistration {
    private static final StringManager sm = StringManager.getManager(AbstractProtocol.class);
    private static final AtomicInteger nameCounter = new AtomicInteger(0);
    private int nameIndex = 0;
    private final AbstractEndpoint<S, ?> endpoint;
    private AbstractEndpoint.Handler<S> handler;
    private final Set<Processor> waitingProcessors = Collections.newSetFromMap(new ConcurrentHashMap());
    private ScheduledFuture<?> timeoutFuture = null;
    private ScheduledFuture<?> monitorFuture;
    protected ObjectName rgOname = null;
    protected Adapter adapter;
    protected int processorCache = 200;
    private String clientCertProvider = null;
    private int maxHeaderCount = 100;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public AbstractProtocol(AbstractEndpoint<S, ?> abstractEndpoint) {
        this.endpoint = abstractEndpoint;
        this.setConnectionLinger(-1);
        this.setTcpNoDelay(true);
    }

    public boolean setProperty(String string, String string2) {
        return this.endpoint.setProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.endpoint.getProperty(string);
    }

    public ObjectName getGlobalRequestProcessorMBeanName() {
        return this.rgOname;
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int n) {
        this.processorCache = n;
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String string) {
        this.clientCertProvider = string;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public void setMaxHeaderCount(int n) {
        this.maxHeaderCount = n;
    }

    @Override
    public boolean isAprRequired() {
        return false;
    }

    @Override
    public boolean isSendfileSupported() {
        return this.endpoint.getUseSendfile();
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    @Override
    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    @Override
    public ScheduledExecutorService getUtilityExecutor() {
        return this.endpoint.getUtilityExecutor();
    }

    @Override
    public void setUtilityExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.endpoint.setUtilityExecutor(scheduledExecutorService);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int n) {
        this.endpoint.setMaxThreads(n);
    }

    public int getMaxConnections() {
        return this.endpoint.getMaxConnections();
    }

    public void setMaxConnections(int n) {
        this.endpoint.setMaxConnections(n);
    }

    public int getMinSpareThreads() {
        return this.endpoint.getMinSpareThreads();
    }

    public void setMinSpareThreads(int n) {
        this.endpoint.setMinSpareThreads(n);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int n) {
        this.endpoint.setThreadPriority(n);
    }

    public int getAcceptCount() {
        return this.endpoint.getAcceptCount();
    }

    public void setAcceptCount(int n) {
        this.endpoint.setAcceptCount(n);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean bl) {
        this.endpoint.setTcpNoDelay(bl);
    }

    public int getConnectionLinger() {
        return this.endpoint.getConnectionLinger();
    }

    public void setConnectionLinger(int n) {
        this.endpoint.setConnectionLinger(n);
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int n) {
        this.endpoint.setKeepAliveTimeout(n);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress inetAddress) {
        this.endpoint.setAddress(inetAddress);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int n) {
        this.endpoint.setPort(n);
    }

    public int getPortOffset() {
        return this.endpoint.getPortOffset();
    }

    public void setPortOffset(int n) {
        this.endpoint.setPortOffset(n);
    }

    public int getPortWithOffset() {
        return this.endpoint.getPortWithOffset();
    }

    public int getLocalPort() {
        return this.endpoint.getLocalPort();
    }

    public int getConnectionTimeout() {
        return this.endpoint.getConnectionTimeout();
    }

    public void setConnectionTimeout(int n) {
        this.endpoint.setConnectionTimeout(n);
    }

    public long getConnectionCount() {
        return this.endpoint.getConnectionCount();
    }

    @Deprecated
    public void setAcceptorThreadCount(int n) {
    }

    @Deprecated
    public int getAcceptorThreadCount() {
        return 1;
    }

    public void setAcceptorThreadPriority(int n) {
        this.endpoint.setAcceptorThreadPriority(n);
    }

    public int getAcceptorThreadPriority() {
        return this.endpoint.getAcceptorThreadPriority();
    }

    public synchronized int getNameIndex() {
        if (this.nameIndex == 0) {
            this.nameIndex = nameCounter.incrementAndGet();
        }
        return this.nameIndex;
    }

    public String getName() {
        return ObjectName.quote(this.getNameInternal());
    }

    private String getNameInternal() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(this.getNamePrefix());
        stringBuilder.append('-');
        if (this.getAddress() != null) {
            stringBuilder.append(this.getAddress().getHostAddress());
            stringBuilder.append('-');
        }
        if ((n = this.getPortWithOffset()) == 0) {
            stringBuilder.append("auto-");
            stringBuilder.append(this.getNameIndex());
            n = this.getLocalPort();
            if (n != -1) {
                stringBuilder.append('-');
                stringBuilder.append(n);
            }
        } else {
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    public void addWaitingProcessor(Processor processor) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)sm.getString("abstractProtocol.waitingProcessor.add", new Object[]{processor}));
        }
        this.waitingProcessors.add(processor);
    }

    public void removeWaitingProcessor(Processor processor) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)sm.getString("abstractProtocol.waitingProcessor.remove", new Object[]{processor}));
        }
        this.waitingProcessors.remove(processor);
    }

    public int getWaitingProcessorCount() {
        return this.waitingProcessors.size();
    }

    protected AbstractEndpoint<S, ?> getEndpoint() {
        return this.endpoint;
    }

    protected AbstractEndpoint.Handler<S> getHandler() {
        return this.handler;
    }

    protected void setHandler(AbstractEndpoint.Handler<S> handler) {
        this.handler = handler;
    }

    protected abstract Log getLog();

    protected abstract String getNamePrefix();

    protected abstract String getProtocolName();

    protected abstract UpgradeProtocol getNegotiatedProtocol(String var1);

    protected abstract UpgradeProtocol getUpgradeProtocol(String var1);

    protected abstract Processor createProcessor();

    protected abstract Processor createUpgradeProcessor(SocketWrapperBase<?> var1, UpgradeToken var2);

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.oname = objectName;
        this.mserver = mBeanServer;
        this.domain = objectName.getDomain();
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    private ObjectName createObjectName() throws MalformedObjectNameException {
        this.domain = this.getAdapter().getDomain();
        if (this.domain == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.getDomain());
        stringBuilder.append(":type=ProtocolHandler,port=");
        int n = this.getPortWithOffset();
        if (n > 0) {
            stringBuilder.append(n);
        } else {
            stringBuilder.append("auto-");
            stringBuilder.append(this.getNameIndex());
        }
        InetAddress inetAddress = this.getAddress();
        if (inetAddress != null) {
            stringBuilder.append(",address=");
            stringBuilder.append(ObjectName.quote(inetAddress.getHostAddress()));
        }
        return new ObjectName(stringBuilder.toString());
    }

    @Override
    public void init() throws Exception {
        Object object;
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.init", new Object[]{this.getName()}));
            this.logPortOffset();
        }
        if (this.oname == null) {
            this.oname = this.createObjectName();
            if (this.oname != null) {
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
        }
        if (this.domain != null) {
            this.rgOname = object = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent(this.getHandler().getGlobal(), (ObjectName)object, null);
        }
        object = this.getName();
        this.endpoint.setName(((String)object).substring(1, ((String)object).length() - 1));
        this.endpoint.setDomain(this.domain);
        this.endpoint.init();
    }

    @Override
    public void start() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.start", new Object[]{this.getName()}));
            this.logPortOffset();
        }
        this.endpoint.start();
        this.monitorFuture = this.getUtilityExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (!AbstractProtocol.this.isPaused()) {
                    AbstractProtocol.this.startAsyncTimeout();
                }
            }
        }, 0L, 60L, TimeUnit.SECONDS);
    }

    protected void startAsyncTimeout() {
        if (this.timeoutFuture == null || this.timeoutFuture != null && this.timeoutFuture.isDone()) {
            if (this.timeoutFuture != null && this.timeoutFuture.isDone()) {
                try {
                    this.timeoutFuture.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    this.getLog().error((Object)sm.getString("abstractProtocolHandler.asyncTimeoutError"), (Throwable)exception);
                }
            }
            this.timeoutFuture = this.getUtilityExecutor().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    long l = System.currentTimeMillis();
                    for (Processor processor : AbstractProtocol.this.waitingProcessors) {
                        processor.timeoutAsync(l);
                    }
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    protected void stopAsyncTimeout() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
        }
    }

    @Override
    public void pause() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.pause", new Object[]{this.getName()}));
        }
        this.stopAsyncTimeout();
        this.endpoint.pause();
    }

    public boolean isPaused() {
        return this.endpoint.isPaused();
    }

    @Override
    public void resume() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.resume", new Object[]{this.getName()}));
        }
        this.endpoint.resume();
        this.startAsyncTimeout();
    }

    @Override
    public void stop() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.stop", new Object[]{this.getName()}));
            this.logPortOffset();
        }
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
            this.monitorFuture = null;
        }
        this.stopAsyncTimeout();
        for (Processor processor : this.waitingProcessors) {
            processor.timeoutAsync(-1L);
        }
        this.endpoint.stop();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws Exception {
        ObjectName objectName;
        block10: {
            block11: {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((Object)sm.getString("abstractProtocolHandler.destroy", new Object[]{this.getName()}));
                    this.logPortOffset();
                }
                try {
                    this.endpoint.destroy();
                    if (this.oname == null) break block10;
                    if (this.mserver != null) break block11;
                    Registry.getRegistry(null, null).unregisterComponent(this.oname);
                    break block10;
                }
                catch (Throwable throwable) {
                    ObjectName objectName2;
                    if (this.oname != null) {
                        if (this.mserver == null) {
                            Registry.getRegistry(null, null).unregisterComponent(this.oname);
                        } else {
                            try {
                                this.mserver.unregisterMBean(this.oname);
                            }
                            catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
                                this.getLog().info((Object)sm.getString("abstractProtocol.mbeanDeregistrationFailed", new Object[]{this.oname, this.mserver}));
                            }
                        }
                    }
                    if ((objectName2 = this.getGlobalRequestProcessorMBeanName()) == null) throw throwable;
                    Registry.getRegistry(null, null).unregisterComponent(objectName2);
                    throw throwable;
                }
            }
            try {
                this.mserver.unregisterMBean(this.oname);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
                this.getLog().info((Object)sm.getString("abstractProtocol.mbeanDeregistrationFailed", new Object[]{this.oname, this.mserver}));
            }
        }
        if ((objectName = this.getGlobalRequestProcessorMBeanName()) == null) return;
        Registry.getRegistry(null, null).unregisterComponent(objectName);
    }

    @Override
    public void closeServerSocketGraceful() {
        this.endpoint.closeServerSocketGraceful();
    }

    private void logPortOffset() {
        if (this.getPort() != this.getPortWithOffset()) {
            this.getLog().info((Object)sm.getString("abstractProtocolHandler.portOffset", new Object[]{this.getName(), String.valueOf(this.getPort()), String.valueOf(this.getPortOffset())}));
        }
    }

    protected static class RecycledProcessors
    extends SynchronizedStack<Processor> {
        private final transient ConnectionHandler<?> handler;
        protected final AtomicInteger size = new AtomicInteger(0);

        public RecycledProcessors(ConnectionHandler<?> connectionHandler) {
            this.handler = connectionHandler;
        }

        public boolean push(Processor processor) {
            int n = this.handler.getProtocol().getProcessorCache();
            boolean bl = n == -1 ? true : this.size.get() < n;
            boolean bl2 = false;
            if (bl && (bl2 = super.push((Object)processor))) {
                this.size.incrementAndGet();
            }
            if (!bl2) {
                this.handler.unregister(processor);
            }
            return bl2;
        }

        public Processor pop() {
            Processor processor = (Processor)super.pop();
            if (processor != null) {
                this.size.decrementAndGet();
            }
            return processor;
        }

        public synchronized void clear() {
            Processor processor = this.pop();
            while (processor != null) {
                this.handler.unregister(processor);
                processor = this.pop();
            }
            super.clear();
            this.size.set(0);
        }
    }

    protected static class ConnectionHandler<S>
    implements AbstractEndpoint.Handler<S> {
        private final AbstractProtocol<S> proto;
        private final RequestGroupInfo global = new RequestGroupInfo();
        private final AtomicLong registerCount = new AtomicLong(0L);
        private final RecycledProcessors recycledProcessors = new RecycledProcessors(this);

        public ConnectionHandler(AbstractProtocol<S> abstractProtocol) {
            this.proto = abstractProtocol;
        }

        protected AbstractProtocol<S> getProtocol() {
            return this.proto;
        }

        protected Log getLog() {
            return this.getProtocol().getLog();
        }

        @Override
        public Object getGlobal() {
            return this.global;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapperBase<S> socketWrapperBase, SocketEvent socketEvent) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)sm.getString("abstractConnectionHandler.process", new Object[]{socketWrapperBase.getSocket(), socketEvent}));
            }
            if (socketWrapperBase == null) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            S s = socketWrapperBase.getSocket();
            Processor processor = (Processor)socketWrapperBase.getCurrentProcessor();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)sm.getString("abstractConnectionHandler.connectionsGet", new Object[]{processor, s}));
            }
            if (SocketEvent.TIMEOUT == socketEvent && (processor == null || !processor.isAsync() && !processor.isUpgrade() || processor.isAsync() && !processor.checkAsyncTimeoutGeneration())) {
                return AbstractEndpoint.Handler.SocketState.OPEN;
            }
            if (processor != null) {
                this.getProtocol().removeWaitingProcessor(processor);
            } else if (socketEvent == SocketEvent.DISCONNECT || socketEvent == SocketEvent.ERROR) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            ContainerThreadMarker.set();
            try {
                ClassLoader classLoader;
                Object object;
                ByteBuffer byteBuffer;
                Object object2;
                Object object3;
                if (processor == null && (object3 = socketWrapperBase.getNegotiatedProtocol()) != null && object3.length() > 0) {
                    object2 = this.getProtocol().getNegotiatedProtocol((String)object3);
                    if (object2 != null) {
                        processor = object2.getProcessor(socketWrapperBase, this.getProtocol().getAdapter());
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)sm.getString("abstractConnectionHandler.processorCreate", new Object[]{processor}));
                        }
                    } else if (!object3.equals("http/1.1")) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)sm.getString("abstractConnectionHandler.negotiatedProcessor.fail", new Object[]{object3}));
                        }
                        AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
                        return socketState;
                    }
                }
                if (processor == null) {
                    processor = this.recycledProcessors.pop();
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)sm.getString("abstractConnectionHandler.processorPop", new Object[]{processor}));
                    }
                }
                if (processor == null) {
                    processor = this.getProtocol().createProcessor();
                    this.register(processor);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)sm.getString("abstractConnectionHandler.processorCreate", new Object[]{processor}));
                    }
                }
                processor.setSslSupport(socketWrapperBase.getSslSupport(this.getProtocol().getClientCertProvider()));
                socketWrapperBase.setCurrentProcessor(processor);
                object3 = AbstractEndpoint.Handler.SocketState.CLOSED;
                do {
                    if ((object3 = processor.process(socketWrapperBase, socketEvent)) != AbstractEndpoint.Handler.SocketState.UPGRADING) continue;
                    object2 = processor.getUpgradeToken();
                    byteBuffer = processor.getLeftoverInput();
                    if (object2 == null) {
                        object = this.getProtocol().getUpgradeProtocol("h2c");
                        if (object != null) {
                            this.release(processor);
                            processor = object.getProcessor(socketWrapperBase, this.getProtocol().getAdapter());
                            socketWrapperBase.unRead(byteBuffer);
                            socketWrapperBase.setCurrentProcessor(processor);
                            continue;
                        }
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)sm.getString("abstractConnectionHandler.negotiatedProcessor.fail", new Object[]{"h2c"}));
                        }
                        object3 = AbstractEndpoint.Handler.SocketState.CLOSED;
                        continue;
                    }
                    object = ((UpgradeToken)object2).getHttpUpgradeHandler();
                    this.release(processor);
                    processor = this.getProtocol().createUpgradeProcessor(socketWrapperBase, (UpgradeToken)object2);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)sm.getString("abstractConnectionHandler.upgradeCreate", new Object[]{processor, socketWrapperBase}));
                    }
                    socketWrapperBase.unRead(byteBuffer);
                    socketWrapperBase.setCurrentProcessor(processor);
                    if (((UpgradeToken)object2).getInstanceManager() == null) {
                        object.init((WebConnection)processor);
                    } else {
                        classLoader = ((UpgradeToken)object2).getContextBind().bind(false, null);
                        try {
                            object.init((WebConnection)processor);
                        }
                        finally {
                            ((UpgradeToken)object2).getContextBind().unbind(false, classLoader);
                        }
                    }
                    if (!(object instanceof InternalHttpUpgradeHandler) || !((InternalHttpUpgradeHandler)object).hasAsyncIO()) continue;
                    object3 = AbstractEndpoint.Handler.SocketState.UPGRADED;
                } while (object3 == AbstractEndpoint.Handler.SocketState.UPGRADING);
                if (object3 == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.longPoll(socketWrapperBase, processor);
                    if (processor.isAsync()) {
                        this.getProtocol().addWaitingProcessor(processor);
                    }
                } else if (object3 == AbstractEndpoint.Handler.SocketState.OPEN) {
                    socketWrapperBase.setCurrentProcessor(null);
                    this.release(processor);
                    socketWrapperBase.registerReadInterest();
                } else if (object3 != AbstractEndpoint.Handler.SocketState.SENDFILE) {
                    if (object3 == AbstractEndpoint.Handler.SocketState.UPGRADED) {
                        if (socketEvent != SocketEvent.OPEN_WRITE) {
                            this.longPoll(socketWrapperBase, processor);
                            this.getProtocol().addWaitingProcessor(processor);
                        }
                    } else if (object3 != AbstractEndpoint.Handler.SocketState.SUSPENDED) {
                        socketWrapperBase.setCurrentProcessor(null);
                        if (processor.isUpgrade()) {
                            object2 = processor.getUpgradeToken();
                            byteBuffer = ((UpgradeToken)object2).getHttpUpgradeHandler();
                            object = ((UpgradeToken)object2).getInstanceManager();
                            if (object == null) {
                                byteBuffer.destroy();
                            } else {
                                classLoader = ((UpgradeToken)object2).getContextBind().bind(false, null);
                                try {
                                    byteBuffer.destroy();
                                }
                                finally {
                                    try {
                                        object.destroyInstance((Object)byteBuffer);
                                    }
                                    catch (Throwable throwable) {
                                        ExceptionUtils.handleThrowable((Throwable)throwable);
                                        this.getLog().error((Object)sm.getString("abstractConnectionHandler.error"), throwable);
                                    }
                                    ((UpgradeToken)object2).getContextBind().unbind(false, classLoader);
                                }
                            }
                        }
                        this.release(processor);
                    }
                }
                object2 = object3;
                return object2;
            }
            catch (SocketException socketException) {
                this.getLog().debug((Object)sm.getString("abstractConnectionHandler.socketexception.debug"), (Throwable)socketException);
            }
            catch (IOException iOException) {
                this.getLog().debug((Object)sm.getString("abstractConnectionHandler.ioexception.debug"), (Throwable)iOException);
            }
            catch (ProtocolException protocolException) {
                this.getLog().debug((Object)sm.getString("abstractConnectionHandler.protocolexception.debug"), (Throwable)protocolException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.getLog().error((Object)sm.getString("abstractConnectionHandler.oome"), (Throwable)outOfMemoryError);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.getLog().error((Object)sm.getString("abstractConnectionHandler.error"), throwable);
            }
            finally {
                ContainerThreadMarker.clear();
            }
            socketWrapperBase.setCurrentProcessor(null);
            this.release(processor);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        protected void longPoll(SocketWrapperBase<?> socketWrapperBase, Processor processor) {
            if (!processor.isAsync()) {
                socketWrapperBase.registerReadInterest();
            }
        }

        @Override
        public Set<S> getOpenSockets() {
            Set<SocketWrapperBase<S>> set = this.proto.getEndpoint().getConnections();
            HashSet<S> hashSet = new HashSet<S>();
            for (SocketWrapperBase<S> socketWrapperBase : set) {
                S s = socketWrapperBase.getSocket();
                if (s == null) continue;
                hashSet.add(s);
            }
            return hashSet;
        }

        private void release(Processor processor) {
            if (processor != null) {
                processor.recycle();
                if (processor.isUpgrade()) {
                    this.getProtocol().removeWaitingProcessor(processor);
                } else {
                    this.recycledProcessors.push(processor);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)("Pushed Processor [" + processor + "]"));
                    }
                }
            }
        }

        @Override
        public void release(SocketWrapperBase<S> socketWrapperBase) {
            Processor processor = (Processor)socketWrapperBase.getCurrentProcessor();
            socketWrapperBase.setCurrentProcessor(null);
            this.release(processor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(Processor processor) {
            if (this.getProtocol().getDomain() != null) {
                ConnectionHandler connectionHandler = this;
                synchronized (connectionHandler) {
                    try {
                        long l = this.registerCount.incrementAndGet();
                        RequestInfo requestInfo = processor.getRequest().getRequestProcessor();
                        requestInfo.setGlobalProcessor(this.global);
                        ObjectName objectName = new ObjectName(this.getProtocol().getDomain() + ":type=RequestProcessor,worker=" + this.getProtocol().getName() + ",name=" + this.getProtocol().getProtocolName() + "Request" + l);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)("Register [" + processor + "] as [" + objectName + "]"));
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)requestInfo, objectName, null);
                        requestInfo.setRpName(objectName);
                    }
                    catch (Exception exception) {
                        this.getLog().warn((Object)sm.getString("abstractProtocol.processorRegisterError"), (Throwable)exception);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Processor processor) {
            if (this.getProtocol().getDomain() != null) {
                ConnectionHandler connectionHandler = this;
                synchronized (connectionHandler) {
                    try {
                        Request request = processor.getRequest();
                        if (request == null) {
                            return;
                        }
                        RequestInfo requestInfo = request.getRequestProcessor();
                        requestInfo.setGlobalProcessor(null);
                        ObjectName objectName = requestInfo.getRpName();
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)("Unregister [" + objectName + "]"));
                        }
                        Registry.getRegistry(null, null).unregisterComponent(objectName);
                        requestInfo.setRpName(null);
                    }
                    catch (Exception exception) {
                        this.getLog().warn((Object)sm.getString("abstractProtocol.processorUnregisterError"), (Throwable)exception);
                    }
                }
            }
        }

        @Override
        public final void pause() {
            for (SocketWrapperBase<S> socketWrapperBase : this.proto.getEndpoint().getConnections()) {
                Processor processor = (Processor)socketWrapperBase.getCurrentProcessor();
                if (processor == null) continue;
                processor.pause();
            }
        }
    }
}

