/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPOutputStream;
import org.apache.coyote.Response;
import org.apache.coyote.http11.HttpOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class GzipOutputFilter
implements OutputFilter {
    protected static final Log log = LogFactory.getLog(GzipOutputFilter.class);
    protected HttpOutputBuffer buffer;
    protected GZIPOutputStream compressionStream = null;
    protected final OutputStream fakeOutputStream = new FakeOutputStream();

    @Override
    public int doWrite(ByteBuffer byteBuffer) throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new GZIPOutputStream(this.fakeOutputStream, true);
        }
        int n = byteBuffer.remaining();
        if (byteBuffer.hasArray()) {
            this.compressionStream.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n);
        } else {
            byte[] byArray = new byte[n];
            byteBuffer.put(byArray);
            this.compressionStream.write(byArray, 0, n);
        }
        return n;
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void flush() throws IOException {
        block4: {
            if (this.compressionStream != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Flushing the compression stream!");
                    }
                    this.compressionStream.flush();
                }
                catch (IOException iOException) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Ignored exception while flushing gzip filter", (Throwable)iOException);
                }
            }
        }
        this.buffer.flush();
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void setBuffer(HttpOutputBuffer httpOutputBuffer) {
        this.buffer = httpOutputBuffer;
    }

    @Override
    public void end() throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new GZIPOutputStream(this.fakeOutputStream, true);
        }
        this.compressionStream.finish();
        this.compressionStream.close();
        this.buffer.end();
    }

    @Override
    public void recycle() {
        this.compressionStream = null;
    }

    protected class FakeOutputStream
    extends OutputStream {
        protected final ByteBuffer outputChunk = ByteBuffer.allocate(1);

        protected FakeOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            this.outputChunk.put(0, (byte)(n & 0xFF));
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            GzipOutputFilter.this.buffer.doWrite(ByteBuffer.wrap(byArray, n, n2));
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

