/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemChange;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;

abstract class TimelineXYPainter
extends XYItemPainter.Abstract {
    private final int viewExtent;
    private final boolean bottomBased;
    private boolean painting;
    protected final double dataFactor;

    TimelineXYPainter(int n, boolean bl, double d) {
        this.viewExtent = n;
        this.bottomBased = bl;
        this.dataFactor = d;
        this.painting = true;
    }

    protected abstract void paint(XYItem var1, List<ItemSelection> var2, List<ItemSelection> var3, Graphics2D var4, Rectangle var5, SynchronousXYChartContext var6);

    protected abstract Color getDefiningColor();

    void setPainting(boolean bl) {
        this.painting = bl;
    }

    boolean isPainting() {
        return this.painting;
    }

    public LongRect getItemBounds(ChartItem chartItem) {
        XYItem xYItem = (XYItem)chartItem;
        return this.getDataBounds(xYItem.getBounds());
    }

    public LongRect getItemBounds(ChartItem chartItem, ChartContext chartContext) {
        XYItem xYItem = (XYItem)chartItem;
        return this.getViewBounds(xYItem.getBounds(), chartContext);
    }

    public boolean isBoundsChange(ChartItemChange chartItemChange) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        return !LongRect.equals((LongRect)xYItemChange.getOldValuesBounds(), (LongRect)xYItemChange.getNewValuesBounds());
    }

    public boolean isAppearanceChange(ChartItemChange chartItemChange) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        LongRect longRect = xYItemChange.getDirtyValuesBounds();
        return longRect.width != 0L || longRect.height != 0L;
    }

    public LongRect getDirtyBounds(ChartItemChange chartItemChange, ChartContext chartContext) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        return this.getViewBounds(xYItemChange.getDirtyValuesBounds(), chartContext);
    }

    public boolean supportsHovering(ChartItem chartItem) {
        return true;
    }

    public boolean supportsSelecting(ChartItem chartItem) {
        return true;
    }

    public LongRect getSelectionBounds(ItemSelection itemSelection, ChartContext chartContext) {
        XYItemSelection xYItemSelection = (XYItemSelection)itemSelection;
        XYItem xYItem = xYItemSelection.getItem();
        int n = xYItemSelection.getValueIndex();
        if (n == -1 || n >= xYItem.getValuesCount()) {
            return new LongRect(0L, 0L, (long)chartContext.getViewportWidth(), (long)chartContext.getViewportHeight());
        }
        return this.getViewBounds(xYItem, n, chartContext);
    }

    public XYItemSelection getClosestSelection(ChartItem chartItem, int n, int n2, ChartContext chartContext) {
        SynchronousXYChartContext synchronousXYChartContext = (SynchronousXYChartContext)chartContext;
        int n3 = synchronousXYChartContext.getNearestTimestampIndex(n, n2);
        if (n3 == -1) {
            return null;
        }
        SynchronousXYItem synchronousXYItem = (SynchronousXYItem)chartItem;
        return new XYItemSelection.Default((XYItem)synchronousXYItem, n3, Integer.MAX_VALUE);
    }

    public final void paintItem(ChartItem chartItem, List<ItemSelection> list, List<ItemSelection> list2, Graphics2D graphics2D, Rectangle rectangle, ChartContext chartContext) {
        if (!this.painting) {
            return;
        }
        XYItem xYItem = (XYItem)chartItem;
        if (xYItem.getValuesCount() < 1) {
            return;
        }
        if (chartContext.getViewWidth() == 0L || chartContext.getViewHeight() == 0L) {
            return;
        }
        SynchronousXYChartContext synchronousXYChartContext = (SynchronousXYChartContext)chartContext;
        this.paint((XYItem)chartItem, list, list2, graphics2D, rectangle, synchronousXYChartContext);
    }

    public double getItemView(double d, XYItem xYItem, ChartContext chartContext) {
        return chartContext.getViewY(d * this.dataFactor);
    }

    public double getItemValue(double d, XYItem xYItem, ChartContext chartContext) {
        return chartContext.getDataY(d / this.dataFactor);
    }

    public double getItemValueScale(XYItem xYItem, ChartContext chartContext) {
        double d = chartContext.getViewHeight(this.dataFactor);
        if (d <= 0.0) {
            d = -1.0;
        }
        return d;
    }

    private LongRect getDataBounds(LongRect longRect) {
        LongRect longRect2 = new LongRect(longRect);
        longRect2.y = (long)((double)longRect2.y * this.dataFactor);
        longRect2.height = (long)((double)longRect2.height * this.dataFactor);
        if (this.bottomBased) {
            longRect2.height += longRect2.y;
            longRect2.y = 0L;
        }
        return longRect2;
    }

    private LongRect getViewBounds(LongRect longRect, ChartContext chartContext) {
        LongRect longRect2 = this.getDataBounds(longRect);
        LongRect longRect3 = chartContext.getViewRect(longRect2);
        LongRect.addBorder((LongRect)longRect3, (long)this.viewExtent);
        return longRect3;
    }

    private LongRect getViewBounds(XYItem xYItem, int n, ChartContext chartContext) {
        long l = xYItem.getXValue(n);
        long l2 = (long)((double)xYItem.getYValue(n) * this.dataFactor);
        return chartContext.getViewRect(new LongRect(l, l2, 0L, 0L));
    }
}

