/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.lang.reflect.InvocationTargetException;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class POIXMLFactory {
    private static final POILogger LOGGER = POILogFactory.getLogger(POIXMLFactory.class);
    private static final Class<?>[] PARENT_PART = new Class[]{POIXMLDocumentPart.class, PackagePart.class};
    private static final Class<?>[] ORPHAN_PART = new Class[]{PackagePart.class};

    public POIXMLDocumentPart createDocumentPart(POIXMLDocumentPart parent, PackagePart part) {
        PackageRelationship rel = this.getPackageRelationship(parent, part);
        POIXMLRelation descriptor = this.getDescriptor(rel.getRelationshipType());
        if (descriptor == null || descriptor.getRelationClass() == null) {
            LOGGER.log(1, new Object[]{"using default POIXMLDocumentPart for " + rel.getRelationshipType()});
            return new POIXMLDocumentPart(parent, part);
        }
        Class<? extends POIXMLDocumentPart> cls = descriptor.getRelationClass();
        try {
            try {
                return this.createDocumentPart(cls, PARENT_PART, new Object[]{parent, part});
            }
            catch (NoSuchMethodException e) {
                return this.createDocumentPart(cls, ORPHAN_PART, new Object[]{part});
            }
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    protected abstract POIXMLDocumentPart createDocumentPart(Class<? extends POIXMLDocumentPart> var1, Class<?>[] var2, Object[] var3) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException;

    protected abstract POIXMLRelation getDescriptor(String var1);

    public POIXMLDocumentPart newDocumentPart(POIXMLRelation descriptor) {
        Class<? extends POIXMLDocumentPart> cls = descriptor.getRelationClass();
        try {
            return this.createDocumentPart(cls, null, null);
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    protected PackageRelationship getPackageRelationship(POIXMLDocumentPart parent, PackagePart part) {
        try {
            String partName = part.getPartName().getName();
            for (PackageRelationship pr : parent.getPackagePart().getRelationships()) {
                String packName = pr.getTargetURI().toASCIIString();
                if (!packName.equalsIgnoreCase(partName)) continue;
                return pr;
            }
        }
        catch (InvalidFormatException e) {
            throw new POIXMLException("error while determining package relations", e);
        }
        throw new POIXMLException("package part isn't a child of the parent document.");
    }
}

