/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.lang.ref.WeakReference;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleValue;
import org.GNOME.Accessibility.AtkUtil;

public class AtkValue {
    WeakReference<AccessibleValue> _acc_value;

    public AtkValue(AccessibleContext accessibleContext) {
        this._acc_value = new WeakReference<AccessibleValue>(accessibleContext.getAccessibleValue());
    }

    public static AtkValue createAtkValue(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> new AtkValue(accessibleContext), null);
    }

    public Number get_current_value() {
        AccessibleValue accessibleValue = (AccessibleValue)this._acc_value.get();
        if (accessibleValue == null) {
            return 0.0;
        }
        return AtkUtil.invokeInSwing(() -> accessibleValue.getCurrentAccessibleValue(), 0.0);
    }

    public double getMaximumValue() {
        AccessibleValue accessibleValue = (AccessibleValue)this._acc_value.get();
        if (accessibleValue == null) {
            return 0.0;
        }
        return AtkUtil.invokeInSwing(() -> accessibleValue.getMaximumAccessibleValue().doubleValue(), 0.0);
    }

    public double getMinimumValue() {
        AccessibleValue accessibleValue = (AccessibleValue)this._acc_value.get();
        if (accessibleValue == null) {
            return 0.0;
        }
        return AtkUtil.invokeInSwing(() -> accessibleValue.getMinimumAccessibleValue().doubleValue(), 0.0);
    }

    public void setValue(Number number) {
        AccessibleValue accessibleValue = (AccessibleValue)this._acc_value.get();
        if (accessibleValue == null) {
            return;
        }
        AtkUtil.invokeInSwing(() -> accessibleValue.setCurrentAccessibleValue(number));
    }

    public double getIncrement() {
        return Double.MIN_VALUE;
    }
}

