/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;

public class ExtendedGridLayoutConstraints {
    public static final int REMAINDER = Integer.MAX_VALUE;
    private int row;
    private int col;
    private int colspan;
    private int effectiveColspan;
    private int rowspan;
    private int effectiveRowspan;
    private boolean placeholder;
    private ExtendedGridLayoutConstraints mainConstraints;
    private Component component;

    public ExtendedGridLayoutConstraints(Component component) {
        this(0, 0, 1, 1, component, false, null);
    }

    public ExtendedGridLayoutConstraints(int n, Component component) {
        this(n, 0, 1, 1, component, false, null);
    }

    public ExtendedGridLayoutConstraints(int n, int n2, int n3, Component component) {
        this(n, 0, n2, n3, component, false, null);
    }

    private ExtendedGridLayoutConstraints(int n, int n2, int n3, int n4, Component component, boolean bl, ExtendedGridLayoutConstraints extendedGridLayoutConstraints) {
        if (n < 0) {
            throw new IllegalArgumentException("row must be non-negative (" + n + ")");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("col must be non-negative (" + n2 + ")");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("colspan must be at least 1 (" + n3 + ")");
        }
        if (n4 < 1) {
            throw new IllegalArgumentException("rowspan must be at least 1 (" + n4 + ")");
        }
        this.row = n;
        this.col = n2;
        this.colspan = n3;
        this.effectiveColspan = 1;
        this.rowspan = n4;
        this.effectiveRowspan = 1;
        this.component = component;
        this.placeholder = bl;
        this.mainConstraints = extendedGridLayoutConstraints;
    }

    ExtendedGridLayoutConstraints getColspanPlaceholder(boolean bl) {
        if (1 == this.colspan) {
            return null;
        }
        ExtendedGridLayoutConstraints extendedGridLayoutConstraints = new ExtendedGridLayoutConstraints(this.row, this.col + 1, this.colspan == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.colspan - 1, this.rowspan, this.component, true, null == this.mainConstraints ? this : this.mainConstraints);
        if (bl && extendedGridLayoutConstraints.mainConstraints.row == this.row) {
            ++extendedGridLayoutConstraints.mainConstraints.effectiveColspan;
        }
        return extendedGridLayoutConstraints;
    }

    ExtendedGridLayoutConstraints getRowspanPlaceholder(boolean bl) {
        if (1 == this.rowspan) {
            return null;
        }
        ExtendedGridLayoutConstraints extendedGridLayoutConstraints = new ExtendedGridLayoutConstraints(this.row + 1, this.col, this.colspan, this.rowspan == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.rowspan - 1, this.component, true, null == this.mainConstraints ? this : this.mainConstraints);
        if (bl && extendedGridLayoutConstraints.mainConstraints.col == this.col) {
            ++extendedGridLayoutConstraints.mainConstraints.effectiveRowspan;
        }
        return extendedGridLayoutConstraints;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    void setCol(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("col must be non-negative (" + n + ")");
        }
        this.col = n;
    }

    public int getColspan() {
        return this.colspan;
    }

    int getEffectiveColspan() {
        return null == this.mainConstraints ? this.effectiveColspan : this.mainConstraints.effectiveColspan;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    int getEffectiveRowspan() {
        return null == this.mainConstraints ? this.effectiveRowspan : this.mainConstraints.effectiveRowspan;
    }

    Component getComponent() {
        return this.component;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    ExtendedGridLayoutConstraints getWorkCopy() {
        return new ExtendedGridLayoutConstraints(this.row, this.col, this.colspan, this.rowspan, this.component, this.placeholder, null == this.mainConstraints ? null : this.mainConstraints.getWorkCopy());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ExtendedGridLayoutConstraints)) {
            return false;
        }
        if (this.component == null) {
            return ((ExtendedGridLayoutConstraints)object).component == null;
        }
        return this.component.equals(((ExtendedGridLayoutConstraints)object).component);
    }

    public int hashCode() {
        if (null == this.component) {
            return 0;
        }
        return this.component.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[row=" + this.row + ",col=" + this.col + ",colspan=" + this.colspan + ",effectiveColspan=" + this.effectiveColspan + ",rowspan=" + this.rowspan + ",effectiveRowspan=" + this.effectiveRowspan + ",placeholder=" + this.placeholder + ",component=" + this.component + ",mainConstraints=" + this.mainConstraints + "]";
    }
}

