/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.compression;

import java.io.IOException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.compression.Zlib;

public class CompressionFilter
extends IoFilterAdapter {
    public static final int COMPRESSION_MAX = 9;
    public static final int COMPRESSION_MIN = 1;
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_DEFAULT = -1;
    private final AttributeKey DEFLATER = new AttributeKey(((Object)((Object)this)).getClass(), "deflater");
    private final AttributeKey INFLATER = new AttributeKey(((Object)((Object)this)).getClass(), "inflater");
    public static final AttributeKey DISABLE_COMPRESSION_ONCE = new AttributeKey(CompressionFilter.class, "disableOnce");
    private boolean compressInbound = true;
    private boolean compressOutbound = true;
    private int compressionLevel;

    public CompressionFilter() {
        this(true, true, -1);
    }

    public CompressionFilter(int compressionLevel) {
        this(true, true, compressionLevel);
    }

    public CompressionFilter(boolean compressInbound, boolean compressOutbound, int compressionLevel) {
        this.compressionLevel = compressionLevel;
        this.compressInbound = compressInbound;
        this.compressOutbound = compressOutbound;
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Object compressedMessage = this.doFilterWrite(nextFilter, session, writeRequest);
        if (compressedMessage != null && compressedMessage != writeRequest.getMessage()) {
            writeRequest.setMessage(compressedMessage);
        }
        nextFilter.filterWrite(session, writeRequest);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (!this.compressInbound || !(message instanceof IoBuffer)) {
            nextFilter.messageReceived(session, message);
            return;
        }
        Zlib inflater = (Zlib)session.getAttribute((Object)this.INFLATER);
        if (inflater == null) {
            throw new IllegalStateException();
        }
        IoBuffer inBuffer = (IoBuffer)message;
        nextFilter.messageReceived(session, (Object)inflater.inflate(inBuffer));
    }

    protected Object doFilterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws IOException {
        if (!this.compressOutbound) {
            return null;
        }
        if (session.containsAttribute((Object)DISABLE_COMPRESSION_ONCE)) {
            session.removeAttribute((Object)DISABLE_COMPRESSION_ONCE);
            return null;
        }
        Zlib deflater = (Zlib)session.getAttribute((Object)this.DEFLATER);
        if (deflater == null) {
            throw new IllegalStateException();
        }
        IoBuffer inBuffer = (IoBuffer)writeRequest.getMessage();
        if (!inBuffer.hasRemaining()) {
            return null;
        }
        return deflater.deflate(inBuffer);
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(CompressionFilter.class)) {
            throw new IllegalStateException("Only one " + CompressionFilter.class + " is permitted.");
        }
        Zlib deflater = new Zlib(this.compressionLevel, 1);
        Zlib inflater = new Zlib(this.compressionLevel, 2);
        IoSession session = parent.getSession();
        session.setAttribute((Object)this.DEFLATER, (Object)deflater);
        session.setAttribute((Object)this.INFLATER, (Object)inflater);
    }

    public boolean isCompressInbound() {
        return this.compressInbound;
    }

    public void setCompressInbound(boolean compressInbound) {
        this.compressInbound = compressInbound;
    }

    public boolean isCompressOutbound() {
        return this.compressOutbound;
    }

    public void setCompressOutbound(boolean compressOutbound) {
        this.compressOutbound = compressOutbound;
    }

    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        super.onPostRemove(parent, name, nextFilter);
        IoSession session = parent.getSession();
        if (session == null) {
            return;
        }
        Zlib inflater = (Zlib)session.getAttribute((Object)this.INFLATER);
        Zlib deflater = (Zlib)session.getAttribute((Object)this.DEFLATER);
        if (deflater != null) {
            deflater.cleanUp();
        }
        if (inflater != null) {
            inflater.cleanUp();
        }
    }
}

