/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gephi.filters.FilterQueryImpl;
import org.gephi.filters.OperatorQueryImpl;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Graph;

public abstract class AbstractQueryImpl
implements Query {
    protected List<AbstractQueryImpl> children = new ArrayList<AbstractQueryImpl>();
    protected Query parent;
    protected Graph result;

    public abstract int getChildrenSlotsCount();

    public abstract int getPropertiesCount();

    public abstract String getPropertyName(int var1);

    public abstract Object getPropertyValue(int var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public Query[] getChildren() {
        return this.children.toArray(new Query[0]);
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public AbstractQueryImpl getChildAt(int index) {
        return this.children.get(index);
    }

    public void addSubQuery(Query subQuery) {
        this.children.add((AbstractQueryImpl)subQuery);
        ((AbstractQueryImpl)subQuery).setParent(this);
    }

    public void removeSubQuery(Query subQuery) {
        this.children.remove((AbstractQueryImpl)subQuery);
    }

    public Query getParent() {
        return this.parent;
    }

    public void setParent(Query parent) {
        this.parent = parent;
    }

    public void setResult(Graph result) {
        this.result = result;
    }

    public Graph getResult() {
        return this.result;
    }

    public AbstractQueryImpl getRoot() {
        AbstractQueryImpl root = this;
        while (root.getParent() != null) {
            root = (AbstractQueryImpl)root.getParent();
        }
        return root;
    }

    public AbstractQueryImpl[] getLeaves() {
        ArrayList<AbstractQueryImpl> leaves = new ArrayList<AbstractQueryImpl>();
        ArrayDeque<AbstractQueryImpl> stack = new ArrayDeque<AbstractQueryImpl>();
        stack.add(this);
        while (!stack.isEmpty()) {
            AbstractQueryImpl query = (AbstractQueryImpl)stack.pop();
            if (query.children.size() > 0) {
                stack.addAll(query.children);
                continue;
            }
            leaves.add(query);
        }
        return leaves.toArray(new AbstractQueryImpl[0]);
    }

    public AbstractQueryImpl copy() {
        AbstractQueryImpl copy = null;
        if (this instanceof FilterQueryImpl) {
            copy = new FilterQueryImpl(this.getBuilder(), this.getFilter());
        } else if (this instanceof OperatorQueryImpl) {
            copy = new OperatorQueryImpl((Operator)this.getFilter());
        }
        for (int i = 0; i < this.children.size(); ++i) {
            AbstractQueryImpl child = this.children.get(i);
            AbstractQueryImpl childCopy = child.copy();
            childCopy.parent = copy;
            copy.children.add(childCopy);
        }
        return copy;
    }

    public Query[] getQueries(Class<? extends Filter> filterClass) {
        LinkedList<Query> r = new LinkedList<Query>();
        LinkedList<Query> stack = new LinkedList<Query>();
        stack.add(this);
        while (!stack.isEmpty()) {
            Query q = (Query)stack.pop();
            r.add(q);
            stack.addAll(Arrays.asList(q.getChildren()));
        }
        Iterator itr = r.iterator();
        while (itr.hasNext()) {
            Query q = (Query)itr.next();
            if (q.getFilter().getClass().equals(filterClass)) continue;
            itr.remove();
        }
        return r.toArray(new Query[0]);
    }

    public Query[] getDescendantsAndSelf() {
        LinkedList<Query> r = new LinkedList<Query>();
        LinkedList<Query> stack = new LinkedList<Query>();
        stack.add(this);
        while (!stack.isEmpty()) {
            Query q = (Query)stack.pop();
            r.add(q);
            stack.addAll(Arrays.asList(q.getChildren()));
        }
        return r.toArray(new Query[0]);
    }
}

