/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.forceAtlas2;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.spi.LayoutData;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.forceAtlas2.ForceAtlas2Builder;
import org.gephi.layout.plugin.forceAtlas2.ForceAtlas2LayoutData;
import org.gephi.layout.plugin.forceAtlas2.ForceFactory;
import org.gephi.layout.plugin.forceAtlas2.NodesThread;
import org.gephi.layout.plugin.forceAtlas2.Region;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ForceAtlas2
implements Layout {
    private GraphModel graphModel;
    private Graph graph;
    private final ForceAtlas2Builder layoutBuilder;
    private double edgeWeightInfluence;
    private double jitterTolerance;
    private double scalingRatio;
    private double gravity;
    private double speed;
    private double speedEfficiency;
    private boolean outboundAttractionDistribution;
    private boolean adjustSizes;
    private boolean barnesHutOptimize;
    private double barnesHutTheta;
    private boolean linLogMode;
    private boolean strongGravityMode;
    private int threadCount;
    private int currentThreadCount;
    private Region rootRegion;
    double outboundAttCompensation = 1.0;
    private ExecutorService pool;

    public ForceAtlas2(ForceAtlas2Builder layoutBuilder) {
        this.layoutBuilder = layoutBuilder;
        this.threadCount = Math.min(4, Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAlgo() {
        AbstractLayout.ensureSafeLayoutNodePositions(this.graphModel);
        this.speed = 1.0;
        this.speedEfficiency = 1.0;
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            Node[] nodes;
            for (Node n : nodes = this.graph.getNodes().toArray()) {
                ForceAtlas2LayoutData nLayout;
                if (n.getLayoutData() == null || !(n.getLayoutData() instanceof ForceAtlas2LayoutData)) {
                    nLayout = new ForceAtlas2LayoutData();
                    n.setLayoutData((LayoutData)nLayout);
                }
                nLayout = (ForceAtlas2LayoutData)n.getLayoutData();
                nLayout.mass = 1 + this.graph.getDegree(n);
                nLayout.old_dx = 0.0;
                nLayout.old_dy = 0.0;
                nLayout.dx = 0.0;
                nLayout.dy = 0.0;
            }
            this.pool = Executors.newFixedThreadPool(this.threadCount);
            this.currentThreadCount = this.threadCount;
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    private double getEdgeWeight(Edge edge, boolean isDynamicWeight, Interval interval) {
        if (isDynamicWeight) {
            return edge.getWeight(interval);
        }
        return edge.getWeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goAlgo() {
        if (this.graphModel == null) {
            return;
        }
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        boolean isDynamicWeight = this.graphModel.getEdgeTable().getColumn("weight").isDynamic();
        Interval interval = this.graph.getView().getTimeInterval();
        try {
            Node[] nodes = this.graph.getNodes().toArray();
            Edge[] edges = this.graph.getEdges().toArray();
            for (Node n : nodes) {
                if (n.getLayoutData() == null || !(n.getLayoutData() instanceof ForceAtlas2LayoutData)) {
                    ForceAtlas2LayoutData forceAtlas2LayoutData = new ForceAtlas2LayoutData();
                    n.setLayoutData((LayoutData)forceAtlas2LayoutData);
                }
                ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)n.getLayoutData();
                forceAtlas2LayoutData.mass = 1 + this.graph.getDegree(n);
                forceAtlas2LayoutData.old_dx = forceAtlas2LayoutData.dx;
                forceAtlas2LayoutData.old_dy = forceAtlas2LayoutData.dy;
                forceAtlas2LayoutData.dx = 0.0;
                forceAtlas2LayoutData.dy = 0.0;
            }
            if (this.isBarnesHutOptimize().booleanValue()) {
                this.rootRegion = new Region(nodes);
                this.rootRegion.buildSubRegions();
            }
            if (this.isOutboundAttractionDistribution().booleanValue()) {
                this.outboundAttCompensation = 0.0;
                for (Node n : nodes) {
                    ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)n.getLayoutData();
                    this.outboundAttCompensation += forceAtlas2LayoutData.mass;
                }
                this.outboundAttCompensation /= (double)nodes.length;
            }
            ForceFactory.RepulsionForce Repulsion = ForceFactory.builder.buildRepulsion(this.isAdjustSizes(), this.getScalingRatio());
            int taskCount = 8 * this.currentThreadCount;
            ArrayList threads = new ArrayList();
            for (int t = taskCount; t > 0; --t) {
                int n = (int)Math.floor(nodes.length * (t - 1) / taskCount);
                int to = (int)Math.floor(nodes.length * t / taskCount);
                Future<?> future = this.pool.submit(new NodesThread(nodes, n, to, this.isBarnesHutOptimize(), this.getBarnesHutTheta(), this.getGravity(), this.isStrongGravityMode() != false ? ForceFactory.builder.getStrongGravity(this.getScalingRatio()) : Repulsion, this.getScalingRatio(), this.rootRegion, Repulsion));
                threads.add(future);
            }
            for (Future future : threads) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to layout " + this.getClass().getSimpleName() + ".", e);
                }
            }
            ForceFactory.AttractionForce Attraction = ForceFactory.builder.buildAttraction(this.isLinLogMode(), this.isOutboundAttractionDistribution(), this.isAdjustSizes(), 1.0 * (this.isOutboundAttractionDistribution() != false ? this.outboundAttCompensation : 1.0));
            if (this.getEdgeWeightInfluence() == 0.0) {
                for (Edge e : edges) {
                    Attraction.apply(e.getSource(), e.getTarget(), 1.0);
                }
            } else if (this.getEdgeWeightInfluence() == 1.0) {
                for (Edge e : edges) {
                    Attraction.apply(e.getSource(), e.getTarget(), this.getEdgeWeight(e, isDynamicWeight, interval));
                }
            } else {
                for (Edge e : edges) {
                    Attraction.apply(e.getSource(), e.getTarget(), Math.pow(this.getEdgeWeight(e, isDynamicWeight, interval), this.getEdgeWeightInfluence()));
                }
            }
            double d = 0.0;
            double totalEffectiveTraction = 0.0;
            for (Node n : nodes) {
                ForceAtlas2LayoutData nLayout2 = (ForceAtlas2LayoutData)n.getLayoutData();
                if (n.isFixed()) continue;
                double swinging = Math.sqrt(Math.pow(nLayout2.old_dx - nLayout2.dx, 2.0) + Math.pow(nLayout2.old_dy - nLayout2.dy, 2.0));
                d += nLayout2.mass * swinging;
                totalEffectiveTraction += nLayout2.mass * 0.5 * Math.sqrt(Math.pow(nLayout2.old_dx + nLayout2.dx, 2.0) + Math.pow(nLayout2.old_dy + nLayout2.dy, 2.0));
            }
            double estimatedOptimalJitterTolerance = 0.05 * Math.sqrt(nodes.length);
            double minJT = Math.sqrt(estimatedOptimalJitterTolerance);
            double maxJT = 10.0;
            double jt = this.jitterTolerance * Math.max(minJT, Math.min(maxJT, estimatedOptimalJitterTolerance * totalEffectiveTraction / Math.pow(nodes.length, 2.0)));
            double minSpeedEfficiency = 0.05;
            if (d / totalEffectiveTraction > 2.0) {
                if (this.speedEfficiency > minSpeedEfficiency) {
                    this.speedEfficiency *= 0.5;
                }
                jt = Math.max(jt, this.jitterTolerance);
            }
            double targetSpeed = jt * this.speedEfficiency * totalEffectiveTraction / d;
            if (d > jt * totalEffectiveTraction) {
                if (this.speedEfficiency > minSpeedEfficiency) {
                    this.speedEfficiency *= 0.7;
                }
            } else if (this.speed < 1000.0) {
                this.speedEfficiency *= 1.3;
            }
            double maxRise = 0.5;
            this.speed += Math.min(targetSpeed - this.speed, maxRise * this.speed);
            if (this.isAdjustSizes().booleanValue()) {
                for (Node n : nodes) {
                    ForceAtlas2LayoutData nLayout3 = (ForceAtlas2LayoutData)n.getLayoutData();
                    if (n.isFixed()) continue;
                    double swinging = nLayout3.mass * Math.sqrt((nLayout3.old_dx - nLayout3.dx) * (nLayout3.old_dx - nLayout3.dx) + (nLayout3.old_dy - nLayout3.dy) * (nLayout3.old_dy - nLayout3.dy));
                    double factor = 0.1 * this.speed / (1.0 + Math.sqrt(this.speed * swinging));
                    double df = Math.sqrt(Math.pow(nLayout3.dx, 2.0) + Math.pow(nLayout3.dy, 2.0));
                    factor = Math.min(factor * df, 10.0) / df;
                    double x = (double)n.x() + nLayout3.dx * factor;
                    double y = (double)n.y() + nLayout3.dy * factor;
                    n.setX((float)x);
                    n.setY((float)y);
                }
            } else {
                for (Node n : nodes) {
                    ForceAtlas2LayoutData nLayout4 = (ForceAtlas2LayoutData)n.getLayoutData();
                    if (n.isFixed()) continue;
                    double swinging = nLayout4.mass * Math.sqrt((nLayout4.old_dx - nLayout4.dx) * (nLayout4.old_dx - nLayout4.dx) + (nLayout4.old_dy - nLayout4.dy) * (nLayout4.old_dy - nLayout4.dy));
                    double factor = this.speed / (1.0 + Math.sqrt(this.speed * swinging));
                    double x = (double)n.x() + nLayout4.dx * factor;
                    double y = (double)n.y() + nLayout4.dy * factor;
                    n.setX((float)x);
                    n.setY((float)y);
                }
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    public boolean canAlgo() {
        return this.graphModel != null;
    }

    public void endAlgo() {
        this.graph.readLock();
        try {
            for (Node n : this.graph.getNodes()) {
                n.setLayoutData(null);
            }
            this.pool.shutdown();
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String FORCEATLAS2_TUNING = NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.tuning");
        String FORCEATLAS2_BEHAVIOR = NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.behavior");
        String FORCEATLAS2_PERFORMANCE = NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.performance");
        String FORCEATLAS2_THREADS = NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.threads");
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.scalingRatio.name"), (String)FORCEATLAS2_TUNING, (String)"ForceAtlas2.scalingRatio.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.scalingRatio.desc"), (String)"getScalingRatio", (String)"setScalingRatio"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.strongGravityMode.name"), (String)FORCEATLAS2_TUNING, (String)"ForceAtlas2.strongGravityMode.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.strongGravityMode.desc"), (String)"isStrongGravityMode", (String)"setStrongGravityMode"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.gravity.name"), (String)FORCEATLAS2_TUNING, (String)"ForceAtlas2.gravity.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.gravity.desc"), (String)"getGravity", (String)"setGravity"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.distributedAttraction.name"), (String)FORCEATLAS2_BEHAVIOR, (String)"ForceAtlas2.distributedAttraction.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.distributedAttraction.desc"), (String)"isOutboundAttractionDistribution", (String)"setOutboundAttractionDistribution"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.linLogMode.name"), (String)FORCEATLAS2_BEHAVIOR, (String)"ForceAtlas2.linLogMode.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.linLogMode.desc"), (String)"isLinLogMode", (String)"setLinLogMode"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.adjustSizes.name"), (String)FORCEATLAS2_BEHAVIOR, (String)"ForceAtlas2.adjustSizes.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.adjustSizes.desc"), (String)"isAdjustSizes", (String)"setAdjustSizes"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.edgeWeightInfluence.name"), (String)FORCEATLAS2_BEHAVIOR, (String)"ForceAtlas2.edgeWeightInfluence.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.edgeWeightInfluence.desc"), (String)"getEdgeWeightInfluence", (String)"setEdgeWeightInfluence"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.jitterTolerance.name"), (String)FORCEATLAS2_PERFORMANCE, (String)"ForceAtlas2.jitterTolerance.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.jitterTolerance.desc"), (String)"getJitterTolerance", (String)"setJitterTolerance"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.barnesHutOptimization.name"), (String)FORCEATLAS2_PERFORMANCE, (String)"ForceAtlas2.barnesHutOptimization.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.barnesHutOptimization.desc"), (String)"isBarnesHutOptimize", (String)"setBarnesHutOptimize"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.barnesHutTheta.name"), (String)FORCEATLAS2_PERFORMANCE, (String)"ForceAtlas2.barnesHutTheta.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.barnesHutTheta.desc"), (String)"getBarnesHutTheta", (String)"setBarnesHutTheta"));
            properties.add(LayoutProperty.createProperty((Layout)this, Integer.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.threads.name"), (String)FORCEATLAS2_THREADS, (String)"ForceAtlas2.threads.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.threads.desc"), (String)"getThreadsCount", (String)"setThreadsCount"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public void resetPropertiesValues() {
        int nodesCount = 0;
        if (this.graphModel != null) {
            nodesCount = this.graphModel.getGraphVisible().getNodeCount();
        }
        if (nodesCount >= 100) {
            this.setScalingRatio(2.0);
        } else {
            this.setScalingRatio(10.0);
        }
        this.setStrongGravityMode(false);
        this.setGravity(1.0);
        this.setOutboundAttractionDistribution(false);
        this.setLinLogMode(false);
        this.setAdjustSizes(false);
        this.setEdgeWeightInfluence(1.0);
        this.setJitterTolerance(1.0);
        if (nodesCount >= 1000) {
            this.setBarnesHutOptimize(true);
        } else {
            this.setBarnesHutOptimize(false);
        }
        this.setBarnesHutTheta(1.2);
        this.setThreadsCount(Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
    }

    public LayoutBuilder getBuilder() {
        return this.layoutBuilder;
    }

    public void setGraphModel(GraphModel graphModel) {
        this.graphModel = graphModel;
        this.resetPropertiesValues();
    }

    public Double getBarnesHutTheta() {
        return this.barnesHutTheta;
    }

    public void setBarnesHutTheta(Double barnesHutTheta) {
        this.barnesHutTheta = barnesHutTheta;
    }

    public Double getEdgeWeightInfluence() {
        return this.edgeWeightInfluence;
    }

    public void setEdgeWeightInfluence(Double edgeWeightInfluence) {
        this.edgeWeightInfluence = edgeWeightInfluence;
    }

    public Double getJitterTolerance() {
        return this.jitterTolerance;
    }

    public void setJitterTolerance(Double jitterTolerance) {
        this.jitterTolerance = jitterTolerance;
    }

    public Boolean isLinLogMode() {
        return this.linLogMode;
    }

    public void setLinLogMode(Boolean linLogMode) {
        this.linLogMode = linLogMode;
    }

    public Double getScalingRatio() {
        return this.scalingRatio;
    }

    public void setScalingRatio(Double scalingRatio) {
        this.scalingRatio = scalingRatio;
    }

    public Boolean isStrongGravityMode() {
        return this.strongGravityMode;
    }

    public void setStrongGravityMode(Boolean strongGravityMode) {
        this.strongGravityMode = strongGravityMode;
    }

    public Double getGravity() {
        return this.gravity;
    }

    public void setGravity(Double gravity) {
        this.gravity = gravity;
    }

    public Integer getThreadsCount() {
        return this.threadCount;
    }

    public void setThreadsCount(Integer threadCount) {
        this.threadCount = Math.max(1, threadCount);
    }

    public Boolean isOutboundAttractionDistribution() {
        return this.outboundAttractionDistribution;
    }

    public void setOutboundAttractionDistribution(Boolean outboundAttractionDistribution) {
        this.outboundAttractionDistribution = outboundAttractionDistribution;
    }

    public Boolean isAdjustSizes() {
        return this.adjustSizes;
    }

    public void setAdjustSizes(Boolean adjustSizes) {
        this.adjustSizes = adjustSizes;
    }

    public Boolean isBarnesHutOptimize() {
        return this.barnesHutOptimize;
    }

    public void setBarnesHutOptimize(Boolean barnesHutOptimize) {
        this.barnesHutOptimize = barnesHutOptimize;
    }
}

