/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public abstract class AbstractBeanIntrospection<T>
implements BeanIntrospection<T> {
    protected final AnnotationMetadata annotationMetadata;
    protected final Class<T> beanType;
    protected final Map<String, BeanProperty<T, Object>> beanProperties;
    private Map<Class<? extends Annotation>, List<BeanProperty<T, Object>>> indexed;
    private Map<AnnotationValueKey, BeanProperty<T, Object>> indexedValues;

    protected AbstractBeanIntrospection(@Nonnull Class<T> beanType, @Nullable AnnotationMetadata annotationMetadata, int propertyCount) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        this.beanType = beanType;
        this.annotationMetadata = annotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : annotationMetadata;
        this.beanProperties = new LinkedHashMap<String, BeanProperty<T, Object>>(propertyCount);
    }

    @Override
    @Nonnull
    public Optional<BeanProperty<T, Object>> getIndexedProperty(@Nonnull Class<? extends Annotation> annotationType, @Nonnull String annotationValue) {
        ArgumentUtils.requireNonNull("annotationType", annotationType);
        if (this.indexedValues != null && StringUtils.isNotEmpty(annotationValue)) {
            return Optional.ofNullable(this.indexedValues.get(new AnnotationValueKey(annotationType, annotationValue)));
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public T instantiate(boolean strictNullable, Object ... arguments) throws InstantiationException {
        ArgumentUtils.requireNonNull("arguments", arguments);
        Argument<?>[] constructorArguments = this.getConstructorArguments();
        if (constructorArguments.length != arguments.length) {
            throw new InstantiationException("Argument count [" + arguments.length + "] doesn't match required argument count: " + constructorArguments.length);
        }
        for (int i = 0; i < constructorArguments.length; ++i) {
            Argument<?> constructorArgument = constructorArguments[i];
            Object specified = arguments[i];
            if (specified == null) {
                if (constructorArgument.isDeclaredNullable() || !strictNullable) continue;
                throw new InstantiationException("Null argument specified for [" + constructorArgument.getName() + "]. If this argument is allowed to be null annotate it with @Nullable");
            }
            if (ReflectionUtils.getWrapperType(constructorArgument.getType()).isInstance(specified)) continue;
            throw new InstantiationException("Invalid argument [" + specified + "] specified for argument: " + constructorArgument);
        }
        return this.instantiateInternal(arguments);
    }

    @Override
    @Nonnull
    public Optional<BeanProperty<T, Object>> getProperty(@Nonnull String name) {
        ArgumentUtils.requireNonNull("name", name);
        return Optional.ofNullable(this.beanProperties.get(name));
    }

    @Override
    @Nonnull
    public Collection<BeanProperty<T, Object>> getIndexedProperties(@Nonnull Class<? extends Annotation> annotationType) {
        List<BeanProperty<T, Object>> indexed;
        ArgumentUtils.requireNonNull("annotationType", annotationType);
        if (this.indexed != null && (indexed = this.indexed.get(annotationType)) != null) {
            return Collections.unmodifiableCollection(indexed);
        }
        return Collections.emptyList();
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    @Nonnull
    public Collection<BeanProperty<T, Object>> getBeanProperties() {
        return Collections.unmodifiableCollection(this.beanProperties.values());
    }

    @Override
    @Nonnull
    public Class<T> getBeanType() {
        return this.beanType;
    }

    @Internal
    protected abstract T instantiateInternal(Object[] var1);

    @Internal
    protected final void addProperty(@Nonnull BeanProperty<T, Object> property) {
        ArgumentUtils.requireNonNull("property", property);
        this.beanProperties.put(property.getName(), property);
    }

    @Internal
    protected final void indexProperty(@Nonnull Class<? extends Annotation> annotationType, @Nonnull String propertyName) {
        ArgumentUtils.requireNonNull("annotationType", annotationType);
        if (StringUtils.isNotEmpty(propertyName)) {
            BeanProperty<T, Object> property = this.beanProperties.get(propertyName);
            if (property == null) {
                throw new IllegalStateException("Invalid byte code generated during bean introspection. Call addProperty first!");
            }
            if (this.indexed == null) {
                this.indexed = new HashMap<Class<? extends Annotation>, List<BeanProperty<T, Object>>>(2);
            }
            List indexed = this.indexed.computeIfAbsent(annotationType, aClass -> new ArrayList(2));
            indexed.add(property);
        }
    }

    @Internal
    protected final void indexProperty(@Nonnull Class<? extends Annotation> annotationType, @Nonnull String propertyName, @Nonnull String annotationValue) {
        this.indexProperty(annotationType, propertyName);
        if (StringUtils.isNotEmpty(annotationValue) && StringUtils.isNotEmpty(propertyName)) {
            if (this.indexedValues == null) {
                this.indexedValues = new HashMap<AnnotationValueKey, BeanProperty<T, Object>>(10);
            }
            BeanProperty<T, Object> property = this.beanProperties.get(propertyName);
            this.indexedValues.put(new AnnotationValueKey(annotationType, annotationValue), property);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBeanIntrospection that = (AbstractBeanIntrospection)o;
        return Objects.equals(this.beanType, that.beanType);
    }

    public int hashCode() {
        return Objects.hash(this.beanType);
    }

    public String toString() {
        return "BeanIntrospection{type=" + this.beanType + '}';
    }

    private final class AnnotationValueKey {
        @Nonnull
        final Class<? extends Annotation> type;
        @Nonnull
        final String value;

        AnnotationValueKey(@Nonnull Class<? extends Annotation> type, String value) {
            this.type = type;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationValueKey that = (AnnotationValueKey)o;
            return this.type.equals(that.type) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }
    }
}

