/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UnsignedValueConstant;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class UIntValue
extends UnsignedValueConstant<Integer> {
    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ClassId classId = KotlinBuiltIns.FQ_NAMES.uInt;
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"KotlinBuiltIns.FQ_NAMES.uInt");
        Annotated annotated = FindClassInModuleKt.findClassAcrossModuleDependencies(module, classId);
        if (annotated != null && (annotated = annotated.getDefaultType()) != null) {
            kotlinType = (KotlinType)annotated;
        } else {
            SimpleType simpleType2 = ErrorUtils.createErrorType("Unsigned type UInt not found");
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"ErrorUtils.createErrorTy\u2026ned type UInt not found\")");
            kotlinType = simpleType2;
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Number)this.getValue()).intValue() + ".toUInt()";
    }

    public UIntValue(int intValue) {
        super(intValue);
    }
}

