/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.ConversionTypeContext;
import org.jetbrains.kotlin.fir.backend.ConversionTypeOrigin;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrLocalStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.descriptors.FirBuiltInsPackageFragment;
import org.jetbrains.kotlin.fir.descriptors.FirModuleDescriptor;
import org.jetbrains.kotlin.fir.descriptors.FirPackageFragmentDescriptor;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirExpressionStub;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirClassSubstitutionScope;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionBase;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrPropertyImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.descriptors.WrappedCallableDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedClassConstructorDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedEnumEntryDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedFieldDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedFunctionDescriptorWithContainerSource;
import org.jetbrains.kotlin.ir.descriptors.WrappedPropertyDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedPropertyDescriptorWithContainerSource;
import org.jetbrains.kotlin.ir.descriptors.WrappedPropertyGetterDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedPropertySetterDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedValueParameterDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedVariableDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00cd\u00012\u00020\u0001:\u0002\u00cd\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0000\u00a2\u0006\u0002\bNJ\u001c\u0010O\u001a\u00020P2\n\u0010Q\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010R\u001a\u00020SH\u0002J\u0016\u0010T\u001a\u00020$2\u0006\u0010U\u001a\u00020#2\u0006\u0010V\u001a\u00020MJ \u0010W\u001a\u00020\u00102\u0006\u0010X\u001a\u00020\u000f2\u0006\u0010V\u001a\u00020M2\b\b\u0002\u0010Y\u001a\u00020ZJ\u0010\u0010[\u001a\u00020\u00162\u0006\u0010\\\u001a\u00020\u0015H\u0002J2\u0010]\u001a\u00020!2\n\u0010^\u001a\u0006\u0012\u0002\b\u00030 2\b\u0010V\u001a\u0004\u0018\u00010_2\n\b\u0002\u0010`\u001a\u0004\u0018\u00010M2\b\b\u0002\u0010Y\u001a\u00020ZJ.\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020d2\b\b\u0002\u0010e\u001a\u00020*2\b\b\u0002\u0010f\u001a\u00020P2\b\b\u0002\u0010g\u001a\u00020hH\u0002J.\u0010i\u001a\u00020/2\u0006\u0010j\u001a\u00020.2\b\u0010V\u001a\u0004\u0018\u00010_2\n\b\u0002\u0010`\u001a\u0004\u0018\u00010M2\b\b\u0002\u0010Y\u001a\u00020ZJ`\u0010k\u001a\u00020!2\b\u0010l\u001a\u0004\u0018\u00010m2\u0006\u0010j\u001a\u00020.2\u0006\u0010n\u001a\u00020/2\u0006\u0010o\u001a\u00020p2\b\u0010V\u001a\u0004\u0018\u00010_2\n\b\u0002\u0010`\u001a\u0004\u0018\u00010M2\u0006\u0010q\u001a\u00020P2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010r\u001a\u00020*2\u0006\u0010s\u001a\u00020*H\u0002J&\u0010t\u001a\u00020u2\n\u0010v\u001a\u0006\u0012\u0002\b\u00030w2\u0006\u0010V\u001a\u00020_2\n\b\u0002\u0010x\u001a\u0004\u0018\u00010ZJH\u0010y\u001a\u00020u2\u0006\u0010r\u001a\u00020*2\u0006\u0010s\u001a\u00020*2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020p2\u0006\u0010}\u001a\u00020P2\u0006\u0010~\u001a\u00020P2\u0006\u0010\u007f\u001a\u00020PH\u0002J\u001f\u0010\u0080\u0001\u001a\u00020u2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\f\b\u0002\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001J\u0011\u0010\u0085\u0001\u001a\u00020I2\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001J\u001f\u0010\u0088\u0001\u001a\u0004\u0018\u00010_2\f\u0010\u0089\u0001\u001a\u0007\u0012\u0002\b\u00030\u008a\u0001H\u0000\u00a2\u0006\u0003\b\u008b\u0001J4\u0010\u0088\u0001\u001a\u0004\u0018\u00010_2\u0007\u0010\u008c\u0001\u001a\u00020\b2\n\u0010\u008d\u0001\u001a\u0005\u0018\u00010\u008e\u00012\f\u0010\u008f\u0001\u001a\u0007\u0012\u0002\b\u00030\u0090\u0001H\u0000\u00a2\u0006\u0003\b\u008b\u0001J\u0011\u0010\u0091\u0001\u001a\u0004\u0018\u00010$2\u0006\u0010U\u001a\u00020#J\u0011\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u00102\u0006\u0010X\u001a\u00020\u000fJ\u0015\u0010\u0093\u0001\u001a\u0004\u0018\u00010!2\n\u0010^\u001a\u0006\u0012\u0002\b\u00030 J\u0011\u0010\u0094\u0001\u001a\u0004\u0018\u00010/2\u0006\u0010j\u001a\u00020.J\u0016\u0010\u0095\u0001\u001a\u00030\u0096\u00012\f\u0010\u0097\u0001\u001a\u0007\u0012\u0002\b\u00030\u0098\u0001J\u0012\u0010\u0099\u0001\u001a\u00020\t2\u0007\u0010\u009a\u0001\u001a\u00020\bH\u0002J\u0012\u0010\u009b\u0001\u001a\u00030\u009c\u00012\b\u0010\u009d\u0001\u001a\u00030\u009e\u0001J\u0012\u0010\u009f\u0001\u001a\u00020\t2\u0007\u0010\u009a\u0001\u001a\u00020\bH\u0002J\u0012\u0010\u00a0\u0001\u001a\u00020\t2\u0007\u0010\u009a\u0001\u001a\u00020\bH\u0002J\u0010\u0010\u00a1\u0001\u001a\u00020\u00192\u0007\u0010\u00a2\u0001\u001a\u00020\u0018J\u0016\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\f\u0010\u00a5\u0001\u001a\u0007\u0012\u0002\b\u00030\u00a6\u0001J\u0016\u0010\u00a7\u0001\u001a\u00030\u0096\u00012\f\u0010\u0097\u0001\u001a\u0007\u0012\u0002\b\u00030\u0098\u0001J\u0016\u0010\u00a8\u0001\u001a\u00030\u0096\u00012\f\u0010\u0097\u0001\u001a\u0007\u0012\u0002\b\u00030\u0098\u0001J\u0017\u0010\u00a9\u0001\u001a\u00030\u00aa\u00012\u000b\u0010\u00ab\u0001\u001a\u0006\u0012\u0002\b\u00030wH\u0002J\u0016\u0010\u00ac\u0001\u001a\u00030\u0084\u00012\n\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001H\u0002J\u0011\u0010\u00ad\u0001\u001a\u00020I2\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001J\t\u0010\u00ae\u0001\u001a\u00020*H\u0002J \u0010\u00af\u0001\u001a\u00020I2\u0007\u0010\u00b0\u0001\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0000\u00a2\u0006\u0003\b\u00b1\u0001J\u0019\u0010\u00b2\u0001\u001a\u00020I2\u0007\u0010\u00a2\u0001\u001a\u00020\u00182\u0007\u0010\u00b3\u0001\u001a\u00020\u0019Jl\u0010\u00b4\u0001\u001a\u0003H\u00b5\u0001\"\t\b\u0000\u0010\u00b5\u0001*\u00020S*\u0003H\u00b5\u00012\f\u0010^\u001a\b\u0012\u0002\b\u0003\u0018\u00010 2\u000f\u0010\u0086\u0001\u001a\n\u0012\u0005\u0012\u0003H\u00b5\u00010\u00b6\u00012\b\u0010V\u001a\u0004\u0018\u00010_2\n\b\u0002\u0010`\u001a\u0004\u0018\u00010M2\u0007\u0010\u00b7\u0001\u001a\u00020P2\f\b\u0002\u0010\u00b8\u0001\u001a\u0005\u0018\u00010\u00b9\u0001H\u0002\u00a2\u0006\u0003\u0010\u00ba\u0001Jc\u0010\u00bb\u0001\u001a\u00020\u0016*\u00020/2\u0006\u0010j\u001a\u00020.2\u0006\u0010Y\u001a\u00020Z2\b\u0010\u0086\u0001\u001a\u00030\u00bc\u00012\u0007\u0010\u00bd\u0001\u001a\u00020E2\u0006\u0010z\u001a\u00020{2\u0007\u0010\u00be\u0001\u001a\u00020P2\n\u0010\u00bf\u0001\u001a\u0005\u0018\u00010\u00c0\u00012\b\u0010`\u001a\u0004\u0018\u00010M2\n\b\u0002\u0010|\u001a\u0004\u0018\u00010pH\u0002J(\u0010\u00c1\u0001\u001a\u0003H\u00b5\u0001\"\t\b\u0000\u0010\u00b5\u0001*\u00020S*\u0003H\u00b5\u00012\u0006\u0010|\u001a\u00020pH\u0002\u00a2\u0006\u0003\u0010\u00c2\u0001JM\u0010\u00c3\u0001\u001a\u00020I\"\t\b\u0000\u0010\u00b5\u0001*\u00020S*\u0003H\u00b5\u00012\f\u0010^\u001a\b\u0012\u0002\b\u0003\u0018\u00010 2\t\u0010\u00c4\u0001\u001a\u0004\u0018\u00010M2\u0007\u0010\u00b7\u0001\u001a\u00020P2\n\u0010\u00b8\u0001\u001a\u0005\u0018\u00010\u00b9\u0001H\u0002\u00a2\u0006\u0003\u0010\u00c5\u0001J\u0015\u0010\u00c6\u0001\u001a\u00020I*\u00020\u00162\u0006\u0010`\u001a\u00020MH\u0002J\u0015\u0010\u00c6\u0001\u001a\u00020I*\u00020!2\u0006\u0010`\u001a\u00020MH\u0002J*\u0010\u00c7\u0001\u001a\u0003H\u00b5\u0001\"\t\b\u0000\u0010\u00b5\u0001*\u00020S*\u0003H\u00b5\u00012\n\u0010^\u001a\u0006\u0012\u0002\b\u00030 \u00a2\u0006\u0003\u0010\u00c8\u0001J\u0018\u0010\u00c9\u0001\u001a\u00020I*\u00030\u00ca\u00012\b\u0010V\u001a\u0004\u0018\u00010_H\u0002J\u0018\u0010\u00cb\u0001\u001a\u00020p*\u00030\u00cc\u00012\b\b\u0002\u0010g\u001a\u00020hH\u0002J\u0018\u0010\u00cb\u0001\u001a\u00020p*\u00030\u00b9\u00012\b\b\u0002\u0010g\u001a\u00020hH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030 \u0012\u0004\u0012\u00020!0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00020&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00100\u001a\u000201X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0012\u00104\u001a\u000205X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0012\u00108\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0012\u0010<\u001a\u00020=X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0012\u0010@\u001a\u00020AX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0018\u0010D\u001a\u00020E*\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006\u00ce\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "components", "moduleDescriptor", "Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;)V", "builtInsFragmentCache", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "constructorCache", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "declarationStorage", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "fieldCache", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "fileCache", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "firProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "firSymbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "fragmentCache", "functionCache", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "initializerCache", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "lastTemporaryIndex", "", "localStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalStorage;", "propertyCache", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "fieldVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "getFieldVisibility", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "addDeclarationsToExternalClass", "", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "addDeclarationsToExternalClass$fir2ir", "areCompatible", "", "firFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "createIrAnonymousInitializer", "anonymousInitializer", "irParent", "createIrConstructor", "constructor", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "createIrField", "field", "createIrFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "thisReceiverOwner", "createIrParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "index", "useStubForDefaultValueStub", "typeContext", "Lorg/jetbrains/kotlin/fir/backend/ConversionTypeContext;", "createIrProperty", "property", "createIrPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "correspondingProperty", "propertyType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isSetter", "startOffset", "endOffset", "createIrVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "givenOrigin", "declareIrVariable", "name", "Lorg/jetbrains/kotlin/name/Name;", "type", "isVar", "isConst", "isLateinit", "declareTemporaryVariable", "base", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "nameHint", "", "enterScope", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findIrParent", "callableDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "findIrParent$fir2ir", "packageFqName", "parentClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "firBasedSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getCachedIrAnonymousInitializer", "getCachedIrConstructor", "getCachedIrFunction", "getCachedIrProperty", "getIrBackingFieldSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "firVariableSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "getIrBuiltInsPackageFragment", "fqName", "getIrConstructorSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "firConstructorSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "getIrExternalOrBuiltInsPackageFragment", "getIrExternalPackageFragment", "getIrFile", "firFile", "getIrFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "firFunctionSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "getIrPropertyOrFieldSymbol", "getIrValueSymbol", "getIrVariableSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrVariableSymbol;", "firVariable", "getNameForTemporary", "leaveScope", "nextTemporaryIndex", "preCacheBuiltinClassMembers", "firClass", "preCacheBuiltinClassMembers$fir2ir", "registerFile", "irFile", "bindAndDeclareParameters", "T", "Lorg/jetbrains/kotlin/ir/descriptors/WrappedCallableDescriptor;", "isStatic", "parentPropertyReceiverType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/ir/descriptors/WrappedCallableDescriptor;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Lorg/jetbrains/kotlin/ir/declarations/IrClass;ZLorg/jetbrains/kotlin/fir/types/FirTypeRef;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "createBackingField", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "visibility", "isFinal", "firInitializerExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "declareDefaultSetterParameter", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "declareParameters", "containingClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/ir/declarations/IrClass;ZLorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "populateOverriddenSymbols", "putParametersInScope", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "setAndModifyParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "toIrType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Companion", "fir2ir"})
public final class Fir2IrDeclarationStorage
implements Fir2IrComponents {
    private final FirSymbolProvider firSymbolProvider;
    private final FirProvider firProvider;
    private final Map<FqName, IrExternalPackageFragment> fragmentCache;
    private final Map<FqName, IrExternalPackageFragment> builtInsFragmentCache;
    private final Map<FirFile, IrFile> fileCache;
    private final Map<FirFunction<?>, IrSimpleFunction> functionCache;
    private final Map<FirConstructor, IrConstructor> constructorCache;
    private final Map<FirAnonymousInitializer, IrAnonymousInitializer> initializerCache;
    private final Map<FirProperty, IrProperty> propertyCache;
    private final Map<FirField, IrField> fieldCache;
    private final Fir2IrLocalStorage localStorage;
    private int lastTemporaryIndex;
    private final Fir2IrComponents components;
    private final FirModuleDescriptor moduleDescriptor;
    @NotNull
    private static final Map<Name, IrSyntheticBodyKind> ENUM_SYNTHETIC_NAMES;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean areCompatible(FirFunction<?> firFunction, IrFunction irFunction) {
        boolean bl;
        if (firFunction instanceof FirSimpleFunction && irFunction instanceof IrSimpleFunction && Intrinsics.areEqual(irFunction.getName(), ((FirSimpleFunction)firFunction).getName()) ^ true) {
            return false;
        }
        if (irFunction.getValueParameters().size() != firFunction.getValueParameters().size()) return false;
        Iterable $this$all$iv = CollectionsKt.zip((Iterable)irFunction.getValueParameters(), (Iterable)firFunction.getValueParameters());
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            void irParameter2;
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            Pair $dstr$irParameter$firParameter = (Pair)element$iv;
            boolean bl2 = false;
            IrValueParameter irValueParameter = (IrValueParameter)$dstr$irParameter$firParameter.component1();
            FirValueParameter firParameter = (FirValueParameter)$dstr$irParameter$firParameter.component2();
            IrType irType = irParameter2.getType();
            FirTypeRef firTypeRef = firParameter.getReturnTypeRef();
            if (firTypeRef == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
            }
            ConeKotlinType firType = ((FirResolvedTypeRef)firTypeRef).getType();
            if (!(irType instanceof IrSimpleType)) return false;
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)irType).getClassifier();
            if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
                bl = firType instanceof ConeTypeParameterType;
                continue;
            }
            if (!(irClassifierSymbol instanceof IrClassSymbol)) return false;
            IrClass irClass2 = (IrClass)((IrClassSymbol)irClassifierSymbol).getOwner();
            if (!(firType instanceof ConeClassLikeType)) return false;
            if (!Intrinsics.areEqual(irClass2.getName(), ((ConeClassLikeType)firType).getLookupTag().getName())) return false;
            bl = true;
        } while (bl);
        return false;
    }

    public final void preCacheBuiltinClassMembers$fir2ir(@NotNull FirRegularClass firClass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        for (FirDeclaration declaration2 : firClass.getDeclarations()) {
            IrConstructor irConstructor;
            IrOverridableMember irOverridableMember;
            block8: {
                IrDeclarationWithVisibility it;
                IrOverridableMember irOverridableMember2;
                Iterator<IrOverridableMember> iterator2;
                boolean bl;
                Sequence<IrOverridableMember> sequence2;
                boolean bl2;
                Sequence<IrDeclarationWithVisibility> sequence3;
                FirDeclaration firDeclaration = declaration2;
                if (firDeclaration instanceof FirProperty) {
                    IrProperty irProperty;
                    IrOverridableMember irOverridableMember3;
                    block6: {
                        sequence3 = IrUtilsKt.getProperties(irClass2);
                        bl2 = false;
                        sequence2 = sequence3;
                        bl = false;
                        iterator2 = sequence2.iterator();
                        while (iterator2.hasNext()) {
                            irOverridableMember2 = iterator2.next();
                            it = (IrProperty)irOverridableMember2;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(it.getName(), ((FirProperty)declaration2).getName())) continue;
                            irOverridableMember3 = irOverridableMember2;
                            break block6;
                        }
                        irOverridableMember3 = null;
                    }
                    if ((irProperty = (IrProperty)irOverridableMember3) == null) continue;
                    this.propertyCache.put((FirProperty)declaration2, irProperty);
                    continue;
                }
                if (firDeclaration instanceof FirSimpleFunction) {
                    IrSimpleFunction irFunction;
                    IrOverridableMember irOverridableMember4;
                    block7: {
                        sequence3 = IrUtilsKt.getFunctions(irClass2);
                        bl2 = false;
                        sequence2 = sequence3;
                        bl = false;
                        iterator2 = sequence2.iterator();
                        while (iterator2.hasNext()) {
                            irOverridableMember2 = iterator2.next();
                            it = (IrSimpleFunction)irOverridableMember2;
                            boolean bl4 = false;
                            if (!this.areCompatible((FirFunction)declaration2, (IrFunction)it)) continue;
                            irOverridableMember4 = irOverridableMember2;
                            break block7;
                        }
                        irOverridableMember4 = null;
                    }
                    if ((irFunction = (IrSimpleFunction)irOverridableMember4) == null) continue;
                    this.functionCache.put((FirFunction<?>)declaration2, irFunction);
                    continue;
                }
                if (!(firDeclaration instanceof FirConstructor)) continue;
                sequence3 = IrUtilsKt.getConstructors(irClass2);
                bl2 = false;
                sequence2 = sequence3;
                bl = false;
                iterator2 = sequence2.iterator();
                while (iterator2.hasNext()) {
                    irOverridableMember2 = iterator2.next();
                    it = (IrConstructor)((Object)irOverridableMember2);
                    boolean bl5 = false;
                    if (!this.areCompatible((FirFunction)declaration2, (IrFunction)it)) continue;
                    irOverridableMember = irOverridableMember2;
                    break block8;
                }
                irOverridableMember = null;
            }
            if ((irConstructor = (IrConstructor)((Object)irOverridableMember)) == null) continue;
            this.constructorCache.put((FirConstructor)declaration2, irConstructor);
        }
    }

    public final void registerFile(@NotNull FirFile firFile, @NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(firFile, "firFile");
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.fileCache.put(firFile, irFile);
    }

    @NotNull
    public final IrFile getIrFile(@NotNull FirFile firFile) {
        Intrinsics.checkNotNullParameter(firFile, "firFile");
        IrFile irFile = this.fileCache.get(firFile);
        Intrinsics.checkNotNull(irFile);
        return irFile;
    }

    public final void enterScope(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.getSymbolTable().enterScope(descriptor2);
        if (descriptor2 instanceof WrappedSimpleFunctionDescriptor || descriptor2 instanceof WrappedClassConstructorDescriptor || descriptor2 instanceof WrappedPropertyDescriptor || descriptor2 instanceof WrappedEnumEntryDescriptor) {
            this.localStorage.enterCallable();
        }
    }

    public final void leaveScope(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (descriptor2 instanceof WrappedSimpleFunctionDescriptor || descriptor2 instanceof WrappedClassConstructorDescriptor || descriptor2 instanceof WrappedPropertyDescriptor || descriptor2 instanceof WrappedEnumEntryDescriptor) {
            this.localStorage.leaveCallable();
        }
        this.getSymbolTable().leaveScope(descriptor2);
    }

    private final IrType toIrType(FirTypeRef $this$toIrType, ConversionTypeContext typeContext) {
        Fir2IrTypeConverter fir2IrTypeConverter = this.getTypeConverter();
        boolean bl = false;
        boolean bl2 = false;
        Fir2IrTypeConverter $this$with = fir2IrTypeConverter;
        boolean bl3 = false;
        return $this$with.toIrType($this$toIrType, typeContext);
    }

    static /* synthetic */ IrType toIrType$default(Fir2IrDeclarationStorage fir2IrDeclarationStorage, FirTypeRef firTypeRef, ConversionTypeContext conversionTypeContext, int n, Object object) {
        if ((n & 1) != 0) {
            conversionTypeContext = ConversionTypeContext.Companion.getDEFAULT$fir2ir();
        }
        return fir2IrDeclarationStorage.toIrType(firTypeRef, conversionTypeContext);
    }

    private final IrType toIrType(ConeKotlinType $this$toIrType, ConversionTypeContext typeContext) {
        Fir2IrTypeConverter fir2IrTypeConverter = this.getTypeConverter();
        boolean bl = false;
        boolean bl2 = false;
        Fir2IrTypeConverter $this$with = fir2IrTypeConverter;
        boolean bl3 = false;
        return $this$with.toIrType($this$toIrType, typeContext);
    }

    private final IrExternalPackageFragment getIrExternalOrBuiltInsPackageFragment(FqName fqName2) {
        boolean isBuiltIn = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAMES.contains(fqName2);
        return isBuiltIn ? this.getIrBuiltInsPackageFragment(fqName2) : this.getIrExternalPackageFragment(fqName2);
    }

    private final IrExternalPackageFragment getIrBuiltInsPackageFragment(FqName fqName2) {
        Map<FqName, IrExternalPackageFragment> $this$getOrPut$iv = this.builtInsFragmentCache;
        boolean $i$f$getOrPut = false;
        IrExternalPackageFragment value$iv = $this$getOrPut$iv.get(fqName2);
        if (value$iv == null) {
            boolean bl = false;
            return this.getSymbolTable().declareExternalPackageFragment(new FirBuiltInsPackageFragment(fqName2, this.moduleDescriptor));
        }
        return value$iv;
    }

    private final IrExternalPackageFragment getIrExternalPackageFragment(FqName fqName2) {
        Map<FqName, IrExternalPackageFragment> $this$getOrPut$iv = this.fragmentCache;
        boolean $i$f$getOrPut = false;
        IrExternalPackageFragment value$iv = $this$getOrPut$iv.get(fqName2);
        if (value$iv == null) {
            boolean bl = false;
            return this.getSymbolTable().declareExternalPackageFragment(new FirPackageFragmentDescriptor(fqName2, this.moduleDescriptor));
        }
        return value$iv;
    }

    public final void addDeclarationsToExternalClass$fir2ir(@NotNull FirRegularClass regularClass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        if (Intrinsics.areEqual(regularClass.getOrigin(), FirDeclarationOrigin.Java.INSTANCE)) {
            FirSimpleFunction sam2 = ConversionUtilsKt.getSamIfAny(regularClass);
            if (sam2 != null) {
                FirScope firScope = SupertypeUtilsKt.buildUseSiteMemberScope(regularClass, this.getSession(), this.getScopeSession());
                Intrinsics.checkNotNull(firScope);
                FirScope scope2 = firScope;
                scope2.processFunctionsByName(sam2.getName(), new Function1<FirFunctionSymbol<?>, Unit>(this, irClass2){
                    final /* synthetic */ Fir2IrDeclarationStorage this$0;
                    final /* synthetic */ IrClass $irClass;

                    public final void invoke(@NotNull FirFunctionSymbol<?> it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (it instanceof FirNamedFunctionSymbol && !((FirNamedFunctionSymbol)it).isFakeOverride()) {
                            Collection collection = this.$irClass.getDeclarations();
                            IrSimpleFunction irSimpleFunction = Fir2IrDeclarationStorage.createIrFunction$default(this.this$0, (FirFunction)((FirNamedFunctionSymbol)it).getFir(), this.$irClass, null, null, 12, null);
                            boolean bl = false;
                            collection.add(irSimpleFunction);
                        }
                    }
                    {
                        this.this$0 = fir2IrDeclarationStorage;
                        this.$irClass = irClass2;
                        super(1);
                    }
                });
            }
        } else if (regularClass.getSymbol().getClassId().getPackageFqName().startsWith(Name.identifier("kotlin"))) {
            Collection collection;
            boolean scope2 = false;
            Set processedNames = new LinkedHashSet();
            FirScope firScope = SupertypeUtilsKt.buildUseSiteMemberScope(regularClass, this.getSession(), this.getScopeSession());
            Intrinsics.checkNotNull(firScope);
            FirScope scope22 = firScope;
            scope22.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)new Function1<FirConstructorSymbol, Unit>(this, irClass2){
                final /* synthetic */ Fir2IrDeclarationStorage this$0;
                final /* synthetic */ IrClass $irClass;

                public final void invoke(@NotNull FirConstructorSymbol it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    Collection collection = this.$irClass.getDeclarations();
                    IrConstructor irConstructor = Fir2IrDeclarationStorage.createIrConstructor$default(this.this$0, (FirConstructor)it.getFir(), this.$irClass, null, 4, null);
                    boolean bl = false;
                    collection.add(irConstructor);
                }
                {
                    this.this$0 = fir2IrDeclarationStorage;
                    this.$irClass = irClass2;
                    super(1);
                }
            });
            for (FirDeclaration declaration2 : regularClass.getDeclarations()) {
                boolean bl;
                Object object;
                FirDeclaration firDeclaration = declaration2;
                if (firDeclaration instanceof FirSimpleFunction) {
                    if (processedNames.contains(((FirSimpleFunction)declaration2).getName())) continue;
                    collection = processedNames;
                    object = ((FirSimpleFunction)declaration2).getName();
                    bl = false;
                    collection.add(object);
                    scope22.processFunctionsByName(((FirSimpleFunction)declaration2).getName(), new Function1<FirFunctionSymbol<?>, Unit>(this, irClass2){
                        final /* synthetic */ Fir2IrDeclarationStorage this$0;
                        final /* synthetic */ IrClass $irClass;

                        public final void invoke(@NotNull FirFunctionSymbol<?> it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            if (it instanceof FirNamedFunctionSymbol) {
                                if (!((FirNamedFunctionSymbol)it).isFakeOverride()) {
                                    Collection collection = this.$irClass.getDeclarations();
                                    IrSimpleFunction irSimpleFunction = Fir2IrDeclarationStorage.createIrFunction$default(this.this$0, (FirFunction)((FirNamedFunctionSymbol)it).getFir(), this.$irClass, null, null, 12, null);
                                    boolean bl = false;
                                    collection.add(irSimpleFunction);
                                } else {
                                    FirNamedFunctionSymbol fakeOverrideSymbol = FirClassSubstitutionScope.Companion.createFakeOverrideFunction$default(FirClassSubstitutionScope.Companion, this.this$0.getSession(), (FirSimpleFunction)((FirNamedFunctionSymbol)it).getFir(), (FirNamedFunctionSymbol)it, null, null, null, null, null, 248, null);
                                    this.this$0.getClassifierStorage().preCacheTypeParameters$fir2ir((FirTypeParameterRefsOwner)((FirNamedFunctionSymbol)it).getFir());
                                    Collection collection = this.$irClass.getDeclarations();
                                    IrSimpleFunction irSimpleFunction = Fir2IrDeclarationStorage.createIrFunction$default(this.this$0, (FirFunction)fakeOverrideSymbol.getFir(), this.$irClass, null, null, 12, null);
                                    boolean bl = false;
                                    collection.add(irSimpleFunction);
                                }
                            }
                        }
                        {
                            this.this$0 = fir2IrDeclarationStorage;
                            this.$irClass = irClass2;
                            super(1);
                        }
                    });
                    continue;
                }
                if (firDeclaration instanceof FirProperty) {
                    if (processedNames.contains(((FirProperty)declaration2).getName())) continue;
                    collection = processedNames;
                    object = ((FirProperty)declaration2).getName();
                    bl = false;
                    collection.add(object);
                    scope22.processPropertiesByName(((FirProperty)declaration2).getName(), new Function1<FirVariableSymbol<?>, Unit>(this, irClass2){
                        final /* synthetic */ Fir2IrDeclarationStorage this$0;
                        final /* synthetic */ IrClass $irClass;

                        public final void invoke(@NotNull FirVariableSymbol<?> it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            if (it instanceof FirPropertySymbol) {
                                if (!((FirPropertySymbol)it).isFakeOverride()) {
                                    Collection collection = this.$irClass.getDeclarations();
                                    IrProperty irProperty = Fir2IrDeclarationStorage.createIrProperty$default(this.this$0, (FirProperty)((FirPropertySymbol)it).getFir(), this.$irClass, null, null, 12, null);
                                    boolean bl = false;
                                    collection.add(irProperty);
                                } else {
                                    FirPropertySymbol fakeOverrideSymbol = FirClassSubstitutionScope.Companion.createFakeOverrideProperty$default(FirClassSubstitutionScope.Companion, this.this$0.getSession(), (FirProperty)((FirPropertySymbol)it).getFir(), (FirPropertySymbol)it, null, null, null, null, 120, null);
                                    this.this$0.getClassifierStorage().preCacheTypeParameters$fir2ir((FirTypeParameterRefsOwner)((FirPropertySymbol)it).getFir());
                                    Collection collection = this.$irClass.getDeclarations();
                                    IrProperty irProperty = Fir2IrDeclarationStorage.createIrProperty$default(this.this$0, (FirProperty)fakeOverrideSymbol.getFir(), this.$irClass, null, null, 12, null);
                                    boolean bl = false;
                                    collection.add(irProperty);
                                }
                            }
                        }
                        {
                            this.this$0 = fir2IrDeclarationStorage;
                            this.$irClass = irClass2;
                            super(1);
                        }
                    });
                    continue;
                }
                if (!(firDeclaration instanceof FirRegularClass)) continue;
                collection = irClass2.getDeclarations();
                object = this.getClassifierStorage().createIrClass$fir2ir((FirClass)declaration2, irClass2);
                bl = false;
                collection.add(object);
            }
            Set<Name> allNames2 = ConversionUtilsKt.collectCallableNamesFromSupertypes(regularClass, this.getSession());
            for (Name name : allNames2) {
                if (processedNames.contains(name)) continue;
                collection = processedNames;
                boolean bl = false;
                collection.add(name);
                scope22.processFunctionsByName(name, new Function1<FirFunctionSymbol<?>, Unit>(this, irClass2){
                    final /* synthetic */ Fir2IrDeclarationStorage this$0;
                    final /* synthetic */ IrClass $irClass;

                    public final void invoke(@NotNull FirFunctionSymbol<?> functionSymbol) {
                        Intrinsics.checkNotNullParameter(functionSymbol, "functionSymbol");
                        if (functionSymbol instanceof FirNamedFunctionSymbol) {
                            FirNamedFunctionSymbol fakeOverrideSymbol = FirClassSubstitutionScope.Companion.createFakeOverrideFunction$default(FirClassSubstitutionScope.Companion, this.this$0.getSession(), (FirSimpleFunction)((FirNamedFunctionSymbol)functionSymbol).getFir(), (FirNamedFunctionSymbol)functionSymbol, null, null, null, null, null, 248, null);
                            this.this$0.getClassifierStorage().preCacheTypeParameters$fir2ir((FirTypeParameterRefsOwner)((FirNamedFunctionSymbol)functionSymbol).getFir());
                            Collection collection = this.$irClass.getDeclarations();
                            IrSimpleFunction irSimpleFunction = Fir2IrDeclarationStorage.createIrFunction$default(this.this$0, (FirFunction)fakeOverrideSymbol.getFir(), this.$irClass, null, null, 12, null);
                            boolean bl = false;
                            collection.add(irSimpleFunction);
                        }
                    }
                    {
                        this.this$0 = fir2IrDeclarationStorage;
                        this.$irClass = irClass2;
                        super(1);
                    }
                });
                scope22.processPropertiesByName(name, new Function1<FirVariableSymbol<?>, Unit>(this, irClass2){
                    final /* synthetic */ Fir2IrDeclarationStorage this$0;
                    final /* synthetic */ IrClass $irClass;

                    public final void invoke(@NotNull FirVariableSymbol<?> propertySymbol) {
                        Intrinsics.checkNotNullParameter(propertySymbol, "propertySymbol");
                        if (propertySymbol instanceof FirPropertySymbol) {
                            FirPropertySymbol fakeOverrideSymbol = FirClassSubstitutionScope.Companion.createFakeOverrideProperty$default(FirClassSubstitutionScope.Companion, this.this$0.getSession(), (FirProperty)((FirPropertySymbol)propertySymbol).getFir(), (FirPropertySymbol)propertySymbol, null, null, null, null, 120, null);
                            this.this$0.getClassifierStorage().preCacheTypeParameters$fir2ir((FirTypeParameterRefsOwner)((FirPropertySymbol)propertySymbol).getFir());
                            Collection collection = this.$irClass.getDeclarations();
                            IrProperty irProperty = Fir2IrDeclarationStorage.createIrProperty$default(this.this$0, (FirProperty)fakeOverrideSymbol.getFir(), this.$irClass, null, null, 12, null);
                            boolean bl = false;
                            collection.add(irProperty);
                        }
                    }
                    {
                        this.this$0 = fir2IrDeclarationStorage;
                        this.$irClass = irClass2;
                        super(1);
                    }
                });
            }
            for (IrDeclaration irDeclaration2 : irClass2.getDeclarations()) {
                irDeclaration2.setParent(irClass2);
            }
        }
    }

    @Nullable
    public final IrDeclarationParent findIrParent$fir2ir(@NotNull FqName packageFqName, @Nullable ClassId parentClassId, @NotNull FirBasedSymbol<?> firBasedSymbol) {
        IrDeclarationParent irDeclarationParent;
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(firBasedSymbol, "firBasedSymbol");
        if (parentClassId != null) {
            IrClass irClass2;
            FirClassLikeSymbol<?> parentFirSymbol = this.firSymbolProvider.getClassLikeSymbolByFqName(parentClassId);
            if (parentFirSymbol instanceof FirClassSymbol) {
                IrClassSymbol parentIrSymbol = this.getClassifierStorage().getIrClassSymbol((FirClassSymbol)parentFirSymbol);
                irClass2 = (IrClass)parentIrSymbol.getOwner();
            } else {
                irClass2 = null;
            }
            irDeclarationParent = irClass2;
        } else {
            FirFile firFile;
            FirBasedSymbol<?> firBasedSymbol2 = firBasedSymbol;
            if (firBasedSymbol2 instanceof FirCallableSymbol) {
                firFile = this.firProvider.getFirCallableContainerFile((FirCallableSymbol)firBasedSymbol);
            } else if (firBasedSymbol2 instanceof FirClassLikeSymbol) {
                firFile = this.firProvider.getFirClassifierContainerFileIfAny((FirClassLikeSymbol)firBasedSymbol);
            } else {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected: " + firBasedSymbol)));
            }
            FirFile containerFile = firFile;
            irDeclarationParent = containerFile != null ? (IrPackageFragment)this.fileCache.get(containerFile) : (firBasedSymbol instanceof FirCallableSymbol ? (IrPackageFragment)this.getIrExternalPackageFragment(packageFqName) : (IrPackageFragment)this.getIrExternalOrBuiltInsPackageFragment(packageFqName));
        }
        return irDeclarationParent;
    }

    @Nullable
    public final IrDeclarationParent findIrParent$fir2ir(@NotNull FirCallableDeclaration<?> callableDeclaration) {
        Intrinsics.checkNotNullParameter(callableDeclaration, "callableDeclaration");
        FirCallableSymbol<?> firBasedSymbol = callableDeclaration.getSymbol();
        CallableId callableId = firBasedSymbol.getCallableId();
        return this.findIrParent$fir2ir(callableId.getPackageName(), callableId.getClassId(), (FirBasedSymbol)firBasedSymbol);
    }

    private final void setAndModifyParent(IrDeclaration $this$setAndModifyParent, IrDeclarationParent irParent) {
        if (irParent != null) {
            $this$setAndModifyParent.setParent(irParent);
            if (irParent instanceof IrExternalPackageFragment) {
                Collection collection = ((IrExternalPackageFragment)irParent).getDeclarations();
                boolean bl = false;
                collection.add($this$setAndModifyParent);
            } else {
                boolean cfr_ignored_0 = irParent instanceof IrClass;
            }
        }
    }

    private final <T extends IrFunction> T declareDefaultSetterParameter(T $this$declareDefaultSetterParameter, IrType type2) {
        T parent2 = $this$declareDefaultSetterParameter;
        WrappedValueParameterDescriptor descriptor2 = new WrappedValueParameterDescriptor(null, null, 3, null);
        $this$declareDefaultSetterParameter.setValueParameters(CollectionsKt.listOf(SymbolTable.declareValueParameter$default(this.getSymbolTable(), $this$declareDefaultSetterParameter.getStartOffset(), $this$declareDefaultSetterParameter.getEndOffset(), $this$declareDefaultSetterParameter.getOrigin(), descriptor2, type2, null, new Function1<IrValueParameterSymbol, IrValueParameter>($this$declareDefaultSetterParameter, type2, parent2, descriptor2){
            final /* synthetic */ IrFunction $this_declareDefaultSetterParameter;
            final /* synthetic */ IrType $type;
            final /* synthetic */ IrFunction $parent;
            final /* synthetic */ WrappedValueParameterDescriptor $descriptor;

            @NotNull
            public final IrValueParameter invoke(@NotNull IrValueParameterSymbol symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                int n = this.$this_declareDefaultSetterParameter.getStartOffset();
                int n2 = this.$this_declareDefaultSetterParameter.getEndOffset();
                IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
                Name name = Name.special("<set-?>");
                Intrinsics.checkNotNullExpressionValue(name, "Name.special(\"<set-?>\")");
                IrValueParameterImpl irValueParameterImpl = new IrValueParameterImpl(n, n2, irDeclarationOrigin, symbol2, name, 0, this.$type, null, false, false);
                boolean bl = false;
                boolean bl2 = false;
                IrValueParameterImpl $this$apply = irValueParameterImpl;
                boolean bl3 = false;
                $this$apply.setParent(this.$parent);
                this.$descriptor.bind((IrDeclaration)$this$apply);
                return irValueParameterImpl;
            }
            {
                this.$this_declareDefaultSetterParameter = irFunction;
                this.$type = irType;
                this.$parent = irFunction2;
                this.$descriptor = wrappedValueParameterDescriptor;
                super(1);
            }
        }, 32, null)));
        return $this$declareDefaultSetterParameter;
    }

    /*
     * Unable to fully structure code
     */
    private final <T extends IrFunction> void declareParameters(T $this$declareParameters, FirFunction<?> function, IrClass containingClass, boolean isStatic, FirTypeRef parentPropertyReceiverType) {
        block15: {
            block14: {
                parent = $this$declareParameters;
                if (function instanceof FirSimpleFunction || function instanceof FirConstructor) {
                    var7_7 = this.getClassifierStorage();
                    var8_9 = false;
                    var9_11 = false;
                    $this$with = var7_7;
                    $i$a$-with-Fir2IrDeclarationStorage$declareParameters$1 = false;
                    Fir2IrClassifierStorage.setTypeParameters$fir2ir$default($this$with, $this$declareParameters, function, null, 2, null);
                }
                forSetter = function instanceof FirPropertyAccessor != false && ((FirPropertyAccessor)function).isSetter() != false;
                typeContext = new ConversionTypeContext(false, forSetter != false ? ConversionTypeOrigin.SETTER : ConversionTypeOrigin.DEFAULT);
                if (!(function instanceof FirDefaultPropertySetter)) break block14;
                type = this.toIrType(CollectionsKt.first(((FirDefaultPropertySetter)function).getValueParameters()).getReturnTypeRef(), ConversionTypeContext.Companion.getDEFAULT$fir2ir().inSetter());
                this.declareDefaultSetterParameter($this$declareParameters, type);
                break block15;
            }
            if (function == null) break block15;
            type = function.getValueParameters();
            var27_20 = $this$declareParameters;
            $i$f$mapIndexed = false;
            $i$a$-with-Fir2IrDeclarationStorage$declareParameters$1 = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            $i$f$mapIndexedTo = false;
            index$iv$iv = 0;
            for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                var17_27 = index$iv$iv++;
                var18_28 = false;
                if (var17_27 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                var19_29 = (FirValueParameter)item$iv$iv;
                var20_30 = var17_27;
                var28_37 = destination$iv$iv;
                $i$a$-mapIndexed-Fir2IrDeclarationStorage$declareParameters$2 = false;
                if (!(function instanceof FirConstructor)) ** GOTO lbl-1000
                v0 = containingClass;
                if (Intrinsics.areEqual(v0 != null ? v0.getName() : null, Name.identifier("Enum")) ^ true) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                var22_32 = this.createIrParameter((FirValueParameter)valueParameter, (int)index, v1, typeContext);
                var23_33 = false;
                var24_34 = false;
                $this$apply = var22_32;
                $i$a$-apply-Fir2IrDeclarationStorage$declareParameters$2$1 = false;
                $this$apply.setParent(parent);
                var29_38 = var22_32;
                var28_37.add(var29_38);
            }
            var28_37 = (List)destination$iv$iv;
            var27_20.setValueParameters((List<IrValueParameter>)var28_37);
        }
        var9_14 = this.getClassifierStorage();
        var10_17 = false;
        var11_18 = false;
        $this$with = var9_14;
        $i$a$-with-Fir2IrDeclarationStorage$declareParameters$3 = false;
        thisOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        if (!(function instanceof FirConstructor)) {
            if (!(function instanceof FirPropertyAccessor)) {
                v2 = function;
                v3 = v2 != null ? v2.getReceiverTypeRef() : null;
            } else {
                v3 = receiverTypeRef = parentPropertyReceiverType;
            }
            if (receiverTypeRef != null) {
                $this$declareParameters.setExtensionReceiverParameter((IrValueParameter)ConversionUtilsKt.convertWithOffsets(receiverTypeRef, (Function2)new Function2<Integer, Integer, IrValueParameter>($this$with, receiverTypeRef, thisOrigin, this, $this$declareParameters, function, parentPropertyReceiverType, typeContext, containingClass, isStatic){
                    final /* synthetic */ Fir2IrClassifierStorage $this_with;
                    final /* synthetic */ FirTypeRef $receiverTypeRef;
                    final /* synthetic */ IrDeclarationOrigin.DEFINED $thisOrigin;
                    final /* synthetic */ Fir2IrDeclarationStorage this$0;
                    final /* synthetic */ IrFunction $this_declareParameters$inlined;
                    final /* synthetic */ FirFunction $function$inlined;
                    final /* synthetic */ FirTypeRef $parentPropertyReceiverType$inlined;
                    final /* synthetic */ ConversionTypeContext $typeContext$inlined;
                    final /* synthetic */ IrClass $containingClass$inlined;
                    final /* synthetic */ boolean $isStatic$inlined;
                    {
                        this.$this_with = fir2IrClassifierStorage;
                        this.$receiverTypeRef = firTypeRef;
                        this.$thisOrigin = dEFINED;
                        this.this$0 = fir2IrDeclarationStorage;
                        this.$this_declareParameters$inlined = irFunction;
                        this.$function$inlined = firFunction;
                        this.$parentPropertyReceiverType$inlined = firTypeRef2;
                        this.$typeContext$inlined = conversionTypeContext;
                        this.$containingClass$inlined = irClass2;
                        this.$isStatic$inlined = bl;
                        super(2);
                    }

                    @NotNull
                    public final IrValueParameter invoke(int startOffset, int endOffset) {
                        return ConversionUtilsKt.declareThisReceiverParameter(this.$this_declareParameters$inlined, this.$this_with.getSymbolTable(), Fir2IrDeclarationStorage.access$toIrType(this.this$0, this.$receiverTypeRef, this.$typeContext$inlined), this.$thisOrigin, startOffset, endOffset);
                    }
                }));
            }
            if (!(function instanceof FirAnonymousFunction) && containingClass != null && !isStatic) {
                v4 = $this$declareParameters;
                v5 = $this$with.getSymbolTable();
                v6 = containingClass.getThisReceiver();
                Intrinsics.checkNotNull(v6);
                $this$declareParameters.setDispatchReceiverParameter(ConversionUtilsKt.declareThisReceiverParameter$default(v4, v5, v6.getType(), thisOrigin, 0, 0, 24, null));
            }
        } else {
            v7 = containingClass;
            outerClass = v7 != null ? IrUtilsKt.getParentClassOrNull(v7) : null;
            v8 = containingClass;
            if (v8 != null) {
                if (v8.isInner()) {
                    if (outerClass != null) {
                        v9 = $this$declareParameters;
                        v10 = $this$with.getSymbolTable();
                        v11 = outerClass.getThisReceiver();
                        Intrinsics.checkNotNull(v11);
                        $this$declareParameters.setDispatchReceiverParameter(ConversionUtilsKt.declareThisReceiverParameter$default(v9, v10, v11.getType(), thisOrigin, 0, 0, 24, null));
                    }
                }
            }
        }
    }

    private final <T extends IrFunction> T bindAndDeclareParameters(T $this$bindAndDeclareParameters, FirFunction<?> function2, WrappedCallableDescriptor<T> descriptor2, IrDeclarationParent irParent, IrClass thisReceiverOwner, boolean isStatic, FirTypeRef parentPropertyReceiverType) {
        if (irParent != null) {
            $this$bindAndDeclareParameters.setParent(irParent);
        }
        descriptor2.bind($this$bindAndDeclareParameters);
        this.declareParameters($this$bindAndDeclareParameters, function2, thisReceiverOwner, isStatic, parentPropertyReceiverType);
        return $this$bindAndDeclareParameters;
    }

    static /* synthetic */ IrFunction bindAndDeclareParameters$default(Fir2IrDeclarationStorage fir2IrDeclarationStorage, IrFunction irFunction, FirFunction firFunction, WrappedCallableDescriptor wrappedCallableDescriptor, IrDeclarationParent irDeclarationParent, IrClass irClass2, boolean bl, FirTypeRef firTypeRef, int n, Object object) {
        if ((n & 8) != 0) {
            IrDeclarationParent irDeclarationParent2 = irDeclarationParent;
            if (!(irDeclarationParent2 instanceof IrClass)) {
                irDeclarationParent2 = null;
            }
            irClass2 = (IrClass)irDeclarationParent2;
        }
        if ((n & 0x20) != 0) {
            firTypeRef = null;
        }
        return fir2IrDeclarationStorage.bindAndDeclareParameters(irFunction, firFunction, wrappedCallableDescriptor, irDeclarationParent, irClass2, bl, firTypeRef);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends IrFunction> T putParametersInScope(@NotNull T $this$putParametersInScope, @NotNull FirFunction<?> function2) {
        Intrinsics.checkNotNullParameter($this$putParametersInScope, "$this$putParametersInScope");
        Intrinsics.checkNotNullParameter(function2, "function");
        for (Pair pair : CollectionsKt.zip((Iterable)function2.getValueParameters(), (Iterable)$this$putParametersInScope.getValueParameters())) {
            void firParameter;
            FirValueParameter firValueParameter = (FirValueParameter)pair.component1();
            IrValueParameter irParameter2 = (IrValueParameter)pair.component2();
            this.localStorage.putParameter((FirValueParameter)firParameter, irParameter2);
        }
        return $this$putParametersInScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final IrSimpleFunction getCachedIrFunction(@NotNull FirFunction<?> function2) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter(function2, "function");
        if (function2 instanceof FirSimpleFunction) {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)((Object)function2);
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.LOCAL)) {
                irSimpleFunction = this.functionCache.get(function2);
                return irSimpleFunction;
            }
        }
        irSimpleFunction = this.localStorage.getLocalFunction(function2);
        return irSimpleFunction;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final IrSimpleFunction createIrFunction(@NotNull FirFunction<?> function, @Nullable IrDeclarationParent irParent, @Nullable IrClass thisReceiverOwner, @NotNull IrDeclarationOrigin origin) {
        block26: {
            block25: {
                block24: {
                    block23: {
                        block21: {
                            block22: {
                                block20: {
                                    Intrinsics.checkNotNullParameter(function, "function");
                                    Intrinsics.checkNotNullParameter(origin, "origin");
                                    v0 = function;
                                    if (!(v0 instanceof FirSimpleFunction)) {
                                        v0 = null;
                                    }
                                    v1 = simpleFunction = (FirSimpleFunction)v0;
                                    v2 = containerSource = v1 != null ? v1.getContainerSource() : null;
                                    if (v2 != null) {
                                        var8_7 = v2;
                                        var9_9 = false;
                                        var10_11 = false;
                                        it = var8_7;
                                        $i$a$-let-Fir2IrDeclarationStorage$createIrFunction$descriptor$1 = false;
                                        v3 = new WrappedFunctionDescriptorWithContainerSource(it);
                                    } else {
                                        v3 = new WrappedSimpleFunctionDescriptor(null, null, 3, null);
                                    }
                                    descriptor = v3;
                                    v4 = function.getSource();
                                    isLambda = Intrinsics.areEqual(v4 != null ? v4.getElementType() : null, KtNodeTypes.FUNCTION_LITERAL);
                                    if (!isLambda) break block20;
                                    v5 = IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE;
                                    break block21;
                                }
                                if (!ResolveUtilsKt.isKFunctionInvoke(function.getSymbol().getCallableId())) break block22;
                                v5 = IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE;
                                break block21;
                            }
                            v6 = simpleFunction;
                            if (v6 == null) ** GOTO lbl-1000
                            $this$isStatic$iv = v6;
                            $i$f$isStatic = false;
                            if (!$this$isStatic$iv.getStatus().isStatic()) ** GOTO lbl-1000
                            $this$isStatic$iv = Fir2IrDeclarationStorage.ENUM_SYNTHETIC_NAMES;
                            $i$f$isStatic = simpleFunction.getName();
                            $i$a$-let-Fir2IrDeclarationStorage$createIrFunction$descriptor$1 = false;
                            var13_22 = $this$isStatic$iv;
                            var14_26 = false;
                            if (var13_22.containsKey($i$f$isStatic)) {
                                v5 = IrDeclarationOrigin.ENUM_CLASS_SPECIAL_MEMBER.INSTANCE;
                            } else lbl-1000:
                            // 3 sources

                            {
                                v5 = origin;
                            }
                        }
                        updatedOrigin = v5;
                        this.getClassifierStorage().preCacheTypeParameters$fir2ir(function);
                        v7 = simpleFunction;
                        if (v7 == null || (v7 = v7.getName()) == null) {
                            v8 = isLambda != false ? Name.special("<anonymous>") : Name.special("<no name provided>");
                            v7 = v8;
                            Intrinsics.checkNotNullExpressionValue(v8, "if (isLambda) Name.speci\u2026ial(\"<no name provided>\")");
                        }
                        name = v7;
                        v9 = simpleFunction;
                        if (v9 == null) break block23;
                        $this$visibility$iv = (FirMemberDeclaration)v9;
                        $i$f$getVisibility = false;
                        v9 = $this$visibility$iv.getStatus().getVisibility();
                        if (v9 != null) break block24;
                    }
                    v10 = Visibilities.LOCAL;
                    v9 = v10;
                    Intrinsics.checkNotNullExpressionValue(v10, "Visibilities.LOCAL");
                }
                visibility = v9;
                if (!isLambda) break block25;
                v11 = ((FirAnonymousFunction)function).getTypeRef();
                if (!(v11 instanceof FirResolvedTypeRef)) {
                    v11 = null;
                }
                v12 = (FirResolvedTypeRef)v11;
                v13 = v12 != null && v12.isSuspend();
                break block26;
            }
            v14 = simpleFunction;
            if (v14 == null) ** GOTO lbl-1000
            $this$isSuspend$iv = v14;
            $i$f$isSuspend = false;
            if ($this$isSuspend$iv.getStatus().isSuspend()) {
                v13 = true;
            } else lbl-1000:
            // 2 sources

            {
                v13 = false;
            }
        }
        isSuspend = v13;
        v15 = (IrFunction)ConversionUtilsKt.convertWithOffsets(function, (Function2)new Function2<Integer, Integer, IrSimpleFunction>(this, descriptor, updatedOrigin, (Name)name, (Visibility)visibility, simpleFunction, function, isSuspend){
            final /* synthetic */ Fir2IrDeclarationStorage this$0;
            final /* synthetic */ WrappedSimpleFunctionDescriptor $descriptor;
            final /* synthetic */ IrDeclarationOrigin $updatedOrigin;
            final /* synthetic */ Name $name;
            final /* synthetic */ Visibility $visibility;
            final /* synthetic */ FirSimpleFunction $simpleFunction;
            final /* synthetic */ FirFunction $function;
            final /* synthetic */ boolean $isSuspend;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IrSimpleFunction invoke(int startOffset, int endOffset) {
                void var3_3;
                this.this$0.enterScope(this.$descriptor);
                IrSimpleFunction result2 = this.this$0.getSymbolTable().declareSimpleFunction(this.$descriptor, (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(this, startOffset, endOffset){
                    final /* synthetic */ createIrFunction.created.1 this$0;
                    final /* synthetic */ int $startOffset;
                    final /* synthetic */ int $endOffset;

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    @NotNull
                    public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol symbol) {
                        block14: {
                            block13: {
                                Intrinsics.checkNotNullParameter(symbol, "symbol");
                                v0 = this.this$0.$updatedOrigin;
                                v1 = this.this$0.$name;
                                v2 = this.this$0.$visibility;
                                v3 /* !! */  = this.this$0.$simpleFunction;
                                if (v3 /* !! */  == null) break block13;
                                $this$modality$iv = v3 /* !! */ ;
                                $i$f$getModality = false;
                                v3 /* !! */  = $this$modality$iv.getStatus().getModality();
                                if (v3 /* !! */  != null) break block14;
                            }
                            v3 /* !! */  = Modality.FINAL;
                        }
                        v4 = Fir2IrDeclarationStorage.toIrType$default(this.this$0.this$0, this.this$0.$function.getReturnTypeRef(), null, 1, null);
                        v5 = this.this$0.$simpleFunction;
                        if (v5 == null) ** GOTO lbl-1000
                        $this$isInline$iv = v5;
                        $i$f$isInline = false;
                        if ($this$isInline$iv.getStatus().isInline()) {
                            v6 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v6 = false;
                        }
                        v7 = this.this$0.$simpleFunction;
                        if (v7 == null) ** GOTO lbl-1000
                        $this$isExternal$iv = v7;
                        $i$f$isExternal = false;
                        if ($this$isExternal$iv.getStatus().isExternal()) {
                            v8 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v8 = false;
                        }
                        v9 = this.this$0.$simpleFunction;
                        if (v9 == null) ** GOTO lbl-1000
                        $this$isTailRec$iv = v9;
                        $i$f$isTailRec = false;
                        if ($this$isTailRec$iv.getStatus().isTailRec()) {
                            v10 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v10 = false;
                        }
                        v11 = this.this$0.$isSuspend;
                        v12 = this.this$0.$simpleFunction;
                        if (v12 == null) ** GOTO lbl-1000
                        $this$isExpect$iv = v12;
                        $i$f$isExpect = false;
                        if ($this$isExpect$iv.getStatus().isExpect()) {
                            v13 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v13 = false;
                        }
                        v14 = Intrinsics.areEqual(this.this$0.$updatedOrigin, IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE);
                        v15 = this.this$0.$simpleFunction;
                        if (v15 == null) ** GOTO lbl-1000
                        $this$isOperator$iv = v15;
                        $i$f$isOperator = false;
                        if ($this$isOperator$iv.getStatus().isOperator()) {
                            v16 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v16 = false;
                        }
                        var2_3 = v16;
                        var3_5 = v14;
                        var4_6 = v13;
                        var2_4 = new IrFunctionImpl(this.$startOffset, this.$endOffset, v0, symbol, v1, v2, (Modality)v3 /* !! */ , v4, v6, v8, v10, v11, var2_3, var4_6, var3_5);
                        var3_5 = false;
                        var4_6 = false;
                        $this$apply = var2_4;
                        $i$a$-apply-Fir2IrDeclarationStorage$createIrFunction$created$1$result$1$1 = false;
                        $this$apply.setMetadata(new FirMetadataSource.Function(this.this$0.$function, this.this$0.$descriptor));
                        return var2_4;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$startOffset = n;
                        this.$endOffset = n2;
                        super(1);
                    }
                });
                return var3_3;
            }
            {
                this.this$0 = fir2IrDeclarationStorage;
                this.$descriptor = wrappedSimpleFunctionDescriptor;
                this.$updatedOrigin = irDeclarationOrigin;
                this.$name = name;
                this.$visibility = visibility;
                this.$simpleFunction = firSimpleFunction;
                this.$function = firFunction;
                this.$isSuspend = bl;
                super(2);
            }
        });
        v16 = descriptor;
        v17 = simpleFunction;
        if (v17 == null) ** GOTO lbl-1000
        $this$isStatic$iv = v17;
        $i$f$isStatic = false;
        if ($this$isStatic$iv.getStatus().isStatic()) {
            v18 = true;
        } else lbl-1000:
        // 2 sources

        {
            v18 = false;
        }
        created = (IrSimpleFunction)Fir2IrDeclarationStorage.bindAndDeclareParameters$default(this, v15, function, v16, irParent, thisReceiverOwner, v18, null, 32, null);
        this.leaveScope(created.getDescriptor());
        if (Intrinsics.areEqual(visibility, Visibilities.LOCAL)) {
            this.localStorage.putLocalFunction(function, created);
            return created;
        }
        if (ResolveUtilsKt.isKFunctionInvoke(function.getSymbol().getCallableId())) {
            v19 = function.getSymbol().getOverriddenSymbol();
            if (!(v19 instanceof FirNamedFunctionSymbol)) {
                v19 = null;
            }
            v20 = (FirNamedFunctionSymbol)v19;
            if (v20 != null) {
                var14_28 = v20;
                var15_29 = false;
                var16_30 = false;
                it = var14_28;
                $i$a$-let-Fir2IrDeclarationStorage$createIrFunction$1 = false;
                v21 = created;
                v22 = this.getIrFunctionSymbol(it);
                if (v22 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol");
                }
                v21.setOverriddenSymbols(CollectionsKt.plus((Collection)v21.getOverriddenSymbols(), (IrSimpleFunctionSymbol)v22));
            }
        }
        if (!created.isFakeOverride() && thisReceiverOwner != null) {
            this.populateOverriddenSymbols(created, thisReceiverOwner);
        }
        this.functionCache.put(function, created);
        return created;
    }

    public static /* synthetic */ IrSimpleFunction createIrFunction$default(Fir2IrDeclarationStorage fir2IrDeclarationStorage, FirFunction firFunction, IrDeclarationParent irDeclarationParent, IrClass irClass2, IrDeclarationOrigin irDeclarationOrigin, int n, Object object) {
        if ((n & 4) != 0) {
            IrDeclarationParent irDeclarationParent2 = irDeclarationParent;
            if (!(irDeclarationParent2 instanceof IrClass)) {
                irDeclarationParent2 = null;
            }
            irClass2 = (IrClass)irDeclarationParent2;
        }
        if ((n & 8) != 0) {
            irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        }
        return fir2IrDeclarationStorage.createIrFunction(firFunction, irDeclarationParent, irClass2, irDeclarationOrigin);
    }

    @Nullable
    public final IrAnonymousInitializer getCachedIrAnonymousInitializer(@NotNull FirAnonymousInitializer anonymousInitializer) {
        Intrinsics.checkNotNullParameter(anonymousInitializer, "anonymousInitializer");
        return this.initializerCache.get(anonymousInitializer);
    }

    @NotNull
    public final IrAnonymousInitializer createIrAnonymousInitializer(@NotNull FirAnonymousInitializer anonymousInitializer, @NotNull IrClass irParent) {
        Intrinsics.checkNotNullParameter(anonymousInitializer, "anonymousInitializer");
        Intrinsics.checkNotNullParameter(irParent, "irParent");
        return (IrAnonymousInitializer)ConversionUtilsKt.convertWithOffsets(anonymousInitializer, (Function2)new Function2<Integer, Integer, IrAnonymousInitializer>(this, irParent, anonymousInitializer){
            final /* synthetic */ Fir2IrDeclarationStorage this$0;
            final /* synthetic */ IrClass $irParent;
            final /* synthetic */ FirAnonymousInitializer $anonymousInitializer;

            @NotNull
            public final IrAnonymousInitializer invoke(int startOffset, int endOffset) {
                IrAnonymousInitializer irAnonymousInitializer = this.this$0.getSymbolTable().declareAnonymousInitializer(startOffset, endOffset, IrDeclarationOrigin.DEFINED.INSTANCE, this.$irParent.getDescriptor());
                boolean bl = false;
                boolean bl2 = false;
                IrAnonymousInitializer $this$apply = irAnonymousInitializer;
                boolean bl3 = false;
                $this$apply.setParent(this.$irParent);
                Fir2IrDeclarationStorage.access$getInitializerCache$p(this.this$0).put(this.$anonymousInitializer, $this$apply);
                return irAnonymousInitializer;
            }
            {
                this.this$0 = fir2IrDeclarationStorage;
                this.$irParent = irClass2;
                this.$anonymousInitializer = firAnonymousInitializer;
                super(2);
            }
        });
    }

    @Nullable
    public final IrConstructor getCachedIrConstructor(@NotNull FirConstructor constructor) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        return this.constructorCache.get(constructor);
    }

    @NotNull
    public final IrConstructor createIrConstructor(@NotNull FirConstructor constructor, @NotNull IrClass irParent, @NotNull IrDeclarationOrigin origin) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(irParent, "irParent");
        Intrinsics.checkNotNullParameter(origin, "origin");
        WrappedClassConstructorDescriptor descriptor2 = new WrappedClassConstructorDescriptor(null, null, 3, null);
        boolean isPrimary = constructor.isPrimary();
        this.getClassifierStorage().preCacheTypeParameters$fir2ir(constructor);
        IrConstructor created2 = (IrConstructor)ConversionUtilsKt.convertWithOffsets(constructor, (Function2)new Function2<Integer, Integer, IrConstructor>(this, descriptor2, origin, constructor, isPrimary, irParent){
            final /* synthetic */ Fir2IrDeclarationStorage this$0;
            final /* synthetic */ WrappedClassConstructorDescriptor $descriptor;
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ FirConstructor $constructor;
            final /* synthetic */ boolean $isPrimary;
            final /* synthetic */ IrClass $irParent;

            @NotNull
            public final IrConstructor invoke(int startOffset, int endOffset) {
                return this.this$0.getSymbolTable().declareConstructor(this.$descriptor, (Function1<? super IrConstructorSymbol, ? extends IrConstructor>)new Function1<IrConstructorSymbol, IrConstructor>(this, startOffset, endOffset){
                    final /* synthetic */ createIrConstructor.created.1 this$0;
                    final /* synthetic */ int $startOffset;
                    final /* synthetic */ int $endOffset;

                    @NotNull
                    public final IrConstructor invoke(@NotNull IrConstructorSymbol symbol2) {
                        IrConstructor $this$apply;
                        Intrinsics.checkNotNullParameter(symbol2, "symbol");
                        Fir2IrDeclarationStorage fir2IrDeclarationStorage = this.this$0.this$0;
                        IrDeclarationOrigin irDeclarationOrigin = this.this$0.$origin;
                        Name name = Name.special("<init>");
                        Intrinsics.checkNotNullExpressionValue(name, "Name.special(\"<init>\")");
                        FirMemberDeclaration $this$visibility$iv = this.this$0.$constructor;
                        boolean $i$f$getVisibility = false;
                        IrFunction irFunction = new IrConstructorImpl(this.$startOffset, this.$endOffset, irDeclarationOrigin, symbol2, name, $this$visibility$iv.getStatus().getVisibility(), Fir2IrDeclarationStorage.toIrType$default(this.this$0.this$0, this.this$0.$constructor.getReturnTypeRef(), null, 1, null), false, false, this.this$0.$isPrimary, false);
                        boolean bl = false;
                        boolean bl2 = false;
                        IrConstructorImpl irConstructorImpl = irFunction;
                        Fir2IrDeclarationStorage fir2IrDeclarationStorage2 = fir2IrDeclarationStorage;
                        boolean bl3 = false;
                        ((IrFunctionBase)((Object)$this$apply)).setMetadata(new FirMetadataSource.Function(this.this$0.$constructor, this.this$0.$descriptor));
                        this.this$0.this$0.enterScope(this.this$0.$descriptor);
                        Unit unit = Unit.INSTANCE;
                        irFunction = Fir2IrDeclarationStorage.bindAndDeclareParameters$default(fir2IrDeclarationStorage2, irFunction, this.this$0.$constructor, this.this$0.$descriptor, this.this$0.$irParent, null, false, null, 40, null);
                        bl = false;
                        bl2 = false;
                        $this$apply = irFunction;
                        boolean bl4 = false;
                        this.this$0.this$0.leaveScope(this.this$0.$descriptor);
                        return irFunction;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$startOffset = n;
                        this.$endOffset = n2;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = fir2IrDeclarationStorage;
                this.$descriptor = wrappedClassConstructorDescriptor;
                this.$origin = irDeclarationOrigin;
                this.$constructor = firConstructor;
                this.$isPrimary = bl;
                this.$irParent = irClass2;
                super(2);
            }
        });
        this.constructorCache.put(constructor, created2);
        return created2;
    }

    public static /* synthetic */ IrConstructor createIrConstructor$default(Fir2IrDeclarationStorage fir2IrDeclarationStorage, FirConstructor firConstructor, IrClass irClass2, IrDeclarationOrigin irDeclarationOrigin, int n, Object object) {
        if ((n & 4) != 0) {
            irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        }
        return fir2IrDeclarationStorage.createIrConstructor(firConstructor, irClass2, irDeclarationOrigin);
    }

    private final IrSimpleFunction createIrPropertyAccessor(FirPropertyAccessor propertyAccessor, FirProperty property2, IrProperty correspondingProperty, IrType propertyType, IrDeclarationParent irParent, IrClass thisReceiverOwner, boolean isSetter, IrDeclarationOrigin origin, int startOffset, int endOffset) {
        WrappedSimpleFunctionDescriptor wrappedSimpleFunctionDescriptor;
        PropertyDescriptor propertyDescriptor = correspondingProperty.getDescriptor();
        if (propertyDescriptor instanceof WrappedPropertyDescriptorWithContainerSource) {
            wrappedSimpleFunctionDescriptor = new WrappedFunctionDescriptorWithContainerSource(((WrappedPropertyDescriptorWithContainerSource)propertyDescriptor).getContainerSource());
        } else if (isSetter) {
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue(sourceElement, "SourceElement.NO_SOURCE");
            wrappedSimpleFunctionDescriptor = new WrappedPropertySetterDescriptor(annotations2, sourceElement);
        } else {
            Annotations annotations3 = Annotations.Companion.getEMPTY();
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue(sourceElement, "SourceElement.NO_SOURCE");
            wrappedSimpleFunctionDescriptor = new WrappedPropertyGetterDescriptor(annotations3, sourceElement);
        }
        WrappedSimpleFunctionDescriptor descriptor2 = wrappedSimpleFunctionDescriptor;
        String prefix = isSetter ? "set" : "get";
        return this.getSymbolTable().declareSimpleFunction(descriptor2, (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(this, isSetter, propertyType, startOffset, endOffset, origin, prefix, correspondingProperty, propertyAccessor, descriptor2, property2, irParent, thisReceiverOwner){
            final /* synthetic */ Fir2IrDeclarationStorage this$0;
            final /* synthetic */ boolean $isSetter;
            final /* synthetic */ IrType $propertyType;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ String $prefix;
            final /* synthetic */ IrProperty $correspondingProperty;
            final /* synthetic */ FirPropertyAccessor $propertyAccessor;
            final /* synthetic */ WrappedSimpleFunctionDescriptor $descriptor;
            final /* synthetic */ FirProperty $property;
            final /* synthetic */ IrDeclarationParent $irParent;
            final /* synthetic */ IrClass $thisReceiverOwner;

            @NotNull
            public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol symbol2) {
                IrSimpleFunction $this$apply;
                Object object;
                Name name;
                IrType accessorReturnType;
                block8: {
                    block7: {
                        Intrinsics.checkNotNullParameter(symbol2, "symbol");
                        accessorReturnType = this.$isSetter ? this.this$0.getIrBuiltIns().getUnitType() : this.$propertyType;
                        name = Name.special('<' + this.$prefix + '-' + this.$correspondingProperty.getName() + '>');
                        Intrinsics.checkNotNullExpressionValue(name, "Name.special(\"<$prefix-$\u2026spondingProperty.name}>\")");
                        object = this.$propertyAccessor;
                        if (object == null) break block7;
                        FirPropertyAccessor $this$visibility$iv = object;
                        boolean $i$f$getVisibility = false;
                        object = $this$visibility$iv.getStatus().getVisibility();
                        if (object != null) break block8;
                    }
                    object = this.$correspondingProperty.getVisibility();
                }
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual(this.$origin, IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE);
                boolean bl3 = false;
                IrFunction irFunction = new IrFunctionImpl(this.$startOffset, this.$endOffset, this.$origin, symbol2, name, (Visibility)object, this.$correspondingProperty.getModality(), accessorReturnType, false, false, false, false, bl, bl3, bl2);
                bl2 = false;
                bl3 = false;
                IrFunctionImpl irFunctionImpl = irFunction;
                Fir2IrDeclarationStorage fir2IrDeclarationStorage = this.this$0;
                boolean bl4 = false;
                if (this.$propertyAccessor != null) {
                    ((IrFunctionBase)((Object)$this$apply)).setMetadata(new FirMetadataSource.Function(this.$propertyAccessor, this.$descriptor));
                }
                Fir2IrClassifierStorage fir2IrClassifierStorage = this.this$0.getClassifierStorage();
                boolean bl5 = false;
                boolean bl6 = false;
                Fir2IrClassifierStorage $this$with = fir2IrClassifierStorage;
                boolean bl7 = false;
                $this$with.setTypeParameters$fir2ir($this$apply, this.$property, new ConversionTypeContext(false, this.$isSetter ? ConversionTypeOrigin.SETTER : ConversionTypeOrigin.DEFAULT));
                if (this.$propertyAccessor == null && this.$isSetter) {
                    Fir2IrDeclarationStorage.access$declareDefaultSetterParameter(this.this$0, $this$apply, Fir2IrDeclarationStorage.access$toIrType(this.this$0, this.$property.getReturnTypeRef(), ConversionTypeContext.Companion.getDEFAULT$fir2ir().inSetter()));
                }
                this.this$0.enterScope(this.$descriptor);
                Unit unit = Unit.INSTANCE;
                irFunction = Fir2IrDeclarationStorage.access$bindAndDeclareParameters(fir2IrDeclarationStorage, irFunction, this.$propertyAccessor, this.$descriptor, this.$irParent, this.$thisReceiverOwner, !(this.$irParent instanceof IrClass), this.$property.getReceiverTypeRef());
                bl2 = false;
                bl3 = false;
                $this$apply = irFunction;
                boolean bl8 = false;
                this.this$0.leaveScope(this.$descriptor);
                if (this.$irParent != null) {
                    $this$apply.setParent(this.$irParent);
                }
                $this$apply.setCorrespondingPropertySymbol(this.$correspondingProperty.getSymbol());
                if (!$this$apply.isFakeOverride() && this.$thisReceiverOwner != null) {
                    Fir2IrDeclarationStorage.access$populateOverriddenSymbols(this.this$0, $this$apply, this.$thisReceiverOwner);
                }
                return irFunction;
            }
            {
                this.this$0 = fir2IrDeclarationStorage;
                this.$isSetter = bl;
                this.$propertyType = irType;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$origin = irDeclarationOrigin;
                this.$prefix = string2;
                this.$correspondingProperty = irProperty;
                this.$propertyAccessor = firPropertyAccessor;
                this.$descriptor = wrappedSimpleFunctionDescriptor;
                this.$property = firProperty;
                this.$irParent = irDeclarationParent;
                this.$thisReceiverOwner = irClass2;
                super(1);
            }
        });
    }

    private final IrField createBackingField(IrProperty $this$createBackingField, FirProperty property2, IrDeclarationOrigin origin, PropertyDescriptor descriptor2, Visibility visibility, Name name, boolean isFinal, FirExpression firInitializerExpression, IrClass thisReceiverOwner, IrType type2) {
        IrType irType = type2;
        if (irType == null) {
            FirExpression firExpression2 = firInitializerExpression;
            Intrinsics.checkNotNull(firExpression2);
            irType = Fir2IrDeclarationStorage.toIrType$default(this, firExpression2.getTypeRef(), null, 1, null);
        }
        IrType inferredType = irType;
        return SymbolTable.declareField$default(this.getSymbolTable(), $this$createBackingField.getStartOffset(), $this$createBackingField.getEndOffset(), origin, descriptor2, inferredType, null, new Function1<IrFieldSymbol, IrField>(this, $this$createBackingField, origin, name, inferredType, visibility, isFinal, property2, thisReceiverOwner, descriptor2){
            final /* synthetic */ Fir2IrDeclarationStorage this$0;
            final /* synthetic */ IrProperty $this_createBackingField;
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ Name $name;
            final /* synthetic */ IrType $inferredType;
            final /* synthetic */ Visibility $visibility;
            final /* synthetic */ boolean $isFinal;
            final /* synthetic */ FirProperty $property;
            final /* synthetic */ IrClass $thisReceiverOwner;
            final /* synthetic */ PropertyDescriptor $descriptor;

            @NotNull
            public final IrField invoke(@NotNull IrFieldSymbol symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                FirMemberDeclaration $this$isStatic$iv = this.$property;
                boolean $i$f$isStatic = false;
                IrFieldImpl irFieldImpl = new IrFieldImpl(this.$this_createBackingField.getStartOffset(), this.$this_createBackingField.getEndOffset(), this.$origin, symbol2, this.$name, this.$inferredType, this.$visibility, this.$isFinal, false, $this$isStatic$iv.getStatus().isStatic() || !(this.$this_createBackingField.getParent() instanceof IrClass), Intrinsics.areEqual(this.$origin, IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE));
                boolean bl = false;
                boolean bl2 = false;
                IrFieldImpl it = irFieldImpl;
                boolean bl3 = false;
                it.setCorrespondingPropertySymbol(this.$this_createBackingField.getSymbol());
                if (!this.$this_createBackingField.isFakeOverride() && this.$thisReceiverOwner != null) {
                    Fir2IrDeclarationStorage.access$populateOverriddenSymbols(this.this$0, it, this.$thisReceiverOwner);
                }
                bl = false;
                bl2 = false;
                IrFieldImpl $this$apply = irFieldImpl;
                boolean bl4 = false;
                $this$apply.setMetadata(new FirMetadataSource.Property(this.$property, this.$descriptor));
                return irFieldImpl;
            }
            {
                this.this$0 = fir2IrDeclarationStorage;
                this.$this_createBackingField = irProperty;
                this.$origin = irDeclarationOrigin;
                this.$name = name;
                this.$inferredType = irType;
                this.$visibility = visibility;
                this.$isFinal = bl;
                this.$property = firProperty;
                this.$thisReceiverOwner = irClass2;
                this.$descriptor = propertyDescriptor;
                super(1);
            }
        }, 32, null);
    }

    static /* synthetic */ IrField createBackingField$default(Fir2IrDeclarationStorage fir2IrDeclarationStorage, IrProperty irProperty, FirProperty firProperty, IrDeclarationOrigin irDeclarationOrigin, PropertyDescriptor propertyDescriptor, Visibility visibility, Name name, boolean bl, FirExpression firExpression2, IrClass irClass2, IrType irType, int n, Object object) {
        if ((n & 0x100) != 0) {
            irType = null;
        }
        return fir2IrDeclarationStorage.createBackingField(irProperty, firProperty, irDeclarationOrigin, propertyDescriptor, visibility, name, bl, firExpression2, irClass2, irType);
    }

    private final Visibility getFieldVisibility(FirProperty $this$fieldVisibility) {
        Object object;
        block6: {
            block4: {
                block5: {
                    FirMemberDeclaration $this$isLateInit$iv = $this$fieldVisibility;
                    boolean $i$f$isLateInit = false;
                    if (!$this$isLateInit$iv.getStatus().isLateInit()) break block4;
                    object = $this$fieldVisibility.getSetter();
                    if (object == null) break block5;
                    FirPropertyAccessor $this$visibility$iv = object;
                    boolean $i$f$getVisibility = false;
                    object = $this$visibility$iv.getStatus().getVisibility();
                    if (object != null) break block6;
                }
                object = $this$fieldVisibility.getStatus().getVisibility();
                break block6;
            }
            FirMemberDeclaration $this$isConst$iv = $this$fieldVisibility;
            boolean $i$f$isConst = false;
            if ($this$isConst$iv.getStatus().isConst()) {
                object = $this$fieldVisibility.getStatus().getVisibility();
            } else {
                Visibility visibility = Visibilities.PRIVATE;
                object = visibility;
                Intrinsics.checkNotNullExpressionValue(visibility, "Visibilities.PRIVATE");
            }
        }
        return object;
    }

    @NotNull
    public final IrProperty createIrProperty(@NotNull FirProperty property2, @Nullable IrDeclarationParent irParent, @Nullable IrClass thisReceiverOwner, @NotNull IrDeclarationOrigin origin) {
        WrappedPropertyDescriptor wrappedPropertyDescriptor;
        DeserializedContainerSource containerSource;
        Intrinsics.checkNotNullParameter(property2, "property");
        Intrinsics.checkNotNullParameter(origin, "origin");
        DeserializedContainerSource deserializedContainerSource = containerSource = property2.getContainerSource();
        if (deserializedContainerSource != null) {
            DeserializedContainerSource deserializedContainerSource2 = deserializedContainerSource;
            boolean bl = false;
            boolean bl2 = false;
            DeserializedContainerSource it = deserializedContainerSource2;
            boolean bl3 = false;
            wrappedPropertyDescriptor = new WrappedPropertyDescriptorWithContainerSource(it);
        } else {
            wrappedPropertyDescriptor = new WrappedPropertyDescriptor(null, null, 3, null);
        }
        WrappedPropertyDescriptor descriptor2 = wrappedPropertyDescriptor;
        this.getClassifierStorage().preCacheTypeParameters$fir2ir(property2);
        return (IrProperty)ConversionUtilsKt.convertWithOffsets(property2, (Function2)new Function2<Integer, Integer, IrProperty>(this, descriptor2, origin, property2, irParent, thisReceiverOwner){
            final /* synthetic */ Fir2IrDeclarationStorage this$0;
            final /* synthetic */ WrappedPropertyDescriptor $descriptor;
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ FirProperty $property;
            final /* synthetic */ IrDeclarationParent $irParent;
            final /* synthetic */ IrClass $thisReceiverOwner;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IrProperty invoke(int startOffset, int endOffset) {
                void var3_3;
                this.this$0.enterScope(this.$descriptor);
                IrProperty result2 = this.this$0.getSymbolTable().declareProperty(startOffset, endOffset, this.$origin, this.$descriptor, this.$property.getDelegate() != null, (Function1<? super IrPropertySymbol, ? extends IrProperty>)new Function1<IrPropertySymbol, IrProperty>(this, startOffset, endOffset){
                    final /* synthetic */ createIrProperty.1 this$0;
                    final /* synthetic */ int $startOffset;
                    final /* synthetic */ int $endOffset;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final IrProperty invoke(@NotNull IrPropertySymbol symbol2) {
                        FirPropertyAccessor setter2;
                        FirPropertyAccessor getter2;
                        FirExpression delegate;
                        IrType type2;
                        IrPropertyImpl $this$apply;
                        IrPropertyImpl irPropertyImpl;
                        block13: {
                            FirExpression initializer2;
                            block12: {
                                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                                IrDeclarationOrigin irDeclarationOrigin = this.this$0.$origin;
                                Name name = this.this$0.$property.getName();
                                FirMemberDeclaration $this$visibility$iv = this.this$0.$property;
                                boolean $i$f$getVisibility = false;
                                Visibility visibility = $this$visibility$iv.getStatus().getVisibility();
                                FirMemberDeclaration $this$modality$iv = this.this$0.$property;
                                boolean $i$f$getModality = false;
                                Modality modality = $this$modality$iv.getStatus().getModality();
                                Intrinsics.checkNotNull((Object)((Object)modality));
                                FirMemberDeclaration $this$isConst$iv = this.this$0.$property;
                                boolean $i$f$isConst = false;
                                FirMemberDeclaration $this$isLateInit$iv = this.this$0.$property;
                                boolean $i$f$isLateInit = false;
                                FirMemberDeclaration $this$isExpect$iv = this.this$0.$property;
                                boolean $i$f$isExpect = false;
                                irPropertyImpl = new IrPropertyImpl(this.$startOffset, this.$endOffset, irDeclarationOrigin, symbol2, name, visibility, modality, this.this$0.$property.isVar(), $this$isConst$iv.getStatus().isConst(), $this$isLateInit$iv.getStatus().isLateInit(), this.this$0.$property.getDelegate() != null, false, $this$isExpect$iv.getStatus().isExpect(), Intrinsics.areEqual(this.this$0.$origin, IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE));
                                boolean bl = false;
                                boolean bl2 = false;
                                $this$apply = irPropertyImpl;
                                boolean bl3 = false;
                                $this$apply.setMetadata(new FirMetadataSource.Variable(this.this$0.$property, this.this$0.$descriptor));
                                this.this$0.$descriptor.bind((IrDeclaration)$this$apply);
                                if (this.this$0.$irParent != null) {
                                    $this$apply.setParent(this.this$0.$irParent);
                                }
                                type2 = Fir2IrDeclarationStorage.toIrType$default(this.this$0.this$0, this.this$0.$property.getReturnTypeRef(), null, 1, null);
                                initializer2 = this.this$0.$property.getInitializer();
                                delegate = this.this$0.$property.getDelegate();
                                getter2 = this.this$0.$property.getGetter();
                                setter2 = this.this$0.$property.getSetter();
                                FirMemberDeclaration $this$isConst$iv2 = this.this$0.$property;
                                boolean $i$f$isConst2 = false;
                                if ($this$isConst$iv2.getStatus().isConst()) break block12;
                                FirMemberDeclaration $this$modality$iv2 = this.this$0.$property;
                                boolean $i$f$getModality2 = false;
                                if ($this$modality$iv2.getStatus().getModality() == Modality.ABSTRACT || this.this$0.$irParent instanceof IrClass && IrUtilsKt.isInterface((IrClass)this.this$0.$irParent)) break block13;
                            }
                            if (initializer2 != null || getter2 instanceof FirDefaultPropertyGetter || this.this$0.$property.isVar() && setter2 instanceof FirDefaultPropertySetter) {
                                IrField irField = Fir2IrDeclarationStorage.access$createBackingField(this.this$0.this$0, $this$apply, this.this$0.$property, IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE, this.this$0.$descriptor, Fir2IrDeclarationStorage.access$getFieldVisibility$p(this.this$0.this$0, this.this$0.$property), this.this$0.$property.getName(), this.this$0.$property.isVal(), initializer2, this.this$0.$thisReceiverOwner, type2);
                                boolean bl = false;
                                boolean bl4 = false;
                                IrField irField2 = irField;
                                IrPropertyImpl irPropertyImpl2 = $this$apply;
                                boolean bl5 = false;
                                if (initializer2 instanceof FirConstExpression) {
                                    void field;
                                    IrType irType = Fir2IrDeclarationStorage.toIrType$default(this.this$0.this$0, initializer2.getTypeRef(), null, 1, null);
                                    boolean bl6 = false;
                                    boolean bl7 = false;
                                    IrType it = irType;
                                    boolean bl8 = false;
                                    IrType irType2 = !(it instanceof IrErrorType) ? irType : null;
                                    if (irType2 == null) {
                                        irType2 = type2;
                                    }
                                    IrType constType = irType2;
                                    field.setInitializer(new IrExpressionBodyImpl(ConversionUtilsKt.toIrConst((FirConstExpression)initializer2, constType)));
                                }
                                Unit unit = Unit.INSTANCE;
                                irPropertyImpl2.setBackingField(irField);
                            } else if (delegate != null) {
                                Fir2IrDeclarationStorage fir2IrDeclarationStorage = this.this$0.this$0;
                                IrProperty irProperty = $this$apply;
                                FirProperty firProperty = this.this$0.$property;
                                IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.PROPERTY_DELEGATE.INSTANCE;
                                PropertyDescriptor propertyDescriptor = this.this$0.$descriptor;
                                Visibility visibility = Fir2IrDeclarationStorage.access$getFieldVisibility$p(this.this$0.this$0, this.this$0.$property);
                                Name name = Name.identifier(this.this$0.$property.getName() + "$delegate");
                                Intrinsics.checkNotNullExpressionValue(name, "Name.identifier(\"${property.name}\\$delegate\")");
                                $this$apply.setBackingField(Fir2IrDeclarationStorage.createBackingField$default(fir2IrDeclarationStorage, irProperty, firProperty, irDeclarationOrigin, propertyDescriptor, visibility, name, true, delegate, this.this$0.$thisReceiverOwner, null, 256, null));
                            }
                            if (this.this$0.$irParent != null) {
                                IrField irField = $this$apply.getBackingField();
                                if (irField != null) {
                                    irField.setParent(this.this$0.$irParent);
                                }
                            }
                        }
                        $this$apply.setGetter(Fir2IrDeclarationStorage.access$createIrPropertyAccessor(this.this$0.this$0, getter2, this.this$0.$property, $this$apply, type2, this.this$0.$irParent, this.this$0.$thisReceiverOwner, false, Intrinsics.areEqual(this.this$0.$origin, IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE) ? this.this$0.$origin : (delegate != null ? (IrDeclarationOrigin)IrDeclarationOrigin.DELEGATED_PROPERTY_ACCESSOR.INSTANCE : (getter2 instanceof FirDefaultPropertyGetter ? (IrDeclarationOrigin)IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE : this.this$0.$origin)), this.$startOffset, this.$endOffset));
                        if (this.this$0.$property.isVar()) {
                            $this$apply.setSetter(Fir2IrDeclarationStorage.access$createIrPropertyAccessor(this.this$0.this$0, setter2, this.this$0.$property, $this$apply, type2, this.this$0.$irParent, this.this$0.$thisReceiverOwner, true, delegate != null ? (IrDeclarationOrigin)IrDeclarationOrigin.DELEGATED_PROPERTY_ACCESSOR.INSTANCE : (setter2 instanceof FirDefaultPropertySetter ? (IrDeclarationOrigin)IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE : this.this$0.$origin), this.$startOffset, this.$endOffset));
                        }
                        return irPropertyImpl;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$startOffset = n;
                        this.$endOffset = n2;
                        super(1);
                    }
                });
                this.this$0.leaveScope(this.$descriptor);
                Fir2IrDeclarationStorage.access$getPropertyCache$p(this.this$0).put(this.$property, result2);
                return var3_3;
            }
            {
                this.this$0 = fir2IrDeclarationStorage;
                this.$descriptor = wrappedPropertyDescriptor;
                this.$origin = irDeclarationOrigin;
                this.$property = firProperty;
                this.$irParent = irDeclarationParent;
                this.$thisReceiverOwner = irClass2;
                super(2);
            }
        });
    }

    public static /* synthetic */ IrProperty createIrProperty$default(Fir2IrDeclarationStorage fir2IrDeclarationStorage, FirProperty firProperty, IrDeclarationParent irDeclarationParent, IrClass irClass2, IrDeclarationOrigin irDeclarationOrigin, int n, Object object) {
        if ((n & 4) != 0) {
            IrDeclarationParent irDeclarationParent2 = irDeclarationParent;
            if (!(irDeclarationParent2 instanceof IrClass)) {
                irDeclarationParent2 = null;
            }
            irClass2 = (IrClass)irDeclarationParent2;
        }
        if ((n & 8) != 0) {
            irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        }
        return fir2IrDeclarationStorage.createIrProperty(firProperty, irDeclarationParent, irClass2, irDeclarationOrigin);
    }

    @Nullable
    public final IrProperty getCachedIrProperty(@NotNull FirProperty property2) {
        Intrinsics.checkNotNullParameter(property2, "property");
        return this.propertyCache.get(property2);
    }

    private final IrField createIrField(FirField field) {
        WrappedFieldDescriptor descriptor2 = new WrappedFieldDescriptor(null, null, 3, null);
        IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB origin = IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE;
        IrType type2 = Fir2IrDeclarationStorage.toIrType$default(this, field.getReturnTypeRef(), null, 1, null);
        return (IrField)ConversionUtilsKt.convertWithOffsets(field, (Function2)new Function2<Integer, Integer, IrField>(this, origin, descriptor2, type2, field){
            final /* synthetic */ Fir2IrDeclarationStorage this$0;
            final /* synthetic */ IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB $origin;
            final /* synthetic */ WrappedFieldDescriptor $descriptor;
            final /* synthetic */ IrType $type;
            final /* synthetic */ FirField $field;

            @NotNull
            public final IrField invoke(int startOffset, int endOffset) {
                return SymbolTable.declareField$default(this.this$0.getSymbolTable(), startOffset, endOffset, this.$origin, this.$descriptor, this.$type, null, new Function1<IrFieldSymbol, IrField>(this, startOffset, endOffset){
                    final /* synthetic */ createIrField.1 this$0;
                    final /* synthetic */ int $startOffset;
                    final /* synthetic */ int $endOffset;

                    @NotNull
                    public final IrField invoke(@NotNull IrFieldSymbol symbol2) {
                        Intrinsics.checkNotNullParameter(symbol2, "symbol");
                        FirMemberDeclaration $this$visibility$iv = this.this$0.$field;
                        boolean $i$f$getVisibility = false;
                        FirMemberDeclaration $this$modality$iv = this.this$0.$field;
                        boolean $i$f$getModality = false;
                        FirMemberDeclaration $this$isStatic$iv = this.this$0.$field;
                        boolean $i$f$isStatic = false;
                        IrFieldImpl irFieldImpl = new IrFieldImpl(this.$startOffset, this.$endOffset, this.this$0.$origin, symbol2, this.this$0.$field.getName(), this.this$0.$type, $this$visibility$iv.getStatus().getVisibility(), $this$modality$iv.getStatus().getModality() == Modality.FINAL, false, $this$isStatic$iv.getStatus().isStatic(), false);
                        boolean bl = false;
                        boolean bl2 = false;
                        IrFieldImpl $this$apply = irFieldImpl;
                        boolean bl3 = false;
                        $this$apply.setMetadata(new FirMetadataSource.Variable(this.this$0.$field, this.this$0.$descriptor));
                        this.this$0.$descriptor.bind((IrDeclaration)$this$apply);
                        Fir2IrDeclarationStorage.access$getFieldCache$p(this.this$0.this$0).put(this.this$0.$field, $this$apply);
                        return irFieldImpl;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$startOffset = n;
                        this.$endOffset = n2;
                        super(1);
                    }
                }, 32, null);
            }
            {
                this.this$0 = fir2IrDeclarationStorage;
                this.$origin = iR_EXTERNAL_JAVA_DECLARATION_STUB;
                this.$descriptor = wrappedFieldDescriptor;
                this.$type = irType;
                this.$field = firField;
                super(2);
            }
        });
    }

    private final IrValueParameter createIrParameter(FirValueParameter valueParameter, int index2, boolean useStubForDefaultValueStub, ConversionTypeContext typeContext) {
        WrappedValueParameterDescriptor descriptor2 = new WrappedValueParameterDescriptor(null, null, 3, null);
        IrDeclarationOrigin.DEFINED origin = IrDeclarationOrigin.DEFINED.INSTANCE;
        IrType type2 = Fir2IrDeclarationStorage.toIrType$default(this, valueParameter.getReturnTypeRef(), null, 1, null);
        IrValueParameter irParameter2 = (IrValueParameter)ConversionUtilsKt.convertWithOffsets(valueParameter, (Function2)new Function2<Integer, Integer, IrValueParameter>(this, origin, descriptor2, type2, valueParameter, index2, typeContext, useStubForDefaultValueStub){
            final /* synthetic */ Fir2IrDeclarationStorage this$0;
            final /* synthetic */ IrDeclarationOrigin.DEFINED $origin;
            final /* synthetic */ WrappedValueParameterDescriptor $descriptor;
            final /* synthetic */ IrType $type;
            final /* synthetic */ FirValueParameter $valueParameter;
            final /* synthetic */ int $index;
            final /* synthetic */ ConversionTypeContext $typeContext;
            final /* synthetic */ boolean $useStubForDefaultValueStub;

            @NotNull
            public final IrValueParameter invoke(int startOffset, int endOffset) {
                return SymbolTable.declareValueParameter$default(this.this$0.getSymbolTable(), startOffset, endOffset, this.$origin, this.$descriptor, this.$type, null, new Function1<IrValueParameterSymbol, IrValueParameter>(this, startOffset, endOffset){
                    final /* synthetic */ createIrParameter.irParameter.1 this$0;
                    final /* synthetic */ int $startOffset;
                    final /* synthetic */ int $endOffset;

                    @NotNull
                    public final IrValueParameter invoke(@NotNull IrValueParameterSymbol symbol2) {
                        boolean bl;
                        IrType irType;
                        Intrinsics.checkNotNullParameter(symbol2, "symbol");
                        IrDeclarationOrigin irDeclarationOrigin = this.this$0.$origin;
                        Name name = this.this$0.$valueParameter.getName();
                        int n = this.this$0.$index;
                        IrType irType2 = this.this$0.$type;
                        if (!this.this$0.$valueParameter.isVararg()) {
                            irType = null;
                        } else {
                            ConeKotlinType coneKotlinType;
                            FirTypeRef $this$coneTypeSafe$iv = this.this$0.$valueParameter.getReturnTypeRef();
                            boolean $i$f$coneTypeSafe = false;
                            bl = false;
                            FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                                firTypeRef = null;
                            }
                            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                            ConeKotlinType coneKotlinType2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                            if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                                coneKotlinType2 = coneKotlinType = null;
                            }
                            irType = coneKotlinType2 != null && (coneKotlinType = ArrayUtilsKt.arrayElementType(coneKotlinType, this.this$0.this$0.getSession())) != null ? Fir2IrDeclarationStorage.access$toIrType(this.this$0.this$0, coneKotlinType, this.this$0.$typeContext) : null;
                        }
                        IrValueParameterImpl irValueParameterImpl = new IrValueParameterImpl(this.$startOffset, this.$endOffset, irDeclarationOrigin, symbol2, name, n, irType2, irType, this.this$0.$valueParameter.isCrossinline(), this.this$0.$valueParameter.isNoinline());
                        boolean bl2 = false;
                        bl = false;
                        IrValueParameterImpl $this$apply = irValueParameterImpl;
                        boolean bl3 = false;
                        this.this$0.$descriptor.bind((IrDeclaration)$this$apply);
                        FirExpression firExpression2 = this.this$0.$valueParameter.getDefaultValue();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        FirExpression it = firExpression2;
                        boolean bl6 = false;
                        if (it != null && (this.this$0.$useStubForDefaultValueStub || !(it instanceof FirExpressionStub))) {
                            $this$apply.setDefaultValue(new IrExpressionBodyImpl(new IrErrorExpressionImpl(-1, -1, this.this$0.$type, "Stub expression for default value of " + this.this$0.$valueParameter.getName())));
                        }
                        return irValueParameterImpl;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$startOffset = n;
                        this.$endOffset = n2;
                        super(1);
                    }
                }, 32, null);
            }
            {
                this.this$0 = fir2IrDeclarationStorage;
                this.$origin = dEFINED;
                this.$descriptor = wrappedValueParameterDescriptor;
                this.$type = irType;
                this.$valueParameter = firValueParameter;
                this.$index = n;
                this.$typeContext = conversionTypeContext;
                this.$useStubForDefaultValueStub = bl;
                super(2);
            }
        });
        this.localStorage.putParameter(valueParameter, irParameter2);
        return irParameter2;
    }

    private final int nextTemporaryIndex() {
        int n = this.lastTemporaryIndex;
        this.lastTemporaryIndex = n + 1;
        return n;
    }

    private final String getNameForTemporary(String nameHint) {
        int index2 = this.nextTemporaryIndex();
        return nameHint != null ? "tmp" + index2 + '_' + nameHint : "tmp" + index2;
    }

    private final IrVariable declareIrVariable(int startOffset, int endOffset, IrDeclarationOrigin origin, Name name, IrType type2, boolean isVar, boolean isConst, boolean isLateinit) {
        WrappedVariableDescriptor descriptor2 = new WrappedVariableDescriptor(null, null, 3, null);
        return this.getSymbolTable().declareVariable(startOffset, endOffset, origin, (VariableDescriptor)descriptor2, type2, (Function1<? super IrVariableSymbol, ? extends IrVariable>)new Function1<IrVariableSymbol, IrVariable>(startOffset, endOffset, origin, name, type2, isVar, isConst, isLateinit, descriptor2){
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ Name $name;
            final /* synthetic */ IrType $type;
            final /* synthetic */ boolean $isVar;
            final /* synthetic */ boolean $isConst;
            final /* synthetic */ boolean $isLateinit;
            final /* synthetic */ WrappedVariableDescriptor $descriptor;

            @NotNull
            public final IrVariable invoke(@NotNull IrVariableSymbol symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                IrVariableImpl irVariableImpl = new IrVariableImpl(this.$startOffset, this.$endOffset, this.$origin, symbol2, this.$name, this.$type, this.$isVar, this.$isConst, this.$isLateinit);
                boolean bl = false;
                boolean bl2 = false;
                IrVariableImpl $this$apply = irVariableImpl;
                boolean bl3 = false;
                this.$descriptor.bind((IrDeclaration)$this$apply);
                return irVariableImpl;
            }
            {
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$origin = irDeclarationOrigin;
                this.$name = name;
                this.$type = irType;
                this.$isVar = bl;
                this.$isConst = bl2;
                this.$isLateinit = bl3;
                this.$descriptor = wrappedVariableDescriptor;
                super(1);
            }
        });
    }

    @NotNull
    public final IrVariable createIrVariable(@NotNull FirVariable<?> variable2, @NotNull IrDeclarationParent irParent, @Nullable IrDeclarationOrigin givenOrigin) {
        boolean bl;
        IrDeclarationOrigin origin;
        Intrinsics.checkNotNullParameter(variable2, "variable");
        Intrinsics.checkNotNullParameter(irParent, "irParent");
        IrType type2 = Fir2IrDeclarationStorage.toIrType$default(this, variable2.getReturnTypeRef(), null, 1, null);
        IrDeclarationOrigin irDeclarationOrigin = givenOrigin != null ? givenOrigin : (Intrinsics.areEqual(variable2.getName(), Name.special("<iterator>")) ? (IrDeclarationOrigin)IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE : (origin = variable2.getName().isSpecial() ? (IrDeclarationOrigin)IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE : (IrDeclarationOrigin)IrDeclarationOrigin.DEFINED.INSTANCE));
        if (variable2 instanceof FirProperty) {
            FirMemberDeclaration $this$isLateInit$iv = (FirMemberDeclaration)((Object)variable2);
            boolean $i$f$isLateInit = false;
            bl = $this$isLateInit$iv.getStatus().isLateInit();
        } else {
            bl = false;
        }
        boolean isLateInit = bl;
        IrVariable irVariable2 = (IrVariable)ConversionUtilsKt.convertWithOffsets(variable2, (Function2)new Function2<Integer, Integer, IrVariable>(this, origin, variable2, type2, isLateInit){
            final /* synthetic */ Fir2IrDeclarationStorage this$0;
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ FirVariable $variable;
            final /* synthetic */ IrType $type;
            final /* synthetic */ boolean $isLateInit;

            @NotNull
            public final IrVariable invoke(int startOffset, int endOffset) {
                return Fir2IrDeclarationStorage.access$declareIrVariable(this.this$0, startOffset, endOffset, this.$origin, this.$variable.getName(), this.$type, this.$variable.isVar(), false, this.$isLateInit);
            }
            {
                this.this$0 = fir2IrDeclarationStorage;
                this.$origin = irDeclarationOrigin;
                this.$variable = firVariable;
                this.$type = irType;
                this.$isLateInit = bl;
                super(2);
            }
        });
        irVariable2.setParent(irParent);
        this.localStorage.putVariable(variable2, irVariable2);
        return irVariable2;
    }

    public static /* synthetic */ IrVariable createIrVariable$default(Fir2IrDeclarationStorage fir2IrDeclarationStorage, FirVariable firVariable, IrDeclarationParent irDeclarationParent, IrDeclarationOrigin irDeclarationOrigin, int n, Object object) {
        if ((n & 4) != 0) {
            irDeclarationOrigin = null;
        }
        return fir2IrDeclarationStorage.createIrVariable(firVariable, irDeclarationParent, irDeclarationOrigin);
    }

    @NotNull
    public final IrVariable declareTemporaryVariable(@NotNull IrExpression base, @Nullable String nameHint) {
        Intrinsics.checkNotNullParameter(base, "base");
        int n = base.getStartOffset();
        int n2 = base.getEndOffset();
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE;
        Name name = Name.identifier(this.getNameForTemporary(nameHint));
        Intrinsics.checkNotNullExpressionValue(name, "Name.identifier(getNameForTemporary(nameHint))");
        IrVariable irVariable2 = this.declareIrVariable(n, n2, irDeclarationOrigin, name, base.getType(), false, false, false);
        boolean bl = false;
        boolean bl2 = false;
        IrVariable $this$apply = irVariable2;
        boolean bl3 = false;
        $this$apply.setInitializer(base);
        return irVariable2;
    }

    public static /* synthetic */ IrVariable declareTemporaryVariable$default(Fir2IrDeclarationStorage fir2IrDeclarationStorage, IrExpression irExpression, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return fir2IrDeclarationStorage.declareTemporaryVariable(irExpression, string2);
    }

    @NotNull
    public final IrConstructorSymbol getIrConstructorSymbol(@NotNull FirConstructorSymbol firConstructorSymbol) {
        Object object;
        Intrinsics.checkNotNullParameter(firConstructorSymbol, "firConstructorSymbol");
        FirConstructor firConstructor = (FirConstructor)firConstructorSymbol.getFir();
        IrConstructor irConstructor = this.getCachedIrConstructor(firConstructor);
        if (irConstructor != null) {
            IrConstructor irConstructor2 = irConstructor;
            boolean bl = false;
            boolean bl2 = false;
            IrConstructor it = irConstructor2;
            boolean bl3 = false;
            return (IrConstructorSymbol)it.getSymbol();
        }
        IrDeclarationParent irDeclarationParent = this.findIrParent$fir2ir(firConstructor);
        if (irDeclarationParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrClass irParent = (IrClass)irDeclarationParent;
        IrClass irClass2 = irParent;
        if (!(irClass2 instanceof IrDeclaration)) {
            irClass2 = null;
        }
        if ((object = (IrDeclaration)irClass2) == null || (object = object.getOrigin()) == null) {
            object = IrDeclarationOrigin.DEFINED.INSTANCE;
        }
        Object parentOrigin = object;
        IrConstructor irConstructor3 = this.createIrConstructor(firConstructor, irParent, (IrDeclarationOrigin)parentOrigin);
        boolean bl = false;
        boolean bl4 = false;
        IrConstructor $this$apply = irConstructor3;
        boolean bl5 = false;
        this.setAndModifyParent($this$apply, irParent);
        IrConstructor irDeclaration2 = irConstructor3;
        return (IrConstructorSymbol)irDeclaration2.getSymbol();
    }

    @NotNull
    public final IrFunctionSymbol getIrFunctionSymbol(@NotNull FirFunctionSymbol<?> firFunctionSymbol) {
        IrFunctionSymbol irFunctionSymbol;
        Intrinsics.checkNotNullParameter(firFunctionSymbol, "firFunctionSymbol");
        FirFunction firDeclaration = (FirFunction)firFunctionSymbol.getFir();
        if (firDeclaration instanceof FirSimpleFunction || firDeclaration instanceof FirAnonymousFunction) {
            Object object;
            IrSimpleFunction irSimpleFunction = this.getCachedIrFunction(firDeclaration);
            if (irSimpleFunction != null) {
                IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
                boolean bl = false;
                boolean bl2 = false;
                IrSimpleFunction it = irSimpleFunction2;
                boolean bl3 = false;
                return it.getSymbol();
            }
            IrDeclarationParent irParent = this.findIrParent$fir2ir(firDeclaration);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.getSymbolTable().referenceSimpleFunctionIfAny(this.getSignatureComposer().composeSignature(firDeclaration));
            if (irSimpleFunctionSymbol != null) {
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = irSimpleFunctionSymbol;
                boolean bl = false;
                boolean bl4 = false;
                IrSimpleFunctionSymbol irFunctionSymbol2 = irSimpleFunctionSymbol2;
                boolean bl5 = false;
                IrSimpleFunction irFunction = (IrSimpleFunction)irFunctionSymbol2.getOwner();
                this.functionCache.put(firDeclaration, irFunction);
                return irFunctionSymbol2;
            }
            IrDeclarationParent irDeclarationParent = irParent;
            if (!(irDeclarationParent instanceof IrDeclaration)) {
                irDeclarationParent = null;
            }
            if ((object = (IrDeclaration)((Object)irDeclarationParent)) == null || (object = object.getOrigin()) == null) {
                object = IrDeclarationOrigin.DEFINED.INSTANCE;
            }
            Object parentOrigin = object;
            IrSimpleFunction irSimpleFunction3 = Fir2IrDeclarationStorage.createIrFunction$default(this, firDeclaration, irParent, null, (IrDeclarationOrigin)parentOrigin, 4, null);
            boolean bl = false;
            boolean bl6 = false;
            IrSimpleFunction $this$apply = irSimpleFunction3;
            boolean bl7 = false;
            this.setAndModifyParent($this$apply, irParent);
            irFunctionSymbol = irSimpleFunction3.getSymbol();
        } else if (firDeclaration instanceof FirConstructor) {
            irFunctionSymbol = this.getIrConstructorSymbol(((FirConstructor)firDeclaration).getSymbol());
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Should not be here: " + firDeclaration.getClass() + ": " + FirRendererKt.render$default(firDeclaration, null, 1, null))));
        }
        return irFunctionSymbol;
    }

    @NotNull
    public final IrSymbol getIrPropertyOrFieldSymbol(@NotNull FirVariableSymbol<?> firVariableSymbol) {
        IrBindableSymbol irBindableSymbol;
        Intrinsics.checkNotNullParameter(firVariableSymbol, "firVariableSymbol");
        FirVariable fir = (FirVariable)firVariableSymbol.getFir();
        if (fir instanceof FirProperty) {
            Object object;
            IrProperty irProperty = this.propertyCache.get(fir);
            if (irProperty != null) {
                IrProperty irProperty2 = irProperty;
                boolean bl = false;
                boolean bl2 = false;
                IrProperty it = irProperty2;
                boolean bl3 = false;
                return it.getSymbol();
            }
            IrDeclarationParent irParent = this.findIrParent$fir2ir(fir);
            IrPropertySymbol irPropertySymbol = this.getSymbolTable().referencePropertyIfAny(this.getSignatureComposer().composeSignature(fir));
            if (irPropertySymbol != null) {
                IrPropertySymbol irPropertySymbol2 = irPropertySymbol;
                boolean bl = false;
                boolean it = false;
                IrPropertySymbol irPropertySymbol3 = irPropertySymbol2;
                boolean bl4 = false;
                IrProperty irProperty3 = (IrProperty)irPropertySymbol3.getOwner();
                this.propertyCache.put((FirProperty)fir, irProperty3);
                return irPropertySymbol3;
            }
            IrDeclarationParent irDeclarationParent = irParent;
            if (!(irDeclarationParent instanceof IrDeclaration)) {
                irDeclarationParent = null;
            }
            if ((object = (IrDeclaration)((Object)irDeclarationParent)) == null || (object = object.getOrigin()) == null) {
                object = IrDeclarationOrigin.DEFINED.INSTANCE;
            }
            Object parentOrigin = object;
            IrProperty irProperty4 = Fir2IrDeclarationStorage.createIrProperty$default(this, (FirProperty)fir, irParent, null, (IrDeclarationOrigin)parentOrigin, 4, null);
            boolean it = false;
            boolean irPropertySymbol3 = false;
            IrProperty $this$apply = irProperty4;
            boolean bl = false;
            this.setAndModifyParent($this$apply, irParent);
            irBindableSymbol = irProperty4.getSymbol();
        } else if (fir instanceof FirField) {
            IrField irField = this.fieldCache.get(fir);
            if (irField != null) {
                IrField irField2 = irField;
                boolean bl = false;
                boolean bl5 = false;
                IrField it = irField2;
                boolean bl6 = false;
                return it.getSymbol();
            }
            IrField irField3 = this.createIrField((FirField)fir);
            boolean bl = false;
            boolean bl7 = false;
            IrField $this$apply = irField3;
            boolean bl8 = false;
            this.setAndModifyParent($this$apply, this.findIrParent$fir2ir(fir));
            irBindableSymbol = (IrBindableSymbol)irField3.getSymbol();
        } else {
            throw (Throwable)new IllegalArgumentException("Unexpected fir in property symbol: " + FirRendererKt.render$default(fir, null, 1, null));
        }
        return irBindableSymbol;
    }

    @NotNull
    public final IrSymbol getIrBackingFieldSymbol(@NotNull FirVariableSymbol<?> firVariableSymbol) {
        IrBindableSymbol irBindableSymbol;
        Intrinsics.checkNotNullParameter(firVariableSymbol, "firVariableSymbol");
        FirVariable fir = (FirVariable)firVariableSymbol.getFir();
        if (fir instanceof FirProperty) {
            Object object;
            IrProperty irProperty = this.propertyCache.get(fir);
            if (irProperty != null) {
                IrProperty irProperty2 = irProperty;
                boolean bl = false;
                boolean bl2 = false;
                IrProperty it = irProperty2;
                boolean bl3 = false;
                IrField irField = it.getBackingField();
                Intrinsics.checkNotNull(irField);
                return irField.getSymbol();
            }
            IrDeclarationParent irParent = this.findIrParent$fir2ir(fir);
            IrDeclarationParent irDeclarationParent = irParent;
            if (!(irDeclarationParent instanceof IrDeclaration)) {
                irDeclarationParent = null;
            }
            if ((object = (IrDeclaration)((Object)irDeclarationParent)) == null || (object = object.getOrigin()) == null) {
                object = IrDeclarationOrigin.DEFINED.INSTANCE;
            }
            Object parentOrigin = object;
            IrProperty irProperty3 = Fir2IrDeclarationStorage.createIrProperty$default(this, (FirProperty)fir, irParent, null, (IrDeclarationOrigin)parentOrigin, 4, null);
            boolean bl = false;
            boolean bl4 = false;
            IrProperty $this$apply = irProperty3;
            boolean bl5 = false;
            this.setAndModifyParent($this$apply, irParent);
            IrField irField = irProperty3.getBackingField();
            Intrinsics.checkNotNull(irField);
            irBindableSymbol = (IrBindableSymbol)irField.getSymbol();
        } else {
            irBindableSymbol = this.getIrVariableSymbol(fir);
        }
        return irBindableSymbol;
    }

    private final IrVariableSymbol getIrVariableSymbol(FirVariable<?> firVariable) {
        Object object = this.localStorage.getVariable(firVariable);
        if (object == null || (object = (IrVariableSymbol)object.getSymbol()) == null) {
            throw (Throwable)new IllegalArgumentException("Cannot find variable " + FirRendererKt.render$default(firVariable, null, 1, null) + " in local storage");
        }
        return object;
    }

    @NotNull
    public final IrSymbol getIrValueSymbol(@NotNull FirVariableSymbol<?> firVariableSymbol) {
        IrBindableSymbol irBindableSymbol;
        Intrinsics.checkNotNullParameter(firVariableSymbol, "firVariableSymbol");
        FirVariable firDeclaration = (FirVariable)firVariableSymbol.getFir();
        if (firDeclaration instanceof FirEnumEntry) {
            Object object;
            IrClass irClass2;
            FirClassLikeSymbol<?> parentClassSymbol;
            FirClassLikeSymbol<?> firClassLikeSymbol;
            boolean bl;
            IrEnumEntry irEnumEntry = this.getClassifierStorage().getCachedIrEnumEntry((FirEnumEntry)firDeclaration);
            if (irEnumEntry != null) {
                IrEnumEntry irEnumEntry2 = irEnumEntry;
                boolean bl2 = false;
                boolean bl3 = false;
                IrEnumEntry it = irEnumEntry2;
                boolean bl4 = false;
                return it.getSymbol();
            }
            FirFile containingFile = this.firProvider.getFirCallableContainerFile((FirCallableSymbol)firVariableSymbol);
            ClassId classId = firVariableSymbol.getCallableId().getClassId();
            if (classId != null) {
                ClassId classId2 = classId;
                boolean bl5 = false;
                bl = false;
                ClassId it = classId2;
                boolean bl6 = false;
                firClassLikeSymbol = this.firSymbolProvider.getClassLikeSymbolByFqName(it);
            } else {
                firClassLikeSymbol = null;
            }
            FirClassLikeSymbol<?> firClassLikeSymbol2 = parentClassSymbol = firClassLikeSymbol;
            FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol2 != null ? (FirClassLikeDeclaration)firClassLikeSymbol2.getFir() : null;
            if (!(firClassLikeDeclaration instanceof FirClass)) {
                firClassLikeDeclaration = null;
            }
            FirClass firClass = (FirClass)firClassLikeDeclaration;
            if (firClass != null) {
                FirClass firClass2 = firClass;
                bl = false;
                boolean bl7 = false;
                FirClass it = firClass2;
                boolean bl8 = false;
                irClass2 = this.getClassifierStorage().getCachedIrClass(it);
            } else {
                irClass2 = null;
            }
            IrClass irParentClass = irClass2;
            Fir2IrClassifierStorage fir2IrClassifierStorage = this.getClassifierStorage();
            FirEnumEntry firEnumEntry = (FirEnumEntry)firDeclaration;
            if (containingFile != null) {
                object = IrDeclarationOrigin.DEFINED.INSTANCE;
            } else {
                FirClassLikeSymbol<?> firClassLikeSymbol3 = parentClassSymbol;
                FirClassLikeDeclaration firClassLikeDeclaration2 = firClassLikeSymbol3 != null ? (FirClassLikeDeclaration)firClassLikeSymbol3.getFir() : null;
                if (!(firClassLikeDeclaration2 instanceof FirClass)) {
                    firClassLikeDeclaration2 = null;
                }
                if ((object = (FirClass)firClassLikeDeclaration2) == null || (object = ConversionUtilsKt.irOrigin(object, this.firProvider)) == null) {
                    object = IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE;
                }
            }
            irBindableSymbol = (IrBindableSymbol)fir2IrClassifierStorage.createIrEnumEntry(firEnumEntry, irParentClass, (IrDeclarationOrigin)object).getSymbol();
        } else if (firDeclaration instanceof FirValueParameter) {
            Object object = this.localStorage.getParameter((FirValueParameter)firDeclaration);
            if (object == null || (object = (IrValueParameterSymbol)object.getSymbol()) == null) {
                return this.getIrVariableSymbol(firDeclaration);
            }
            irBindableSymbol = (IrBindableSymbol)object;
        } else {
            irBindableSymbol = this.getIrVariableSymbol(firDeclaration);
        }
        return irBindableSymbol;
    }

    /*
     * WARNING - void declaration
     */
    private final void populateOverriddenSymbols(IrSimpleFunction $this$populateOverriddenSymbols, IrClass thisReceiverOwner) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = ConversionUtilsKt.findMatchingOverriddenSymbolsFromSupertypes$default(thisReceiverOwner, this.components.getIrBuiltIns(), $this$populateOverriddenSymbols, null, null, 12, null);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunctionSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        Collection collection = it;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            $this$populateOverriddenSymbols.setOverriddenSymbols(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void populateOverriddenSymbols(IrField $this$populateOverriddenSymbols, IrClass thisReceiverOwner) {
        block1: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ConversionUtilsKt.findMatchingOverriddenSymbolsFromSupertypes$default(thisReceiverOwner, this.components.getIrBuiltIns(), $this$populateOverriddenSymbols, null, null, 12, null);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrFieldSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            IrFieldSymbol irFieldSymbol = (IrFieldSymbol)CollectionsKt.singleOrNull((List)destination$iv$iv);
            if (irFieldSymbol == null) break block1;
            IrFieldSymbol irFieldSymbol2 = irFieldSymbol;
            boolean bl = false;
            boolean bl2 = false;
            IrFieldSymbol it = irFieldSymbol2;
            boolean bl3 = false;
            $this$populateOverriddenSymbols.setOverriddenSymbols(CollectionsKt.listOf(it));
        }
    }

    public Fir2IrDeclarationStorage(@NotNull Fir2IrComponents components, @NotNull FirModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(components, "components");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        this.components = components;
        this.moduleDescriptor = moduleDescriptor;
        this.firSymbolProvider = ResolveUtilsKt.getFirSymbolProvider(this.getSession());
        this.firProvider = ResolveUtilsKt.getFirProvider(this.getSession());
        boolean bl = false;
        this.fragmentCache = new LinkedHashMap();
        bl = false;
        this.builtInsFragmentCache = new LinkedHashMap();
        bl = false;
        this.fileCache = new LinkedHashMap();
        bl = false;
        this.functionCache = new LinkedHashMap();
        bl = false;
        this.constructorCache = new LinkedHashMap();
        bl = false;
        this.initializerCache = new LinkedHashMap();
        bl = false;
        this.propertyCache = new LinkedHashMap();
        bl = false;
        this.fieldCache = new LinkedHashMap();
        this.localStorage = new Fir2IrLocalStorage();
    }

    static {
        Companion = new Companion(null);
        ENUM_SYNTHETIC_NAMES = MapsKt.mapOf(TuplesKt.to(Name.identifier("values"), IrSyntheticBodyKind.ENUM_VALUES), TuplesKt.to(Name.identifier("valueOf"), IrSyntheticBodyKind.ENUM_VALUEOF));
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public Fir2IrSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    public static final /* synthetic */ IrType access$toIrType(Fir2IrDeclarationStorage $this, FirTypeRef $this$access_u24toIrType, ConversionTypeContext typeContext) {
        return $this.toIrType($this$access_u24toIrType, typeContext);
    }

    public static final /* synthetic */ Map access$getInitializerCache$p(Fir2IrDeclarationStorage $this) {
        return $this.initializerCache;
    }

    public static final /* synthetic */ IrFunction access$bindAndDeclareParameters(Fir2IrDeclarationStorage $this, IrFunction $this$access_u24bindAndDeclareParameters, FirFunction function2, WrappedCallableDescriptor descriptor2, IrDeclarationParent irParent, IrClass thisReceiverOwner, boolean isStatic, FirTypeRef parentPropertyReceiverType) {
        return $this.bindAndDeclareParameters($this$access_u24bindAndDeclareParameters, function2, descriptor2, irParent, thisReceiverOwner, isStatic, parentPropertyReceiverType);
    }

    public static final /* synthetic */ IrFunction access$declareDefaultSetterParameter(Fir2IrDeclarationStorage $this, IrFunction $this$access_u24declareDefaultSetterParameter, IrType type2) {
        return $this.declareDefaultSetterParameter($this$access_u24declareDefaultSetterParameter, type2);
    }

    public static final /* synthetic */ void access$populateOverriddenSymbols(Fir2IrDeclarationStorage $this, IrSimpleFunction $this$access_u24populateOverriddenSymbols, IrClass thisReceiverOwner) {
        $this.populateOverriddenSymbols($this$access_u24populateOverriddenSymbols, thisReceiverOwner);
    }

    public static final /* synthetic */ void access$populateOverriddenSymbols(Fir2IrDeclarationStorage $this, IrField $this$access_u24populateOverriddenSymbols, IrClass thisReceiverOwner) {
        $this.populateOverriddenSymbols($this$access_u24populateOverriddenSymbols, thisReceiverOwner);
    }

    public static final /* synthetic */ IrField access$createBackingField(Fir2IrDeclarationStorage $this, IrProperty $this$access_u24createBackingField, FirProperty property2, IrDeclarationOrigin origin, PropertyDescriptor descriptor2, Visibility visibility, Name name, boolean isFinal, FirExpression firInitializerExpression, IrClass thisReceiverOwner, IrType type2) {
        return $this.createBackingField($this$access_u24createBackingField, property2, origin, descriptor2, visibility, name, isFinal, firInitializerExpression, thisReceiverOwner, type2);
    }

    public static final /* synthetic */ Visibility access$getFieldVisibility$p(Fir2IrDeclarationStorage $this, FirProperty $this$access_u24fieldVisibility_u24p) {
        return $this.getFieldVisibility($this$access_u24fieldVisibility_u24p);
    }

    public static final /* synthetic */ IrSimpleFunction access$createIrPropertyAccessor(Fir2IrDeclarationStorage $this, FirPropertyAccessor propertyAccessor, FirProperty property2, IrProperty correspondingProperty, IrType propertyType, IrDeclarationParent irParent, IrClass thisReceiverOwner, boolean isSetter, IrDeclarationOrigin origin, int startOffset, int endOffset) {
        return $this.createIrPropertyAccessor(propertyAccessor, property2, correspondingProperty, propertyType, irParent, thisReceiverOwner, isSetter, origin, startOffset, endOffset);
    }

    public static final /* synthetic */ Map access$getPropertyCache$p(Fir2IrDeclarationStorage $this) {
        return $this.propertyCache;
    }

    public static final /* synthetic */ Map access$getFieldCache$p(Fir2IrDeclarationStorage $this) {
        return $this.fieldCache;
    }

    public static final /* synthetic */ IrType access$toIrType(Fir2IrDeclarationStorage $this, ConeKotlinType $this$access_u24toIrType, ConversionTypeContext typeContext) {
        return $this.toIrType($this$access_u24toIrType, typeContext);
    }

    public static final /* synthetic */ IrVariable access$declareIrVariable(Fir2IrDeclarationStorage $this, int startOffset, int endOffset, IrDeclarationOrigin origin, Name name, IrType type2, boolean isVar, boolean isConst, boolean isLateinit) {
        return $this.declareIrVariable(startOffset, endOffset, origin, name, type2, isVar, isConst, isLateinit);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage$Companion;", "", "()V", "ENUM_SYNTHETIC_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/expressions/IrSyntheticBodyKind;", "getENUM_SYNTHETIC_NAMES$fir2ir", "()Ljava/util/Map;", "fir2ir"})
    public static final class Companion {
        @NotNull
        public final Map<Name, IrSyntheticBodyKind> getENUM_SYNTHETIC_NAMES$fir2ir() {
            return ENUM_SYNTHETIC_NAMES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

