/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.io.InputStream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class ActivationDataFlavor
extends DataFlavor {
    private String mimeType;
    private String humanPresentableName;
    private Class representationClass;

    public ActivationDataFlavor(Class clazz, String string, String string2) {
        super(string, string2);
        this.mimeType = string;
        this.humanPresentableName = string2;
        this.representationClass = clazz;
    }

    public ActivationDataFlavor(Class clazz, String string) {
        super(clazz, string);
        this.mimeType = super.getMimeType();
        this.representationClass = clazz;
        this.humanPresentableName = string;
    }

    public ActivationDataFlavor(String string, String string2) {
        super(string, string2);
        this.mimeType = string;
        this.humanPresentableName = string2;
        this.representationClass = InputStream.class;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    @Override
    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    @Override
    public void setHumanPresentableName(String string) {
        this.humanPresentableName = string;
    }

    @Override
    public boolean equals(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor) && dataFlavor.getRepresentationClass() == this.representationClass;
    }

    @Override
    public boolean isMimeTypeEqual(String string) {
        try {
            return new MimeType(this.mimeType).match(new MimeType(string));
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            return false;
        }
    }

    @Override
    protected String normalizeMimeTypeParameter(String string, String string2) {
        return new StringBuffer(string).append('=').append(string2).toString();
    }

    @Override
    protected String normalizeMimeType(String string) {
        return string;
    }
}

