/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

public final class Utils {
    private static final ResourceBundle messages = ResourceBundle.getBundle(Utils.class.getPackage().getName() + ".LocalStrings");
    public static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;
    public static final String DISCONNECTION_SQL_CODE_PREFIX = "08";
    public static final Set<String> DISCONNECTION_SQL_CODES = new HashSet<String>();

    public static char[] clone(char[] cArray) {
        return cArray == null ? null : (char[])cArray.clone();
    }

    public static void closeQuietly(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getMessage(String string) {
        return Utils.getMessage(string, null);
    }

    public static String getMessage(String string, Object ... objectArray) {
        String string2 = messages.getString(string);
        if (objectArray == null || objectArray.length == 0) {
            return string2;
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        return messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    public static char[] toCharArray(String string) {
        return string != null ? string.toCharArray() : null;
    }

    public static String toString(char[] cArray) {
        return cArray == null ? null : String.valueOf(cArray);
    }

    private Utils() {
    }

    static {
        DISCONNECTION_SQL_CODES.add("57P01");
        DISCONNECTION_SQL_CODES.add("57P02");
        DISCONNECTION_SQL_CODES.add("57P03");
        DISCONNECTION_SQL_CODES.add("01002");
        DISCONNECTION_SQL_CODES.add("JZ0C0");
        DISCONNECTION_SQL_CODES.add("JZ0C1");
    }
}

