/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.URLEncoder;
import org.apache.naming.resources.CacheEntry;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.tomcat.util.http.parser.EntityTag;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class DefaultServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.servlets");
    private static final DocumentBuilderFactory factory;
    private static final SecureEntityResolver secureEntityResolver;
    protected static final ArrayList<Range> FULL;
    protected static final String mimeSeparation = "CATALINA_MIME_BOUNDARY";
    protected static final String RESOURCES_JNDI_NAME = "java:/comp/Resources";
    protected static final int BUFFER_SIZE = 4096;
    protected static final URLEncoder urlEncoder;
    protected int debug = 0;
    protected int input = 2048;
    protected boolean listings = false;
    protected boolean readOnly = true;
    protected int output = 2048;
    protected String localXsltFile = null;
    protected String contextXsltFile = null;
    protected String globalXsltFile = null;
    protected String readmeFile = null;
    protected transient ProxyDirContext resources = null;
    protected String fileEncoding = null;
    protected int sendfileSize = 49152;
    protected boolean useAcceptRanges = true;
    protected boolean showServerInfo = true;

    public void destroy() {
    }

    public void init() throws ServletException {
        if (this.getServletConfig().getInitParameter("debug") != null) {
            this.debug = Integer.parseInt(this.getServletConfig().getInitParameter("debug"));
        }
        if (this.getServletConfig().getInitParameter("input") != null) {
            this.input = Integer.parseInt(this.getServletConfig().getInitParameter("input"));
        }
        if (this.getServletConfig().getInitParameter("output") != null) {
            this.output = Integer.parseInt(this.getServletConfig().getInitParameter("output"));
        }
        this.listings = Boolean.parseBoolean(this.getServletConfig().getInitParameter("listings"));
        if (this.getServletConfig().getInitParameter("readonly") != null) {
            this.readOnly = Boolean.parseBoolean(this.getServletConfig().getInitParameter("readonly"));
        }
        if (this.getServletConfig().getInitParameter("sendfileSize") != null) {
            this.sendfileSize = Integer.parseInt(this.getServletConfig().getInitParameter("sendfileSize")) * 1024;
        }
        this.fileEncoding = this.getServletConfig().getInitParameter("fileEncoding");
        this.globalXsltFile = this.getServletConfig().getInitParameter("globalXsltFile");
        this.contextXsltFile = this.getServletConfig().getInitParameter("contextXsltFile");
        this.localXsltFile = this.getServletConfig().getInitParameter("localXsltFile");
        this.readmeFile = this.getServletConfig().getInitParameter("readmeFile");
        if (this.getServletConfig().getInitParameter("useAcceptRanges") != null) {
            this.useAcceptRanges = Boolean.parseBoolean(this.getServletConfig().getInitParameter("useAcceptRanges"));
        }
        if (this.input < 256) {
            this.input = 256;
        }
        if (this.output < 256) {
            this.output = 256;
        }
        if (this.debug > 0) {
            this.log("DefaultServlet.init:  input buffer size=" + this.input + ", output buffer size=" + this.output);
        }
        this.resources = (ProxyDirContext)this.getServletContext().getAttribute("org.apache.catalina.resources");
        if (this.resources == null) {
            try {
                this.resources = (ProxyDirContext)new InitialContext().lookup(RESOURCES_JNDI_NAME);
            }
            catch (NamingException namingException) {
                throw new ServletException("No resources", (Throwable)namingException);
            }
        }
        if (this.resources == null) {
            throw new UnavailableException(sm.getString("defaultServlet.noResources"));
        }
        if (this.getServletConfig().getInitParameter("showServerInfo") != null) {
            this.showServerInfo = Boolean.parseBoolean(this.getServletConfig().getInitParameter("showServerInfo"));
        }
    }

    protected String getRelativePath(HttpServletRequest httpServletRequest) {
        return this.getRelativePath(httpServletRequest, false);
    }

    protected String getRelativePath(HttpServletRequest httpServletRequest, boolean bl) {
        String string;
        String string2;
        if (httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
            string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        } else {
            string2 = httpServletRequest.getPathInfo();
            string = httpServletRequest.getServletPath();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            stringBuilder.append(string);
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        if (stringBuilder.length() == 0 && !bl) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    protected String getPathPrefix(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getContextPath();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (httpServletRequest.getDispatcherType() == DispatcherType.ERROR) {
            this.doGet(httpServletRequest, httpServletResponse);
        } else {
            super.service(httpServletRequest, httpServletResponse);
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.serveResource(httpServletRequest, httpServletResponse, true);
    }

    protected void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        boolean bl = DispatcherType.INCLUDE.equals((Object)httpServletRequest.getDispatcherType());
        this.serveResource(httpServletRequest, httpServletResponse, bl);
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setHeader("Allow", this.determineMethodsAllowed(httpServletRequest));
    }

    protected String determineMethodsAllowed(HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OPTIONS, GET, HEAD, POST");
        if (!this.readOnly) {
            stringBuilder.append(", PUT, DELETE");
        }
        if (httpServletRequest instanceof RequestFacade && ((RequestFacade)httpServletRequest).getAllowTrace()) {
            stringBuilder.append(", TRACE");
        }
        return stringBuilder.toString();
    }

    protected void sendNotAllowed(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.addHeader("Allow", this.determineMethodsAllowed(httpServletRequest));
        httpServletResponse.sendError(405);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        boolean bl = true;
        try {
            this.resources.lookup(string);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        boolean bl2 = true;
        Range range = this.parseContentRange(httpServletRequest, httpServletResponse);
        Object object = null;
        try {
            Object object2;
            if (range != null) {
                object2 = this.executePartialPut(httpServletRequest, range, string);
                object = new FileInputStream((File)object2);
            } else {
                object = httpServletRequest.getInputStream();
            }
            object2 = new Resource((InputStream)object);
            if (bl) {
                this.resources.rebind(string, object2);
            } else {
                this.resources.bind(string, object2);
            }
        }
        catch (NamingException namingException) {
            bl2 = false;
        }
        if (bl2) {
            if (bl) {
                httpServletResponse.setStatus(204);
            } else {
                httpServletResponse.setStatus(201);
            }
        } else {
            httpServletResponse.sendError(409);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File executePartialPut(HttpServletRequest httpServletRequest, Range range, String string) throws IOException {
        String string2;
        File file = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        File file2 = new File(file, string2 = string.replace('/', '.'));
        if (file2.createNewFile()) {
            file2.deleteOnExit();
        }
        RandomAccessFile randomAccessFile = null;
        try {
            Object object;
            Object object2;
            randomAccessFile = new RandomAccessFile(file2, "rw");
            Resource resource = null;
            try {
                object2 = this.resources.lookup(string);
                if (object2 instanceof Resource) {
                    resource = (Resource)object2;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (resource != null) {
                object2 = null;
                try {
                    int n;
                    object2 = new BufferedInputStream(resource.streamContent(), 4096);
                    object = new byte[4096];
                    while ((n = ((FilterInputStream)object2).read((byte[])object)) != -1) {
                        randomAccessFile.write((byte[])object, 0, n);
                    }
                }
                finally {
                    if (object2 != null) {
                        try {
                            ((BufferedInputStream)object2).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            randomAccessFile.setLength(range.length);
            randomAccessFile.seek(range.start);
            byte[] byArray = new byte[4096];
            object = null;
            try {
                int n;
                object = new BufferedInputStream((InputStream)httpServletRequest.getInputStream(), 4096);
                while ((n = ((FilterInputStream)object).read(byArray)) != -1) {
                    randomAccessFile.write(byArray, 0, n);
                }
            }
            finally {
                if (object != null) {
                    try {
                        ((BufferedInputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file2;
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        boolean bl = true;
        try {
            this.resources.lookup(string);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        if (bl) {
            boolean bl2 = true;
            try {
                this.resources.unbind(string);
            }
            catch (NamingException namingException) {
                bl2 = false;
            }
            if (bl2) {
                httpServletResponse.setStatus(204);
            } else {
                httpServletResponse.sendError(405);
            }
        } else {
            httpServletResponse.sendError(404);
        }
    }

    protected boolean checkIfHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceAttributes resourceAttributes) throws IOException {
        return this.checkIfMatch(httpServletRequest, httpServletResponse, resourceAttributes) && this.checkIfModifiedSince(httpServletRequest, httpServletResponse, resourceAttributes) && this.checkIfNoneMatch(httpServletRequest, httpServletResponse, resourceAttributes) && this.checkIfUnmodifiedSince(httpServletRequest, httpServletResponse, resourceAttributes);
    }

    protected String rewriteUrl(String string) {
        return urlEncoder.encode(string, "UTF-8");
    }

    @Deprecated
    protected void displaySize(StringBuilder stringBuilder, int n) {
        int n2 = n / 1024;
        int n3 = n % 1024 / 103;
        if (n2 == 0 && n3 == 0 && n != 0) {
            n3 = 1;
        }
        stringBuilder.append(n2).append(".").append(n3);
        stringBuilder.append(" KB");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws IOException, ServletException {
        String string;
        boolean bl2;
        boolean bl3 = bl;
        String string2 = this.getRelativePath(httpServletRequest, true);
        if (this.debug > 0) {
            if (bl3) {
                this.log("DefaultServlet.serveResource:  Serving resource '" + string2 + "' headers and data");
            } else {
                this.log("DefaultServlet.serveResource:  Serving resource '" + string2 + "' headers only");
            }
        }
        if (string2.length() == 0) {
            this.doDirectoryRedirect(httpServletRequest, httpServletResponse);
            return;
        }
        CacheEntry cacheEntry = this.resources.lookupCache(string2);
        boolean bl4 = bl2 = DispatcherType.ERROR == httpServletRequest.getDispatcherType();
        if (!cacheEntry.exists) {
            String string3 = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
            if (string3 != null) {
                throw new FileNotFoundException(sm.getString("defaultServlet.missingResource", new Object[]{string3}));
            }
            string3 = httpServletRequest.getRequestURI();
            if (bl2) {
                httpServletResponse.sendError(((Integer)httpServletRequest.getAttribute("javax.servlet.error.status_code")).intValue());
                return;
            } else {
                httpServletResponse.sendError(404, sm.getString("defaultServlet.missingResource", new Object[]{string3}));
            }
            return;
        }
        if (cacheEntry.context == null) {
            boolean bl5;
            boolean bl6 = bl5 = httpServletRequest.getAttribute("javax.servlet.include.context_path") != null;
            if (!(bl5 || bl2 || this.checkIfHeaders(httpServletRequest, httpServletResponse, cacheEntry.attributes))) {
                return;
            }
        }
        if ((string = cacheEntry.attributes.getMimeType()) == null) {
            string = this.getServletContext().getMimeType(cacheEntry.name);
            cacheEntry.attributes.setMimeType(string);
        }
        ArrayList<Range> arrayList = null;
        long l = -1L;
        if (cacheEntry.context != null) {
            if (!string2.endsWith("/")) {
                this.doDirectoryRedirect(httpServletRequest, httpServletResponse);
                return;
            }
            if (!this.listings) {
                httpServletResponse.sendError(404, sm.getString("defaultServlet.missingResource", new Object[]{httpServletRequest.getRequestURI()}));
                return;
            }
            string = "text/html;charset=UTF-8";
        } else {
            if (!bl2) {
                if (this.useAcceptRanges) {
                    httpServletResponse.setHeader("Accept-Ranges", "bytes");
                }
                arrayList = this.parseRange(httpServletRequest, httpServletResponse, cacheEntry.attributes);
                httpServletResponse.setHeader("ETag", this.generateETag(cacheEntry.attributes));
                httpServletResponse.setHeader("Last-Modified", cacheEntry.attributes.getLastModifiedHttp());
            }
            if ((l = cacheEntry.attributes.getContentLength()) == 0L) {
                bl3 = false;
            }
        }
        ServletOutputStream servletOutputStream = null;
        PrintWriter printWriter = null;
        if (bl3) {
            try {
                servletOutputStream = httpServletResponse.getOutputStream();
            }
            catch (IllegalStateException illegalStateException) {
                if (string != null && !string.startsWith("text") && !string.endsWith("xml") && !string.contains("/javascript")) throw illegalStateException;
                printWriter = httpServletResponse.getWriter();
                arrayList = FULL;
            }
        }
        HttpServletResponse httpServletResponse2 = httpServletResponse;
        long l2 = 0L;
        while (httpServletResponse2 instanceof ServletResponseWrapper) {
            httpServletResponse2 = ((ServletResponseWrapper)httpServletResponse2).getResponse();
        }
        if (httpServletResponse2 instanceof ResponseFacade) {
            l2 = ((ResponseFacade)httpServletResponse2).getContentWritten();
        }
        if (l2 > 0L) {
            arrayList = FULL;
        }
        if (cacheEntry.context != null || bl2 || (arrayList == null || arrayList.isEmpty()) && httpServletRequest.getHeader("Range") == null || arrayList == FULL) {
            if (string != null) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentType='" + string + "'");
                }
                httpServletResponse.setContentType(string);
            }
            if (!(cacheEntry.resource == null || l < 0L || bl3 && servletOutputStream == null)) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentLength=" + l);
                }
                if (l2 == 0L) {
                    if (l < Integer.MAX_VALUE) {
                        httpServletResponse.setContentLength((int)l);
                    } else {
                        httpServletResponse.setHeader("content-length", "" + l);
                    }
                }
            }
            InputStream inputStream = null;
            if (cacheEntry.context != null && bl3) {
                inputStream = this.render(this.getPathPrefix(httpServletRequest), cacheEntry);
            }
            if (!bl3) return;
            try {
                httpServletResponse.setBufferSize(this.output);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (servletOutputStream != null) {
                if (this.checkSendfile(httpServletRequest, httpServletResponse, cacheEntry, l, null)) return;
                this.copy(cacheEntry, inputStream, servletOutputStream);
                return;
            } else {
                this.copy(cacheEntry, inputStream, printWriter);
            }
            return;
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        httpServletResponse.setStatus(206);
        if (arrayList.size() == 1) {
            Range range = arrayList.get(0);
            httpServletResponse.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
            long l3 = range.end - range.start + 1L;
            if (l3 < Integer.MAX_VALUE) {
                httpServletResponse.setContentLength((int)l3);
            } else {
                httpServletResponse.setHeader("content-length", "" + l3);
            }
            if (string != null) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentType='" + string + "'");
                }
                httpServletResponse.setContentType(string);
            }
            if (!bl3) return;
            try {
                httpServletResponse.setBufferSize(this.output);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (servletOutputStream == null) throw new IllegalStateException();
            if (this.checkSendfile(httpServletRequest, httpServletResponse, cacheEntry, range.end - range.start + 1L, range)) return;
            this.copy(cacheEntry, servletOutputStream, range);
            return;
        }
        httpServletResponse.setContentType("multipart/byteranges; boundary=CATALINA_MIME_BOUNDARY");
        if (!bl3) return;
        try {
            httpServletResponse.setBufferSize(this.output);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (servletOutputStream == null) throw new IllegalStateException();
        this.copy(cacheEntry, servletOutputStream, arrayList.iterator(), string);
    }

    private void doDirectoryRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(httpServletRequest.getRequestURI());
        stringBuilder.append('/');
        if (httpServletRequest.getQueryString() != null) {
            stringBuilder.append('?');
            stringBuilder.append(httpServletRequest.getQueryString());
        }
        while (stringBuilder.length() > 1 && stringBuilder.charAt(1) == '/') {
            stringBuilder.deleteCharAt(0);
        }
        httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(stringBuilder.toString()));
    }

    protected Range parseContentRange(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getHeader("Content-Range");
        if (string == null) {
            return null;
        }
        if (!string.startsWith("bytes")) {
            httpServletResponse.sendError(400);
            return null;
        }
        string = string.substring(6).trim();
        int n = string.indexOf(45);
        int n2 = string.indexOf(47);
        if (n == -1) {
            httpServletResponse.sendError(400);
            return null;
        }
        if (n2 == -1) {
            httpServletResponse.sendError(400);
            return null;
        }
        Range range = new Range();
        try {
            range.start = Long.parseLong(string.substring(0, n));
            range.end = Long.parseLong(string.substring(n + 1, n2));
            range.length = Long.parseLong(string.substring(n2 + 1, string.length()));
        }
        catch (NumberFormatException numberFormatException) {
            httpServletResponse.sendError(400);
            return null;
        }
        if (!range.validate()) {
            httpServletResponse.sendError(400);
            return null;
        }
        return range;
    }

    protected ArrayList<Range> parseRange(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceAttributes resourceAttributes) throws IOException {
        String string;
        long l;
        String string2 = httpServletRequest.getHeader("If-Range");
        if (string2 != null) {
            l = -1L;
            try {
                l = httpServletRequest.getDateHeader("If-Range");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            string = this.generateETag(resourceAttributes);
            long l2 = resourceAttributes.getLastModified();
            if (l == -1L ? !string.equals(string2.trim()) : l2 > l + 1000L) {
                return FULL;
            }
        }
        if ((l = resourceAttributes.getContentLength()) == 0L) {
            return null;
        }
        string = httpServletRequest.getHeader("Range");
        if (string == null) {
            return null;
        }
        if (!string.startsWith("bytes")) {
            httpServletResponse.addHeader("Content-Range", "bytes */" + l);
            httpServletResponse.sendError(416);
            return null;
        }
        string = string.substring(6);
        ArrayList<Range> arrayList = new ArrayList<Range>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            Range range = new Range();
            range.length = l;
            int n = string3.indexOf(45);
            if (n == -1) {
                httpServletResponse.addHeader("Content-Range", "bytes */" + l);
                httpServletResponse.sendError(416);
                return null;
            }
            if (n == 0) {
                try {
                    long l3 = Long.parseLong(string3);
                    range.start = l + l3;
                    range.end = l - 1L;
                }
                catch (NumberFormatException numberFormatException) {
                    httpServletResponse.addHeader("Content-Range", "bytes */" + l);
                    httpServletResponse.sendError(416);
                    return null;
                }
            }
            try {
                range.start = Long.parseLong(string3.substring(0, n));
                range.end = n < string3.length() - 1 ? Long.parseLong(string3.substring(n + 1, string3.length())) : l - 1L;
            }
            catch (NumberFormatException numberFormatException) {
                httpServletResponse.addHeader("Content-Range", "bytes */" + l);
                httpServletResponse.sendError(416);
                return null;
            }
            if (!range.validate()) {
                httpServletResponse.addHeader("Content-Range", "bytes */" + l);
                httpServletResponse.sendError(416);
                return null;
            }
            arrayList.add(range);
        }
        return arrayList;
    }

    protected InputStream render(String string, CacheEntry cacheEntry) throws IOException, ServletException {
        Source source = this.findXsltInputStream(cacheEntry.context);
        if (source == null) {
            return this.renderHtml(string, cacheEntry);
        }
        return this.renderXml(string, cacheEntry, source);
    }

    protected InputStream renderXml(String string, CacheEntry cacheEntry, Source source) throws IOException, ServletException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\"?>");
        stringBuilder.append("<listing ");
        stringBuilder.append(" contextPath='");
        stringBuilder.append(string);
        stringBuilder.append("'");
        stringBuilder.append(" directory='");
        stringBuilder.append(cacheEntry.name);
        stringBuilder.append("' ");
        stringBuilder.append(" hasParent='").append(!cacheEntry.name.equals("/"));
        stringBuilder.append("'>");
        stringBuilder.append("<entries>");
        try {
            object6 = this.resources.list(cacheEntry.name);
            object5 = this.rewriteUrl(string);
            while (object6.hasMoreElements()) {
                object4 = (NameClassPair)object6.nextElement();
                object3 = ((NameClassPair)object4).getName();
                object2 = object3;
                if (((String)object2).equalsIgnoreCase("WEB-INF") || ((String)object2).equalsIgnoreCase("META-INF") || ((String)object2).equalsIgnoreCase(this.localXsltFile) || (cacheEntry.name + (String)object2).equals(this.contextXsltFile)) continue;
                object = this.resources.lookupCache(cacheEntry.name + (String)object3);
                if (!((CacheEntry)object).exists) continue;
                stringBuilder.append("<entry");
                stringBuilder.append(" type='").append(((CacheEntry)object).context != null ? "dir" : "file").append("'");
                stringBuilder.append(" urlPath='").append((String)object5).append(this.rewriteUrl(cacheEntry.name + (String)object3)).append(((CacheEntry)object).context != null ? "/" : "").append("'");
                if (((CacheEntry)object).resource != null) {
                    stringBuilder.append(" size='").append(this.renderSize(((CacheEntry)object).attributes.getContentLength())).append("'");
                }
                stringBuilder.append(" date='").append(((CacheEntry)object).attributes.getLastModifiedHttp()).append("'");
                stringBuilder.append(">");
                stringBuilder.append(RequestUtil.filter((String)object2));
                if (((CacheEntry)object).context != null) {
                    stringBuilder.append("/");
                }
                stringBuilder.append("</entry>");
            }
        }
        catch (NamingException namingException) {
            throw new ServletException("Error accessing resource", (Throwable)namingException);
        }
        stringBuilder.append("</entries>");
        object6 = this.getReadme(cacheEntry.context);
        if (object6 != null) {
            stringBuilder.append("<readme><![CDATA[");
            stringBuilder.append((String)object6);
            stringBuilder.append("]]></readme>");
        }
        stringBuilder.append("</listing>");
        if (Globals.IS_SECURITY_ENABLED) {
            object4 = new PrivilegedGetTccl();
            object5 = (ClassLoader)AccessController.doPrivileged(object4);
        } else {
            object5 = Thread.currentThread().getContextClassLoader();
        }
        try {
            if (Globals.IS_SECURITY_ENABLED) {
                object4 = new PrivilegedSetTccl(DefaultServlet.class.getClassLoader());
                AccessController.doPrivileged(object4);
            } else {
                Thread.currentThread().setContextClassLoader(DefaultServlet.class.getClassLoader());
            }
            object4 = TransformerFactory.newInstance();
            object3 = new StreamSource(new StringReader(stringBuilder.toString()));
            object2 = ((TransformerFactory)object4).newTransformer(source);
            object = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, "UTF-8");
            StreamResult streamResult = new StreamResult(outputStreamWriter);
            ((Transformer)object2).transform((Source)object3, streamResult);
            outputStreamWriter.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            return byteArrayInputStream;
        }
        catch (TransformerException transformerException) {
            throw new ServletException(sm.getString("defaultServlet.xslError"), (Throwable)transformerException);
        }
        finally {
            if (Globals.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl((ClassLoader)object5);
                AccessController.doPrivileged(privilegedSetTccl);
            } else {
                Thread.currentThread().setContextClassLoader((ClassLoader)object5);
            }
        }
    }

    protected InputStream renderHtml(String string, CacheEntry cacheEntry) throws IOException, ServletException {
        Object object;
        int n;
        String string2 = cacheEntry.name;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = this.rewriteUrl(string);
        stringBuilder.append("<!doctype html><html>\r\n");
        stringBuilder.append("<head>\r\n");
        stringBuilder.append("<title>");
        stringBuilder.append(sm.getString("directory.title", new Object[]{string2}));
        stringBuilder.append("</title>\r\n");
        stringBuilder.append("<style>");
        stringBuilder.append("body {font-family:Tahoma,Arial,sans-serif;} h1, h2, h3, b {color:white;background-color:#525D76;} h1 {font-size:22px;} h2 {font-size:16px;} h3 {font-size:14px;} p {font-size:12px;} a {color:black;} .line {height:1px;background-color:#525D76;border:none;}");
        stringBuilder.append("</style> ");
        stringBuilder.append("</head>\r\n");
        stringBuilder.append("<body>");
        stringBuilder.append("<h1>");
        stringBuilder.append(sm.getString("directory.title", new Object[]{string2}));
        String string4 = string2;
        if (string4.endsWith("/")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        if ((n = string4.lastIndexOf(47)) >= 0) {
            object = string2.substring(0, n);
            stringBuilder.append(" - <a href=\"");
            stringBuilder.append(string3);
            if (((String)object).equals("")) {
                object = "/";
            }
            stringBuilder.append(this.rewriteUrl((String)object));
            if (!((String)object).endsWith("/")) {
                stringBuilder.append("/");
            }
            stringBuilder.append("\">");
            stringBuilder.append("<b>");
            stringBuilder.append(sm.getString("directory.parent", new Object[]{object}));
            stringBuilder.append("</b>");
            stringBuilder.append("</a>");
        }
        stringBuilder.append("</h1>");
        stringBuilder.append("<hr class=\"line\">");
        stringBuilder.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        stringBuilder.append("<tr>\r\n");
        stringBuilder.append("<td align=\"left\"><font size=\"+1\"><strong>");
        stringBuilder.append(sm.getString("directory.filename"));
        stringBuilder.append("</strong></font></td>\r\n");
        stringBuilder.append("<td align=\"center\"><font size=\"+1\"><strong>");
        stringBuilder.append(sm.getString("directory.size"));
        stringBuilder.append("</strong></font></td>\r\n");
        stringBuilder.append("<td align=\"right\"><font size=\"+1\"><strong>");
        stringBuilder.append(sm.getString("directory.lastModified"));
        stringBuilder.append("</strong></font></td>\r\n");
        stringBuilder.append("</tr>");
        try {
            object = this.resources.list(cacheEntry.name);
            boolean bl = false;
            while (object.hasMoreElements()) {
                NameClassPair nameClassPair = (NameClassPair)object.nextElement();
                String string5 = nameClassPair.getName();
                String string6 = string5;
                if (string6.equalsIgnoreCase("WEB-INF") || string6.equalsIgnoreCase("META-INF")) continue;
                CacheEntry cacheEntry2 = this.resources.lookupCache(cacheEntry.name + string5);
                if (!cacheEntry2.exists) continue;
                stringBuilder.append("<tr");
                if (bl) {
                    stringBuilder.append(" bgcolor=\"#eeeeee\"");
                }
                stringBuilder.append(">\r\n");
                bl = !bl;
                stringBuilder.append("<td align=\"left\">&nbsp;&nbsp;\r\n");
                stringBuilder.append("<a href=\"");
                stringBuilder.append(string3);
                string5 = this.rewriteUrl(string2 + string5);
                stringBuilder.append(string5);
                if (cacheEntry2.context != null) {
                    stringBuilder.append("/");
                }
                stringBuilder.append("\"><tt>");
                stringBuilder.append(RequestUtil.filter(string6));
                if (cacheEntry2.context != null) {
                    stringBuilder.append("/");
                }
                stringBuilder.append("</tt></a></td>\r\n");
                stringBuilder.append("<td align=\"right\"><tt>");
                if (cacheEntry2.context != null) {
                    stringBuilder.append("&nbsp;");
                } else {
                    stringBuilder.append(this.renderSize(cacheEntry2.attributes.getContentLength()));
                }
                stringBuilder.append("</tt></td>\r\n");
                stringBuilder.append("<td align=\"right\"><tt>");
                stringBuilder.append(cacheEntry2.attributes.getLastModifiedHttp());
                stringBuilder.append("</tt></td>\r\n");
                stringBuilder.append("</tr>\r\n");
            }
        }
        catch (NamingException namingException) {
            throw new ServletException("Error accessing resource", (Throwable)namingException);
        }
        stringBuilder.append("</table>\r\n");
        stringBuilder.append("<hr class=\"line\">");
        object = this.getReadme(cacheEntry.context);
        if (object != null) {
            stringBuilder.append((String)object);
            stringBuilder.append("<hr class=\"line\">");
        }
        if (this.showServerInfo) {
            stringBuilder.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
        }
        stringBuilder.append("</body>\r\n");
        stringBuilder.append("</html>\r\n");
        printWriter.write(stringBuilder.toString());
        printWriter.flush();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    protected String renderSize(long l) {
        long l2 = l / 1024L;
        long l3 = l % 1024L / 103L;
        if (l2 == 0L && l3 == 0L && l > 0L) {
            l3 = 1L;
        }
        return "" + l2 + "." + l3 + " kb";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getReadme(DirContext dirContext) throws IOException {
        block17: {
            if (this.readmeFile != null) {
                try {
                    Object object = dirContext.lookup(this.readmeFile);
                    if (object == null || !(object instanceof Resource)) break block17;
                    StringWriter stringWriter = new StringWriter();
                    InputStream inputStream = null;
                    Reader reader = null;
                    try {
                        inputStream = ((Resource)object).streamContent();
                        reader = this.fileEncoding != null ? new InputStreamReader(inputStream, this.fileEncoding) : new InputStreamReader(inputStream);
                        this.copyRange(reader, new PrintWriter(stringWriter));
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {
                                this.log("Could not close reader", iOException);
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {
                                this.log("Could not close is", iOException);
                            }
                        }
                    }
                    return stringWriter.toString();
                }
                catch (NamingException namingException) {
                    if (this.debug > 10) {
                        this.log("readme '" + this.readmeFile + "' not found", namingException);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Source findXsltInputStream(DirContext dirContext) throws IOException {
        Object object;
        block20: {
            if (this.localXsltFile != null) {
                try {
                    InputStream inputStream;
                    object = dirContext.lookup(this.localXsltFile);
                    if (object != null && object instanceof Resource && (inputStream = ((Resource)object).streamContent()) != null) {
                        if (Globals.IS_SECURITY_ENABLED) {
                            return this.secureXslt(inputStream);
                        }
                        return new StreamSource(inputStream);
                    }
                }
                catch (NamingException namingException) {
                    if (this.debug <= 10) break block20;
                    this.log("localXsltFile '" + this.localXsltFile + "' not found", namingException);
                }
            }
        }
        if (this.contextXsltFile != null) {
            object = this.getServletContext().getResourceAsStream(this.contextXsltFile);
            if (object != null) {
                if (Globals.IS_SECURITY_ENABLED) {
                    return this.secureXslt((InputStream)object);
                }
                return new StreamSource((InputStream)object);
            }
            if (this.debug > 10) {
                this.log("contextXsltFile '" + this.contextXsltFile + "' not found");
            }
        }
        if (this.globalXsltFile != null && (object = this.validateGlobalXsltFile()) != null) {
            long l = ((File)object).length();
            if (l > Integer.MAX_VALUE) {
                this.log("globalXsltFile [" + ((File)object).getAbsolutePath() + "] is too big to buffer");
            } else {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream((File)object);
                    byte[] byArray = new byte[(int)((File)object).length()];
                    IOTools.readFully(fileInputStream, byArray);
                    StreamSource streamSource = new StreamSource(new ByteArrayInputStream(byArray));
                    return streamSource;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return null;
    }

    private File validateGlobalXsltFile() {
        Object object;
        File file = null;
        String string = System.getProperty("catalina.base");
        if (string != null) {
            object = new File(string, "conf");
            file = this.validateGlobalXsltFile((File)object);
        }
        if (file == null && (object = System.getProperty("catalina.home")) != null && !((String)object).equals(string)) {
            File file2 = new File((String)object, "conf");
            file = this.validateGlobalXsltFile(file2);
        }
        return file;
    }

    private File validateGlobalXsltFile(File file) {
        File file2 = new File(this.globalXsltFile);
        if (!file2.isAbsolute()) {
            file2 = new File(file, this.globalXsltFile);
        }
        if (!file2.isFile()) {
            return null;
        }
        try {
            if (!file2.getCanonicalPath().startsWith(file.getCanonicalPath())) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        String string = file2.getName().toLowerCase(Locale.ENGLISH);
        if (!string.endsWith(".xslt") && !string.endsWith(".xsl")) {
            return null;
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Source secureXslt(InputStream inputStream) {
        DOMSource dOMSource = null;
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setEntityResolver(secureEntityResolver);
            Document document = documentBuilder.parse(inputStream);
            dOMSource = new DOMSource(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            if (this.debug > 0) {
                this.log(parserConfigurationException.getMessage(), parserConfigurationException);
            }
        }
        catch (SAXException sAXException) {
            if (this.debug > 0) {
                this.log(sAXException.getMessage(), sAXException);
            }
        }
        catch (IOException iOException) {
            if (this.debug > 0) {
                this.log(iOException.getMessage(), iOException);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return dOMSource;
    }

    protected boolean checkSendfile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, CacheEntry cacheEntry, long l, Range range) {
        if (this.sendfileSize > 0 && cacheEntry.resource != null && (l > (long)this.sendfileSize || cacheEntry.resource.getContent() == null) && cacheEntry.attributes.getCanonicalPath() != null && Boolean.TRUE.equals(httpServletRequest.getAttribute("org.apache.tomcat.sendfile.support")) && httpServletRequest.getClass().getName().equals("org.apache.catalina.connector.RequestFacade") && httpServletResponse.getClass().getName().equals("org.apache.catalina.connector.ResponseFacade")) {
            httpServletRequest.setAttribute("org.apache.tomcat.sendfile.filename", (Object)cacheEntry.attributes.getCanonicalPath());
            if (range == null) {
                httpServletRequest.setAttribute("org.apache.tomcat.sendfile.start", (Object)0L);
                httpServletRequest.setAttribute("org.apache.tomcat.sendfile.end", (Object)l);
            } else {
                httpServletRequest.setAttribute("org.apache.tomcat.sendfile.start", (Object)range.start);
                httpServletRequest.setAttribute("org.apache.tomcat.sendfile.end", (Object)(range.end + 1L));
            }
            return true;
        }
        return false;
    }

    protected boolean checkIfMatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceAttributes resourceAttributes) throws IOException {
        String string = httpServletRequest.getHeader("If-Match");
        if (string != null) {
            boolean bl;
            if (!string.equals("*")) {
                String string2 = this.generateETag(resourceAttributes);
                if (string2 == null) {
                    bl = false;
                } else {
                    Boolean bl2 = EntityTag.compareEntityTag((StringReader)new StringReader(string), (boolean)false, (String)string2);
                    if (bl2 == null) {
                        if (this.debug > 10) {
                            this.log("DefaultServlet.checkIfMatch:  Invalid header value [" + string + "]");
                        }
                        httpServletResponse.sendError(400);
                        return false;
                    }
                    bl = bl2;
                }
            } else {
                bl = true;
            }
            if (!bl) {
                httpServletResponse.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfModifiedSince(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceAttributes resourceAttributes) {
        try {
            long l = httpServletRequest.getDateHeader("If-Modified-Since");
            long l2 = resourceAttributes.getLastModified();
            if (l != -1L && httpServletRequest.getHeader("If-None-Match") == null && l2 < l + 1000L) {
                httpServletResponse.setStatus(304);
                httpServletResponse.setHeader("ETag", this.generateETag(resourceAttributes));
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return true;
    }

    protected boolean checkIfNoneMatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceAttributes resourceAttributes) throws IOException {
        String string = httpServletRequest.getHeader("If-None-Match");
        if (string != null) {
            boolean bl;
            String string2 = this.generateETag(resourceAttributes);
            if (!string.equals("*")) {
                if (string2 == null) {
                    bl = false;
                } else {
                    Boolean bl2 = EntityTag.compareEntityTag((StringReader)new StringReader(string), (boolean)true, (String)string2);
                    if (bl2 == null) {
                        if (this.debug > 10) {
                            this.log("DefaultServlet.checkIfNoneMatch:  Invalid header value [" + string + "]");
                        }
                        httpServletResponse.sendError(400);
                        return false;
                    }
                    bl = bl2;
                }
            } else {
                bl = true;
            }
            if (bl) {
                if ("GET".equals(httpServletRequest.getMethod()) || "HEAD".equals(httpServletRequest.getMethod())) {
                    httpServletResponse.setStatus(304);
                    httpServletResponse.setHeader("ETag", string2);
                } else {
                    httpServletResponse.sendError(412);
                }
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfUnmodifiedSince(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceAttributes resourceAttributes) throws IOException {
        try {
            long l = resourceAttributes.getLastModified();
            long l2 = httpServletRequest.getDateHeader("If-Unmodified-Since");
            if (l2 != -1L && l >= l2 + 1000L) {
                httpServletResponse.sendError(412);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return true;
    }

    protected String generateETag(ResourceAttributes resourceAttributes) {
        return resourceAttributes.getETag();
    }

    protected void copy(CacheEntry cacheEntry, InputStream inputStream, ServletOutputStream servletOutputStream) throws IOException {
        Object object;
        IOException iOException = null;
        InputStream inputStream2 = null;
        if (cacheEntry.resource != null) {
            object = cacheEntry.resource.getContent();
            if (object != null) {
                servletOutputStream.write(object, 0, ((byte[])object).length);
                return;
            }
            inputStream2 = cacheEntry.resource.streamContent();
        } else {
            inputStream2 = inputStream;
        }
        object = new BufferedInputStream(inputStream2, this.input);
        iOException = this.copyRange((InputStream)object, servletOutputStream);
        object.close();
        if (iOException != null) {
            throw iOException;
        }
    }

    protected void copy(CacheEntry cacheEntry, InputStream inputStream, PrintWriter printWriter) throws IOException {
        IOException iOException = null;
        InputStream inputStream2 = null;
        inputStream2 = cacheEntry.resource != null ? cacheEntry.resource.streamContent() : inputStream;
        InputStreamReader inputStreamReader = this.fileEncoding == null ? new InputStreamReader(inputStream2) : new InputStreamReader(inputStream2, this.fileEncoding);
        iOException = this.copyRange(inputStreamReader, printWriter);
        ((Reader)inputStreamReader).close();
        if (iOException != null) {
            throw iOException;
        }
    }

    protected void copy(CacheEntry cacheEntry, ServletOutputStream servletOutputStream, Range range) throws IOException {
        IOException iOException = null;
        InputStream inputStream = cacheEntry.resource.streamContent();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, this.input);
        iOException = this.copyRange(bufferedInputStream, servletOutputStream, range.start, range.end);
        ((InputStream)bufferedInputStream).close();
        if (iOException != null) {
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(CacheEntry cacheEntry, ServletOutputStream servletOutputStream, Iterator<Range> iterator, String string) throws IOException {
        IOException iOException = null;
        while (iOException == null && iterator.hasNext()) {
            InputStream inputStream = cacheEntry.resource.streamContent();
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(inputStream, this.input);
                Range range = iterator.next();
                servletOutputStream.println();
                servletOutputStream.println("--CATALINA_MIME_BOUNDARY");
                if (string != null) {
                    servletOutputStream.println("Content-Type: " + string);
                }
                servletOutputStream.println("Content-Range: bytes " + range.start + "-" + range.end + "/" + range.length);
                servletOutputStream.println();
                iOException = this.copyRange(bufferedInputStream, servletOutputStream, range.start, range.end);
            }
            finally {
                if (bufferedInputStream == null) continue;
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException2) {}
            }
        }
        servletOutputStream.println();
        servletOutputStream.print("--CATALINA_MIME_BOUNDARY--");
        if (iOException != null) {
            throw iOException;
        }
    }

    protected IOException copyRange(InputStream inputStream, ServletOutputStream servletOutputStream) {
        IOException iOException = null;
        byte[] byArray = new byte[this.input];
        int n = byArray.length;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                servletOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            n = -1;
        }
        return iOException;
    }

    protected IOException copyRange(Reader reader, PrintWriter printWriter) {
        IOException iOException = null;
        char[] cArray = new char[this.input];
        int n = cArray.length;
        try {
            while ((n = reader.read(cArray)) != -1) {
                printWriter.write(cArray, 0, n);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            n = -1;
        }
        return iOException;
    }

    protected IOException copyRange(InputStream inputStream, ServletOutputStream servletOutputStream, long l, long l2) {
        if (this.debug > 10) {
            this.log("Serving bytes:" + l + "-" + l2);
        }
        long l3 = 0L;
        try {
            l3 = inputStream.skip(l);
        }
        catch (IOException iOException) {
            return iOException;
        }
        if (l3 < l) {
            return new IOException(sm.getString("defaultServlet.skipfail", new Object[]{l3, l}));
        }
        IOException iOException = null;
        long l4 = l2 - l + 1L;
        byte[] byArray = new byte[this.input];
        int n = byArray.length;
        while (l4 > 0L && n >= byArray.length) {
            try {
                n = inputStream.read(byArray);
                if (l4 >= (long)n) {
                    servletOutputStream.write(byArray, 0, n);
                    l4 -= (long)n;
                } else {
                    servletOutputStream.write(byArray, 0, (int)l4);
                    l4 = 0L;
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                n = -1;
            }
            if (n >= byArray.length) continue;
            break;
        }
        return iOException;
    }

    static {
        FULL = new ArrayList();
        urlEncoder = new URLEncoder();
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
        if (Globals.IS_SECURITY_ENABLED) {
            factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            secureEntityResolver = new SecureEntityResolver();
        } else {
            factory = null;
            secureEntityResolver = null;
        }
    }

    private static class SecureEntityResolver
    implements EntityResolver2 {
        private SecureEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            throw new SAXException(sm.getString("defaultServlet.blockExternalEntity", new Object[]{string, string2}));
        }

        @Override
        public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
            throw new SAXException(sm.getString("defaultServlet.blockExternalSubset", new Object[]{string, string2}));
        }

        @Override
        public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
            throw new SAXException(sm.getString("defaultServlet.blockExternalEntity2", new Object[]{string, string2, string3, string4}));
        }
    }

    protected static class Range {
        public long start;
        public long end;
        public long length;

        protected Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }
    }
}

