/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.coyote.http11.upgrade.AbstractServletInputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.net.SocketWrapper;

public class AprServletInputStream
extends AbstractServletInputStream {
    private static final Log log = LogFactory.getLog(AprServletInputStream.class);
    private final SocketWrapper<Long> wrapper;
    private final long socket;
    private volatile boolean eagain = false;
    private volatile boolean closed = false;

    public AprServletInputStream(SocketWrapper<Long> socketWrapper) {
        this.wrapper = socketWrapper;
        this.socket = socketWrapper.getSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRead(boolean bl, byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("apr.closed", new Object[]{this.socket}));
        }
        Lock lock = this.wrapper.getBlockingStatusReadLock();
        ReentrantReadWriteLock.WriteLock writeLock = this.wrapper.getBlockingStatusWriteLock();
        boolean bl2 = false;
        int n3 = 0;
        try {
            lock.lock();
            if (this.wrapper.getBlockingStatus() == bl) {
                n3 = Socket.recv(this.socket, byArray, n, n2);
                bl2 = true;
            }
        }
        finally {
            lock.unlock();
        }
        if (!bl2) {
            try {
                writeLock.lock();
                this.wrapper.setBlockingStatus(bl);
                Socket.optSet(this.socket, 8, bl ? 0 : 1);
                try {
                    lock.lock();
                    writeLock.unlock();
                    n3 = Socket.recv(this.socket, byArray, n, n2);
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                if (writeLock.isHeldByCurrentThread()) {
                    writeLock.unlock();
                }
            }
        }
        if (n3 > 0) {
            this.eagain = false;
            return n3;
        }
        if (-n3 == 120002) {
            this.eagain = true;
            return 0;
        }
        if (-n3 == 20014 && this.wrapper.isSecure()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("apr.read.sslGeneralError", new Object[]{this.socket, this.wrapper}));
            }
            this.eagain = true;
            return 0;
        }
        if (-n3 == 70014) {
            throw new EOFException(sm.getString("apr.clientAbort"));
        }
        if ((OS.IS_WIN32 || OS.IS_WIN64) && -n3 == 730053) {
            throw new EOFException(sm.getString("apr.clientAbort"));
        }
        throw new IOException(sm.getString("apr.read.error", new Object[]{-n3, this.socket, this.wrapper}));
    }

    @Override
    protected boolean doIsReady() {
        return !this.eagain;
    }

    @Override
    protected void doClose() throws IOException {
        this.closed = true;
    }
}

