/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.File;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Sockaddr;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Constants;
import org.apache.tomcat.util.net.SendfileKeepAliveState;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.security.PrivilegedSetTccl;

public class AprEndpoint
extends AbstractEndpoint<Long> {
    private static final Log log = LogFactory.getLog(AprEndpoint.class);
    private static volatile Set<String> SSL_PROTO_ALL;
    private static final Object SSL_PROTO_ALL_LOCK;
    protected long rootPool = 0L;
    protected long serverSock = 0L;
    protected long serverSockPool = 0L;
    protected long sslContext = 0L;
    protected ConcurrentLinkedQueue<SocketWrapper<Long>> waitingRequests = new ConcurrentLinkedQueue();
    private final Map<Long, AprSocketWrapper> connections = new ConcurrentHashMap<Long, AprSocketWrapper>();
    protected boolean deferAccept = true;
    protected int sendfileSize = 1024;
    protected Handler handler = null;
    protected int pollTime = 2000;
    protected boolean useSendfile = false;
    private boolean useSendFileSet = false;
    protected boolean useComet = true;
    protected int sendfileThreadCount = 0;
    protected Poller poller = null;
    protected AsyncTimeout asyncTimeout = null;
    protected Sendfile sendfile = null;
    protected String SSLProtocol = "all";
    protected String SSLPassword = null;
    protected String SSLCipherSuite = "HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5:!kRSA";
    protected String SSLCertificateFile = null;
    protected String SSLCertificateKeyFile = null;
    protected String SSLCertificateChainFile = null;
    protected String SSLCACertificatePath = null;
    protected String SSLCACertificateFile = null;
    protected String SSLCARevocationPath = null;
    protected String SSLCARevocationFile = null;
    protected String SSLVerifyClient = "none";
    protected int SSLVerifyDepth = 10;
    protected boolean SSLInsecureRenegotiation = false;
    protected boolean SSLHonorCipherOrder = false;
    protected boolean SSLDisableCompression = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Set<String> getSslProtocolAll() {
        if (SSL_PROTO_ALL == null) {
            Object object = SSL_PROTO_ALL_LOCK;
            synchronized (object) {
                if (SSL_PROTO_ALL == null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.add("TLSv1");
                    hashSet.add("TLSv1.1");
                    hashSet.add("TLSv1.2");
                    if (SSL.version() >= 0x1010100F) {
                        hashSet.add("TLSv1.3");
                    }
                    SSL_PROTO_ALL = hashSet;
                }
            }
        }
        return SSL_PROTO_ALL;
    }

    @Override
    public void removeWaitingRequest(SocketWrapper<Long> socketWrapper) {
        this.waitingRequests.remove(socketWrapper);
    }

    public AprEndpoint() {
        this.setMaxConnections(8192);
    }

    public void setDeferAccept(boolean bl) {
        this.deferAccept = bl;
    }

    @Override
    public boolean getDeferAccept() {
        return this.deferAccept;
    }

    public void setSendfileSize(int n) {
        this.sendfileSize = n;
    }

    public int getSendfileSize() {
        return this.sendfileSize;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public int getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(int n) {
        if (n > 0) {
            this.pollTime = n;
        }
    }

    public void setUseSendfile(boolean bl) {
        this.useSendFileSet = true;
        this.useSendfile = bl;
    }

    @Override
    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setUseComet(boolean bl) {
        this.useComet = bl;
    }

    @Override
    public boolean getUseComet() {
        return this.useComet;
    }

    @Override
    public boolean getUseCometTimeout() {
        return false;
    }

    @Override
    public boolean getUsePolling() {
        return true;
    }

    public void setSendfileThreadCount(int n) {
        this.sendfileThreadCount = n;
    }

    public int getSendfileThreadCount() {
        return this.sendfileThreadCount;
    }

    public Poller getPoller() {
        return this.poller;
    }

    public AsyncTimeout getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public Sendfile getSendfile() {
        return this.sendfile;
    }

    public String getSSLProtocol() {
        return this.SSLProtocol;
    }

    public void setSSLProtocol(String string) {
        this.SSLProtocol = string;
    }

    public String getSSLPassword() {
        return this.SSLPassword;
    }

    public void setSSLPassword(String string) {
        this.SSLPassword = string;
    }

    public String getSSLCipherSuite() {
        return this.SSLCipherSuite;
    }

    public void setSSLCipherSuite(String string) {
        this.SSLCipherSuite = string;
    }

    public String getSSLCertificateFile() {
        return this.SSLCertificateFile;
    }

    public void setSSLCertificateFile(String string) {
        this.SSLCertificateFile = string;
    }

    public String getSSLCertificateKeyFile() {
        return this.SSLCertificateKeyFile;
    }

    public void setSSLCertificateKeyFile(String string) {
        this.SSLCertificateKeyFile = string;
    }

    public String getSSLCertificateChainFile() {
        return this.SSLCertificateChainFile;
    }

    public void setSSLCertificateChainFile(String string) {
        this.SSLCertificateChainFile = string;
    }

    public String getSSLCACertificatePath() {
        return this.SSLCACertificatePath;
    }

    public void setSSLCACertificatePath(String string) {
        this.SSLCACertificatePath = string;
    }

    public String getSSLCACertificateFile() {
        return this.SSLCACertificateFile;
    }

    public void setSSLCACertificateFile(String string) {
        this.SSLCACertificateFile = string;
    }

    public String getSSLCARevocationPath() {
        return this.SSLCARevocationPath;
    }

    public void setSSLCARevocationPath(String string) {
        this.SSLCARevocationPath = string;
    }

    public String getSSLCARevocationFile() {
        return this.SSLCARevocationFile;
    }

    public void setSSLCARevocationFile(String string) {
        this.SSLCARevocationFile = string;
    }

    public String getSSLVerifyClient() {
        return this.SSLVerifyClient;
    }

    public void setSSLVerifyClient(String string) {
        this.SSLVerifyClient = string;
    }

    public int getSSLVerifyDepth() {
        return this.SSLVerifyDepth;
    }

    public void setSSLVerifyDepth(int n) {
        this.SSLVerifyDepth = n;
    }

    public void setSSLInsecureRenegotiation(boolean bl) {
        this.SSLInsecureRenegotiation = bl;
    }

    public boolean getSSLInsecureRenegotiation() {
        return this.SSLInsecureRenegotiation;
    }

    public void setSSLHonorCipherOrder(boolean bl) {
        this.SSLHonorCipherOrder = bl;
    }

    public boolean getSSLHonorCipherOrder() {
        return this.SSLHonorCipherOrder;
    }

    public void setSSLDisableCompression(boolean bl) {
        this.SSLDisableCompression = bl;
    }

    public boolean getSSLDisableCompression() {
        return this.SSLDisableCompression;
    }

    @Override
    public int getLocalPort() {
        long l = this.serverSock;
        if (l == 0L) {
            return -1;
        }
        try {
            long l2 = Address.get(0, l);
            Sockaddr sockaddr = Address.getInfo(l2);
            return sockaddr.port;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public void setMaxConnections(int n) {
        if (n == -1) {
            log.warn((Object)sm.getString("endpoint.apr.maxConnections.unlimited", new Object[]{this.getMaxConnections()}));
            return;
        }
        if (this.running) {
            log.warn((Object)sm.getString("endpoint.apr.maxConnections.running", new Object[]{this.getMaxConnections()}));
            return;
        }
        super.setMaxConnections(n);
    }

    public int getKeepAliveCount() {
        if (this.poller == null) {
            return 0;
        }
        return this.poller.getConnectionCount();
    }

    public int getSendfileCount() {
        if (this.sendfile == null) {
            return 0;
        }
        return this.sendfile.getSendfileCount();
    }

    @Override
    public void bind() throws Exception {
        try {
            this.rootPool = Pool.create(0L);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new Exception(sm.getString("endpoint.init.notavail"));
        }
        this.serverSockPool = Pool.create(this.rootPool);
        String string = null;
        if (this.getAddress() != null) {
            string = this.getAddress().getHostAddress();
        }
        int n = 1;
        if (Library.APR_HAVE_IPV6) {
            if (string == null) {
                if (!(OS.IS_BSD || OS.IS_WIN32 || OS.IS_WIN64)) {
                    n = 0;
                }
            } else if (string.indexOf(58) >= 0) {
                n = 0;
            }
        }
        long l = Address.info(string, n, this.getPort(), 0, this.rootPool);
        this.serverSock = Socket.create(Address.getInfo((long)l).family, 0, 6, this.rootPool);
        if (OS.IS_UNIX) {
            Socket.optSet(this.serverSock, 16, 1);
        }
        Socket.optSet(this.serverSock, 2, 1);
        int n2 = Socket.bind(this.serverSock, l);
        if (n2 != 0) {
            throw new Exception(sm.getString("endpoint.init.bind", new Object[]{"" + n2, Error.strerror(n2)}));
        }
        n2 = Socket.listen(this.serverSock, this.getBacklog());
        if (n2 != 0) {
            throw new Exception(sm.getString("endpoint.init.listen", new Object[]{"" + n2, Error.strerror(n2)}));
        }
        if (OS.IS_WIN32 || OS.IS_WIN64) {
            Socket.optSet(this.serverSock, 16, 1);
        }
        if (!this.useSendFileSet) {
            this.useSendfile = Library.APR_HAS_SENDFILE;
        } else if (this.useSendfile && !Library.APR_HAS_SENDFILE) {
            this.useSendfile = false;
        }
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.deferAccept && Socket.optSet(this.serverSock, 32768, 1) == 70023) {
            this.deferAccept = false;
        }
        if (this.isSSLEnabled()) {
            if (this.SSLCertificateFile == null) {
                throw new Exception(sm.getString("endpoint.apr.noSslCertFile"));
            }
            int n3 = 0;
            if (this.SSLProtocol == null || this.SSLProtocol.length() == 0) {
                n3 = 60;
            } else {
                HashSet<String> hashSet = new HashSet<String>();
                for (String string2 : this.SSLProtocol.split("(?=[-+])")) {
                    String string3 = string2.trim();
                    if (string3.length() <= 1) continue;
                    if (string3.charAt(0) == '-') {
                        if ((string3 = string3.substring(1).trim()).equalsIgnoreCase("all")) {
                            hashSet.removeAll(AprEndpoint.getSslProtocolAll());
                            continue;
                        }
                        hashSet.remove(string3);
                        continue;
                    }
                    if (string3.charAt(0) == '+') {
                        string3 = string3.substring(1).trim();
                    }
                    if (string3.equalsIgnoreCase("all")) {
                        hashSet.addAll(AprEndpoint.getSslProtocolAll());
                        continue;
                    }
                    hashSet.add(string3);
                }
                for (String string4 : hashSet) {
                    if ("SSLv2".equalsIgnoreCase(string4)) {
                        n3 |= 1;
                        continue;
                    }
                    if ("SSLv3".equalsIgnoreCase(string4)) {
                        n3 |= 2;
                        continue;
                    }
                    if ("TLSv1".equalsIgnoreCase(string4)) {
                        n3 |= 4;
                        continue;
                    }
                    if ("TLSv1.1".equalsIgnoreCase(string4)) {
                        n3 |= 8;
                        continue;
                    }
                    if ("TLSv1.2".equalsIgnoreCase(string4)) {
                        n3 |= 0x10;
                        continue;
                    }
                    if ("TLSv1.3".equalsIgnoreCase(string4) && SSL.version() >= 0x1010100F) {
                        n3 |= 0x20;
                        continue;
                    }
                    throw new Exception(sm.getString("endpoint.apr.invalidSslProtocol", new Object[]{this.SSLProtocol}));
                }
            }
            try {
                this.sslContext = SSLContext.make(this.rootPool, n3, 1);
            }
            catch (Exception exception) {
                throw new Exception(sm.getString("endpoint.apr.failSslContextMake"), exception);
            }
            if (this.SSLInsecureRenegotiation) {
                boolean bl = false;
                try {
                    bl = SSL.hasOp(262144);
                    if (bl) {
                        SSLContext.setOptions(this.sslContext, 262144);
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
                if (!bl) {
                    log.warn((Object)sm.getString("endpoint.warn.noInsecureReneg", new Object[]{SSL.versionString()}));
                }
            }
            if (this.SSLHonorCipherOrder) {
                boolean bl = false;
                try {
                    bl = SSL.hasOp(0x400000);
                    if (bl) {
                        SSLContext.setOptions(this.sslContext, 0x400000);
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
                if (!bl) {
                    log.warn((Object)sm.getString("endpoint.warn.noHonorCipherOrder", new Object[]{SSL.versionString()}));
                }
            }
            if (this.SSLDisableCompression) {
                boolean bl = false;
                try {
                    bl = SSL.hasOp(131072);
                    if (bl) {
                        SSLContext.setOptions(this.sslContext, 131072);
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
                if (!bl) {
                    log.warn((Object)sm.getString("endpoint.warn.noDisableCompression", new Object[]{SSL.versionString()}));
                }
            }
            SSLContext.setCipherSuite(this.sslContext, this.SSLCipherSuite);
            SSLContext.setCertificate(this.sslContext, this.SSLCertificateFile, this.SSLCertificateKeyFile, this.SSLPassword, 0);
            SSLContext.setCertificateChainFile(this.sslContext, this.SSLCertificateChainFile, false);
            SSLContext.setCACertificate(this.sslContext, this.SSLCACertificateFile, this.SSLCACertificatePath);
            SSLContext.setCARevocation(this.sslContext, this.SSLCARevocationFile, this.SSLCARevocationPath);
            n3 = 0;
            if ("optional".equalsIgnoreCase(this.SSLVerifyClient)) {
                n3 = 1;
            } else if ("require".equalsIgnoreCase(this.SSLVerifyClient)) {
                n3 = 2;
            } else if ("optionalNoCA".equalsIgnoreCase(this.SSLVerifyClient)) {
                n3 = 3;
            }
            SSLContext.setVerify(this.sslContext, n3, this.SSLVerifyDepth);
            if (this.useSendfile) {
                this.useSendfile = false;
                if (this.useSendFileSet) {
                    log.warn((Object)sm.getString("endpoint.apr.noSendfileWithSSL"));
                }
            }
        }
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            Thread thread;
            this.running = true;
            this.paused = false;
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.poller = new Poller();
            this.poller.init();
            Thread thread2 = new Thread((Runnable)this.poller, this.getName() + "-Poller");
            thread2.setPriority(this.threadPriority);
            thread2.setDaemon(true);
            thread2.start();
            if (this.useSendfile) {
                this.sendfile = new Sendfile();
                this.sendfile.init();
                thread = new Thread((Runnable)this.sendfile, this.getName() + "-Sendfile");
                thread.setPriority(this.threadPriority);
                thread.setDaemon(true);
                thread.start();
            }
            this.startAcceptorThreads();
            this.asyncTimeout = new AsyncTimeout();
            thread = new Thread((Runnable)this.asyncTimeout, this.getName() + "-AsyncTimeout");
            thread.setPriority(this.threadPriority);
            thread.setDaemon(true);
            thread.start();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.poller.stop();
            this.asyncTimeout.stop();
            this.unlockAccept();
            for (AbstractEndpoint.Acceptor acceptor : this.acceptors) {
                long l;
                for (l = 10000L; l > 0L && acceptor.getState() != AbstractEndpoint.Acceptor.AcceptorState.ENDED && this.serverSock != 0L; l -= 50L) {
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (l != 0L) continue;
                log.warn((Object)sm.getString("endpoint.warn.unlockAcceptorFailed", new Object[]{acceptor.getThreadName()}));
                if (this.serverSock == 0L) continue;
                Socket.shutdown(this.serverSock, 0);
                this.serverSock = 0L;
            }
            for (Long l : this.connections.keySet()) {
                Socket.shutdown(l, 2);
            }
            try {
                this.poller.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.poller = null;
            this.connections.clear();
            if (this.useSendfile) {
                try {
                    this.sendfile.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sendfile = null;
            }
        }
        this.shutdownExecutor();
    }

    @Override
    public void unbind() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.serverSockPool != 0L) {
            Pool.destroy(this.serverSockPool);
            this.serverSockPool = 0L;
        }
        if (this.serverSock != 0L) {
            Socket.close(this.serverSock);
            this.serverSock = 0L;
        }
        this.sslContext = 0L;
        if (this.rootPool != 0L) {
            Pool.destroy(this.rootPool);
            this.rootPool = 0L;
        }
        this.handler.recycle();
    }

    @Override
    protected AbstractEndpoint.Acceptor createAcceptor() {
        return new Acceptor();
    }

    protected boolean setSocketOptions(long l) {
        int n = 1;
        try {
            if (this.socketProperties.getSoLingerOn() && this.socketProperties.getSoLingerTime() >= 0) {
                Socket.optSet(l, 1, this.socketProperties.getSoLingerTime());
            }
            if (this.socketProperties.getTcpNoDelay()) {
                Socket.optSet(l, 512, this.socketProperties.getTcpNoDelay() ? 1 : 0);
            }
            Socket.timeoutSet(l, this.socketProperties.getSoTimeout() * 1000);
            n = 2;
            if (this.sslContext != 0L) {
                SSLSocket.attach(this.sslContext, l);
                if (SSLSocket.handshake(l) != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(sm.getString("endpoint.err.handshake") + ": " + SSL.getLastError()));
                    }
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            if (log.isDebugEnabled()) {
                if (n == 2) {
                    log.debug((Object)sm.getString("endpoint.err.handshake"), throwable);
                } else {
                    log.debug((Object)sm.getString("endpoint.err.unexpected"), throwable);
                }
            }
            return false;
        }
        return true;
    }

    protected long allocatePoller(int n, long l, int n2) {
        try {
            return Poll.create(n, l, 0, n2 * 1000);
        }
        catch (Error error) {
            if (Status.APR_STATUS_IS_EINVAL(error.getError())) {
                log.info((Object)sm.getString("endpoint.poll.limitedpollsize", new Object[]{"" + n}));
                return 0L;
            }
            log.error((Object)sm.getString("endpoint.poll.initfail"), (Throwable)error);
            return -1L;
        }
    }

    protected boolean processSocketWithOptions(long l) {
        try {
            if (this.running) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("endpoint.debug.socket", new Object[]{l}));
                }
                AprSocketWrapper aprSocketWrapper = new AprSocketWrapper(l);
                aprSocketWrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
                aprSocketWrapper.setSecure(this.isSSLEnabled());
                this.connections.put(l, aprSocketWrapper);
                this.getExecutor().execute(new SocketWithOptionsProcessor(aprSocketWrapper));
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            log.warn((Object)("Socket processing request was rejected for:" + l), (Throwable)rejectedExecutionException);
            return false;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            log.error((Object)sm.getString("endpoint.process.fail"), throwable);
            return false;
        }
        return true;
    }

    public boolean processSocket(long l, SocketStatus socketStatus) {
        try {
            Executor executor = this.getExecutor();
            if (executor == null) {
                log.warn((Object)sm.getString("endpoint.warn.noExector", new Object[]{l, null}));
            } else {
                SocketWrapper socketWrapper = this.connections.get(l);
                if (socketWrapper != null) {
                    executor.execute(new SocketProcessor(socketWrapper, socketStatus));
                }
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            log.warn((Object)("Socket processing request was rejected for:" + l), (Throwable)rejectedExecutionException);
            return false;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            log.error((Object)sm.getString("endpoint.process.fail"), throwable);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processSocketAsync(SocketWrapper<Long> socketWrapper, SocketStatus socketStatus) {
        try {
            SocketWrapper<Long> socketWrapper2 = socketWrapper;
            synchronized (socketWrapper2) {
                if (this.waitingRequests.remove(socketWrapper)) {
                    SocketProcessor socketProcessor = new SocketProcessor(socketWrapper, socketStatus);
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Object object;
                        if (Constants.IS_SECURITY_ENABLED) {
                            object = new PrivilegedSetTccl(this.getClass().getClassLoader());
                            AccessController.doPrivileged(object);
                        } else {
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        }
                        object = this.getExecutor();
                        if (object == null) {
                            log.warn((Object)sm.getString("endpoint.warn.noExector", new Object[]{socketWrapper, socketStatus}));
                            return;
                        }
                        object.execute(socketProcessor);
                    }
                    finally {
                        if (Constants.IS_SECURITY_ENABLED) {
                            PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl(classLoader);
                            AccessController.doPrivileged(privilegedSetTccl);
                        } else {
                            Thread.currentThread().setContextClassLoader(classLoader);
                        }
                    }
                }
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            log.warn((Object)("Socket processing request was rejected for: " + socketWrapper), (Throwable)rejectedExecutionException);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            log.error((Object)sm.getString("endpoint.process.fail"), throwable);
        }
    }

    private void closeSocket(long l) {
        this.connections.remove(l);
        Poller poller = this.poller;
        if (poller != null && !poller.close(l)) {
            this.destroySocket(l);
        }
    }

    private void destroySocket(long l) {
        this.connections.remove(l);
        if (log.isDebugEnabled()) {
            String string = sm.getString("endpoint.debug.destroySocket", new Object[]{l});
            if (log.isTraceEnabled()) {
                log.trace((Object)string, (Throwable)new Exception());
            } else {
                log.debug((Object)string);
            }
        }
        if (l != 0L) {
            Socket.destroy(l);
            this.countDownConnection();
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    static {
        SSL_PROTO_ALL_LOCK = new Object();
    }

    private static class AprSocketWrapper
    extends SocketWrapper<Long> {
        private int pollerFlags = 0;

        public AprSocketWrapper(Long l) {
            super(l);
        }
    }

    protected class SocketProcessor
    implements Runnable {
        private final SocketWrapper<Long> socket;
        private final SocketStatus status;

        public SocketProcessor(SocketWrapper<Long> socketWrapper, SocketStatus socketStatus) {
            this.socket = socketWrapper;
            if (socketStatus == null) {
                throw new NullPointerException();
            }
            this.status = socketStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.socket.isUpgraded() && SocketStatus.OPEN_WRITE == this.status) {
                Object object = this.socket.getWriteThreadLock();
                synchronized (object) {
                    this.doRun();
                }
            }
            SocketWrapper<Long> socketWrapper = this.socket;
            synchronized (socketWrapper) {
                this.doRun();
            }
        }

        private void doRun() {
            if (this.socket.getSocket() == null) {
                return;
            }
            AbstractEndpoint.Handler.SocketState socketState = AprEndpoint.this.handler.process(this.socket, this.status);
            if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                AprEndpoint.this.closeSocket(this.socket.getSocket());
                this.socket.socket = null;
            } else if (socketState == AbstractEndpoint.Handler.SocketState.LONG) {
                this.socket.access();
                if (this.socket.async) {
                    AprEndpoint.this.waitingRequests.add(this.socket);
                }
            } else if (socketState == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                this.socket.access();
                SocketProcessor socketProcessor = new SocketProcessor(this.socket, SocketStatus.OPEN_READ);
                AprEndpoint.this.getExecutor().execute(socketProcessor);
            }
        }
    }

    protected class SocketWithOptionsProcessor
    implements Runnable {
        protected SocketWrapper<Long> socket = null;

        public SocketWithOptionsProcessor(SocketWrapper<Long> socketWrapper) {
            this.socket = socketWrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketWrapper<Long> socketWrapper = this.socket;
            synchronized (socketWrapper) {
                if (!AprEndpoint.this.deferAccept) {
                    if (AprEndpoint.this.setSocketOptions(this.socket.getSocket())) {
                        AprEndpoint.this.getPoller().add(this.socket.getSocket(), AprEndpoint.this.getSoTimeout(), true, false);
                    } else {
                        AprEndpoint.this.closeSocket(this.socket.getSocket());
                        this.socket = null;
                    }
                } else {
                    if (!AprEndpoint.this.setSocketOptions(this.socket.getSocket())) {
                        AprEndpoint.this.closeSocket(this.socket.getSocket());
                        this.socket = null;
                        return;
                    }
                    AbstractEndpoint.Handler.SocketState socketState = AprEndpoint.this.handler.process(this.socket, SocketStatus.OPEN_READ);
                    if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        AprEndpoint.this.closeSocket(this.socket.getSocket());
                        this.socket = null;
                    } else if (socketState == AbstractEndpoint.Handler.SocketState.LONG) {
                        this.socket.access();
                        if (this.socket.async) {
                            AprEndpoint.this.waitingRequests.add(this.socket);
                        }
                    }
                }
            }
        }
    }

    public static interface Handler
    extends AbstractEndpoint.Handler {
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Long> var1, SocketStatus var2);

        public boolean isAvailable(SocketWrapper<Long> var1);
    }

    public class Sendfile
    implements Runnable {
        protected long sendfilePollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected HashMap<Long, SendfileData> sendfileData;
        protected int sendfileCount;
        protected ArrayList<SendfileData> addS;
        private volatile boolean sendfileRunning = true;

        public int getSendfileCount() {
            return this.sendfileCount;
        }

        protected void init() {
            this.pool = Pool.create(AprEndpoint.this.serverSockPool);
            int n = AprEndpoint.this.sendfileSize;
            if (n <= 0) {
                n = 16384;
            }
            this.sendfilePollset = AprEndpoint.this.allocatePoller(n, this.pool, AprEndpoint.this.getSoTimeout());
            this.desc = new long[n * 2];
            this.sendfileData = new HashMap(n);
            this.addS = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            int n;
            this.sendfileRunning = false;
            try {
                Sendfile sendfile = this;
                synchronized (sendfile) {
                    this.notify();
                    this.wait(AprEndpoint.this.pollTime / 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (n = this.addS.size() - 1; n >= 0; --n) {
                SendfileData sendfileData = this.addS.get(n);
                AprEndpoint.this.closeSocket(sendfileData.socket);
            }
            n = Poll.pollset(this.sendfilePollset, this.desc);
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    AprEndpoint.this.closeSocket(this.desc[i * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.sendfileData.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SendfileState add(SendfileData sendfileData) {
            try {
                sendfileData.fdpool = Socket.pool(sendfileData.socket);
                sendfileData.fd = File.open(sendfileData.fileName, 4129, 0, sendfileData.fdpool);
                sendfileData.pos = sendfileData.start;
                Socket.timeoutSet(sendfileData.socket, 0L);
                while (this.sendfileRunning) {
                    long l = Socket.sendfilen(sendfileData.socket, sendfileData.fd, sendfileData.pos, sendfileData.end - sendfileData.pos, 0);
                    if (l < 0L) {
                        if (-l == 120002L) break;
                        Pool.destroy(sendfileData.fdpool);
                        sendfileData.socket = 0L;
                        return SendfileState.ERROR;
                    }
                    sendfileData.pos += l;
                    if (sendfileData.pos < sendfileData.end) continue;
                    Pool.destroy(sendfileData.fdpool);
                    Socket.timeoutSet(sendfileData.socket, AprEndpoint.this.getSoTimeout() * 1000);
                    return SendfileState.DONE;
                }
            }
            catch (Exception exception) {
                log.warn((Object)AbstractEndpoint.sm.getString("endpoint.sendfile.error"), (Throwable)exception);
                return SendfileState.ERROR;
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.addS.add(sendfileData);
                this.notify();
            }
            return SendfileState.PENDING;
        }

        protected void remove(SendfileData sendfileData) {
            int n = Poll.remove(this.sendfilePollset, sendfileData.socket);
            if (n == 0) {
                --this.sendfileCount;
            }
            this.sendfileData.remove(sendfileData.socket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = 0L;
            while (this.sendfileRunning) {
                Sendfile sendfile;
                while (this.sendfileRunning && AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                while (this.sendfileRunning && this.sendfileCount < 1 && this.addS.size() < 1) {
                    l = 0L;
                    try {
                        sendfile = this;
                        synchronized (sendfile) {
                            if (this.sendfileRunning && this.sendfileCount < 1 && this.addS.size() < 1) {
                                this.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                if (!this.sendfileRunning) break;
                try {
                    Object object;
                    int n;
                    if (this.addS.size() > 0) {
                        sendfile = this;
                        synchronized (sendfile) {
                            for (n = this.addS.size() - 1; n >= 0; --n) {
                                object = this.addS.get(n);
                                int n2 = Poll.add(this.sendfilePollset, ((SendfileData)object).socket, 4);
                                if (n2 == 0) {
                                    this.sendfileData.put(((SendfileData)object).socket, (SendfileData)object);
                                    ++this.sendfileCount;
                                    continue;
                                }
                                AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.sendfile.addfail", new Object[]{n2, Error.strerror(n2)}));
                                AprEndpoint.this.closeSocket(((SendfileData)object).socket);
                            }
                            this.addS.clear();
                        }
                    }
                    l += (long)AprEndpoint.this.pollTime;
                    int n3 = Poll.poll(this.sendfilePollset, AprEndpoint.this.pollTime, this.desc, false);
                    if (n3 > 0) {
                        block27: for (n = 0; n < n3; ++n) {
                            object = this.sendfileData.get(this.desc[n * 2 + 1]);
                            if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L) {
                                this.remove((SendfileData)object);
                                AprEndpoint.this.closeSocket(((SendfileData)object).socket);
                                continue;
                            }
                            long l2 = Socket.sendfilen(((SendfileData)object).socket, ((SendfileData)object).fd, ((SendfileData)object).pos, ((SendfileData)object).end - ((SendfileData)object).pos, 0);
                            if (l2 < 0L) {
                                this.remove((SendfileData)object);
                                AprEndpoint.this.closeSocket(((SendfileData)object).socket);
                                continue;
                            }
                            ((SendfileData)object).pos += l2;
                            if (((SendfileData)object).pos < ((SendfileData)object).end) continue;
                            this.remove((SendfileData)object);
                            switch (((SendfileData)object).keepAliveState) {
                                case NONE: {
                                    AprEndpoint.this.closeSocket(((SendfileData)object).socket);
                                    continue block27;
                                }
                                case PIPELINED: {
                                    Pool.destroy(((SendfileData)object).fdpool);
                                    Socket.timeoutSet(((SendfileData)object).socket, AprEndpoint.this.getSoTimeout() * 1000);
                                    if (AprEndpoint.this.processSocket(((SendfileData)object).socket, SocketStatus.OPEN_READ)) continue block27;
                                    AprEndpoint.this.closeSocket(((SendfileData)object).socket);
                                    continue block27;
                                }
                                case OPEN: {
                                    Pool.destroy(((SendfileData)object).fdpool);
                                    Socket.timeoutSet(((SendfileData)object).socket, AprEndpoint.this.getSoTimeout() * 1000);
                                    AprEndpoint.this.getPoller().add(((SendfileData)object).socket, AprEndpoint.this.getKeepAliveTimeout(), true, false);
                                }
                            }
                        }
                    } else if (n3 < 0 && (n = -n3) != 120001 && n != 120003) {
                        if (n > 120000) {
                            n -= 120000;
                        }
                        AprEndpoint.this.getLog().error((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollError", new Object[]{n, Error.strerror(n)}));
                        object = this;
                        synchronized (object) {
                            this.destroy();
                            this.init();
                            continue;
                        }
                    }
                    if (AprEndpoint.this.getSoTimeout() <= 0 || l <= 1000000L || !this.sendfileRunning) continue;
                    n3 = Poll.maintain(this.sendfilePollset, this.desc, false);
                    l = 0L;
                    if (n3 <= 0) continue;
                    for (n = 0; n < n3; ++n) {
                        object = this.sendfileData.get(this.desc[n]);
                        this.remove((SendfileData)object);
                        AprEndpoint.this.closeSocket(((SendfileData)object).socket);
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    AprEndpoint.this.getLog().error((Object)AbstractEndpoint.sm.getString("endpoint.poll.error"), throwable);
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.notifyAll();
            }
        }
    }

    public static class SendfileData {
        public String fileName;
        public long fd;
        public long fdpool;
        public long start;
        public long end;
        public long socket;
        public long pos;
        public SendfileKeepAliveState keepAliveState = SendfileKeepAliveState.NONE;
    }

    public class Poller
    implements Runnable {
        private long aprPoller;
        private int pollerSize = 0;
        protected long pool = 0L;
        protected long[] desc;
        protected SocketList addList = null;
        private SocketList closeList = null;
        protected SocketTimeouts timeouts = null;
        protected long lastMaintain = System.currentTimeMillis();
        private AtomicInteger connectionCount = new AtomicInteger(0);
        private volatile boolean pollerRunning = true;

        public int getConnectionCount() {
            return this.connectionCount.get();
        }

        protected void init() {
            this.pool = Pool.create(AprEndpoint.this.serverSockPool);
            this.pollerSize = AprEndpoint.this.getMaxConnections();
            this.timeouts = new SocketTimeouts(this.pollerSize);
            this.aprPoller = AprEndpoint.this.allocatePoller(this.pollerSize, this.pool, -1);
            this.desc = new long[this.pollerSize * 4];
            this.connectionCount.set(0);
            this.addList = new SocketList(this.pollerSize);
            this.closeList = new SocketList(this.pollerSize);
        }

        protected synchronized void stop() {
            this.pollerRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            int n;
            Object object;
            try {
                object = this;
                synchronized (object) {
                    this.notify();
                    this.wait(AprEndpoint.this.pollTime / 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object = this.addList.get();
            while (object != null) {
                n = ((AprSocketWrapper)AprEndpoint.this.connections.get(((SocketInfo)object).socket)).isComet() ? 1 : 0;
                if (n == 0 || !AprEndpoint.this.processSocket(((SocketInfo)object).socket, SocketStatus.STOP)) {
                    AprEndpoint.this.destroySocket(((SocketInfo)object).socket);
                }
                object = this.addList.get();
            }
            this.addList.clear();
            n = Poll.pollset(this.aprPoller, this.desc);
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    boolean bl = ((AprSocketWrapper)AprEndpoint.this.connections.get(this.desc[i * 2 + 1])).isComet();
                    if (bl && AprEndpoint.this.processSocket(this.desc[i * 2 + 1], SocketStatus.STOP)) continue;
                    AprEndpoint.this.destroySocket(this.desc[i * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.connectionCount.set(0);
        }

        public void add(long l, int n, boolean bl, boolean bl2) {
            this.add(l, n, (bl ? 1 : 0) | (bl2 ? 4 : 0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(long l, int n, int n2) {
            boolean bl;
            if (log.isDebugEnabled()) {
                String string = AbstractEndpoint.sm.getString("endpoint.debug.pollerAdd", new Object[]{l, n, n2});
                if (log.isTraceEnabled()) {
                    log.trace((Object)string, (Throwable)new Exception());
                } else {
                    log.debug((Object)string);
                }
            }
            if (n <= 0) {
                n = Integer.MAX_VALUE;
            }
            boolean bl2 = false;
            Poller poller = this;
            synchronized (poller) {
                if (this.pollerRunning && this.addList.add(l, n, n2)) {
                    bl2 = true;
                    this.notify();
                }
            }
            if (!(bl2 || (bl = ((AprSocketWrapper)AprEndpoint.this.connections.get(l)).isComet()) && AprEndpoint.this.processSocket(l, SocketStatus.ERROR))) {
                AprEndpoint.this.closeSocket(l);
            }
        }

        protected boolean addToPoller(long l, int n) {
            int n2 = Poll.add(this.aprPoller, l, n);
            if (n2 == 0) {
                this.connectionCount.incrementAndGet();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean close(long l) {
            if (!this.pollerRunning) {
                return false;
            }
            Poller poller = this;
            synchronized (poller) {
                if (!this.pollerRunning) {
                    return false;
                }
                this.closeList.add(l, 0, 0);
                this.notify();
                return true;
            }
        }

        private boolean removeFromPoller(long l) {
            int n;
            if (log.isDebugEnabled()) {
                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerRemove", new Object[]{l}));
            }
            if ((n = Poll.remove(this.aprPoller, l)) != 70015) {
                this.connectionCount.decrementAndGet();
                if (log.isDebugEnabled()) {
                    log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerRemoved", new Object[]{l}));
                }
            }
            this.timeouts.remove(l);
            return n == 0;
        }

        protected void maintain() {
            long l = System.currentTimeMillis();
            if (l - this.lastMaintain < 5000L) {
                return;
            }
            this.lastMaintain = l;
            long l2 = this.timeouts.check(l);
            while (l2 != 0L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.socketTimeout", new Object[]{l2}));
                }
                this.removeFromPoller(l2);
                boolean bl = ((AprSocketWrapper)AprEndpoint.this.connections.get(l2)).isComet();
                if (!bl || !AprEndpoint.this.processSocket(l2, SocketStatus.TIMEOUT)) {
                    AprEndpoint.this.destroySocket(l2);
                }
                l2 = this.timeouts.check(l);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Poller");
            long[] lArray = new long[this.pollerSize * 2];
            int n = Poll.pollset(this.aprPoller, lArray);
            stringBuilder.append(" [ ");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.desc[2 * i + 1]).append(' ');
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketList socketList = new SocketList(AprEndpoint.this.getMaxConnections());
            SocketList socketList2 = new SocketList(AprEndpoint.this.getMaxConnections());
            while (this.pollerRunning) {
                while (this.pollerRunning && AprEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                while (this.pollerRunning && this.connectionCount.get() < 1 && this.addList.size() < 1 && this.closeList.size() < 1) {
                    try {
                        if (AprEndpoint.this.getSoTimeout() > 0 && this.pollerRunning) {
                            this.maintain();
                        }
                        Poller poller = this;
                        synchronized (poller) {
                            if (this.addList.size() < 1 && this.closeList.size() < 1) {
                                this.wait(10000L);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable(throwable);
                        AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.timeout.err"));
                    }
                }
                if (!this.pollerRunning) break;
                try {
                    long l;
                    int n;
                    Object object = this;
                    synchronized (object) {
                        if (this.closeList.size() > 0) {
                            this.closeList.duplicate(socketList2);
                            this.closeList.clear();
                        } else {
                            socketList2.clear();
                        }
                    }
                    object = this;
                    synchronized (object) {
                        if (this.addList.size() > 0) {
                            this.addList.duplicate(socketList);
                            this.addList.clear();
                        } else {
                            socketList.clear();
                        }
                    }
                    if (socketList2.size() > 0) {
                        object = socketList2.get();
                        while (object != null) {
                            socketList.remove(((SocketInfo)object).socket);
                            this.removeFromPoller(((SocketInfo)object).socket);
                            AprEndpoint.this.destroySocket(((SocketInfo)object).socket);
                            object = socketList2.get();
                        }
                    }
                    if (socketList.size() > 0) {
                        object = socketList.get();
                        while (object != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerAddDo", new Object[]{((SocketInfo)object).socket}));
                            }
                            this.timeouts.remove(((SocketInfo)object).socket);
                            AprSocketWrapper aprSocketWrapper = (AprSocketWrapper)AprEndpoint.this.connections.get(((SocketInfo)object).socket);
                            if (aprSocketWrapper != null) {
                                if (((SocketInfo)object).read() || ((SocketInfo)object).write()) {
                                    n = aprSocketWrapper.isComet() ? 1 : 0;
                                    if (n != 0 || aprSocketWrapper.pollerFlags != 0) {
                                        this.removeFromPoller(((SocketInfo)object).socket);
                                    }
                                    aprSocketWrapper.pollerFlags = aprSocketWrapper.pollerFlags | (((SocketInfo)object).read() ? 1 : 0) | (((SocketInfo)object).write() ? 4 : 0);
                                    if (!this.addToPoller(((SocketInfo)object).socket, aprSocketWrapper.pollerFlags)) {
                                        if (n == 0 || !AprEndpoint.this.processSocket(((SocketInfo)object).socket, SocketStatus.ERROR)) {
                                            AprEndpoint.this.closeSocket(((SocketInfo)object).socket);
                                        }
                                    } else {
                                        this.timeouts.add(((SocketInfo)object).socket, System.currentTimeMillis() + (long)((SocketInfo)object).timeout);
                                    }
                                } else {
                                    AprEndpoint.this.closeSocket(((SocketInfo)object).socket);
                                    AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollAddInvalid", new Object[]{object}));
                                }
                            }
                            object = socketList.get();
                        }
                    }
                    boolean bl = false;
                    int n2 = Poll.poll(this.aprPoller, AprEndpoint.this.pollTime, this.desc, true);
                    if (n2 > 0) {
                        n2 = this.mergeDescriptors(this.desc, n2);
                        this.connectionCount.addAndGet(-n2);
                        for (n = 0; n < n2; ++n) {
                            if (AprEndpoint.this.getLog().isDebugEnabled()) {
                                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.pollerProcess", new Object[]{this.desc[n * 2 + 1], this.desc[n * 2]}));
                            }
                            l = this.timeouts.remove(this.desc[n * 2 + 1]);
                            AprSocketWrapper aprSocketWrapper = (AprSocketWrapper)AprEndpoint.this.connections.get(this.desc[n * 2 + 1]);
                            if (aprSocketWrapper == null) continue;
                            aprSocketWrapper.pollerFlags = aprSocketWrapper.pollerFlags & ~((int)this.desc[n * 2]);
                            if (aprSocketWrapper.isComet()) {
                                if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L || (this.desc[n * 2] & 0x40L) == 64L) {
                                    if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.ERROR)) continue;
                                    AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                    continue;
                                }
                                if ((this.desc[n * 2] & 1L) == 1L) {
                                    if (aprSocketWrapper.pollerFlags != 0) {
                                        this.add(this.desc[n * 2 + 1], 1, aprSocketWrapper.pollerFlags);
                                    }
                                    if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.OPEN_READ)) continue;
                                    AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                    continue;
                                }
                                if ((this.desc[n * 2] & 4L) == 4L) {
                                    if (aprSocketWrapper.pollerFlags != 0) {
                                        this.add(this.desc[n * 2 + 1], 1, aprSocketWrapper.pollerFlags);
                                    }
                                    if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.OPEN_WRITE)) continue;
                                    AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                    continue;
                                }
                                AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollUnknownEvent", new Object[]{this.desc[n * 2]}));
                                if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.ERROR)) continue;
                                AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                continue;
                            }
                            if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L || (this.desc[n * 2] & 0x40L) == 64L) {
                                if (aprSocketWrapper.isUpgraded()) {
                                    if ((this.desc[n * 2] & 1L) == 1L) {
                                        if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.OPEN_READ)) continue;
                                        AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                        continue;
                                    }
                                    if ((this.desc[n * 2] & 4L) == 4L) {
                                        if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.OPEN_WRITE)) continue;
                                        AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                        continue;
                                    }
                                    if ((aprSocketWrapper.pollerFlags & 1) == 1) {
                                        if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.OPEN_READ)) continue;
                                        AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                        continue;
                                    }
                                    if ((aprSocketWrapper.pollerFlags & 4) == 4) {
                                        if (AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.OPEN_WRITE)) continue;
                                        AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                        continue;
                                    }
                                    AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                    continue;
                                }
                                AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                continue;
                            }
                            if ((this.desc[n * 2] & 1L) == 1L || (this.desc[n * 2] & 4L) == 4L) {
                                boolean bl2 = false;
                                if ((this.desc[n * 2] & 1L) == 1L && !AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.OPEN_READ)) {
                                    bl2 = true;
                                    AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                }
                                if (!bl2 && (this.desc[n * 2] & 4L) == 4L && !AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.OPEN_WRITE)) {
                                    bl2 = true;
                                    AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                                }
                                if (bl2 || aprSocketWrapper.pollerFlags == 0) continue;
                                if (l > 0L) {
                                    l -= System.currentTimeMillis();
                                }
                                if (l <= 0L) {
                                    l = 1L;
                                }
                                if (l > Integer.MAX_VALUE) {
                                    l = Integer.MAX_VALUE;
                                }
                                this.add(this.desc[n * 2 + 1], (int)l, aprSocketWrapper.pollerFlags);
                                continue;
                            }
                            AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollUnknownEvent", new Object[]{this.desc[n * 2]}));
                            AprEndpoint.this.closeSocket(this.desc[n * 2 + 1]);
                        }
                    } else if (n2 < 0 && (n = -n2) != 120001 && n != 120003) {
                        if (n > 120000) {
                            n -= 120000;
                        }
                        AprEndpoint.this.getLog().error((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollError", new Object[]{n, Error.strerror(n)}));
                        bl = true;
                    }
                    if (bl && this.pollerRunning) {
                        n = Poll.pollset(this.aprPoller, this.desc);
                        l = AprEndpoint.this.allocatePoller(this.pollerSize, this.pool, -1);
                        this.connectionCount.addAndGet(-n);
                        Poll.destroy(this.aprPoller);
                        this.aprPoller = l;
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.poll.error"), throwable);
                }
                try {
                    if (AprEndpoint.this.getSoTimeout() <= 0 || !this.pollerRunning) continue;
                    this.maintain();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    AprEndpoint.this.getLog().warn((Object)AbstractEndpoint.sm.getString("endpoint.timeout.err"), throwable);
                }
            }
            Poller poller = this;
            synchronized (poller) {
                this.notifyAll();
            }
        }

        private int mergeDescriptors(long[] lArray, int n) {
            int n2;
            HashMap<Long, Long> hashMap = new HashMap<Long, Long>(n);
            for (n2 = 0; n2 < n; ++n2) {
                Long l = hashMap.put(lArray[2 * n2 + 1], lArray[2 * n2]);
                if (l == null) continue;
                hashMap.put(lArray[2 * n2 + 1], lArray[2 * n2] | l);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.apr.pollMergeEvents", new Object[]{lArray[2 * n2 + 1], lArray[2 * n2], l}));
            }
            n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                lArray[n2++] = (Long)entry.getValue();
                lArray[n2++] = (Long)entry.getKey();
            }
            return hashMap.size();
        }
    }

    public static class SocketList {
        protected volatile int size = 0;
        protected int pos = 0;
        protected long[] sockets;
        protected int[] timeouts;
        protected int[] flags;
        protected SocketInfo info = new SocketInfo();

        public SocketList(int n) {
            this.sockets = new long[n];
            this.timeouts = new int[n];
            this.flags = new int[n];
        }

        public int size() {
            return this.size;
        }

        public SocketInfo get() {
            if (this.pos == this.size) {
                return null;
            }
            this.info.socket = this.sockets[this.pos];
            this.info.timeout = this.timeouts[this.pos];
            this.info.flags = this.flags[this.pos];
            ++this.pos;
            return this.info;
        }

        public void clear() {
            this.size = 0;
            this.pos = 0;
        }

        public boolean add(long l, int n, int n2) {
            if (this.size == this.sockets.length) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != l) continue;
                this.flags[i] = SocketInfo.merge(this.flags[i], n2);
                return true;
            }
            this.sockets[this.size] = l;
            this.timeouts[this.size] = n;
            this.flags[this.size] = n2;
            ++this.size;
            return true;
        }

        public boolean remove(long l) {
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != l) continue;
                this.sockets[i] = this.sockets[this.size - 1];
                this.timeouts[i] = this.timeouts[this.size - 1];
                this.flags[this.size] = this.flags[this.size - 1];
                --this.size;
                return true;
            }
            return false;
        }

        public void duplicate(SocketList socketList) {
            socketList.size = this.size;
            socketList.pos = this.pos;
            System.arraycopy(this.sockets, 0, socketList.sockets, 0, this.size);
            System.arraycopy(this.timeouts, 0, socketList.timeouts, 0, this.size);
            System.arraycopy(this.flags, 0, socketList.flags, 0, this.size);
        }
    }

    public static class SocketTimeouts {
        protected int size = 0;
        protected long[] sockets;
        protected long[] timeouts;
        protected int pos = 0;

        public SocketTimeouts(int n) {
            this.sockets = new long[n];
            this.timeouts = new long[n];
        }

        public void add(long l, long l2) {
            this.sockets[this.size] = l;
            this.timeouts[this.size] = l2;
            ++this.size;
        }

        public long remove(long l) {
            long l2 = 0L;
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != l) continue;
                l2 = this.timeouts[i];
                this.sockets[i] = this.sockets[this.size - 1];
                this.timeouts[i] = this.timeouts[this.size - 1];
                --this.size;
                break;
            }
            return l2;
        }

        public long check(long l) {
            while (this.pos < this.size) {
                if (l >= this.timeouts[this.pos]) {
                    long l2 = this.sockets[this.pos];
                    this.sockets[this.pos] = this.sockets[this.size - 1];
                    this.timeouts[this.pos] = this.timeouts[this.size - 1];
                    --this.size;
                    return l2;
                }
                ++this.pos;
            }
            this.pos = 0;
            return 0L;
        }
    }

    public static class SocketInfo {
        public long socket;
        public int timeout;
        public int flags;

        public boolean read() {
            return (this.flags & 1) == 1;
        }

        public boolean write() {
            return (this.flags & 4) == 4;
        }

        public static int merge(int n, int n2) {
            return n & 1 | n2 & 1 | (n & 4 | n2 & 4);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Socket: [");
            stringBuilder.append(this.socket);
            stringBuilder.append("], timeout: [");
            stringBuilder.append(this.timeout);
            stringBuilder.append("], flags: [");
            stringBuilder.append(this.flags);
            return stringBuilder.toString();
        }
    }

    protected class AsyncTimeout
    implements Runnable {
        private volatile boolean asyncTimeoutRunning = true;

        protected AsyncTimeout() {
        }

        @Override
        public void run() {
            while (this.asyncTimeoutRunning) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long l = System.currentTimeMillis();
                for (SocketWrapper<Long> socketWrapper : AprEndpoint.this.waitingRequests) {
                    if (!socketWrapper.async) continue;
                    long l2 = socketWrapper.getLastAccess();
                    if ((socketWrapper.getTimeout() <= 0L || l - l2 <= socketWrapper.getTimeout()) && AprEndpoint.this.handler.isAvailable(socketWrapper)) continue;
                    socketWrapper.setTimeout(-1L);
                    AprEndpoint.this.processSocketAsync(socketWrapper, SocketStatus.TIMEOUT);
                }
                while (AprEndpoint.this.paused && this.asyncTimeoutRunning) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        protected void stop() {
            this.asyncTimeoutRunning = false;
        }
    }

    protected class Acceptor
    extends AbstractEndpoint.Acceptor {
        private final Log log = LogFactory.getLog(Acceptor.class);

        protected Acceptor() {
        }

        @Override
        public void run() {
            int n = 0;
            while (AprEndpoint.this.running) {
                while (AprEndpoint.this.paused && AprEndpoint.this.running) {
                    this.state = AbstractEndpoint.Acceptor.AcceptorState.PAUSED;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!AprEndpoint.this.running) break;
                this.state = AbstractEndpoint.Acceptor.AcceptorState.RUNNING;
                try {
                    AprEndpoint.this.countUpOrAwaitConnection();
                    long l = 0L;
                    try {
                        l = Socket.accept(AprEndpoint.this.serverSock);
                        if (this.log.isDebugEnabled()) {
                            long l2 = Address.get(1, l);
                            Sockaddr sockaddr = Address.getInfo(l2);
                            this.log.debug((Object)AbstractEndpoint.sm.getString("endpoint.apr.remoteport", new Object[]{l, (long)sockaddr.port}));
                        }
                    }
                    catch (Exception exception) {
                        AprEndpoint.this.countDownConnection();
                        n = AprEndpoint.this.handleExceptionWithDelay(n);
                        throw exception;
                    }
                    n = 0;
                    if (AprEndpoint.this.running && !AprEndpoint.this.paused) {
                        if (AprEndpoint.this.processSocketWithOptions(l)) continue;
                        AprEndpoint.this.closeSocket(l);
                        continue;
                    }
                    AprEndpoint.this.destroySocket(l);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    if (!AprEndpoint.this.running) continue;
                    String string = AbstractEndpoint.sm.getString("endpoint.accept.fail");
                    if (throwable instanceof Error) {
                        Error error = (Error)throwable;
                        if (error.getError() == 233) {
                            this.log.warn((Object)string, throwable);
                            continue;
                        }
                        this.log.error((Object)string, throwable);
                        continue;
                    }
                    this.log.error((Object)string, throwable);
                }
            }
            this.state = AbstractEndpoint.Acceptor.AcceptorState.ENDED;
        }
    }
}

