/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class JniLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(JniLifecycleListener.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    private String libraryName = "";
    private String libraryPath = "";

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if ("before_start".equals(lifecycleEvent.getType())) {
            if (!this.libraryName.isEmpty()) {
                System.loadLibrary(this.libraryName);
                log.info((Object)sm.getString("jniLifecycleListener.load.name", new Object[]{this.libraryName}));
            } else if (!this.libraryPath.isEmpty()) {
                System.load(this.libraryPath);
                log.info((Object)sm.getString("jniLifecycleListener.load.path", new Object[]{this.libraryPath}));
            } else {
                throw new IllegalArgumentException(sm.getString("jniLifecycleListener.missingPathOrName"));
            }
        }
    }

    public void setLibraryName(String string) {
        if (!this.libraryPath.isEmpty()) {
            throw new IllegalArgumentException(sm.getString("jniLifecycleListener.bothPathAndName"));
        }
        this.libraryName = string;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryPath(String string) {
        if (!this.libraryName.isEmpty()) {
            throw new IllegalArgumentException(sm.getString("jniLifecycleListener.bothPathAndName"));
        }
        this.libraryPath = string;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }
}

