/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import accessories.plugins.util.html.ClickableImageCreator;
import accessories.plugins.util.xslt.ExportDialog;
import freemind.extensions.ExportHook;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ExportWithXSLT
extends ExportHook {
    private static final String NAME_EXTENSION_PROPERTY = "name_extension";
    private boolean mTransformResultWithoutError = false;

    protected File chooseFile() {
        String nameExtension = null;
        if (this.getProperties().containsKey(NAME_EXTENSION_PROPERTY)) {
            nameExtension = this.getResourceString(NAME_EXTENSION_PROPERTY);
        }
        return this.chooseFile(this.getResourceString("file_type"), this.getTranslatableResourceString("file_description"), nameExtension);
    }

    @Override
    public void startupMapHook() {
        super.startupMapHook();
        ModeController mc = this.getController();
        MindMap model = this.getController().getMap();
        if (Tools.safeEquals(this.getResourceString("file_type"), "user")) {
            if (model == null) {
                return;
            }
            if (model.getFile() == null || model.isReadOnly()) {
                if (mc.save()) {
                    this.export(model.getFile());
                    return;
                }
                return;
            }
            this.export(model.getFile());
        } else {
            File saveFile = this.chooseFile();
            if (saveFile == null) {
                return;
            }
            try {
                this.mTransformResultWithoutError = true;
                String transformErrors = this.transform(saveFile);
                if (transformErrors != null) {
                    JOptionPane.showMessageDialog(null, this.getResourceString(transformErrors), "Freemind", 0);
                    this.mTransformResultWithoutError = false;
                } else if (Tools.safeEquals(this.getResourceString("load_file"), "true")) {
                    this.getController().getFrame().openDocument(Tools.fileToUrl(saveFile));
                }
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
                this.mTransformResultWithoutError = false;
            }
        }
    }

    public String transform(File saveFile) throws Exception {
        boolean create_image = Tools.safeEquals(this.getResourceString("create_html_linked_image"), "true");
        String areaCode = this.getAreaCode(create_image);
        String xsltFileName = this.getResourceString("xslt_file");
        boolean success = this.transformMapWithXslt(xsltFileName, saveFile, areaCode);
        if (!success) {
            return "error_applying_template";
        }
        if (success && Tools.safeEquals(this.getResourceString("create_dir"), "true")) {
            String directoryName = saveFile.getAbsolutePath() + "_files";
            success = this.createDirectory(directoryName);
            if (success) {
                String files = this.getResourceString("files_to_copy");
                String filePrefix = this.getResourceString("file_prefix");
                this.copyFilesFromResourcesToDirectory(directoryName, files, filePrefix);
            }
            if (success && Tools.safeEquals(this.getResourceString("copy_icons"), "true")) {
                success = this.copyIcons(directoryName);
            }
            if (success && Tools.safeEquals(this.getResourceString("copy_map"), "true")) {
                success = this.copyMap(directoryName);
            }
            if (success && create_image) {
                this.createImageFromMap(directoryName);
            }
        }
        if (!success) {
            return "error_creating_directory";
        }
        return null;
    }

    private boolean copyMap(String pDirectoryName) throws IOException {
        boolean success = true;
        BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(pDirectoryName + File.separator + "map.mm")));
        this.getController().getMap().getFilteredXml(fileout);
        return success;
    }

    private boolean copyIcons(String directoryName) {
        String iconDirectoryName = directoryName + File.separatorChar + "icons";
        boolean success = this.createDirectory(iconDirectoryName);
        if (success) {
            this.copyIconsToDirectory(iconDirectoryName);
        }
        return success;
    }

    private void createImageFromMap(String directoryName) {
        if (this.getController().getView() == null) {
            return;
        }
        BufferedImage image = this.createBufferedImage();
        try {
            FileOutputStream out = new FileOutputStream(directoryName + File.separator + "image.png");
            ImageIO.write((RenderedImage)image, "png", out);
            out.close();
        }
        catch (IOException e1) {
            Resources.getInstance().logException(e1);
        }
    }

    private void copyIconsToDirectory(String directoryName2) {
        Vector iconNames = MindIcon.getAllIconNames();
        for (int i = 0; i < iconNames.size(); ++i) {
            String iconName = (String)iconNames.get(i);
            MindIcon myIcon = MindIcon.factory(iconName);
            this.copyFromResource(MindIcon.getIconsPath(), myIcon.getIconBaseFileName(), directoryName2);
        }
        File iconDir = new File(Resources.getInstance().getFreemindDirectory(), "icons");
        if (iconDir.exists()) {
            String[] userIconArray = iconDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(".*\\.png");
                }
            });
            for (int i = 0; i < userIconArray.length; ++i) {
                String iconName = userIconArray[i];
                if (iconName.length() == 4) continue;
                this.copyFromFile(iconDir.getAbsolutePath(), iconName, directoryName2);
            }
        }
    }

    private void copyFilesFromResourcesToDirectory(String directoryName, String files, String filePrefix) {
        StringTokenizer tokenizer = new StringTokenizer(files, ",");
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            this.copyFromResource(filePrefix, next, directoryName);
        }
    }

    private boolean createDirectory(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists()) {
            return dir.mkdir();
        }
        return true;
    }

    private boolean transformMapWithXslt(String xsltFileName, File saveFile, String areaCode) throws IOException {
        StringWriter writer = this.getMapXml();
        StringReader reader = new StringReader(writer.getBuffer().toString());
        URL xsltUrl = this.getResource(xsltFileName);
        if (xsltUrl == null) {
            this.logger.severe("Can't find " + xsltFileName + " as resource.");
            throw new IllegalArgumentException("Can't find " + xsltFileName + " as resource.");
        }
        InputStream xsltFile = xsltUrl.openStream();
        return this.transform(new StreamSource(reader), xsltFile, saveFile, areaCode);
    }

    private StringWriter getMapXml() throws IOException {
        StringWriter writer = new StringWriter();
        this.getController().getMap().getFilteredXml(writer);
        return writer;
    }

    private String getAreaCode(boolean create_image) {
        String areaCode = "";
        if (create_image) {
            MindMapNode root = this.getController().getMap().getRootNode();
            ClickableImageCreator creator = new ClickableImageCreator(root, this.getController(), this.getResourceString("link_replacement_regexp"));
            areaCode = creator.generateHtml();
        }
        return areaCode;
    }

    private void export(File file) {
        ExportDialog exp = new ExportDialog(file, this.getController());
        exp.setVisible(true);
    }

    public boolean transform(Source xmlSource, InputStream xsltStream, File resultFile, String areaCode) throws FileNotFoundException {
        StreamSource xsltSource = new StreamSource(xsltStream);
        StreamResult result = new StreamResult(new FileOutputStream(resultFile));
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.setParameter("destination_dir", Tools.fileToRelativeUrlString(new File(resultFile.getAbsolutePath() + "_files/"), resultFile) + "/");
            trans.setParameter("area_code", areaCode);
            trans.setParameter("folding_type", this.getController().getFrame().getProperty("html_export_folding"));
            trans.transform(xmlSource, result);
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            return false;
        }
        return true;
    }

    public boolean isTransformResultWithoutError() {
        return this.mTransformResultWithoutError;
    }
}

