/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.gui.CombinedListAndModel;
import tim.prune.gui.GuiGridLayout;

public class SelectTimezoneFunction
extends GenericFunction {
    private ArrayList<TimezoneDetails> _zoneInfo;
    private JDialog _dialog = null;
    private JRadioButton _systemRadio = null;
    private JRadioButton _customRadio = null;
    private CombinedListAndModel[] _listBoxes = null;
    private JLabel _selectedZoneLabel = null;
    private JLabel _selectedOffsetLabel = null;
    private JButton _okButton = null;
    private static final int LIST_REGIONS = 0;
    private static final int LIST_OFFSETS = 1;
    private static final int LIST_GROUPS = 2;
    private static final int LIST_NAMES = 3;

    public SelectTimezoneFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.selecttimezone";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.collectTimezoneInfo();
        this._systemRadio.setText(String.valueOf(I18nManager.getText("dialog.settimezone.system")) + " (" + TimeZone.getDefault().getID() + ")");
        String string = Config.getConfigString("prune.timezoneid");
        if (string == null || string.equals("")) {
            this._systemRadio.setSelected(true);
        } else {
            this._customRadio.setSelected(true);
        }
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectTimezoneFunction.this.radioSelected(SelectTimezoneFunction.this._systemRadio.isSelected());
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SelectTimezoneFunction.this.radioSelected(SelectTimezoneFunction.this._systemRadio.isSelected());
            }
        };
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.settimezone.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add(jLabel);
        this._systemRadio = new JRadioButton(I18nManager.getText("dialog.settimezone.system"));
        this._systemRadio.addActionListener(actionListener);
        this._systemRadio.addFocusListener(focusAdapter);
        jPanel2.add(this._systemRadio);
        this._customRadio = new JRadioButton(I18nManager.getText("dialog.settimezone.custom"));
        this._customRadio.addActionListener(actionListener);
        this._customRadio.addFocusListener(focusAdapter);
        jPanel2.add(this._customRadio);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._systemRadio);
        buttonGroup.add(this._customRadio);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 4));
        this._listBoxes = new CombinedListAndModel[4];
        this._listBoxes[0] = new CombinedListAndModel(0);
        this._listBoxes[0].addListSelectionListener(new ListListener(0));
        JScrollPane jScrollPane = new JScrollPane(this._listBoxes[0]);
        jScrollPane.setPreferredSize(new Dimension(100, 200));
        jScrollPane.setMinimumSize(new Dimension(100, 200));
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel4.add(jScrollPane);
        this._listBoxes[1] = new CombinedListAndModel(1);
        this._listBoxes[1].setMaxNumEntries(24);
        this._listBoxes[1].addListSelectionListener(new ListListener(1));
        jScrollPane = new JScrollPane(this._listBoxes[1]);
        jScrollPane.setPreferredSize(new Dimension(100, 200));
        jScrollPane.setMinimumSize(new Dimension(100, 200));
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel4.add(jScrollPane);
        this._listBoxes[2] = new CombinedListAndModel(2);
        this._listBoxes[2].setMaxNumEntries(20);
        this._listBoxes[2].addListSelectionListener(new ListListener(2));
        jScrollPane = new JScrollPane(this._listBoxes[2]);
        jScrollPane.setPreferredSize(new Dimension(100, 200));
        jScrollPane.setMinimumSize(new Dimension(100, 200));
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel4.add(jScrollPane);
        this._listBoxes[3] = new CombinedListAndModel(3);
        this._listBoxes[3].setMaxNumEntries(20);
        this._listBoxes[3].addListSelectionListener(new ListListener(3));
        jScrollPane = new JScrollPane(this._listBoxes[3]);
        jScrollPane.setPreferredSize(new Dimension(100, 200));
        jScrollPane.setMinimumSize(new Dimension(100, 200));
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel4.add(jScrollPane);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel5);
        guiGridLayout.add(new JLabel(String.valueOf(I18nManager.getText("dialog.settimezone.selectedzone")) + " :"));
        this._selectedZoneLabel = new JLabel("");
        guiGridLayout.add(this._selectedZoneLabel);
        guiGridLayout.add(new JLabel(String.valueOf(I18nManager.getText("dialog.settimezone.offsetfromutc")) + " :"));
        this._selectedOffsetLabel = new JLabel("");
        guiGridLayout.add(this._selectedOffsetLabel);
        jPanel3.add(jPanel5);
        jPanel.add((Component)jPanel3, "Center");
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    SelectTimezoneFunction.this._dialog.dispose();
                }
            }
        };
        this._listBoxes[0].addKeyListener(keyAdapter);
        this._listBoxes[1].addKeyListener(keyAdapter);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectTimezoneFunction.this.finishSelectTimezone();
            }
        });
        jPanel6.add(this._okButton);
        this._okButton.addKeyListener(keyAdapter);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectTimezoneFunction.this._dialog.dispose();
            }
        });
        jButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    SelectTimezoneFunction.this._dialog.dispose();
                }
            }
        });
        jPanel6.add(jButton);
        jPanel.add((Component)jPanel6, "South");
        return jPanel;
    }

    private void radioSelected(boolean bl) {
        int n = 0;
        while (n < this._listBoxes.length) {
            if (bl) {
                this._listBoxes[n].clear();
            }
            this._listBoxes[n].setEnabled(!bl);
            ++n;
        }
        if (!bl) {
            this.populateTimezoneRegions();
            this.populateTimezoneOffsets(null);
            this.preselectTimezone(Config.getConfigString("prune.timezoneid"));
        }
        this.showTimezoneDetails();
    }

    private void processListClick(int n) {
        boolean bl;
        boolean bl2 = this._listBoxes[1].getSelectedItem() != null;
        boolean bl3 = bl = this._listBoxes[2].getSelectedItem() != null;
        if (n == 0) {
            this.populateTimezoneOffsets(this._listBoxes[0].getSelectedItem());
        }
        if (n == 1 || n == 0 && !bl2) {
            this.populateTimezoneGroups(this._listBoxes[0].getSelectedItem(), this._listBoxes[1].getSelectedItem());
        }
        if (n == 2 || n <= 1 && !bl) {
            this.populateTimezoneNames(this._listBoxes[0].getSelectedItem(), this._listBoxes[1].getSelectedItem(), this._listBoxes[2].getSelectedItem());
        }
        this.showTimezoneDetails();
    }

    private void collectTimezoneInfo() {
        this._zoneInfo = new ArrayList();
        String[] stringArray = TimeZone.getAvailableIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String string2 = SelectTimezoneFunction.getRegion(string);
            if (string2 != null) {
                TimeZone timeZone = TimeZone.getTimeZone(string);
                TimezoneDetails timezoneDetails = new TimezoneDetails();
                timezoneDetails._id = string;
                timezoneDetails._region = string2;
                timezoneDetails._offset = timeZone.getOffset(System.currentTimeMillis()) / 1000 / 60;
                timezoneDetails._group = timeZone.getDisplayName();
                timezoneDetails._name = SelectTimezoneFunction.getNameWithoutRegion(string);
                this._zoneInfo.add(timezoneDetails);
            }
            ++n2;
        }
    }

    private void populateTimezoneRegions() {
        this._listBoxes[0].clear();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (TimezoneDetails object : this._zoneInfo) {
            treeSet.add(object._region);
        }
        for (String string : treeSet) {
            this._listBoxes[0].addItem(string);
        }
    }

    private static String getRegion(String string) {
        int n;
        int n2 = n = string == null ? -1 : string.indexOf(47);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    private void populateTimezoneOffsets(String string) {
        this._listBoxes[1].clear();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (TimezoneDetails object : this._zoneInfo) {
            String string2 = object._region;
            if (string != null && !string2.equals(string)) continue;
            treeSet.add(object._offset);
        }
        for (Integer n : treeSet) {
            this._listBoxes[1].addItem(SelectTimezoneFunction.makeOffsetString(n));
        }
    }

    private static String makeOffsetString(int n) {
        boolean bl;
        if (n == 0) {
            return "0";
        }
        boolean bl2 = bl = n % 60 == 0;
        if (bl) {
            return String.valueOf(n > 0 ? "+" : "") + n / 60;
        }
        double d = (double)n / 60.0;
        return String.valueOf(n > 0 ? "+" : "") + d;
    }

    private void populateTimezoneGroups(String string, String string2) {
        this._listBoxes[2].clear();
        int n = SelectTimezoneFunction.convertToMinutes(string2);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (TimezoneDetails object : this._zoneInfo) {
            if (string != null && !object._region.equals(string) || n != -1 && n != object._offset) continue;
            treeSet.add(object._group);
        }
        this._listBoxes[2].setUnlimited(string != null && string2 != null);
        for (String string3 : treeSet) {
            this._listBoxes[2].addItem(string3);
        }
    }

    private void populateTimezoneNames(String string, String string2, String string3) {
        CombinedListAndModel combinedListAndModel = this._listBoxes[3];
        combinedListAndModel.clear();
        int n = SelectTimezoneFunction.convertToMinutes(string2);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (TimezoneDetails object : this._zoneInfo) {
            if (string != null && !object._region.equals(string) || n != -1 && object._offset != n || string3 != null && !object._group.equals(string3)) continue;
            treeSet.add(object._name);
        }
        combinedListAndModel.setUnlimited(string != null && string2 != null);
        for (String string4 : treeSet) {
            combinedListAndModel.addItem(string4);
        }
    }

    private static int convertToMinutes(String string) {
        int n = -1;
        try {
            n = (int)(60.0 * Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {}
        return n;
    }

    private static String getNameWithoutRegion(String string) {
        int n;
        int n2 = n = string == null ? -1 : string.indexOf(47);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    private TimeZone getSelectedTimezone() {
        if (this._systemRadio.isSelected()) {
            return TimeZone.getDefault();
        }
        String string = this._listBoxes[0].getSelectedItem();
        int n = SelectTimezoneFunction.convertToMinutes(this._listBoxes[1].getSelectedItem());
        String string2 = this._listBoxes[2].getSelectedItem();
        String string3 = this._listBoxes[3].getSelectedItem();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (TimezoneDetails timezoneDetails : this._zoneInfo) {
            if (string != null && !timezoneDetails._region.equals(string) || n != -1 && timezoneDetails._offset != n || string2 != null && !timezoneDetails._group.equals(string2) || string3 != null && !timezoneDetails._name.equals(string3)) continue;
            treeSet.add(timezoneDetails._id);
            if (treeSet.size() > 1) break;
        }
        if (treeSet.size() == 1) {
            return TimeZone.getTimeZone((String)treeSet.first());
        }
        return null;
    }

    private void showTimezoneDetails() {
        TimeZone timeZone = this.getSelectedTimezone();
        if (timeZone == null) {
            this._selectedZoneLabel.setText("");
            this._selectedOffsetLabel.setText("");
        } else {
            String string = String.valueOf(timeZone.getID()) + " - " + timeZone.getDisplayName();
            this._selectedZoneLabel.setText(string);
            String string2 = SelectTimezoneFunction.getOffsetDescription(timeZone);
            this._selectedOffsetLabel.setText(string2);
        }
        this._okButton.setEnabled(timeZone != null);
    }

    private static String getOffsetDescription(TimeZone timeZone) {
        if (timeZone == null) {
            return "";
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < 5) {
            treeSet.add(timeZone.getOffset(l) / 1000 / 60);
            l += 5184000000L;
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Integer n2 : treeSet) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" / ");
            }
            stringBuffer.append(SelectTimezoneFunction.makeOffsetString(n2));
        }
        return stringBuffer.toString();
    }

    private void preselectTimezone(String string) {
        TimeZone timeZone;
        TimeZone timeZone2 = timeZone = string == null ? TimeZone.getDefault() : TimeZone.getTimeZone(string);
        if (timeZone != null) {
            this._listBoxes[0].selectItem(SelectTimezoneFunction.getRegion(string));
            this._listBoxes[1].selectItem(SelectTimezoneFunction.makeOffsetString(timeZone.getOffset(System.currentTimeMillis()) / 1000 / 60));
            this._listBoxes[2].selectItem(timeZone.getDisplayName());
            this._listBoxes[3].selectItem(SelectTimezoneFunction.getNameWithoutRegion(string));
        }
    }

    private void finishSelectTimezone() {
        TimeZone timeZone = this.getSelectedTimezone();
        if (this._systemRadio.isSelected() || timeZone == null) {
            Config.setConfigString("prune.timezoneid", null);
        } else {
            Config.setConfigString("prune.timezoneid", timeZone.getID());
        }
        this._dialog.dispose();
        UpdateMessageBroker.informSubscribers((byte)32);
    }

    class ListListener
    implements ListSelectionListener {
        private int _key = 0;

        ListListener(int n) {
            this._key = n;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                SelectTimezoneFunction.this.processListClick(this._key);
            }
        }
    }

    class TimezoneDetails {
        public String _id;
        public String _region;
        public int _offset;
        public String _group;
        public String _name;

        TimezoneDetails() {
        }
    }
}

