/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.jcs3.auxiliary.lateral.LateralElementDescriptor;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.CacheInfo;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.threadpool.DaemonThreadFactory;

public class LateralTCPListener<K, V>
implements ILateralCacheListener<K, V>,
IShutdownObserver {
    private static final Log log = LogManager.getLog(LateralTCPListener.class);
    private static final int acceptTimeOut = 1000;
    private transient ICompositeCacheManager cacheManager;
    private static final ConcurrentHashMap<String, ILateralCacheListener<?, ?>> instances = new ConcurrentHashMap();
    private ListenerThread receiver;
    private ITCPLateralCacheAttributes tcpLateralCacheAttributes;
    private ExecutorService pooledExecutor;
    private int putCnt = 0;
    private int removeCnt = 0;
    private int getCnt = 0;
    private long listenerId = CacheInfo.listenerId;
    private AtomicBoolean shutdown;
    private AtomicBoolean terminated;

    public static <K, V> LateralTCPListener<K, V> getInstance(ITCPLateralCacheAttributes ilca, ICompositeCacheManager cacheMgr) {
        LateralTCPListener ins = (LateralTCPListener)instances.computeIfAbsent(String.valueOf(ilca.getTcpListenerPort()), k -> {
            LateralTCPListener newIns = new LateralTCPListener(ilca);
            newIns.init();
            newIns.setCacheManager(cacheMgr);
            log.info("Created new listener {0}", () -> ilca.getTcpListenerPort());
            return newIns;
        });
        return ins;
    }

    protected LateralTCPListener(ITCPLateralCacheAttributes ilca) {
        this.setTcpLateralCacheAttributes(ilca);
    }

    @Override
    public synchronized void init() {
        try {
            ServerSocket serverSocket;
            int port = this.getTcpLateralCacheAttributes().getTcpListenerPort();
            String host = this.getTcpLateralCacheAttributes().getTcpListenerHost();
            this.pooledExecutor = Executors.newCachedThreadPool(new DaemonThreadFactory("JCS-LateralTCPListener-"));
            this.terminated = new AtomicBoolean(false);
            this.shutdown = new AtomicBoolean(false);
            if (host != null && host.length() > 0) {
                log.info("Listening on {0}:{1}", host, port);
                InetAddress inetAddress = InetAddress.getByName(host);
                InetSocketAddress endPoint = new InetSocketAddress(inetAddress, port);
                serverSocket = new ServerSocket();
                serverSocket.bind(endPoint);
            } else {
                log.info("Listening on port {0}", port);
                serverSocket = new ServerSocket(port);
            }
            serverSocket.setSoTimeout(1000);
            this.receiver = new ListenerThread(serverSocket);
            this.receiver.setDaemon(true);
            this.receiver.start();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void setListenerId(long id) throws IOException {
        this.listenerId = id;
        log.debug("set listenerId = {0}", id);
    }

    @Override
    public long getListenerId() throws IOException {
        return this.listenerId;
    }

    @Override
    public void handlePut(ICacheElement<K, V> element) throws IOException {
        ++this.putCnt;
        if (log.isInfoEnabled() && this.getPutCnt() % 100 == 0) {
            log.info("Put Count (port {0}) = {1}", () -> this.getTcpLateralCacheAttributes().getTcpListenerPort(), () -> this.getPutCnt());
        }
        log.debug("handlePut> cacheName={0}, key={1}", () -> element.getCacheName(), () -> element.getKey());
        this.getCache(element.getCacheName()).localUpdate(element);
    }

    @Override
    public void handleRemove(String cacheName, K key) throws IOException {
        ++this.removeCnt;
        if (log.isInfoEnabled() && this.getRemoveCnt() % 100 == 0) {
            log.info("Remove Count = {0}", () -> this.getRemoveCnt());
        }
        log.debug("handleRemove> cacheName={0}, key={1}", cacheName, key);
        this.getCache(cacheName).localRemove(key);
    }

    @Override
    public void handleRemoveAll(String cacheName) throws IOException {
        log.debug("handleRemoveAll> cacheName={0}", cacheName);
        this.getCache(cacheName).localRemoveAll();
    }

    public ICacheElement<K, V> handleGet(String cacheName, K key) throws IOException {
        ++this.getCnt;
        if (log.isInfoEnabled() && this.getGetCnt() % 100 == 0) {
            log.info("Get Count (port {0}) = {1}", () -> this.getTcpLateralCacheAttributes().getTcpListenerPort(), () -> this.getGetCnt());
        }
        log.debug("handleGet> cacheName={0}, key={1}", cacheName, key);
        return this.getCache(cacheName).localGet(key);
    }

    public Map<K, ICacheElement<K, V>> handleGetMatching(String cacheName, String pattern) throws IOException {
        ++this.getCnt;
        if (log.isInfoEnabled() && this.getGetCnt() % 100 == 0) {
            log.info("GetMatching Count (port {0}) = {1}", () -> this.getTcpLateralCacheAttributes().getTcpListenerPort(), () -> this.getGetCnt());
        }
        log.debug("handleGetMatching> cacheName={0}, pattern={1}", cacheName, pattern);
        return this.getCache(cacheName).localGetMatching(pattern);
    }

    public Set<K> handleGetKeySet(String cacheName) throws IOException {
        return this.getCache(cacheName).getKeySet(true);
    }

    @Override
    public void handleDispose(String cacheName) throws IOException {
        log.info("handleDispose > cacheName={0} | Ignoring message. Do not dispose from remote.", cacheName);
        this.terminated.set(true);
    }

    @Override
    public synchronized void dispose() {
        this.terminated.set(true);
        this.notify();
        this.pooledExecutor.shutdownNow();
    }

    protected CompositeCache<K, V> getCache(String name) {
        return this.getCacheManager().getCache(name);
    }

    public int getPutCnt() {
        return this.putCnt;
    }

    public int getGetCnt() {
        return this.getCnt;
    }

    public int getRemoveCnt() {
        return this.removeCnt;
    }

    @Override
    public void setCacheManager(ICompositeCacheManager cacheMgr) {
        this.cacheManager = cacheMgr;
    }

    @Override
    public ICompositeCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setTcpLateralCacheAttributes(ITCPLateralCacheAttributes tcpLateralCacheAttributes) {
        this.tcpLateralCacheAttributes = tcpLateralCacheAttributes;
    }

    public ITCPLateralCacheAttributes getTcpLateralCacheAttributes() {
        return this.tcpLateralCacheAttributes;
    }

    @Override
    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            log.info("Shutting down TCP Lateral receiver.");
            this.receiver.interrupt();
        } else {
            log.debug("Shutdown already called.");
        }
    }

    public class ConnectionHandler
    implements Runnable {
        private final Socket socket;

        public ConnectionHandler(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(this.socket.getInputStream(), null);
                Throwable throwable = null;
                try {
                    try {
                        while (true) {
                            LateralElementDescriptor led;
                            if ((led = (LateralElementDescriptor)ois.readObject()) == null) {
                                log.debug("LateralElementDescriptor is null");
                                continue;
                            }
                            if (led.requesterId == LateralTCPListener.this.getListenerId()) {
                                log.debug("from self");
                                continue;
                            }
                            log.debug("receiving LateralElementDescriptor from another led = {0}", led);
                            this.handle(led);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (ois != null) {
                        if (throwable != null) {
                            try {
                                ois.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ois.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (EOFException e) {
                log.info("Caught EOFException, closing connection.", e);
            }
            catch (SocketException e) {
                log.info("Caught SocketException, closing connection.", e);
            }
            catch (Exception e) {
                log.error("Unexpected exception.", e);
            }
        }

        private void handle(LateralElementDescriptor<K, V> led) throws IOException {
            String cacheName = led.ce.getCacheName();
            Object key = led.ce.getKey();
            Serializable obj = null;
            switch (led.command) {
                case UPDATE: {
                    LateralTCPListener.this.handlePut(led.ce);
                    break;
                }
                case REMOVE: {
                    ICacheElement test;
                    if (led.valHashCode != -1 && LateralTCPListener.this.getTcpLateralCacheAttributes().isFilterRemoveByHashCode() && (test = LateralTCPListener.this.getCache(cacheName).localGet(key)) != null) {
                        if (test.getVal().hashCode() == led.valHashCode) {
                            log.debug("Filtering detected identical hashCode [{0}], not issuing a remove for led {1}", led.valHashCode, led);
                            return;
                        }
                        log.debug("Different hashcodes, in cache [{0}] sent [{1}]", test.getVal().hashCode(), led.valHashCode);
                    }
                    LateralTCPListener.this.handleRemove(cacheName, key);
                    break;
                }
                case REMOVEALL: {
                    LateralTCPListener.this.handleRemoveAll(cacheName);
                    break;
                }
                case GET: {
                    obj = LateralTCPListener.this.handleGet(cacheName, key);
                    break;
                }
                case GET_MATCHING: {
                    obj = (Serializable)((Object)LateralTCPListener.this.handleGetMatching(cacheName, (String)key));
                    break;
                }
                case GET_KEYSET: {
                    obj = (Serializable)((Object)LateralTCPListener.this.handleGetKeySet(cacheName));
                    break;
                }
            }
            if (obj != null) {
                ObjectOutputStream oos = new ObjectOutputStream(this.socket.getOutputStream());
                oos.writeObject(obj);
                oos.flush();
            }
        }
    }

    public class ListenerThread
    extends Thread {
        private final ServerSocket serverSocket;

        public ListenerThread(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            block20: {
                try (ServerSocket ssck = this.serverSocket;){
                    while (true) {
                        log.debug("Waiting for clients to connect ");
                        Socket socket = null;
                        while (true) {
                            if (LateralTCPListener.this.terminated.get()) {
                                log.debug("Thread terminated, exiting gracefully");
                                break block20;
                            }
                            try {
                                socket = ssck.accept();
                            }
                            catch (SocketTimeoutException e) {
                                continue;
                            }
                            break;
                        }
                        if (socket != null && log.isDebugEnabled()) {
                            InetAddress inetAddress = socket.getInetAddress();
                            log.debug("Connected to client at {0}", inetAddress);
                        }
                        ConnectionHandler handler = new ConnectionHandler(socket);
                        LateralTCPListener.this.pooledExecutor.execute(handler);
                    }
                }
                catch (IOException e) {
                    log.error("Exception caught in TCP listener", e);
                }
            }
        }
    }
}

