/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.util.Objects;
import oauth.signpost.OAuthConsumer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class OAuthToken {
    private final String key;
    private final String secret;

    public static OAuthToken createToken(OAuthConsumer consumer) {
        return new OAuthToken(consumer.getToken(), consumer.getTokenSecret());
    }

    public OAuthToken(String key, String secret) {
        this.key = key;
        this.secret = secret;
    }

    public OAuthToken(OAuthToken other) {
        CheckParameterUtil.ensureParameterNotNull(other, "other");
        this.key = other.key;
        this.secret = other.secret;
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.secret);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthToken that = (OAuthToken)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.secret, that.secret);
    }
}

