/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.tools.I18n;

public class CyclicUploadDependencyException
extends Exception {
    private final List<Relation> cycle;

    public CyclicUploadDependencyException(Stack<Relation> cycle) {
        this.cycle = new ArrayList<Relation>(cycle);
    }

    protected String formatRelation(Relation r) {
        StringBuilder sb = new StringBuilder();
        if (r.getName() != null) {
            sb.append('\'').append(r.getName()).append('\'');
        } else if (!r.isNew()) {
            sb.append(r.getId());
        } else {
            sb.append("relation@").append(r.hashCode());
        }
        return sb.toString();
    }

    @Override
    public String getMessage() {
        return this.cycle.stream().map(this::formatRelation).collect(Collectors.joining(",", I18n.tr("Cyclic dependency between relations:", new Object[0]) + '[', "]"));
    }

    public List<Relation> getCyclicUploadDependency() {
        return Collections.unmodifiableList(this.cycle);
    }
}

