/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import org.openstreetmap.josm.actions.relation.DeleteRelationsAction;
import org.openstreetmap.josm.actions.relation.DownloadMembersAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.actions.relation.DuplicateRelationAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.actions.relation.SelectInRelationListAction;
import org.openstreetmap.josm.actions.relation.SelectMembersAction;
import org.openstreetmap.josm.actions.relation.SelectRelationAction;
import org.openstreetmap.josm.gui.PopupMenuHandler;

public final class RelationPopupMenus {
    private RelationPopupMenus() {
    }

    @SafeVarargs
    public static PopupMenuHandler setupHandler(PopupMenuHandler menu, Class<? extends Action> ... excludeActions) {
        List<Class<? extends Action>> exclude = Arrays.asList(excludeActions);
        if (!exclude.contains(EditRelationAction.class)) {
            menu.addAction(new EditRelationAction());
        }
        if (!exclude.contains(DuplicateRelationAction.class)) {
            menu.addAction(new DuplicateRelationAction());
        }
        if (!exclude.contains(DeleteRelationsAction.class)) {
            menu.addAction(new DeleteRelationsAction());
            menu.addSeparator();
        }
        if (!exclude.contains(SelectInRelationListAction.class)) {
            menu.addAction(new SelectInRelationListAction());
        }
        menu.addAction(new SelectRelationAction(false));
        menu.addAction(new SelectRelationAction(true));
        menu.addAction(new SelectMembersAction(false));
        menu.addAction(new SelectMembersAction(true));
        menu.addSeparator();
        menu.addAction(new DownloadMembersAction());
        menu.addAction(new DownloadSelectedIncompleteMembersAction());
        return menu;
    }
}

