/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.io.UploadOrSaveState;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class SaveLayersModel
extends DefaultTableModel {
    public static final String MODE_PROP = SaveLayerInfo.class.getName() + ".mode";
    private transient List<SaveLayerInfo> layerInfo;
    private Mode mode = Mode.EDITING_DATA;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static final int columnFilename = 0;
    private static final int columnActions = 2;

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    protected void fireModeChanged(Mode oldValue, Mode newValue) {
        this.support.firePropertyChange(MODE_PROP, (Object)oldValue, (Object)newValue);
    }

    public void setMode(Mode newValue) {
        Mode oldValue = this.mode;
        this.mode = newValue;
        this.fireModeChanged(oldValue, newValue);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void populate(List<? extends AbstractModifiableLayer> layers) {
        this.layerInfo = new ArrayList<SaveLayerInfo>();
        if (layers == null) {
            return;
        }
        for (AbstractModifiableLayer abstractModifiableLayer : layers) {
            this.layerInfo.add(new SaveLayerInfo(abstractModifiableLayer));
        }
        this.layerInfo.sort(Comparator.naturalOrder());
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.layerInfo == null) {
            return 0;
        }
        return this.layerInfo.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.layerInfo == null) {
            return null;
        }
        return this.layerInfo.get(row);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0 || column == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        SaveLayerInfo info = this.layerInfo.get(row);
        switch (column) {
            case 0: {
                info.setFile((File)value);
                if (!info.isSavable()) break;
                info.setDoSaveToFile(true);
                break;
            }
            case 2: {
                boolean[] values = (boolean[])value;
                info.setDoUploadToServer(values[0]);
                info.setDoSaveToFile(values[1]);
                break;
            }
        }
        this.fireTableDataChanged();
    }

    public List<SaveLayerInfo> getSafeLayerInfo() {
        return this.layerInfo;
    }

    public List<SaveLayerInfo> getLayersWithoutFilesAndSaveRequest() {
        if (this.layerInfo == null) {
            return Collections.emptyList();
        }
        return this.layerInfo.stream().filter(info -> info.isDoSaveToFile() && info.getFile() == null).collect(Collectors.toList());
    }

    public List<SaveLayerInfo> getLayersWithIllegalFilesAndSaveRequest() {
        if (this.layerInfo == null) {
            return Collections.emptyList();
        }
        return this.layerInfo.stream().filter(info -> info.isDoSaveToFile() && info.getFile() != null && info.getFile().exists() && !info.getFile().canWrite()).collect(Collectors.toList());
    }

    public List<SaveLayerInfo> getLayersWithConflictsAndUploadRequest() {
        ArrayList<SaveLayerInfo> ret = new ArrayList<SaveLayerInfo>();
        if (this.layerInfo != null) {
            for (SaveLayerInfo info : this.layerInfo) {
                AbstractModifiableLayer l = info.getLayer();
                if (!info.isDoUploadToServer() || !(l instanceof OsmDataLayer) || ((OsmDataLayer)l).getConflicts().isEmpty()) continue;
                ret.add(info);
            }
        }
        return ret;
    }

    public List<SaveLayerInfo> getLayersToUpload() {
        if (this.layerInfo == null) {
            return Collections.emptyList();
        }
        return this.layerInfo.stream().filter(SaveLayerInfo::isDoUploadToServer).collect(Collectors.toList());
    }

    public List<SaveLayerInfo> getLayersToSave() {
        if (this.layerInfo == null) {
            return Collections.emptyList();
        }
        return this.layerInfo.stream().filter(SaveLayerInfo::isDoSaveToFile).collect(Collectors.toList());
    }

    public void setUploadState(AbstractModifiableLayer layer, UploadOrSaveState state) {
        SaveLayerInfo info = this.getSaveLayerInfo(layer);
        if (info != null) {
            info.setUploadState(state);
        }
        this.fireTableDataChanged();
    }

    public void setSaveState(AbstractModifiableLayer layer, UploadOrSaveState state) {
        SaveLayerInfo info = this.getSaveLayerInfo(layer);
        if (info != null) {
            info.setSaveState(state);
        }
        this.fireTableDataChanged();
    }

    public SaveLayerInfo getSaveLayerInfo(AbstractModifiableLayer layer) {
        return this.layerInfo.stream().filter(info -> info.getLayer() == layer).findFirst().orElse(null);
    }

    public void resetSaveAndUploadState() {
        for (SaveLayerInfo info : this.layerInfo) {
            info.setSaveState(null);
            info.setUploadState(null);
        }
    }

    public boolean hasUnsavedData() {
        for (SaveLayerInfo info : this.layerInfo) {
            if (info.isDoUploadToServer() && UploadOrSaveState.OK != info.getUploadState()) {
                return true;
            }
            if (!info.isDoSaveToFile() || UploadOrSaveState.OK == info.getSaveState()) continue;
            return true;
        }
        return false;
    }

    public int getNumCancel() {
        return (int)this.layerInfo.stream().filter(info -> UploadOrSaveState.CANCELED == info.getSaveState() || UploadOrSaveState.CANCELED == info.getUploadState()).count();
    }

    public int getNumFailed() {
        return (int)this.layerInfo.stream().filter(info -> UploadOrSaveState.FAILED == info.getSaveState() || UploadOrSaveState.FAILED == info.getUploadState()).count();
    }

    public static enum Mode {
        EDITING_DATA,
        UPLOADING_AND_SAVING;

    }
}

