/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Declaration;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSRule
implements Comparable<MapCSSRule> {
    public final List<Selector> selectors;
    public final Declaration declaration;

    public MapCSSRule(List<Selector> selectors, Declaration declaration) {
        this.selectors = Utils.toUnmodifiableList(selectors);
        this.declaration = declaration;
    }

    public boolean matches(Environment env) {
        return this.selectors.stream().anyMatch(s -> s.matches(env));
    }

    public void execute(Environment env) {
        this.declaration.execute(env);
    }

    @Override
    public int compareTo(MapCSSRule o) {
        return this.declaration.idx - o.declaration.idx;
    }

    public String toString() {
        String selectorsString = this.selectors.stream().map(String::valueOf).collect(Collectors.joining(",\n"));
        String declarationString = this.declaration.instructions.stream().map(String::valueOf).collect(Collectors.joining("\n  ", " {\n  ", "\n}"));
        return selectorsString + declarationString;
    }
}

