/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement.placement;

import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.MapViewPositionAndRotation;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PositionForAreaStrategy;

public class OnLineStrategy
implements PositionForAreaStrategy {
    public static final OnLineStrategy INSTANCE = new OnLineStrategy(0.0);
    private final double yOffset;

    public OnLineStrategy(double yOffset) {
        this.yOffset = yOffset;
    }

    @Override
    public MapViewPositionAndRotation findLabelPlacement(MapViewPath path, Rectangle2D nb) {
        return OnLineStrategy.findOptimalWayPosition(nb, path).map(best -> {
            MapViewState.MapViewPoint center = ((HalfSegment)best).start.interpolate(((HalfSegment)best).end, 0.5);
            double theta = OnLineStrategy.upsideTheta(best);
            MapViewState.MapViewPoint moved = center.getMapViewState().getForView(center.getInViewX() - Math.sin(theta) * this.yOffset, center.getInViewY() + Math.cos(theta) * this.yOffset);
            return new MapViewPositionAndRotation(moved, theta);
        }).orElse(null);
    }

    private static double upsideTheta(HalfSegment best) {
        double theta = OnLineStrategy.theta(best.start, best.end);
        if (theta < -1.5707963267948966) {
            return theta + Math.PI;
        }
        if (theta > 1.5707963267948966) {
            return theta - Math.PI;
        }
        return theta;
    }

    @Override
    public boolean supportsGlyphVector() {
        return true;
    }

    @Override
    public List<GlyphVector> generateGlyphVectors(MapViewPath path, Rectangle2D nb, List<GlyphVector> gvs, boolean isDoubleTranslationBug) {
        double middleOffset = OnLineStrategy.findOptimalWayPosition(nb, path).map(segment -> ((HalfSegment)segment).offset).orElse(path.getLength() / 2.0);
        UpsideComputingVisitor upside = new UpsideComputingVisitor(middleOffset - nb.getWidth() / 2.0, middleOffset + nb.getWidth() / 2.0);
        path.visitLine(upside);
        boolean doRotateText = upside.shouldRotateText();
        List<OffsetGlyph> offsetGlyphs = OnLineStrategy.computeOffsetGlyphs(gvs, middleOffset + (double)(doRotateText ? 1 : -1) * nb.getWidth() / 2.0, doRotateText);
        Collections.sort(offsetGlyphs, Comparator.comparing(OffsetGlyph::getOffset));
        path.visitLine(new GlyphRotatingVisitor(offsetGlyphs, isDoubleTranslationBug));
        return gvs;
    }

    private static List<OffsetGlyph> computeOffsetGlyphs(List<GlyphVector> gvs, double startOffset, boolean rotateText) {
        double offset = startOffset;
        ArrayList<OffsetGlyph> offsetGlyphs = new ArrayList<OffsetGlyph>();
        for (GlyphVector gv : gvs) {
            double gvOffset = offset;
            IntStream.range(0, gv.getNumGlyphs()).mapToObj(i -> new OffsetGlyph(gvOffset, rotateText, gv, i)).forEach(offsetGlyphs::add);
            offset += (double)(rotateText ? -1 : 1) + gv.getLogicalBounds().getBounds2D().getWidth();
        }
        return offsetGlyphs;
    }

    private static Optional<HalfSegment> findOptimalWayPosition(Rectangle2D rect, MapViewPath path) {
        ArrayList longHalfSegment = new ArrayList();
        double minSegmentLength = 2.0 * (rect.getWidth() + 4.0);
        double length = path.visitLine((inLineOffset, start, end, startIsOldEnd) -> {
            double segmentLength = start.distanceToInView(end);
            if (segmentLength > minSegmentLength) {
                MapViewState.MapViewPoint center = start.interpolate(end, 0.5);
                double q = OnLineStrategy.computeQuality(start, center);
                longHalfSegment.add(new HalfSegment(start, center, q + 0.1, inLineOffset + 0.25 * segmentLength));
                q = OnLineStrategy.computeQuality(center, end);
                longHalfSegment.add(new HalfSegment(center, end, q, inLineOffset + 0.75 * segmentLength));
            }
        });
        return longHalfSegment.stream().max(Comparator.comparingDouble(segment -> ((HalfSegment)segment).quality - 1.0E-5 * Math.abs(((HalfSegment)segment).offset - length / 2.0)));
    }

    private static double computeQuality(MapViewState.MapViewPoint p1, MapViewState.MapViewPoint p2) {
        double q = 0.0;
        if (p1.isInView()) {
            q += 1.0;
        }
        if (p2.isInView()) {
            q += 1.0;
        }
        return q;
    }

    private static double theta(MapViewState.MapViewPoint start, MapViewState.MapViewPoint end) {
        return Math.atan2(end.getInViewY() - start.getInViewY(), end.getInViewX() - start.getInViewX());
    }

    @Override
    public PositionForAreaStrategy withAddedOffset(Point2D addToOffset) {
        if (Math.abs(addToOffset.getY()) < 1.0E-5) {
            return this;
        }
        return new OnLineStrategy(this.yOffset - addToOffset.getY());
    }

    public String toString() {
        return "OnLineStrategy [yOffset=" + this.yOffset + ']';
    }

    public int hashCode() {
        return Double.hashCode(this.yOffset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OnLineStrategy other = (OnLineStrategy)obj;
        return Double.doubleToLongBits(this.yOffset) == Double.doubleToLongBits(other.yOffset);
    }

    private static class OffsetGlyph {
        private final double offset;
        private final double preRotate;
        private final GlyphVector glyph;
        private final int glyphIndex;

        OffsetGlyph(double offset, boolean rotateText, GlyphVector glyph, int glyphIndex) {
            this.preRotate = rotateText ? Math.PI : 0.0;
            this.glyph = glyph;
            this.glyphIndex = glyphIndex;
            Rectangle2D rect = this.getBounds();
            this.offset = offset + (double)(rotateText ? -1 : 1) * (rect.getX() + rect.getWidth() / 2.0);
        }

        Rectangle2D getBounds() {
            return this.glyph.getGlyphLogicalBounds(this.glyphIndex).getBounds2D();
        }

        double getOffset() {
            return this.offset;
        }

        public String toString() {
            return "OffsetGlyph [offset=" + this.offset + ", preRotate=" + this.preRotate + ", glyphIndex=" + this.glyphIndex + ']';
        }
    }

    private class GlyphRotatingVisitor
    implements MapViewPath.PathSegmentConsumer {
        private final Iterator<OffsetGlyph> gvs;
        private final boolean isDoubleTranslationBug;
        private OffsetGlyph next;

        GlyphRotatingVisitor(List<OffsetGlyph> gvs, boolean isDoubleTranslationBug) {
            this.isDoubleTranslationBug = isDoubleTranslationBug;
            this.gvs = gvs.iterator();
            this.takeNext();
            while (this.next != null && this.next.offset < 0.0) {
                this.takeNext();
            }
        }

        private void takeNext() {
            this.next = this.gvs.hasNext() ? this.gvs.next() : null;
        }

        @Override
        public void addLineBetween(double inLineOffset, MapViewState.MapViewPoint start, MapViewState.MapViewPoint end, boolean startIsOldEnd) {
            double segLength = start.distanceToInView(end);
            double segEnd = inLineOffset + segLength;
            double theta = OnLineStrategy.theta(start, end);
            while (this.next != null && this.next.offset < segEnd) {
                Rectangle2D rect = this.next.getBounds();
                double centerY = 0.0;
                MapViewState.MapViewPoint p = start.interpolate(end, (this.next.offset - inLineOffset) / segLength);
                AffineTransform trfm = new AffineTransform();
                trfm.translate(-rect.getCenterX(), -centerY);
                trfm.translate(p.getInViewX(), p.getInViewY());
                trfm.rotate(theta + this.next.preRotate, rect.getWidth() / 2.0, centerY);
                trfm.translate(0.0, (double)this.next.glyph.getFont().getSize2D() * 0.25);
                trfm.translate(0.0, OnLineStrategy.this.yOffset);
                if (this.isDoubleTranslationBug) {
                    AffineTransform tmp = AffineTransform.getTranslateInstance(-0.5 * trfm.getTranslateX(), -0.5 * trfm.getTranslateY());
                    tmp.concatenate(trfm);
                    trfm = tmp;
                }
                this.next.glyph.setGlyphTransform(this.next.glyphIndex, trfm);
                this.takeNext();
            }
        }
    }

    private static class UpsideComputingVisitor
    implements MapViewPath.PathSegmentConsumer {
        private final double startOffset;
        private final double endOffset;
        private double upsideUpLines;
        private double upsideDownLines;

        UpsideComputingVisitor(double startOffset, double endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        @Override
        public void addLineBetween(double inLineOffset, MapViewState.MapViewPoint start, MapViewState.MapViewPoint end, boolean startIsOldEnd) {
            if (inLineOffset > this.endOffset) {
                return;
            }
            double length = start.distanceToInView(end);
            if (inLineOffset + length < this.startOffset) {
                return;
            }
            double segmentStart = Math.max(inLineOffset, this.startOffset);
            double segmentEnd = Math.min(inLineOffset + length, this.endOffset);
            double segmentLength = segmentEnd - segmentStart;
            if (start.getInViewX() < end.getInViewX()) {
                this.upsideUpLines += segmentLength;
            } else {
                this.upsideDownLines += segmentLength;
            }
        }

        boolean shouldRotateText() {
            return this.upsideUpLines < this.upsideDownLines;
        }
    }

    private static class HalfSegment {
        private final MapViewState.MapViewPoint start;
        private final MapViewState.MapViewPoint end;
        private final double quality;
        private final double offset;

        HalfSegment(MapViewState.MapViewPoint start, MapViewState.MapViewPoint end, double quality, double offset) {
            this.start = start;
            this.end = end;
            this.quality = quality;
            this.offset = offset;
        }

        public String toString() {
            return "HalfSegment [start=" + this.start + ", end=" + this.end + ", quality=" + this.quality + ']';
        }
    }
}

